/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.coverage;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.MAMath;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.ft.grid.Coverage;
import ucar.nc2.ft.grid.CoverageCS;
import ucar.nc2.ft.grid.IsMissingEvaluator;
import ucar.nc2.ui.grid.ColorScale;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.Debug;

public class CoverageRenderer {
    private PreferencesExt store;
    private boolean drawGrid = true;
    private boolean drawGridLines = true;
    private boolean drawContours = false;
    private boolean drawContourLabels = false;
    private boolean isNewField = true;
    private ColorScale cs = null;
    private ColorScale.MinMaxType dataMinMaxType = ColorScale.MinMaxType.horiz;
    private ProjectionImpl drawProjection = null;
    private ProjectionImpl dataProjection = null;
    private Coverage orgGrid = null;
    private Coverage stridedGrid = null;
    private Array dataH;
    private Array dataV;
    private int wantLevel = -1;
    private int wantSlice = -1;
    private int wantTime = -1;
    private int horizStride = 1;
    private int wantRunTime = -1;
    private int wantEnsemble = -1;
    private int lastLevel = -1;
    private int lastTime = -1;
    private int lastSlice = -1;
    private int lastStride = -1;
    private int lastRunTime = -1;
    private int lastEnsemble = -1;
    private Coverage lastGrid = null;
    private boolean colorScaleChanged = true;
    private boolean dataVolumeChanged = true;
    private boolean useModeForProjections = false;
    private boolean sameProjection = false;
    private LatLonProjection projectll;
    private LatLonPointImpl ptL1 = new LatLonPointImpl();
    private LatLonPointImpl ptL2 = new LatLonPointImpl();
    private ProjectionPointImpl ptP1 = new ProjectionPointImpl();
    private ProjectionPointImpl ptP2 = new ProjectionPointImpl();
    private ProjectionRect[] rects = new ProjectionRect[2];
    private final boolean debugHorizDraw = false;
    private final boolean debugSeam = false;
    private final boolean debugLatLon = false;
    private final boolean debugMiss = false;
    private boolean debugPathShape = false;
    private boolean debugArrayShape = false;
    private boolean debugPts = false;
    private int[] valueIndex = new int[2];
    private Rectangle2D rect = new Rectangle2D.Double();
    private GeneralPath gpRun = new GeneralPath(0, 25);

    public CoverageRenderer(PreferencesExt store) {
        this.store = store;
        this.rects[0] = new ProjectionRect();
    }

    public ColorScale getColorScale() {
        return this.cs;
    }

    public void setColorScale(ColorScale cs) {
        this.cs = cs;
        this.colorScaleChanged = true;
    }

    public void setDataMinMaxType(ColorScale.MinMaxType type) {
        if (type != this.dataMinMaxType) {
            this.dataMinMaxType = type;
            this.colorScaleChanged = true;
        }
    }

    public void setCoverage(Coverage grid) {
        this.orgGrid = grid;
        this.lastGrid = null;
        this.dataProjection = grid.getCoordinateSystem().getProjection();
        this.makeStridedGrid();
        this.isNewField = true;
    }

    public Array getCurrentHorizDataSlice() {
        return this.dataH;
    }

    public ProjectionImpl getDataProjection() {
        return this.dataProjection;
    }

    public ProjectionImpl getDisplayProjection() {
        return this.drawProjection;
    }

    public void setProjection(ProjectionImpl project) {
        this.drawProjection = project;
    }

    public boolean getDrawGrid() {
        return this.drawGrid;
    }

    public void setDrawGridLines(boolean drawGrid) {
        this.drawGridLines = drawGrid;
    }

    public boolean getDrawContours() {
        return this.drawContours;
    }

    public void setDrawContours(boolean drawContours) {
        this.drawContours = drawContours;
    }

    public boolean getDrawContourLabels() {
        return this.drawContourLabels;
    }

    public void setDrawContourLabels(boolean drawContourLabels) {
        this.drawContourLabels = drawContourLabels;
    }

    public int getLevel() {
        return this.wantLevel;
    }

    public void setLevel(int level) {
        this.wantLevel = level;
    }

    public int getTime() {
        return this.wantTime;
    }

    public void setTime(int time) {
        this.wantTime = time;
    }

    public int getRunTime() {
        return this.wantRunTime;
    }

    public void setRunTime(int runtime) {
        this.wantRunTime = runtime;
    }

    public int getEnsemble() {
        return this.wantEnsemble;
    }

    public void setEnsemble(int ensemble) {
        this.wantEnsemble = ensemble;
    }

    public int getSlice() {
        return this.wantSlice;
    }

    public void setSlice(int slice) {
        this.wantSlice = slice;
    }

    public int getHorizStride() {
        return this.horizStride;
    }

    public void setHorizStride(int horizStride) {
        this.horizStride = horizStride;
    }

    void makeStridedGrid() {
        this.stridedGrid = this.orgGrid;
    }

    private Array makeHSlice(Coverage useG, int level, int time, int ensemble, int runtime) {
        CoverageCS gcs = useG.getCoordinateSystem();
        CoordinateAxis xaxis = gcs.getXHorizAxis();
        CoordinateAxis yaxis = gcs.getYHorizAxis();
        if (xaxis == null || yaxis == null) {
            return null;
        }
        if (xaxis.getSize() <= 1L || yaxis.getSize() <= 1L) {
            return null;
        }
        if (useG.equals(this.lastGrid) && time == this.lastTime && level == this.lastLevel && this.horizStride == this.lastStride && ensemble == this.lastEnsemble && runtime == this.lastRunTime) {
            return this.dataH;
        }
        try {
            CoverageCS.Subset subset = gcs.getSubset();
            subset.setLevel(level);
            subset.setTime(time);
            this.dataH = useG.readData(subset);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        this.lastGrid = useG;
        this.lastTime = time;
        this.lastLevel = level;
        this.lastEnsemble = ensemble;
        this.lastRunTime = runtime;
        this.lastStride = this.horizStride;
        if (this.debugArrayShape) {
            System.out.println("Horiz shape = ");
            for (int i = 0; i < this.dataH.getRank(); ++i) {
                System.out.println("   shape = " + this.dataH.getShape()[i]);
            }
        }
        return this.dataH;
    }

    private void setColorScaleParams() {
        if (this.dataMinMaxType == ColorScale.MinMaxType.hold && !this.isNewField) {
            return;
        }
        this.isNewField = false;
        Array dataArr = this.makeHSlice(this.stridedGrid, this.wantLevel, this.wantTime, this.wantEnsemble, this.wantRunTime);
        if (dataArr != null) {
            MAMath.MinMax minmax = MAMath.getMinMaxSkipMissingData((Array)dataArr, (IsMissingEvaluator)this.stridedGrid);
            this.cs.setMinMax(minmax.min, minmax.max);
            this.cs.setGeoGrid((IsMissingEvaluator)this.stridedGrid);
        }
        this.dataVolumeChanged = false;
        this.colorScaleChanged = false;
    }

    public void renderPlanView(Graphics2D g, AffineTransform dFromN) {
        if (this.stridedGrid == null || this.cs == null || this.drawProjection == null) {
            return;
        }
        if (!this.drawGrid && !this.drawContours) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.dataH = this.makeHSlice(this.stridedGrid, this.wantLevel, this.wantTime, this.wantEnsemble, this.wantRunTime);
        if (this.dataH == null) {
            return;
        }
        this.setColorScaleParams();
        if (this.drawGrid) {
            this.drawGridHoriz(g, this.dataH);
        }
        if (this.drawGridLines) {
            this.drawGridLines(g);
        }
    }

    private void drawGridHoriz(Graphics2D g, Array data) {
        boolean count = false;
        CoverageCS geocs = this.stridedGrid.getCoordinateSystem();
        CoordinateAxis xaxis = geocs.getXHorizAxis();
        CoordinateAxis yaxis = geocs.getYHorizAxis();
        if (xaxis instanceof CoordinateAxis1D && yaxis instanceof CoordinateAxis1D) {
            this.drawGridHoriz1D(g, data, (CoordinateAxis1D)xaxis, (CoordinateAxis1D)yaxis);
            return;
        }
        if ((data = data.reduce()).getRank() != 2) {
            throw new IllegalArgumentException("must be 2D");
        }
        if (!(xaxis instanceof CoordinateAxis2D) || !(yaxis instanceof CoordinateAxis2D)) {
            throw new IllegalArgumentException("must be CoordinateAxis2D");
        }
        CoordinateAxis2D xaxis2D = (CoordinateAxis2D)xaxis;
        CoordinateAxis2D yaxis2D = (CoordinateAxis2D)yaxis;
        ArrayDouble.D2 edgex = xaxis2D.getXEdges();
        ArrayDouble.D2 edgey = yaxis2D.getYEdges();
        Index ima = data.getIndex();
        GeneralPath gp = new GeneralPath(0, 5);
        int[] shape = xaxis2D.getShape();
        int ny = shape[0];
        int nx = shape[1];
        for (int y = 0; y < ny; ++y) {
            for (int x = 0; x < nx; ++x) {
                gp.reset();
                gp.moveTo((float)edgex.get(y, x), (float)edgey.get(y, x));
                gp.lineTo((float)edgex.get(y, x + 1), (float)edgey.get(y, x + 1));
                gp.lineTo((float)edgex.get(y + 1, x + 1), (float)edgey.get(y + 1, x + 1));
                gp.lineTo((float)edgex.get(y + 1, x), (float)edgey.get(y + 1, x));
                double val = data.getDouble(ima.set(y, x));
                int colorIndex = this.cs.getIndexFromValue(val);
                g.setColor(this.cs.getColor(colorIndex));
                g.fill(gp);
            }
        }
    }

    private void drawGridLines(Graphics2D g) {
        boolean count = false;
        CoverageCS geocs = this.stridedGrid.getCoordinateSystem();
        CoordinateAxis xaxis = geocs.getXHorizAxis();
        CoordinateAxis yaxis = geocs.getYHorizAxis();
        if (!(xaxis instanceof CoordinateAxis2D) || !(yaxis instanceof CoordinateAxis2D)) {
            return;
        }
        CoordinateAxis2D xaxis2D = (CoordinateAxis2D)xaxis;
        CoordinateAxis2D yaxis2D = (CoordinateAxis2D)yaxis;
        ArrayDouble.D2 edgex = xaxis2D.getXEdges();
        ArrayDouble.D2 edgey = yaxis2D.getYEdges();
        GeneralPath gp = new GeneralPath(0, 5);
        g.setColor(Color.BLACK);
        int[] shape = xaxis2D.getShape();
        int ny = shape[0];
        int nx = shape[1];
        for (int y = 0; y < ny + 1; y += 10) {
            gp.reset();
            for (int x = 0; x < nx + 1; ++x) {
                if (x == 0) {
                    gp.moveTo((float)edgex.get(y, x), (float)edgey.get(y, x));
                    continue;
                }
                gp.lineTo((float)edgex.get(y, x), (float)edgey.get(y, x));
            }
            g.draw(gp);
        }
        for (int x = 0; x < nx + 1; x += 10) {
            gp.reset();
            for (int y = 0; y < ny + 1; ++y) {
                if (y == 0) {
                    gp.moveTo((float)edgex.get(y, x), (float)edgey.get(y, x));
                    continue;
                }
                gp.lineTo((float)edgex.get(y, x), (float)edgey.get(y, x));
            }
            g.draw(gp);
        }
    }

    private void drawGridHorizRotated(Graphics2D g, Array data, CoordinateAxis2D xaxis2D, CoordinateAxis2D yaxis2D) {
        int colorIndex;
        double val;
        int x;
        int y;
        ArrayDouble.D2 edgex = CoordinateAxis2D.makeXEdgesRotated((ArrayDouble.D2)xaxis2D.getMidpoints());
        ArrayDouble.D2 edgey = CoordinateAxis2D.makeYEdgesRotated((ArrayDouble.D2)yaxis2D.getMidpoints());
        Index ima = data.getIndex();
        GeneralPath gp = new GeneralPath(0, 5);
        int[] shape = xaxis2D.getShape();
        int ny = shape[0];
        int nx = shape[1];
        for (y = 0; y < ny - 1; y += 2) {
            for (x = 0; x < nx - 1; ++x) {
                gp.reset();
                gp.moveTo((float)edgex.get(y, x), (float)edgey.get(y, x));
                gp.lineTo((float)edgex.get(y + 1, x), (float)edgey.get(y + 1, x));
                gp.lineTo((float)edgex.get(y + 2, x), (float)edgey.get(y + 2, x));
                gp.lineTo((float)edgex.get(y + 1, x + 1), (float)edgey.get(y + 1, x + 1));
                val = data.getDouble(ima.set(y, x));
                colorIndex = this.cs.getIndexFromValue(val);
                g.setColor(this.cs.getColor(colorIndex));
                g.fill(gp);
            }
        }
        for (y = 1; y < ny - 1; y += 2) {
            for (x = 0; x < nx - 1; ++x) {
                gp.reset();
                gp.moveTo((float)edgex.get(y, x + 1), (float)edgey.get(y, x + 1));
                gp.lineTo((float)edgex.get(y + 1, x), (float)edgey.get(y + 1, x));
                gp.lineTo((float)edgex.get(y + 2, x + 1), (float)edgey.get(y + 2, x + 1));
                gp.lineTo((float)edgex.get(y + 1, x + 1), (float)edgey.get(y + 1, x + 1));
                val = data.getDouble(ima.set(y, x));
                colorIndex = this.cs.getIndexFromValue(val);
                g.setColor(this.cs.getColor(colorIndex));
                g.fill(gp);
            }
        }
    }

    private void drawGridHoriz1D(Graphics2D g, Array data, CoordinateAxis1D xaxis1D, CoordinateAxis1D yaxis1D) {
        int count = 0;
        int nx = (int)xaxis1D.getSize();
        int ny = (int)yaxis1D.getSize();
        this.sameProjection = this.drawProjection.equals((Object)this.dataProjection);
        if (this.drawProjection.isLatLon()) {
            this.projectll = (LatLonProjection)this.drawProjection;
            double centerLon = this.projectll.getCenterLon();
            if (Debug.isSet("projection/LatLonShift")) {
                System.out.println("projection/LatLonShift: gridDraw = " + centerLon);
            }
        }
        int modeColor = this.cs.getHistMax();
        this.cs.resetHist();
        IndexIterator iiter = data.getIndexIterator();
        while (iiter.hasNext()) {
            double val = iiter.getDoubleNext();
            this.cs.getIndexFromValue(val);
        }
        modeColor = this.cs.getHistMax();
        if (this.sameProjection) {
            count += this.drawRect(g, modeColor, xaxis1D.getCoordEdge(0), yaxis1D.getCoordEdge(0), xaxis1D.getCoordEdge(nx), yaxis1D.getCoordEdge(ny), this.drawProjection.isLatLon());
        } else if (this.useModeForProjections) {
            this.drawPathShape(g, modeColor, xaxis1D, yaxis1D);
        }
        this.debugPts = Debug.isSet("GridRenderer/showPts");
        Index imaH = this.dataH.getIndex();
        for (int y = 0; y < ny; ++y) {
            double ybeg = yaxis1D.getCoordEdge(y);
            double yend = yaxis1D.getCoordEdge(y + 1);
            int thisColor = 0;
            int lastColor = 0;
            int run = 0;
            int xbeg = 0;
            this.debugPts = this.debugPts && y == 0;
            for (int x = 0; x < nx; ++x) {
                try {
                    double val = data.getDouble(imaH.set(y, x));
                    thisColor = this.cs.getIndexFromValue(val);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("bad");
                    throw e;
                }
                if (run == 0 || lastColor == thisColor) {
                    ++run;
                } else {
                    if (this.sameProjection) {
                        if (lastColor != modeColor) {
                            count += this.drawRect(g, lastColor, xaxis1D.getCoordEdge(xbeg), ybeg, xaxis1D.getCoordEdge(x), yend, this.drawProjection.isLatLon());
                        }
                    } else {
                        count += this.drawPathRun(g, lastColor, ybeg, yend, xaxis1D, xbeg, x);
                    }
                    xbeg = x;
                }
                lastColor = thisColor;
            }
            if (this.sameProjection) {
                if (lastColor == modeColor) continue;
                count += this.drawRect(g, lastColor, xaxis1D.getCoordEdge(xbeg), ybeg, xaxis1D.getCoordEdge(nx), yend, this.drawProjection.isLatLon());
                continue;
            }
            count += this.drawPathRun(g, lastColor, ybeg, yend, xaxis1D, xbeg, nx - 1);
        }
    }

    private int drawRectLatLon(Graphics2D g, int color, double lon1, double lat1, double lon2, double lat2) {
        g.setColor(this.cs.getColor(color));
        int count = 0;
        ProjectionRect[] rect = this.projectll.latLonToProjRect(lat1, lon1, lat2, lon2);
        for (int i = 0; i < 2; ++i) {
            if (null == rect[i]) continue;
            g.fill((Shape)rect[i]);
            ++count;
        }
        return count;
    }

    private int drawRect(Graphics2D g, int color, double w1, double h1, double w2, double h2, boolean useLatlon) {
        if (useLatlon) {
            return this.drawRectLatLon(g, color, w1, h1, w2, h2);
        }
        g.setColor(this.cs.getColor(color));
        double wmin = Math.min(w1, w2);
        double hmin = Math.min(h1, h2);
        double width = Math.abs(w1 - w2);
        double height = Math.abs(h1 - h2);
        this.rect.setRect(wmin, hmin, width, height);
        g.fill(this.rect);
        return 1;
    }

    private int drawPathRun(Graphics2D g, int color, double y1, double y2, CoordinateAxis1D xaxis, int x1, int x2) {
        int e;
        int nx = (int)xaxis.getSize();
        if (x1 < 0 || x1 > nx || x2 < 0 || x2 > nx || x1 > x2) {
            return 0;
        }
        this.gpRun.reset();
        LatLonPointImpl llp = this.dataProjection.projToLatLon(xaxis.getCoordEdge(x1), y1);
        ProjectionPoint pt = this.drawProjection.latLonToProj((LatLonPoint)llp);
        if (this.debugPts) {
            System.out.println("** moveTo = " + pt.getX() + " " + pt.getY());
        }
        this.gpRun.moveTo((float)pt.getX(), (float)pt.getY());
        this.ptP1.setLocation(pt);
        for (e = x1 + 1; e <= x2 + 1; ++e) {
            llp = this.dataProjection.projToLatLon(xaxis.getCoordEdge(e), y1);
            pt = this.drawProjection.latLonToProj((LatLonPoint)llp);
            if (this.drawProjection.crossSeam((ProjectionPoint)this.ptP1, pt)) {
                int x = e - 1;
                if (this.debugPathShape) {
                    System.out.println("split1 at x = " + x + " " + x1 + " " + x2);
                }
                int count = 0;
                count += this.drawPathRun(g, color, y1, y2, xaxis, x1, x - 1);
                return count += this.drawPathRun(g, color, y1, y2, xaxis, x + 1, x2);
            }
            if (this.debugPts) {
                System.out.println("  lineTo = " + pt.getX() + " " + pt.getY());
            }
            this.gpRun.lineTo((float)pt.getX(), (float)pt.getY());
            this.ptP1.setLocation(pt);
        }
        for (e = x2 + 1; e >= x1; --e) {
            llp = this.dataProjection.projToLatLon(xaxis.getCoordEdge(e), y2);
            pt = this.drawProjection.latLonToProj((LatLonPoint)llp);
            if (this.drawProjection.crossSeam((ProjectionPoint)this.ptP1, pt)) {
                int x;
                int n = x = e == x2 + 1 ? x2 : e;
                if (this.debugPathShape) {
                    System.out.println("split2 at x = " + x + " " + x1 + " " + x2);
                }
                int count = 0;
                count += this.drawPathRun(g, color, y1, y2, xaxis, x1, x - 1);
                return count += this.drawPathRun(g, color, y1, y2, xaxis, x + 1, x2);
            }
            if (this.debugPts) {
                System.out.println("  lineTo = " + pt.getX() + " " + pt.getY());
            }
            this.gpRun.lineTo((float)pt.getX(), (float)pt.getY());
            this.ptP1.setLocation(pt);
        }
        g.setColor(this.cs.getColor(color));
        try {
            g.fill(this.gpRun);
        }
        catch (Throwable e2) {
            System.out.println("Exception in drawPathRun = " + e2);
            return 0;
        }
        return 1;
    }

    private int drawPathShape(Graphics2D g, int color, CoordinateAxis1D xaxis, CoordinateAxis1D yaxis) {
        int count = 0;
        int y = 0;
        while ((long)y < yaxis.getSize() - 1L) {
            double y1 = yaxis.getCoordEdge(y);
            double y2 = yaxis.getCoordEdge(y + 1);
            count += this.drawPathRun(g, color, y1, y2, xaxis, 0, (int)xaxis.getSize() - 1);
            ++y;
        }
        return count;
    }

    private void drawXORline(Graphics2D g, double x1, double y1, double x2, double y2) {
        this.gpRun.reset();
        this.gpRun.moveTo((float)x1, (float)y1);
        this.gpRun.lineTo((float)x2, (float)y2);
        g.setColor(Color.black);
        if (Double.isInfinite(x1) || Double.isInfinite(x2) || Double.isInfinite(y1) || Double.isInfinite(y2)) {
            return;
        }
        g.draw(this.gpRun);
    }
}

