/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.wmo.CommonCodeTable;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class WmoCommonCodesPanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted codeTable;
    private BeanTableSorted entryTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane compareTA;
    private IndependentWindow infoWindow;
    private FileManager fileChooser;

    public WmoCommonCodesPanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.codeTable = new BeanTableSorted(TableBean.class, (PreferencesExt)prefs.node("CodeTableBean"), false);
        this.codeTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TableBean csb = (TableBean)WmoCommonCodesPanel.this.codeTable.getSelectedBean();
                CommonCodeTable cct = CommonCodeTable.getTable((int)csb.t.getTableNo());
                WmoCommonCodesPanel.this.setEntries(cct);
            }
        });
        this.entryTable = new BeanTableSorted(EntryBean.class, (PreferencesExt)prefs.node("EntryBean"), false);
        this.entryTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EntryBean csb = (EntryBean)WmoCommonCodesPanel.this.entryTable.getSelectedBean();
            }
        });
        PopupMenu varPopup = new PopupMenu(this.codeTable.getJTable(), "Options");
        varPopup.addAction("Show", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter out = new Formatter();
                TableBean csb = (TableBean)WmoCommonCodesPanel.this.codeTable.getSelectedBean();
                if (csb == null) {
                    return;
                }
                CommonCodeTable cct = CommonCodeTable.getTable((int)csb.t.getTableNo());
                List<EntryBean> beans = WmoCommonCodesPanel.this.setEntries(cct);
                for (EntryBean bean : beans) {
                    bean.show(out);
                }
                WmoCommonCodesPanel.this.compareTA.setText(out.toString());
                WmoCommonCodesPanel.this.compareTA.gotoTop();
                WmoCommonCodesPanel.this.infoWindow.setVisible(true);
            }
        });
        this.compareTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.compareTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 800, 600)));
        this.split = new JSplitPane(0, false, this.codeTable, this.entryTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
        try {
            ArrayList<TableBean> tables = new ArrayList<TableBean>();
            for (CommonCodeTable.Table t : CommonCodeTable.Table.values()) {
                tables.add(new TableBean(t));
            }
            this.codeTable.setBeans(tables);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() {
        this.codeTable.saveState(false);
        this.entryTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        if (this.fileChooser != null) {
            this.fileChooser.save();
        }
    }

    public List<EntryBean> setEntries(CommonCodeTable codeTable) {
        ArrayList<EntryBean> beans = new ArrayList<EntryBean>(codeTable.entries.size());
        for (CommonCodeTable.TableEntry d : codeTable.entries) {
            beans.add(new EntryBean(d));
        }
        this.entryTable.setBeans(beans);
        return beans;
    }

    public class EntryBean {
        CommonCodeTable.TableEntry te;

        public EntryBean() {
        }

        public EntryBean(CommonCodeTable.TableEntry te) {
            this.te = te;
        }

        public String getValue() {
            return this.te.value;
        }

        public String getComment() {
            return this.te.comment;
        }

        public String getStatus() {
            return this.te.status;
        }

        public int getCode() {
            return this.te.code;
        }

        public int getCode2() {
            return this.te.code2;
        }

        public int getLine() {
            return this.te.line;
        }

        private void show(Formatter f) {
            if (this.getCode() > 0) {
                f.format("%4d; %4d; %s%n", this.getCode(), this.getCode2(), this.getValue());
            }
        }
    }

    public class TableBean {
        CommonCodeTable.Table t;

        public TableBean() {
        }

        public TableBean(CommonCodeTable.Table t) {
            this.t = t;
        }

        public String getName() {
            return this.t.getName();
        }

        public String getEnumName() {
            return this.t.name();
        }

        public int getType() {
            return this.t.getTableType();
        }

        public String getResource() {
            return this.t.getResourceName();
        }
    }
}

