/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.catalog.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ThreddsMetadata;
import thredds.catalog.dl.ADNWriter;
import thredds.catalog.dl.DIFWriter;
import thredds.ui.catalog.CatalogChooser;
import thredds.ui.catalog.CatalogTreeView;
import thredds.ui.catalog.search.Indexer;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class CatalogIndexer
extends JPanel {
    private static final String SOURCE_WINDOW_SIZE = "SourceWindowSize";
    private static final String STATUS_WINDOW_SIZE = "StatusWindowSize";
    private PreferencesExt prefs;
    private Component myParent;
    private CatalogChooser catalogChooser;
    private CatalogTreeView tree;
    private BeanTableSorted dsTable;
    private JSplitPane splitV;
    private ArrayList tables = new ArrayList();
    private IndependentWindow indexWindow = null;
    private TextHistoryPane indexMessages;
    private InvCatalogImpl currentCatalog = null;
    private DatasetBean currentBean = null;
    private ArrayList beans = new ArrayList();
    private ArrayList datasets = new ArrayList();
    private Indexer indexer = new Indexer();
    private DIFWriter difWriter = new DIFWriter();
    private ADNWriter adnWriter = new ADNWriter();
    private boolean debugEvents = false;

    public CatalogIndexer(PreferencesExt prefs, Component parent) {
        this.prefs = prefs;
        this.myParent = parent;
        PreferencesExt node = prefs == null ? null : (PreferencesExt)prefs.node("catIndexer");
        this.catalogChooser = new CatalogChooser(node, true, false, true);
        this.tree = this.catalogChooser.getTreeView();
        this.tree.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (CatalogIndexer.this.debugEvents) {
                    System.out.println("CatalogEditor tree propertyChange= " + e.getPropertyName() + " " + e.getNewValue() + " (" + e.getNewValue().getClass().getName() + ")");
                }
                if (e.getPropertyName().equals("Catalog")) {
                    CatalogIndexer.this.datasets = new ArrayList();
                    CatalogIndexer.this.beans = new ArrayList();
                    CatalogIndexer.this.dsTable.setBeans(CatalogIndexer.this.beans);
                } else if (e.getPropertyName().equals("TreeNode")) {
                    InvDatasetImpl ds = (InvDatasetImpl)e.getNewValue();
                    CatalogIndexer.this.addDataset(ds);
                } else if (e.getPropertyName().equals("Selection")) {
                    InvDatasetImpl ds = (InvDatasetImpl)e.getNewValue();
                    DatasetBean dsBean = CatalogIndexer.this.findDatasetBean((InvDataset)ds);
                    CatalogIndexer.this.dsTable.setSelectedBean(dsBean);
                }
            }
        });
        this.dsTable = new BeanTableSorted(DatasetBean.class, (PreferencesExt)prefs.node("dsBeans"), false);
        this.dsTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DatasetBean bean = (DatasetBean)CatalogIndexer.this.dsTable.getSelectedBean();
                InvDatasetImpl selectedDataset = bean.dataset();
                CatalogIndexer.this.catalogChooser.setSelectedDataset(selectedDataset);
            }
        });
        this.splitV = new JSplitPane(0, false, this.catalogChooser, this.dsTable);
        this.splitV.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitV, "Center");
        JPanel buttPanel = new JPanel();
        this.add((Component)buttPanel, "South");
        JButton openAllButton = new JButton("Open All");
        buttPanel.add(openAllButton);
        openAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogIndexer.this.tree.openAll(true);
            }
        });
        JButton status = new JButton("Status");
        buttPanel.add(status);
        status.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogIndexer.this.indexWindow.show();
            }
        });
        this.indexMessages = new TextHistoryPane(false);
        this.indexWindow = new IndependentWindow("Indexing", BAMutil.getImage("thredds"), this.indexMessages);
        this.indexWindow.setBounds((Rectangle)prefs.getBean(SOURCE_WINDOW_SIZE, (Object)new Rectangle(50, 50, 850, 450)));
        JButton catSource = new JButton("Index");
        catSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogIndexer.this.indexMessages.clear();
                StringBuffer messBuff = new StringBuffer();
                CatalogIndexer.this.indexer.index(messBuff, CatalogIndexer.this.getDatasetsToIndex());
                CatalogIndexer.this.indexMessages.setText(messBuff.toString());
                CatalogIndexer.this.indexMessages.gotoTop();
                CatalogIndexer.this.indexWindow.show();
            }
        });
        buttPanel.add(catSource);
    }

    public void save() {
        this.prefs.putInt("splitPos", this.splitV.getDividerLocation());
        this.catalogChooser.save();
        this.dsTable.saveState(false);
    }

    public void addDataset(InvDatasetImpl ds) {
        if (this.datasets.contains(ds)) {
            return;
        }
        this.datasets.add(ds);
        DatasetBean bean = new DatasetBean(ds);
        this.dsTable.addBean(bean);
    }

    public DatasetBean findDatasetBean(InvDataset ds) {
        for (DatasetBean item : this.beans) {
            if (!item.dataset().equals((Object)ds)) continue;
            return item;
        }
        return null;
    }

    public ArrayList getDatasetsToIndex() {
        ArrayList<InvDataset> sublist = new ArrayList<InvDataset>();
        for (InvDataset item : this.datasets) {
            if (!item.isHarvest()) continue;
            sublist.add(item);
        }
        return sublist;
    }

    public class DatasetBean {
        private InvDatasetImpl ds;
        private boolean adn;
        private boolean dif;
        private boolean summary;
        private boolean rights;
        private String difMessages;
        int keywords;

        public DatasetBean() {
        }

        public DatasetBean(InvDatasetImpl ds) {
            this.ds = ds;
            this.synch();
        }

        public void synch() {
            String s = this.ds.getDocumentation("summary");
            this.summary = s != null;
            s = this.ds.getDocumentation("rights");
            this.rights = s != null;
            StringBuffer sbuff = new StringBuffer();
            sbuff.append("DIF:\n");
            this.dif = CatalogIndexer.this.difWriter.isDatasetUseable((InvDataset)this.ds, sbuff);
            sbuff.append("\nADN:\n");
            this.adn = CatalogIndexer.this.adnWriter.isDatasetUseable((InvDataset)this.ds, sbuff);
            this.difMessages = sbuff.toString();
            this.ds.getKeywords();
            this.keywords = this.ds.getKeywords().size();
        }

        public InvDatasetImpl dataset() {
            return this.ds;
        }

        public String status() {
            return this.difMessages;
        }

        public String getId() {
            return this.ds.getID() == null ? "" : this.ds.getID();
        }

        public String getName() {
            return this.ds.getName();
        }

        public boolean isAdn() {
            return this.adn;
        }

        public boolean isDif() {
            return this.dif;
        }

        public boolean isHarvest() {
            return this.ds.isHarvest();
        }

        public boolean isGeo() {
            ThreddsMetadata.GeospatialCoverage geo = this.ds.getGeospatialCoverage();
            return geo != null && geo.isValid();
        }

        public boolean isTime() {
            return this.ds.getCalendarDateCoverage() != null;
        }

        public boolean isVars() {
            return this.ds.getVariables().size() > 0;
        }

        public boolean isPublish() {
            return this.ds.getPublishers().size() > 0;
        }

        public boolean isRights() {
            return this.rights;
        }

        public boolean isSummary() {
            return this.summary;
        }

        public int getKeywords() {
            return this.keywords;
        }

        public void setKeywords(int keywords) {
            this.keywords = keywords;
        }
    }
}

