/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.bounce.text.LineNumberMargin;
import org.bounce.text.ScrollableEditorPanel;
import org.bounce.text.xml.XMLEditorKit;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.jni.netcdf.Nc4Chunking;
import ucar.nc2.jni.netcdf.Nc4ChunkingStrategyImpl;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.NcMLWriter;
import ucar.nc2.ui.dialog.NetcdfOutputChooser;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.IO;
import ucar.util.prefs.PersistenceManager;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.ComboBox;

public class NcmlEditor
extends JPanel {
    private static final boolean debugNcmlWrite = false;
    private NetcdfDataset ds = null;
    private String ncmlLocation = null;
    private JEditorPane editor;
    private Map<String, String> protoMap = new HashMap<String, String>(10);
    private ComboBox protoChooser;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private FileManager fileChooser;
    private NetcdfOutputChooser outChooser;
    private final AbstractButton coordButt;
    private boolean addCoords;
    private PreferencesExt prefs;

    public NcmlEditor(JPanel buttPanel, PreferencesExt prefs) {
        this.prefs = prefs;
        this.fileChooser = new FileManager(null, null, null, (PreferencesExt)prefs.node("FileManager"));
        AbstractAction coordAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NcmlEditor.this.addCoords = (Boolean)this.getValue("state");
                String tooltip = NcmlEditor.this.addCoords ? "add Coordinates is ON" : "add Coordinates is OFF";
                NcmlEditor.this.coordButt.setToolTipText(tooltip);
            }
        };
        this.addCoords = prefs.getBoolean("coordState", false);
        String tooltip2 = this.addCoords ? "add Coordinates is ON" : "add Coordinates is OFF";
        BAMutil.setActionProperties(coordAction, "addCoords", tooltip2, true, 67, -1);
        coordAction.putValue("state", this.addCoords);
        this.coordButt = BAMutil.addActionToContainer(buttPanel, coordAction);
        this.protoChooser = new ComboBox((PersistenceManager)((PreferencesExt)prefs.node("protoChooser")));
        this.addProtoChoices();
        buttPanel.add(this.protoChooser);
        this.protoChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String ptype = (String)NcmlEditor.this.protoChooser.getSelectedItem();
                String proto = (String)NcmlEditor.this.protoMap.get(ptype);
                if (proto != null) {
                    NcmlEditor.this.editor.setText(proto);
                }
            }
        });
        this.editor = new JEditorPane();
        XMLEditorKit kit = new XMLEditorKit(false);
        kit.setWrapStyleWord(true);
        this.editor.setEditorKit((EditorKit)kit);
        this.editor.setFont(new Font("Monospaced", 0, 12));
        this.editor.getDocument().putProperty("tabSize", 2);
        this.editor.getDocument().putProperty("autoIndentation", true);
        this.editor.getDocument().putProperty("tagCompletion", true);
        kit.setFolding(true);
        kit.setStyle("attribute-name", Color.RED, 1);
        ScrollableEditorPanel editorPanel = new ScrollableEditorPanel(this.editor);
        JScrollPane scroller = new JScrollPane((Component)editorPanel);
        scroller.setRowHeaderView((Component)new LineNumberMargin((JTextComponent)this.editor));
        AbstractAction wrapAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLEditorKit kit;
                kit.setLineWrappingEnabled(!(kit = (XMLEditorKit)NcmlEditor.this.editor.getEditorKit()).isLineWrapping());
                NcmlEditor.this.editor.updateUI();
            }
        };
        BAMutil.setActionProperties(wrapAction, "Wrap", "Toggle Wrapping", false, 87, -1);
        BAMutil.addActionToContainer(buttPanel, wrapAction);
        AbstractAction saveAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filename;
                int pos;
                String location;
                String string = location = NcmlEditor.this.ds == null ? NcmlEditor.this.ncmlLocation : NcmlEditor.this.ds.getLocation();
                if (location == null) {
                    location = "test";
                }
                if ((pos = location.lastIndexOf(".")) > 0) {
                    location = location.substring(0, pos);
                }
                if ((filename = NcmlEditor.this.fileChooser.chooseFilenameToSave(location + ".ncml")) == null) {
                    return;
                }
                if (NcmlEditor.this.doSaveNcml(NcmlEditor.this.editor.getText(), filename)) {
                    NcmlEditor.this.ncmlLocation = filename;
                }
            }
        };
        BAMutil.setActionProperties(saveAction, "Save", "Save NcML", false, 83, -1);
        BAMutil.addActionToContainer(buttPanel, saveAction);
        AbstractAction netcdfAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int pos;
                String location;
                if (NcmlEditor.this.outChooser == null) {
                    NcmlEditor.this.outChooser = new NetcdfOutputChooser((Frame)null);
                    NcmlEditor.this.outChooser.addPropertyChangeListener("OK", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            NcmlEditor.this.writeNetcdf((NetcdfOutputChooser.Data)evt.getNewValue());
                        }
                    });
                }
                String string = location = NcmlEditor.this.ds == null ? NcmlEditor.this.ncmlLocation : NcmlEditor.this.ds.getLocation();
                if (location == null) {
                    location = "test";
                }
                if ((pos = location.lastIndexOf(".")) > 0) {
                    location = location.substring(0, pos);
                }
                NcmlEditor.this.outChooser.setOutputFilename(location);
                NcmlEditor.this.outChooser.setVisible(true);
            }
        };
        BAMutil.setActionProperties(netcdfAction, "netcdf", "Write netCDF file", false, 78, -1);
        BAMutil.addActionToContainer(buttPanel, netcdfAction);
        AbstractAction transAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NcmlEditor.this.doTransform(NcmlEditor.this.editor.getText());
            }
        };
        BAMutil.setActionProperties(transAction, "Import", "read textArea through NcMLReader\n write NcML back out via resulting dataset", false, 84, -1);
        BAMutil.addActionToContainer(buttPanel, transAction);
        AbstractButton compareButton = BAMutil.makeButtcon("Select", "Check NcML", false);
        compareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                NcmlEditor.this.checkNcml(f);
                NcmlEditor.this.infoTA.setText(f.toString());
                NcmlEditor.this.infoTA.gotoTop();
                NcmlEditor.this.infoWindow.show();
            }
        });
        buttPanel.add(compareButton);
        this.setLayout(new BorderLayout());
        this.add((Component)scroller, "Center");
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
    }

    public void save() {
        this.fileChooser.save();
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
    }

    public void closeOpenFiles() {
        try {
            if (this.ds != null) {
                this.ds.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.ds = null;
    }

    public boolean setNcml(String cmd) {
        if (cmd.endsWith(".xml") || cmd.endsWith(".ncml")) {
            if (!cmd.startsWith("http:") && !cmd.startsWith("file:")) {
                cmd = "file:" + cmd;
            }
            this.ncmlLocation = cmd;
            String text = IO.readURLcontents((String)cmd);
            this.editor.setText(text);
        } else {
            this.writeNcml(cmd);
        }
        return true;
    }

    boolean writeNcml(String location) {
        boolean err = false;
        this.closeOpenFiles();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
        try {
            this.ds = this.openDataset(location, this.addCoords, null);
            if (this.ds == null) {
                this.editor.setText("Failed to open <" + location + ">");
            } else {
                String result = new NcMLWriter().writeXML((NetcdfFile)this.ds);
                this.editor.setText(result);
                this.editor.setCaretPosition(0);
            }
        }
        catch (FileNotFoundException ioe) {
            this.editor.setText("Failed to open <" + location + ">");
            err = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            e.printStackTrace(new PrintStream(bos));
            this.editor.setText(bos.toString());
            err = true;
        }
        return !err;
    }

    private NetcdfDataset openDataset(String location, boolean addCoords, CancelTask task) {
        try {
            NetcdfDataset ncd = NetcdfDataset.openDataset((String)location, (boolean)addCoords, (CancelTask)task);
            return ncd;
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + ioe.getMessage());
            if (!(ioe instanceof FileNotFoundException)) {
                ioe.printStackTrace();
            }
            return null;
        }
    }

    void writeNetcdf(NetcdfOutputChooser.Data data) {
        String text = this.editor.getText();
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(text.getBytes());
            NcMLReader.writeNcMLToFile((InputStream)bis, (String)data.outputFilename, (NetcdfFileWriter.Version)data.version, (Nc4Chunking)Nc4ChunkingStrategyImpl.factory((Nc4Chunking.Strategy)data.chunkerType, (int)data.deflate, (boolean)data.shuffle));
            JOptionPane.showMessageDialog(this, "File successfully written");
        }
        catch (Exception ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    void doTransform(String text) {
        try {
            StringReader reader = new StringReader(text);
            NetcdfDataset ncd = NcMLReader.readNcML((Reader)reader, null);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            ncd.writeNcML((OutputStream)bos, null);
            this.editor.setText(bos.toString());
            this.editor.setCaretPosition(0);
            JOptionPane.showMessageDialog(this, "File successfully transformed");
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    private void checkNcml(Formatter f) {
        if (this.ncmlLocation == null) {
            return;
        }
        try {
            NetcdfDataset ncd = NetcdfDataset.openDataset((String)this.ncmlLocation);
            ncd.check(f);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    boolean doSaveNcml(String text, String filename) {
        int val;
        File out = new File(filename);
        if (out.exists() && (val = JOptionPane.showConfirmDialog(null, filename + " already exists. Do you want to overrwrite?", "WARNING", 0)) != 0) {
            return false;
        }
        try {
            IO.writeToFile((String)text, (File)out);
            JOptionPane.showMessageDialog(this, "File successfully written");
            return true;
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
            return false;
        }
    }

    void addProtoChoices() {
        String xml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n  <variable name='time' type='int' shape='time'>\n    <attribute name='long_name' type='string' value='time coordinate' />\n    <attribute name='units' type='string' value='days since 2001-8-31 00:00:00 UTC' />\n    <values start='0' increment='10' />\n  </variable>\n  <aggregation dimName='time' type='joinNew'>\n    <variableAgg name='T'/>\n    <scan location='src/test/data/ncml/nc/' suffix='.nc' subdirs='false'/>\n  </aggregation>\n</netcdf>";
        this.protoMap.put("joinNew", xml);
        this.protoChooser.addItem("joinNew");
        xml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n  <aggregation dimName='time' type='joinExisting'>\n    <scan location='ncml/nc/pfeg/' suffix='.nc' />\n  </aggregation>\n</netcdf>";
        this.protoMap.put("joinExisting", xml);
        this.protoChooser.addItem("joinExisting");
    }
}

