/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.SequenceDS;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.bufr.BufrIosp;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageCompressedDataReader;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.iosp.bufr.MessageUncompressedDataReader;
import ucar.nc2.iosp.bufr.writer.Bufr2Xml;
import ucar.nc2.ui.StructureTable;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class BufrMessageViewer
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted messageTable;
    private BeanTableSorted obsTable;
    private BeanTableSorted ddsTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoTA;
    private TextHistoryPane infoTA2;
    private IndependentWindow infoWindow;
    private IndependentWindow infoWindow2;
    private StructureTable dataTable;
    private IndependentWindow dataWindow;
    private FileManager fileChooser;
    private DateFormatter df = new DateFormatter();
    private boolean seperateWindow = false;
    private boolean doRead = false;
    private RandomAccessFile raf;
    private MessageScanner scan;

    public BufrMessageViewer(final PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        AbstractButton showButt = BAMutil.makeButtcon("addCoords", "Read Data", false);
        showButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List obs = BufrMessageViewer.this.messageTable.getBeans();
                for (Object ob : obs) {
                    MessageBean mb = (MessageBean)ob;
                    mb.read();
                }
            }
        });
        buttPanel.add(showButt);
        AbstractAction seperateWindowAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                BufrMessageViewer.this.seperateWindow = state;
            }
        };
        BAMutil.setActionProperties(seperateWindowAction, "addCoords", "seperate DDS window", true, 67, -1);
        seperateWindowAction.putValue("state", new Boolean(this.seperateWindow));
        BAMutil.addActionToContainer(buttPanel, seperateWindowAction);
        this.messageTable = new BeanTableSorted(MessageBean.class, (PreferencesExt)prefs.node("GridRecordBean"), false);
        this.messageTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BufrMessageViewer.this.ddsTable.setBeans(new ArrayList());
                BufrMessageViewer.this.obsTable.setBeans(new ArrayList());
                MessageBean mb = (MessageBean)BufrMessageViewer.this.messageTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                ArrayList beanList = new ArrayList();
                try {
                    BufrMessageViewer.this.setDataDescriptors(beanList, mb.m.getRootDataDescriptor(), 0);
                    BufrMessageViewer.this.setObs(mb.m);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(BufrMessageViewer.this, e1.getMessage());
                    e1.printStackTrace();
                }
                BufrMessageViewer.this.ddsTable.setBeans(beanList);
            }
        });
        this.obsTable = new BeanTableSorted(ObsBean.class, (PreferencesExt)prefs.node("ObsBean"), false);
        this.obsTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ObsBean csb = (ObsBean)BufrMessageViewer.this.obsTable.getSelectedBean();
            }
        });
        this.ddsTable = new BeanTableSorted(DdsBean.class, (PreferencesExt)prefs.node("DdsBean"), false);
        this.ddsTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DdsBean csb = (DdsBean)BufrMessageViewer.this.ddsTable.getSelectedBean();
            }
        });
        PopupMenu varPopup = new PopupMenu(this.messageTable.getJTable(), "Options");
        varPopup.addAction("Show DDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBean vb = (MessageBean)BufrMessageViewer.this.messageTable.getSelectedBean();
                if (vb == null) {
                    return;
                }
                if (!BufrMessageViewer.this.seperateWindow) {
                    BufrMessageViewer.this.infoTA.clear();
                }
                Formatter f = new Formatter();
                try {
                    if (!vb.m.isTablesComplete()) {
                        f.format(" MISSING DATA DESCRIPTORS= ", new Object[0]);
                        vb.m.showMissingFields(f);
                        f.format("%n%n", new Object[0]);
                    }
                    vb.m.dump(f);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(BufrMessageViewer.this, e1.getMessage());
                    e1.printStackTrace();
                }
                if (BufrMessageViewer.this.seperateWindow) {
                    TextHistoryPane ta = new TextHistoryPane();
                    IndependentWindow info = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), ta);
                    info.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
                    ta.appendLine(f.toString());
                    ta.gotoTop();
                    info.show();
                } else {
                    BufrMessageViewer.this.infoTA.appendLine(f.toString());
                    BufrMessageViewer.this.infoTA.gotoTop();
                    BufrMessageViewer.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Data Table", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBean mb = (MessageBean)BufrMessageViewer.this.messageTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                try {
                    NetcdfDataset ncd = BufrMessageViewer.this.getBufrMessageAsDataset(mb.m);
                    Variable v = ncd.findVariable("obs");
                    if (v != null && v instanceof Structure) {
                        if (BufrMessageViewer.this.dataTable == null) {
                            BufrMessageViewer.this.makeDataTable();
                        }
                        BufrMessageViewer.this.dataTable.setStructure((Structure)v);
                        BufrMessageViewer.this.dataWindow.show();
                        mb.setReadOk(true);
                    }
                }
                catch (Exception ex) {
                    mb.setReadOk(false);
                    JOptionPane.showMessageDialog(BufrMessageViewer.this, ex.getMessage());
                    ex.printStackTrace();
                }
            }
        });
        varPopup.addAction("Bit Count Details", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBean mb = (MessageBean)BufrMessageViewer.this.messageTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                Message m = mb.m;
                Formatter out = new Formatter();
                try {
                    MessageUncompressedDataReader reader;
                    BufrMessageViewer.this.infoTA2.clear();
                    if (!m.dds.isCompressed()) {
                        reader = new MessageUncompressedDataReader();
                        reader.readData(null, m, BufrMessageViewer.this.raf, null, false, out);
                    } else {
                        reader = new MessageCompressedDataReader();
                        reader.readData(null, m, BufrMessageViewer.this.raf, null, out);
                    }
                    int nbitsGiven = 8 * (m.dataSection.getDataLength() - 4);
                    DataDescriptor root = m.getRootDataDescriptor();
                    out.format("Message nobs=%d compressed=%s vlen=%s countBits= %d givenBits=%d %n", m.getNumberDatasets(), m.dds.isCompressed(), root.isVarLength(), m.getCountedDataBits(), nbitsGiven);
                    out.format(" countBits= %d givenBits=%d %n", m.getCountedDataBits(), nbitsGiven);
                    out.format(" countBytes= %d dataSize=%d %n", m.getCountedDataBytes(), m.dataSection.getDataLength());
                    out.format("%n", new Object[0]);
                    BufrMessageViewer.this.infoTA2.appendLine(out.toString());
                }
                catch (Exception ex) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ex.printStackTrace(new PrintStream(bos));
                    BufrMessageViewer.this.infoTA2.appendLine(out.toString());
                    BufrMessageViewer.this.infoTA2.appendLine(bos.toString());
                }
                BufrMessageViewer.this.infoTA2.gotoTop();
                BufrMessageViewer.this.infoWindow2.show();
            }
        });
        varPopup.addAction("Read", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBean mb = (MessageBean)BufrMessageViewer.this.messageTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                mb.read();
            }
        });
        varPopup.addAction("BitCount", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBean mb = (MessageBean)BufrMessageViewer.this.messageTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                mb.checkBits();
            }
        });
        varPopup.addAction("Write Message", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBean mb = (MessageBean)BufrMessageViewer.this.messageTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                try {
                    String filename;
                    String defloc;
                    String header = mb.m.getHeader();
                    if (header != null) {
                        header = header.split(" ")[0];
                    }
                    if (header == null) {
                        defloc = BufrMessageViewer.this.raf.getLocation() == null ? "." : BufrMessageViewer.this.raf.getLocation();
                        int pos = defloc.lastIndexOf(".");
                        if (pos > 0) {
                            defloc = defloc.substring(0, pos);
                        }
                    } else {
                        defloc = header;
                    }
                    if (BufrMessageViewer.this.fileChooser == null) {
                        BufrMessageViewer.this.fileChooser = new FileManager(null, null, null, (PreferencesExt)prefs.node("FileManager"));
                    }
                    if ((filename = BufrMessageViewer.this.fileChooser.chooseFilenameToSave(defloc + ".bufr")) == null) {
                        return;
                    }
                    File file = new File(filename);
                    FileOutputStream fos = new FileOutputStream(file);
                    FileChannel wbc = fos.getChannel();
                    wbc.write(ByteBuffer.wrap(mb.m.getHeader().getBytes()));
                    byte[] raw = BufrMessageViewer.this.scan.getMessageBytes(mb.m);
                    wbc.write(ByteBuffer.wrap(raw));
                    wbc.close();
                    JOptionPane.showMessageDialog(BufrMessageViewer.this, filename + " successfully written");
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(BufrMessageViewer.this, "ERROR: " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
        });
        varPopup.addAction("Dump distinct DDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufrMessageViewer.this.dumpDDS();
            }
        });
        varPopup.addAction("Write all distinct messages", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufrMessageViewer.this.writeAll();
            }
        });
        varPopup.addAction("Show XML", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBean mb = (MessageBean)BufrMessageViewer.this.messageTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                Message m = mb.m;
                ByteArrayOutputStream out = new ByteArrayOutputStream(100000);
                try {
                    BufrMessageViewer.this.infoTA.clear();
                    NetcdfDataset ncd = BufrMessageViewer.this.getBufrMessageAsDataset(mb.m);
                    new Bufr2Xml(m, ncd, (OutputStream)out, true);
                    BufrMessageViewer.this.infoTA.setText(out.toString());
                }
                catch (Exception ex) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ex.printStackTrace(new PrintStream(bos));
                    BufrMessageViewer.this.infoTA.appendLine(out.toString());
                    BufrMessageViewer.this.infoTA.appendLine(bos.toString());
                }
                BufrMessageViewer.this.infoTA.gotoTop();
                BufrMessageViewer.this.infoWindow.show();
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.infoTA2 = new TextHistoryPane();
        this.infoWindow2 = new IndependentWindow("Extra Information-2", BAMutil.getImage("netcdfUI"), this.infoTA2);
        this.infoWindow2.setBounds((Rectangle)prefs.getBean("InfoWindowBounds2", (Object)new Rectangle(300, 300, 500, 300)));
        this.split2 = new JSplitPane(0, false, this.ddsTable, this.obsTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.split = new JSplitPane(0, false, this.messageTable, this.split2);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    private void makeDataTable() {
        this.dataTable = new StructureTable((PreferencesExt)this.prefs.node("structTable"));
        this.dataWindow = new IndependentWindow("Data Table", BAMutil.getImage("netcdfUI"), this.dataTable);
        this.dataWindow.setBounds((Rectangle)this.prefs.getBean("dataWindow", (Object)new Rectangle(50, 300, 1000, 600)));
    }

    private void writeAll() {
        String defloc;
        String dirName;
        List beans = this.messageTable.getBeans();
        HashMap<Integer, Message> map = new HashMap<Integer, Message>(2 * beans.size());
        for (MessageBean mb : beans) {
            map.put(mb.m.hashCode(), mb.m);
        }
        if (this.fileChooser == null) {
            this.fileChooser = new FileManager(null, null, null, (PreferencesExt)this.prefs.node("FileManager"));
        }
        if ((dirName = this.fileChooser.chooseDirectory(defloc = this.raf.getLocation() == null ? "." : this.raf.getLocation())) == null) {
            return;
        }
        try {
            int count = 0;
            for (Message m : map.values()) {
                String header = m.getHeader();
                header = header != null ? header.split(" ")[0] : Integer.toString(Math.abs(m.hashCode()));
                File file = new File(dirName + "/" + header + ".bufr");
                FileOutputStream fos = new FileOutputStream(file);
                FileChannel wbc = fos.getChannel();
                wbc.write(ByteBuffer.wrap(m.getHeader().getBytes()));
                byte[] raw = this.scan.getMessageBytes(m);
                wbc.write(ByteBuffer.wrap(raw));
                wbc.close();
                ++count;
            }
            JOptionPane.showMessageDialog(this, count + " successfully written to " + dirName);
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this, e1.getMessage());
            e1.printStackTrace();
        }
    }

    private void dumpDDS() {
        String filename;
        String defloc;
        int pos;
        List beans = this.messageTable.getBeans();
        HashMap<Integer, Message> map = new HashMap<Integer, Message>(2 * beans.size());
        for (MessageBean mb : beans) {
            map.put(mb.m.hashCode(), mb.m);
        }
        if (this.fileChooser == null) {
            this.fileChooser = new FileManager(null, null, null, (PreferencesExt)this.prefs.node("FileManager"));
        }
        if ((pos = (defloc = this.raf.getLocation() == null ? "." : this.raf.getLocation()).lastIndexOf(".")) > 0) {
            defloc = defloc.substring(0, pos);
        }
        if ((filename = this.fileChooser.chooseFilenameToSave(defloc + ".txt")) == null) {
            return;
        }
        try {
            File file = new File(filename);
            FileOutputStream fos = new FileOutputStream(file);
            int count = 0;
            for (Message m : map.values()) {
                Formatter f = new Formatter(fos);
                m.dump(f);
                f.flush();
                ++count;
            }
            fos.close();
            JOptionPane.showMessageDialog(this, count + " successfully written to " + filename);
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this, e1.getMessage());
            e1.printStackTrace();
        }
    }

    public void save() {
        this.messageTable.saveState(false);
        this.ddsTable.saveState(false);
        this.obsTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putBeanObject("InfoWindowBounds2", (Object)this.infoWindow2.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        if (this.fileChooser != null) {
            this.fileChooser.save();
        }
    }

    public void setBufrFile(RandomAccessFile raf) throws IOException {
        this.raf = raf;
        ArrayList<MessageBean> beanList = new ArrayList<MessageBean>();
        this.scan = new MessageScanner(raf, 0L, true);
        while (this.scan.hasNext()) {
            Message m = this.scan.next();
            if (m == null) continue;
            beanList.add(new MessageBean(m));
        }
        this.messageTable.setBeans(beanList);
        this.obsTable.setBeans(new ArrayList());
        this.ddsTable.setBeans(new ArrayList());
    }

    private NetcdfDataset getBufrMessageAsDataset(Message m) throws IOException {
        BufrIosp iosp = new BufrIosp();
        BufrNetcdf ncfile = new BufrNetcdf((IOServiceProvider)iosp, this.raf.getLocation());
        iosp.open(this.raf, (NetcdfFile)ncfile, m);
        return new NetcdfDataset((NetcdfFile)ncfile);
    }

    private int setDataDescriptors(List<DdsBean> beanList, DataDescriptor dds, int seqno) {
        for (DataDescriptor key : dds.getSubKeys()) {
            beanList.add(new DdsBean(key, seqno++));
            if (key.getSubKeys() == null) continue;
            seqno = this.setDataDescriptors(beanList, key, seqno);
        }
        return seqno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setObs(Message m) {
        ArrayList<ObsBean> beanList;
        block6: {
            beanList = new ArrayList<ObsBean>();
            try {
                NetcdfDataset ncd = this.getBufrMessageAsDataset(m);
                Variable v = ncd.findVariable("obs");
                if (v == null || !(v instanceof Structure)) break block6;
                Structure obs = (Structure)v;
                StructureDataIterator iter = obs.getStructureIterator();
                try {
                    while (iter.hasNext()) {
                        beanList.add(new ObsBean(obs, iter.next()));
                    }
                }
                finally {
                    iter.finish();
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage());
                ex.printStackTrace();
            }
        }
        this.obsTable.setBeans(beanList);
    }

    public class ObsBean {
        double lat = Double.NaN;
        double lon = Double.NaN;
        double alt = Double.NaN;
        int year = -1;
        int month = -1;
        int day = -1;
        int hour = -1;
        int minute = -1;
        int sec = -1;
        Date time;
        int wmo_block = -1;
        int wmo_id = -1;
        String stn = null;

        public ObsBean() {
        }

        public ObsBean(Structure obs, StructureData sdata) {
            String val;
            Attribute att;
            for (Variable v : obs.getVariables()) {
                att = v.findAttribute("BUFR:TableB_descriptor");
                if (att == null) continue;
                val = att.getStringValue();
                if (val.equals("0-5-1") && Double.isNaN(this.lat)) {
                    this.lat = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-6-1") && Double.isNaN(this.lon)) {
                    this.lon = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-7-30") && Double.isNaN(this.alt)) {
                    this.alt = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-1") && this.year < 0) {
                    this.year = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-2") && this.month < 0) {
                    this.month = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-3") && this.day < 0) {
                    this.day = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-4") && this.hour < 0) {
                    this.hour = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-5") && this.minute < 0) {
                    this.minute = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-6") && this.sec < 0) {
                    this.sec = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-1-1") && this.wmo_block < 0) {
                    this.wmo_block = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-1-2") && this.wmo_id < 0) {
                    this.wmo_id = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (this.stn != null || !val.equals("0-1-18")) continue;
                if (v.getDataType().isString()) {
                    this.stn = sdata.getScalarString(v.getShortName());
                    continue;
                }
                this.stn = Integer.toString(sdata.convertScalarInt(v.getShortName()));
            }
            for (Variable v : obs.getVariables()) {
                att = v.findAttribute("BUFR:TableB_descriptor");
                if (att == null) continue;
                val = att.getStringValue();
                if (val.equals("0-5-2") && Double.isNaN(this.lat)) {
                    this.lat = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-6-2") && Double.isNaN(this.lon)) {
                    this.lon = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-7-1") && Double.isNaN(this.alt)) {
                    this.alt = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-7") && this.sec < 0) {
                    this.sec = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (this.stn != null || !val.equals("0-1-15") && !val.equals("0-1-19")) continue;
                if (v.getDataType().isString()) {
                    this.stn = sdata.getScalarString(v.getShortName());
                    continue;
                }
                this.stn = Integer.toString(sdata.convertScalarInt(v.getShortName()));
            }
            for (Variable v : obs.getVariables()) {
                att = v.findAttribute("BUFR:TableB_descriptor");
                if (att == null) continue;
                val = att.getStringValue();
                if (val.equals("0-7-10") && Double.isNaN(this.alt)) {
                    this.alt = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-7-2") && Double.isNaN(this.alt)) {
                    this.alt = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (this.stn != null || !val.equals("0-1-2")) continue;
                if (v.getDataType().isString()) {
                    this.stn = sdata.getScalarString(v.getShortName());
                    continue;
                }
                this.stn = Integer.toString(sdata.convertScalarInt(v.getShortName()));
            }
            if (this.stn == null) {
                for (Variable v : obs.getVariables()) {
                    att = v.findAttribute("BUFR:TableB_descriptor");
                    if (att == null || !(val = att.getStringValue()).equals("0-1-5") && !val.equals("0-1-6") && !val.equals("0-1-7") && !val.equals("0-1-8") && !val.equals("0-1-10") && !val.equals("0-1-11")) continue;
                    if (v.getDataType().isString()) {
                        this.stn = sdata.getScalarString(v.getShortName());
                        continue;
                    }
                    this.stn = Integer.toString(sdata.convertScalarInt(v.getShortName()));
                }
            }
        }

        public double getLat() {
            return this.lat;
        }

        public double getLon() {
            return this.lon;
        }

        public double getHeight() {
            return this.alt;
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }

        public int getDay() {
            return this.day;
        }

        public int getHour() {
            return this.hour;
        }

        public int getMinute() {
            return this.minute;
        }

        public int getSec() {
            return this.sec;
        }

        public String getWmoId() {
            return this.wmo_block + "/" + this.wmo_id;
        }

        public String getStation() {
            return this.stn;
        }
    }

    public class DdsBean {
        DataDescriptor dds;
        int seq;

        public DdsBean() {
        }

        public DdsBean(DataDescriptor dds, int seq) {
            this.dds = dds;
            this.seq = seq;
        }

        public String getFxy() {
            return this.dds.getFxyName();
        }

        public String getName() {
            return this.dds.getName();
        }

        public String getUnits() {
            return this.dds.getUnits();
        }

        public String getDesc() {
            return this.dds.getDesc();
        }

        public int getBitWidth() {
            return this.dds.getBitWidth();
        }

        public int getScale() {
            return this.dds.getScale();
        }

        public int getReference() {
            return this.dds.getRefVal();
        }

        public String getSource() {
            return this.dds.getSource();
        }

        public int getSeq() {
            return this.seq;
        }

        public String getLocal() {
            if (this.dds.isLocalOverride()) {
                return "override";
            }
            return this.dds.isLocal() ? "true" : "false";
        }
    }

    public class MessageBean {
        Message m;
        int readOk = 0;
        int bitsOk = 0;

        public MessageBean() {
        }

        public MessageBean(Message m) {
            this.m = m;
        }

        public String getCategory() throws IOException {
            return this.m.getCategoryFullName();
        }

        public String getCenter() {
            return this.m.getCenterName();
        }

        public String getTable() {
            return this.m.getTableName();
        }

        public String getHeader() {
            return this.m.getHeader();
        }

        public int getEdition() {
            return this.m.is.getBufrEdition();
        }

        public int getNobs() {
            return this.m.getNumberDatasets();
        }

        public long getSize() {
            return this.m.getMessageSize();
        }

        public String getHash() {
            return Integer.toHexString(this.m.dds.getDataDescriptors().hashCode());
        }

        public String getCompress() {
            return this.m.dds.isCompressed() ? "true" : "false";
        }

        public String getDate() {
            return this.m.getReferenceTime().toString();
        }

        public String getComplete() {
            try {
                return this.m.isTablesComplete() ? "true" : "false";
            }
            catch (IOException e) {
                return "exception";
            }
        }

        public String getBitsOk() {
            if (this.bitsOk == 0) {
                this.checkBits();
            }
            switch (this.bitsOk) {
                default: {
                    return "N/A";
                }
                case 1: {
                    return "true";
                }
                case 2: {
                    return "false";
                }
                case 3: 
            }
            return "fail";
        }

        void checkBits() {
            if (this.getNobs() == 0) {
                return;
            }
            try {
                boolean ok = this.m.isBitCountOk();
                this.setBitsOk(ok);
            }
            catch (Exception e) {
                this.bitsOk = 3;
            }
        }

        public String getLocal() {
            try {
                return this.m.usesLocalTable() ? "true" : "false";
            }
            catch (Exception e) {
                return "exception";
            }
        }

        public String getReadOk() {
            switch (this.readOk) {
                default: {
                    return "N/A";
                }
                case 1: {
                    return "true";
                }
                case 2: 
            }
            return "false";
        }

        void setBitsOk(boolean ok) {
            this.bitsOk = ok ? 1 : 2;
        }

        void setReadOk(boolean ok) {
            this.readOk = ok ? 1 : 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void read() {
            try {
                NetcdfDataset ncd = BufrMessageViewer.this.getBufrMessageAsDataset(this.m);
                SequenceDS v = (SequenceDS)ncd.findVariable("obs");
                StructureDataIterator iter = v.getStructureIterator(-1);
                try {
                    while (iter.hasNext()) {
                        iter.next();
                    }
                }
                finally {
                    iter.finish();
                }
                this.setReadOk(true);
            }
            catch (Exception e) {
                this.setReadOk(false);
            }
        }
    }

    private class BufrNetcdf
    extends NetcdfFile {
        protected BufrNetcdf(IOServiceProvider spi, String location) throws IOException {
            super(spi, location);
        }
    }
}

