/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ui.CoordSysTable;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class FmrcTable
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted messageTable;
    private JSplitPane split;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private CoordSysTable coordSysTable;

    public FmrcTable(PreferencesExt prefs) {
        this.prefs = prefs;
        this.messageTable = new BeanTableSorted(DatasetBean.class, (PreferencesExt)prefs.node("DatasetBean"), false);
        this.messageTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DatasetBean dsb = (DatasetBean)FmrcTable.this.messageTable.getSelectedBean();
                if (dsb != null) {
                    FmrcTable.this.coordSysTable.setDataset(dsb.ds);
                }
            }
        });
        PopupMenu varPopup = new PopupMenu(this.messageTable.getJTable(), "Options");
        varPopup.addAction("Open as NetcdfFile", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetBean dsb = (DatasetBean)FmrcTable.this.messageTable.getSelectedBean();
                if (dsb == null) {
                    return;
                }
                FmrcTable.this.firePropertyChange("openNetcdfFile", null, dsb.ds);
            }
        });
        varPopup.addAction("Check CoordSystems", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetBean dsb = (DatasetBean)FmrcTable.this.messageTable.getSelectedBean();
                if (dsb == null) {
                    return;
                }
                FmrcTable.this.firePropertyChange("openCoordSystems", null, dsb.ds);
            }
        });
        varPopup.addAction("Open as GridDataset", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetBean dsb = (DatasetBean)FmrcTable.this.messageTable.getSelectedBean();
                if (dsb == null) {
                    return;
                }
                FmrcTable.this.firePropertyChange("openGridDataset", null, dsb.ds);
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.coordSysTable = new CoordSysTable((PreferencesExt)prefs.node("CoordSys"), null);
        this.split = new JSplitPane(0, false, this.messageTable, this.coordSysTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.messageTable.saveState(false);
        this.coordSysTable.save();
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    public class DatasetBean {
        String name;
        NetcdfDataset ds;

        public DatasetBean() {
        }

        public DatasetBean(String name, NetcdfDataset ds) {
            this.ds = ds;
            this.name = name;
        }

        public String getLocation() throws IOException {
            return this.ds.getLocation();
        }

        public String getName() {
            return this.name;
        }
    }
}

