/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.ma2.StructureData;
import ucar.nc2.NCdumpW;
import ucar.nc2.dt.PointObsDataset;
import ucar.nc2.dt.PointObsDatatype;
import ucar.nc2.ui.point.StationRegionDateChooser;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentDialog;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class PointObsViewer
extends JPanel {
    private PreferencesExt prefs;
    private PointObsDataset pds;
    private StationRegionDateChooser chooser;
    private BeanTableSorted stnTable;
    private JSplitPane splitH = null;
    private IndependentDialog infoWindow;
    private DateFormatter df = new DateFormatter();
    private TextHistoryPane dumpTA;
    private IndependentDialog dumpWindow;
    private boolean eventsOK = true;
    private boolean debugStationRegionSelect = false;
    private boolean debugStationDatsets = false;
    private boolean debugQuery = false;

    public PointObsViewer(PreferencesExt prefs) {
        this.prefs = prefs;
        this.df = new DateFormatter();
        this.chooser = new StationRegionDateChooser();
        this.chooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("Station")) {
                    Station selectedStation = (Station)e.getNewValue();
                    if (PointObsViewer.this.debugStationRegionSelect) {
                        System.out.println("selectedStation= " + selectedStation.getName());
                    }
                    PointObsViewer.this.eventsOK = false;
                    PointObsViewer.this.stnTable.setSelectedBean(selectedStation);
                    PointObsViewer.this.eventsOK = true;
                }
            }
        });
        AbstractAction queryAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PointObsViewer.this.pds == null) {
                    return;
                }
                DateRange dateRange = PointObsViewer.this.chooser.getDateRange();
                boolean useDate = null != dateRange;
                Date startDate = dateRange.getStart().getDate();
                Date endDate = dateRange.getEnd().getDate();
                if (PointObsViewer.this.debugQuery) {
                    System.out.println("date range=" + dateRange);
                }
                LatLonRect geoRegion = PointObsViewer.this.chooser.getGeoSelectionLL();
                if (PointObsViewer.this.debugQuery) {
                    System.out.println("geoRegion=" + geoRegion);
                }
                try {
                    List obsList;
                    List list = obsList = useDate ? PointObsViewer.this.pds.getData(geoRegion, startDate, endDate) : PointObsViewer.this.pds.getData(geoRegion);
                    if (PointObsViewer.this.debugQuery) {
                        System.out.println("obsList=" + obsList.size());
                    }
                    PointObsViewer.this.setObservations(obsList);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        };
        BAMutil.setActionProperties(queryAction, "query", "query for data", false, 81, -1);
        this.chooser.addToolbarAction(queryAction);
        AbstractAction getAllAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PointObsViewer.this.pds == null) {
                    return;
                }
                try {
                    List obsList = PointObsViewer.this.pds.getData();
                    if (obsList != null) {
                        PointObsViewer.this.setObservations(obsList);
                    } else {
                        JOptionPane.showMessageDialog(PointObsViewer.this, "GetAllData not implemented");
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        };
        BAMutil.setActionProperties(getAllAction, "GetAll", "get ALL data", false, 65, -1);
        this.chooser.addToolbarAction(getAllAction);
        this.stnTable = new BeanTableSorted(PointObsBean.class, (PreferencesExt)prefs.node("PointBeans"), false);
        this.stnTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PointObsBean sb = (PointObsBean)PointObsViewer.this.stnTable.getSelectedBean();
                if (PointObsViewer.this.debugStationRegionSelect) {
                    System.out.println("stnTable selected= " + sb.getName());
                }
                if (PointObsViewer.this.eventsOK) {
                    PointObsViewer.this.chooser.setSelectedStation(sb.getName());
                }
                if (sb != null) {
                    PointObsViewer.this.showData(sb.pobs);
                }
            }
        });
        TextHistoryPane infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentDialog(null, true, "Station Information", infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.splitH = new JSplitPane(1, false, this.stnTable, this.chooser);
        this.splitH.setDividerLocation(prefs.getInt("splitPosH", 400));
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitH, "Center");
        this.dumpTA = new TextHistoryPane(false);
        this.dumpWindow = new IndependentDialog(null, false, "Show Data", this.dumpTA);
        this.dumpWindow.setBounds((Rectangle)prefs.getBean("DumpWindowBounds", new Rectangle(300, 300, 300, 200)));
    }

    public void setDataset(PointObsDataset dataset) {
        this.pds = dataset;
        if (this.debugStationDatsets) {
            System.out.println("PointObsViewer open type " + dataset.getClass().getName());
        }
        Date startDate = dataset.getStartDate();
        Date endDate = dataset.getEndDate();
        if (startDate != null && endDate != null) {
            this.chooser.setDateRange(new DateRange(startDate, endDate));
        }
        this.setObservations(new ArrayList());
    }

    public void setObservations(List obsList) {
        ArrayList<PointObsBean> pointBeans = new ArrayList<PointObsBean>();
        for (int i = 0; i < obsList.size(); ++i) {
            PointObsDatatype pob = (PointObsDatatype)obsList.get(i);
            pointBeans.add(new PointObsBean(i, pob));
        }
        this.stnTable.setBeans(pointBeans);
        this.chooser.setStations(pointBeans);
        this.stnTable.clearSelectedCells();
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.stnTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPosH", this.splitH.getDividerLocation());
        this.prefs.putBeanObject("DumpWindowBounds", this.dumpWindow.getBounds());
    }

    private void showData(PointObsDatatype pobs) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
        try {
            StructureData sd = pobs.getData();
            NCdumpW.printStructureData((PrintWriter)new PrintWriter(bos), (StructureData)sd);
        }
        catch (IOException e) {
            e.printStackTrace(new PrintStream(bos));
        }
        this.dumpTA.setText(bos.toString());
        this.dumpWindow.setVisible(true);
    }

    public static String hiddenProperties() {
        return "description wmoId";
    }

    public class PointObsBean
    implements Station {
        private PointObsDatatype pobs;
        private String timeObs;
        private int id;

        public PointObsBean(int id, PointObsDatatype obs) {
            this.id = id;
            this.pobs = obs;
            this.setTime(obs.getObservationTimeAsDate());
        }

        public int getNobs() {
            return -1;
        }

        public String getTime() {
            return this.timeObs;
        }

        public void setTime(Date timeObs) {
            this.timeObs = PointObsViewer.this.df.toDateTimeString(timeObs);
        }

        public String getName() {
            return Integer.toString(this.id);
        }

        public String getDescription() {
            return null;
        }

        public String getWmoId() {
            return null;
        }

        public double getLatitude() {
            return this.pobs.getLocation().getLatitude();
        }

        public double getLongitude() {
            return this.pobs.getLocation().getLongitude();
        }

        public double getAltitude() {
            return this.pobs.getLocation().getAltitude();
        }

        public LatLonPoint getLatLon() {
            return this.pobs.getLocation().getLatLon();
        }

        public boolean isMissing() {
            return this.pobs.getLocation().isMissing();
        }

        public int compareTo(Station so) {
            return this.getName().compareTo(so.getName());
        }
    }
}

