/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.catalog.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import thredds.catalog.DataFormatType;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;
import thredds.catalog.dl.ADNWriter;
import thredds.catalog.dl.DIFWriter;
import thredds.ui.catalog.CatalogChooser;
import thredds.ui.catalog.CatalogTreeView;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.ProgressMonitorTask;
import ucar.nc2.ui.widget.TextGetPutPane;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class DLCrawler
extends JPanel {
    private static final String SOURCE_WINDOW_SIZE = "SourceWindowSize";
    private static final String STATUS_WINDOW_SIZE = "StatusWindowSize";
    private PreferencesExt prefs;
    private Component myParent;
    private CatalogChooser catalogChooser;
    private CatalogTreeView tree;
    private BeanTableSorted dsTable;
    private BeanTableSorted daTable;
    private JTabbedPane tabbedPane;
    private JSplitPane splitV;
    private IndependentWindow sourceWindow = null;
    private IndependentWindow statusWindow = null;
    private TextGetPutPane sourcePane;
    private TextHistoryPane statusPane;
    private List<AccessBean> daList = new ArrayList<AccessBean>();
    private List<DatasetBean> dsList = new ArrayList<DatasetBean>();
    private DIFWriter difWriter = new DIFWriter();
    private ADNWriter adnWriter = new ADNWriter();
    private boolean debugEvents = false;
    private boolean debugBeans = false;
    private boolean debugCheckUrl = false;

    public DLCrawler(PreferencesExt prefs, Component parent) {
        this.prefs = prefs;
        this.myParent = parent;
        PreferencesExt node = prefs == null ? null : (PreferencesExt)prefs.node("catChooser");
        this.catalogChooser = new CatalogChooser(node, true, false, true);
        this.catalogChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                InvCatalog cat;
                String orgURLs;
                if (DLCrawler.this.debugEvents) {
                    System.out.println("CatalogEnhancer chooser propertyChange= " + e.getPropertyName());
                }
                if (e.getPropertyName().equals("Catalog") && (orgURLs = (cat = DLCrawler.this.catalogChooser.getCurrentCatalog()).findProperty("CatalogGenConfigOrigURL")) != null) {
                    try {
                        URI orgURL = cat.resolveUri(orgURLs);
                        orgURLs = orgURL.toString();
                        if (orgURLs.equals(cat.getUriString())) {
                            return;
                        }
                        int val = JOptionPane.showConfirmDialog(DLCrawler.this.myParent, "This catalog was created by the Catalog Generator program\nIf you want to change it you should change the catgen config file\nDo you want to edit the catgen config file instead?", "WARNING - generated file; will be overrwritten", 0);
                        if (val == 0) {
                            DLCrawler.this.catalogChooser.setCatalog(orgURLs);
                        }
                    }
                    catch (URISyntaxException se) {
                        return;
                    }
                }
            }
        });
        this.tree = this.catalogChooser.getTreeView();
        this.tree.setOpenDatasetScans(false);
        this.tree.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (DLCrawler.this.debugEvents) {
                    System.out.println("CatalogEnhancer tree propertyChange= " + e.getPropertyName());
                }
                if (e.getPropertyName().equals("Catalog")) {
                    DLCrawler.this.daList = new ArrayList();
                    DLCrawler.this.dsList = new ArrayList();
                    DLCrawler.this.dsTable.setBeans(DLCrawler.this.dsList);
                    DLCrawler.this.daTable.setBeans(DLCrawler.this.daList);
                } else if (e.getPropertyName().equals("TreeNode")) {
                    InvDatasetImpl ds = (InvDatasetImpl)e.getNewValue();
                    DLCrawler.this.addDataset(ds);
                    DLCrawler.this.addDatasetAccess(ds);
                } else if (e.getPropertyName().equals("Selection")) {
                    InvDatasetImpl ds = (InvDatasetImpl)e.getNewValue();
                    DatasetBean dsBean = DLCrawler.this.findDatasetBean((InvDataset)ds);
                    DLCrawler.this.dsTable.setSelectedBean(dsBean);
                }
            }
        });
        this.dsTable = new BeanTableSorted(DatasetBean.class, (PreferencesExt)prefs.node("dsBeans"), false);
        this.dsTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DatasetBean bean = (DatasetBean)DLCrawler.this.dsTable.getSelectedBean();
                InvDatasetImpl selectedDataset = bean.dataset();
                DLCrawler.this.catalogChooser.setSelectedDataset(selectedDataset);
            }
        });
        this.daTable = new BeanTableSorted(AccessBean.class, (PreferencesExt)prefs.node("daBeans"), false);
        this.daTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AccessBean bean = (AccessBean)DLCrawler.this.daTable.getSelectedBean();
                InvAccess access = bean.access;
                DatasetBean dbean = DLCrawler.this.findDatasetBean(access.getDataset());
                if (dbean != null) {
                    DLCrawler.this.dsTable.setSelectedBean(dbean);
                }
            }
        });
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.addTab("Datasets", this.dsTable);
        this.tabbedPane.addTab("Access", this.daTable);
        this.splitV = new JSplitPane(0, false, this.catalogChooser, this.tabbedPane);
        this.splitV.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitV, "Center");
        JPanel buttPanel = new JPanel();
        this.add((Component)buttPanel, "South");
        this.statusPane = new TextHistoryPane(false);
        this.statusWindow = new IndependentWindow("Digital Library Status", BAMutil.getImage("thredds"), this.statusPane);
        this.statusWindow.setBounds((Rectangle)prefs.getBean(STATUS_WINDOW_SIZE, new Rectangle(50, 50, 725, 450)));
        JButton status = new JButton("Status DL");
        buttPanel.add(status);
        status.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatasetBean b = (DatasetBean)DLCrawler.this.dsTable.getSelectedBean();
                DLCrawler.this.statusPane.setText(b.status());
                DLCrawler.this.statusWindow.show();
            }
        });
        this.sourcePane = new TextGetPutPane((PreferencesExt)prefs.node("getputPane"));
        this.sourceWindow = new IndependentWindow("Source", BAMutil.getImage("thredds"), this.sourcePane);
        this.sourceWindow.setBounds((Rectangle)prefs.getBean(SOURCE_WINDOW_SIZE, new Rectangle(50, 50, 725, 450)));
        JButton catSource = new JButton("Source");
        catSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InvCatalogImpl cat = (InvCatalogImpl)DLCrawler.this.catalogChooser.getCurrentCatalog();
                if (cat == null) {
                    return;
                }
                String catURL = DLCrawler.this.catalogChooser.getCurrentURL();
                try {
                    DLCrawler.this.sourcePane.setCatalog(cat.getBaseURI().toString(), cat);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                DLCrawler.this.sourcePane.gotoTop();
                DLCrawler.this.sourceWindow.show();
            }
        });
        buttPanel.add(catSource);
        JButton openAllButton = new JButton("Open All");
        buttPanel.add(openAllButton);
        openAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DLCrawler.this.tree.openAll(false);
            }
        });
        JButton harvestButton = new JButton("Harvest");
        buttPanel.add(harvestButton);
        harvestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DLCrawler.this.harvest();
            }
        });
    }

    private void harvest() {
        StringBuilder mess = new StringBuilder();
        for (DatasetBean bean : this.dsList) {
            InvDatasetImpl ds = bean.dataset();
            if (!ds.isHarvest()) continue;
            this.difWriter.doOneDataset((InvDataset)ds, "C:/temp/dif2/", mess);
        }
    }

    public void save() {
        this.prefs.putInt("splitPos", this.splitV.getDividerLocation());
        this.catalogChooser.save();
        this.dsTable.saveState(false);
        this.daTable.saveState(false);
    }

    private String checkURL(String urlString) {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            System.out.println(" BAD url " + urlString + " = " + e.getMessage());
            return "BAD";
        }
        try {
            InputStream is = url.openStream();
            is.close();
        }
        catch (IOException ioe) {
            System.out.println(" BAD connection " + urlString + " = " + ioe.getMessage());
            return "MISS";
        }
        return "OK";
    }

    private String makeURL(InvAccess access) {
        String urlString = access.getStandardUrlName();
        if (access.getService().getServiceType() == ServiceType.DODS) {
            urlString = urlString + ".dds";
        }
        return urlString;
    }

    public void clear() {
        this.daList = new ArrayList<AccessBean>();
        this.dsList = new ArrayList<DatasetBean>();
    }

    public List<AccessBean> getDatasetAccessBeans() {
        return this.daList;
    }

    public List<DatasetBean> getDatasetBeans() {
        return this.dsList;
    }

    private void addDatasets(InvDatasetImpl ds) {
        InvCatalogRef catRef;
        this.addDataset(ds);
        if (ds instanceof InvCatalogRef && !(catRef = (InvCatalogRef)ds).isRead()) {
            return;
        }
        if (ds.hasAccess()) {
            for (InvAccess invAccess : ds.getAccess()) {
                this.daList.add(new AccessBean(invAccess));
            }
        }
        List dlist = ds.getDatasets();
        for (int i = 0; i < dlist.size(); ++i) {
            InvDatasetImpl dds = (InvDatasetImpl)dlist.get(i);
            this.addDatasets(dds);
        }
    }

    public void addDataset(InvDatasetImpl ds) {
        DatasetBean bean = new DatasetBean(ds);
        this.dsTable.addBean(bean);
    }

    public void addDatasetAccess(InvDatasetImpl ds) {
        for (InvAccess bean : ds.getAccess()) {
            this.daTable.addBean(bean);
        }
    }

    public DatasetBean findDatasetBean(InvDataset ds) {
        for (DatasetBean item : this.dsList) {
            if (item.dataset() != ds) continue;
            return item;
        }
        return null;
    }

    public AccessBean findAccessBean(InvDataset ds) {
        for (AccessBean item : this.daList) {
            if (item.dataset() != ds) continue;
            return item;
        }
        return null;
    }

    public AccessBean findOrAddBean(InvAccess access) {
        for (AccessBean item : this.daList) {
            if (item.access != access) continue;
            return item;
        }
        AccessBean newBean = new AccessBean(access);
        this.daList.add(newBean);
        return newBean;
    }

    public class AccessBean {
        private InvAccess access;
        private String name;
        private String url;
        private String URLok = "";
        private FeatureType dataType;
        private DataFormatType dataFormatType;
        private ServiceType serviceType;
        private int ngrids;
        private int readTime;
        private boolean hasBoundingBox;
        private boolean hasTimeRange;
        private boolean hasStandardQuantities;

        public AccessBean() {
        }

        public AccessBean(InvAccess access) {
            this.access = access;
            InvDataset ds = access.getDataset();
            this.setName(ds.getName());
            this.setServiceType(access.getService().getServiceType());
            this.setUrl(access.getStandardUrlName());
            this.dataFormatType = access.getDataFormatType();
        }

        public InvDataset dataset() {
            return this.access.getDataset();
        }

        public InvAccess access() {
            return this.access;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getServiceType() {
            return this.serviceType.toString();
        }

        public void setServiceType(ServiceType serviceType) {
            this.serviceType = serviceType;
        }

        public String getFormat() {
            return this.dataFormatType == null ? "" : this.dataFormatType.toString();
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUrlOk() {
            return this.URLok;
        }

        public void setUrlOk(String URLok) {
            this.URLok = URLok;
        }
    }

    public class DatasetBean {
        private InvDatasetImpl ds;
        private boolean adn;
        private boolean dif;
        private boolean summary;
        private boolean rights;
        private boolean datasetScan;
        private String difMessages;

        public DatasetBean() {
        }

        public DatasetBean(InvDatasetImpl ds) {
            this.ds = ds;
            this.synch();
        }

        public void synch() {
            String s = this.ds.getDocumentation("summary");
            this.summary = s != null;
            s = this.ds.getDocumentation("rights");
            this.rights = s != null;
            this.datasetScan = this.ds.findProperty("DatasetScan") != null;
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("DIF:\n");
            this.dif = DLCrawler.this.difWriter.isDatasetUseable((InvDataset)this.ds, sbuff);
            sbuff.append("\nADN:\n");
            this.adn = DLCrawler.this.adnWriter.isDatasetUseable((InvDataset)this.ds, sbuff);
            this.difMessages = sbuff.toString();
        }

        public InvDatasetImpl dataset() {
            return this.ds;
        }

        public String status() {
            return this.difMessages;
        }

        public String getId() {
            return this.ds.getID() == null ? "" : this.ds.getID();
        }

        public String getName() {
            return this.ds.getName();
        }

        public boolean isAdn() {
            return this.adn;
        }

        public boolean isDif() {
            return this.dif;
        }

        public boolean isDatasetScan() {
            return this.datasetScan;
        }

        public boolean isHarvest() {
            return this.ds.isHarvest();
        }

        public boolean isGeo() {
            ThreddsMetadata.GeospatialCoverage geo = this.ds.getGeospatialCoverage();
            return geo != null && geo.isValid();
        }

        public boolean isTime() {
            return this.ds.getCalendarDateCoverage() != null;
        }

        public boolean isVars() {
            return this.ds.getVariables().size() > 0;
        }

        public boolean isPublish() {
            return this.ds.getPublishers().size() > 0;
        }

        public boolean isRights() {
            return this.rights;
        }

        public boolean isSummary() {
            return this.summary;
        }
    }

    private class CheckURLsTask
    extends ProgressMonitorTask {
        int taskLength = 0;
        int count = 0;

        private CheckURLsTask() {
        }

        @Override
        public void run() {
            for (AccessBean bean : DLCrawler.this.getDatasetAccessBeans()) {
                String urlOK = bean.getUrlOk();
                if (urlOK.length() > 0) continue;
                if (this.cancel) break;
                InvAccess access = bean.access();
                if (DLCrawler.this.debugCheckUrl) {
                    System.out.print("Try to open " + access.getStandardUrlName());
                }
                String status = DLCrawler.this.checkURL(DLCrawler.this.makeURL(access));
                if (DLCrawler.this.debugCheckUrl) {
                    System.out.println(" " + status);
                }
                ++this.count;
                bean.setUrlOk(status);
            }
            this.success = !this.cancel && !this.isError();
            this.done = true;
        }

        @Override
        public String getNote() {
            return this.count + " URLs out of " + this.taskLength;
        }

        @Override
        public int getProgress() {
            return this.count;
        }

        public int getTaskLength() {
            this.taskLength = 0;
            for (AccessBean bean : DLCrawler.this.getDatasetAccessBeans()) {
                if (bean.getUrlOk().length() > 0) continue;
                this.taskLength += bean.dataset().getAccess().size();
            }
            return this.taskLength;
        }
    }
}

