/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.itadaki.bzip2.BZip2OutputStream;
import org.itadaki.bzip2.BitOutputStream;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.CollectionManager;
import thredds.inventory.MFile;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.GribVariableRenamer;
import ucar.nc2.grib.grib2.Grib2CollectionBuilder;
import ucar.nc2.grib.grib2.Grib2Drs;
import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2RecordScanner;
import ucar.nc2.grib.grib2.Grib2SectionDataRepresentation;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIndicator;
import ucar.nc2.grib.grib2.Grib2SectionLocalUse;
import ucar.nc2.grib.grib2.Grib2SectionProductDefinition;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.grib.grib2.table.WmoCodeTable;
import ucar.nc2.ui.ReportPanel;
import ucar.nc2.util.Misc;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class Grib2ReportPanel
extends ReportPanel {
    private static final Logger logger = LoggerFactory.getLogger(Grib2ReportPanel.class);
    String dir = "C:/tmp/bzip/";
    private int countPDS;
    private int countPDSdup;
    int total = 0;
    int prob = 0;

    public Grib2ReportPanel(PreferencesExt prefs, JPanel buttPanel) {
        super(prefs, buttPanel);
    }

    public void doReport(String spec, boolean useIndex, boolean eachFile, boolean extra, Report which) throws IOException {
        Formatter f = new Formatter();
        f.format("%s on %s useIndex=%s eachFile=%s extra=%s%n", new Object[]{which, spec, useIndex, eachFile, extra});
        CollectionManager dcm = this.getCollection(spec, f);
        if (dcm == null) {
            return;
        }
        f.format("top dir = %s%n", dcm.getRoot());
        this.reportPane.setText(f.toString());
        File top = new File(dcm.getRoot());
        if (!top.exists()) {
            f.format("top dir = %s does not exist%n", dcm.getRoot());
        } else {
            switch (which) {
                case checkTables: {
                    this.doCheckTables(f, dcm, useIndex);
                    break;
                }
                case localUseSection: {
                    this.doLocalUseSection(f, dcm, useIndex);
                    break;
                }
                case uniqueGds: {
                    this.doUniqueGds(f, dcm, useIndex);
                    break;
                }
                case duplicatePds: {
                    this.doDuplicatePds(f, dcm, useIndex);
                    break;
                }
                case drsSummary: {
                    this.doDrsSummary(f, dcm, useIndex, eachFile, extra);
                    break;
                }
                case gdsTemplate: {
                    this.doGdsTemplate(f, dcm, useIndex);
                    break;
                }
                case pdsSummary: {
                    this.doPdsSummary(f, dcm, useIndex);
                    break;
                }
                case idProblems: {
                    this.doIdProblems(f, dcm, useIndex);
                    break;
                }
                case timeCoord: {
                    this.doTimeCoord(f, dcm, useIndex);
                    break;
                }
                case rename: {
                    this.doRename(f, dcm, useIndex);
                    break;
                }
                case renameCheck: {
                    this.doRenameCheck(f, dcm, useIndex);
                    break;
                }
                case copyCompress: {
                    this.doCopyCompress(f, dcm, useIndex, eachFile, extra);
                }
            }
        }
        this.reportPane.setText(f.toString());
        this.reportPane.gotoTop();
    }

    private void doCopyCompress(Formatter f, CollectionManager dcm, boolean useIndex, boolean eachFile, boolean extra) throws IOException {
        f.format("Copy and Compress selected files%n", new Object[0]);
        ReportPanel.Counter nbitsC = new ReportPanel.Counter(this, "Number of Bits");
        long totalOrg = 0L;
        long totalZip = 0L;
        for (MFile mfile : dcm.getFiles()) {
            f.format("------- %s%n", mfile.getPath());
            long orgSize = mfile.getLength();
            totalOrg += orgSize;
            RandomAccessFile raf = new RandomAccessFile(mfile.getPath(), "r");
            File fileOut = new File(this.dir + mfile.getName() + ".bzip2");
            BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(fileOut), 100000);
            int count = 0;
            Grib2RecordScanner scan = new Grib2RecordScanner(raf);
            while (scan.hasNext()) {
                Grib2Record gr = scan.next();
                this.doCopyCompress(f, gr, raf, fout, nbitsC);
                if (count++ % 100 != 0) continue;
                System.out.printf("%s%n", count);
            }
            raf.close();
            ((OutputStream)fout).close();
            long zipSize = fileOut.length();
            totalZip += zipSize;
            double r = (double)zipSize / (double)orgSize;
            f.format("  org=%d zip=%d ratio=%f%n", orgSize, zipSize, r);
        }
        double r = (double)totalZip / (double)totalOrg;
        f.format("  org=%d zip=%d ratio=%f%n", totalOrg, totalZip, r);
        nbitsC.show(f);
    }

    private void doCopyCompress(Formatter f, Grib2Record gr, RandomAccessFile raf, OutputStream out, ReportPanel.Counter nbitsC) throws IOException {
        float[] data = gr.readData(raf);
        Grib2SectionDataRepresentation drss = gr.getDataRepresentationSection();
        Grib2Drs drs = drss.getDrs(raf);
        int nbits = drs.getNBits();
        nbitsC.count(nbits);
        int width = (2 << nbits - 1) - 1;
        float dataMin = Float.MAX_VALUE;
        float dataMax = -3.4028235E38f;
        for (float fd : data) {
            dataMin = Math.min(dataMin, fd);
            dataMax = Math.max(dataMax, fd);
        }
        float scale_factor = (dataMax - dataMin) / (float)(width - 2);
        float interval = Math.abs(1.0f / scale_factor);
        float add_offset = dataMin - scale_factor;
        BZip2OutputStream zipper = new BZip2OutputStream(out);
        BitOutputStream bitOut = new BitOutputStream((OutputStream)zipper);
        float diffMax = -3.4028235E38f;
        boolean count = false;
        for (float fd : data) {
            int packed_data = Math.round((fd - add_offset) / scale_factor);
            bitOut.writeBits(nbits, packed_data);
            float unpacked_data = (float)packed_data * scale_factor + add_offset;
            float diff = Math.abs(fd - unpacked_data);
            diffMax = Math.max(diffMax, diff);
        }
        bitOut.flush();
        zipper.finish();
    }

    private void doCheckTables(Formatter f, CollectionManager dcm, boolean useIndex) throws IOException {
        f.format("Check Grib-2 Parameter Tables%n", new Object[0]);
        int[] accum = new int[4];
        for (MFile mfile : dcm.getFiles()) {
            f.format("%n %s%n", mfile.getPath());
            this.doCheckTables(mfile, f, accum);
        }
        f.format("%nGrand total=%d not operational = %d local = %d missing = %d%n", accum[0], accum[1], accum[2], accum[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckTables(MFile ff, Formatter fm, int[] accum) throws IOException {
        int local = 0;
        int miss = 0;
        int nonop = 0;
        int total = 0;
        GridDataset ncfile = null;
        try {
            ncfile = GridDataset.open((String)ff.getPath());
            for (GridDatatype dt : ncfile.getGrids()) {
                String currName = dt.getName();
                ++total;
                Attribute att = dt.findAttributeIgnoreCase("Grib_Parameter");
                if (att == null || att.getLength() != 3) continue;
                int discipline = (Integer)att.getValue(0);
                int category = (Integer)att.getValue(1);
                int number = (Integer)att.getValue(2);
                if (category > 191 || number > 191) {
                    fm.format("  local parameter (%d %d %d) = %s units=%s %n", discipline, category, number, currName, dt.getUnitsString());
                    ++local;
                    continue;
                }
                WmoCodeTable.TableEntry entry = WmoCodeTable.getParameterEntry((int)discipline, (int)category, (int)number);
                if (entry == null) {
                    fm.format("  missing from WMO table (%d %d %d) = %s units=%s %n", discipline, category, number, currName, dt.getUnitsString());
                    ++miss;
                    continue;
                }
                if (entry.status.equalsIgnoreCase("Operational")) continue;
                fm.format("  %s parameter = %s (%d %d %d) %n", entry.status, currName, discipline, category, number);
                ++nonop;
            }
        }
        finally {
            if (ncfile != null) {
                ncfile.close();
            }
        }
        fm.format("total=%d not operational = %d local = %d missing = %d%n", total, nonop, local, miss);
        accum[0] = accum[0] + total;
        accum[1] = accum[1] + nonop;
        accum[2] = accum[2] + local;
        accum[3] = accum[3] + miss;
    }

    private void doLocalUseSection(Formatter f, CollectionManager dcm, boolean useIndex) throws IOException {
        f.format("Show Local Use Section%n", new Object[0]);
        for (MFile mfile : dcm.getFiles()) {
            f.format(" %s%n", mfile.getPath());
            this.doLocalUseSection(mfile, f, useIndex);
        }
    }

    private void doLocalUseSection(MFile mf, Formatter f, boolean useIndex) throws IOException {
        f.format("File = %s%n", mf);
        Grib2Index index = this.createIndex(mf, f);
        if (index == null) {
            return;
        }
        for (Grib2Record gr : index.getRecords()) {
            Grib2SectionLocalUse lus = gr.getLocalUseSection();
            if (lus == null || lus.getRawBytes() == null) {
                f.format(" %10d == none%n", gr.getDataSection().getStartingPosition());
                continue;
            }
            f.format(" %10d == %s%n", gr.getDataSection().getStartingPosition(), Misc.showBytes((byte[])lus.getRawBytes()));
        }
    }

    private Grib2Index createIndex(MFile mf, Formatter f) throws IOException {
        Grib2Index index = new Grib2Index();
        String path = mf.getPath();
        if (!index.readIndex(path, mf.getLastModified())) {
            RandomAccessFile raf = new RandomAccessFile(path, "r");
            if (!Grib2RecordScanner.isValidFile((RandomAccessFile)raf)) {
                return null;
            }
            index.makeIndex(path, null);
        }
        return index;
    }

    private void doUniqueGds(Formatter f, CollectionManager dcm, boolean useIndex) throws IOException {
        f.format("Show Unique GDS%n", new Object[0]);
        HashMap<Integer, GdsList> gdsSet = new HashMap<Integer, GdsList>();
        for (MFile mfile : dcm.getFiles()) {
            f.format(" %s%n", mfile.getPath());
            this.doUniqueGds(mfile, gdsSet, f);
        }
        for (GdsList gdsl : gdsSet.values()) {
            f.format("%nGDS = %d x %d (%d) %n", gdsl.gds.getNy(), gdsl.gds.getNx(), gdsl.gds.template);
            for (FileCount fc : gdsl.fileList) {
                f.format("  %5d %s (%d)%n", fc.count, fc.f.getPath(), fc.countGds);
            }
        }
    }

    private void doUniqueGds(MFile mf, Map<Integer, GdsList> gdsSet, Formatter f) throws IOException {
        Grib2Index index = this.createIndex(mf, f);
        if (index == null) {
            return;
        }
        int countGds = index.getGds().size();
        for (Grib2Record gr : index.getRecords()) {
            FileCount fc;
            int hash = gr.getGDSsection().getGDS().hashCode();
            GdsList gdsList = gdsSet.get(hash);
            if (gdsList == null) {
                gdsList = new GdsList(gr.getGDSsection().getGDS());
                gdsSet.put(hash, gdsList);
            }
            if ((fc = gdsList.contains(mf)) == null) {
                fc = new FileCount(mf, countGds);
                gdsList.fileList.add(fc);
            }
            ++fc.count;
        }
    }

    private void doDuplicatePds(Formatter f, CollectionManager dcm, boolean useIndex) throws IOException {
        this.countPDS = 0;
        this.countPDSdup = 0;
        f.format("Show Duplicate PDS%n", new Object[0]);
        for (MFile mfile : dcm.getFiles()) {
            this.doDuplicatePds(f, mfile);
        }
        f.format("Total PDS duplicates = %d / %d%n%n", this.countPDSdup, this.countPDS);
    }

    private void doDuplicatePds(Formatter f, MFile mfile) throws IOException {
        HashSet<Long> pdsMap = new HashSet<Long>();
        int dups = 0;
        int count = 0;
        RandomAccessFile raf = new RandomAccessFile(mfile.getPath(), "r");
        Grib2RecordScanner scan = new Grib2RecordScanner(raf);
        while (scan.hasNext()) {
            Grib2Record gr = scan.next();
            Grib2SectionProductDefinition pds = gr.getPDSsection();
            long crc = pds.calcCRC();
            if (pdsMap.contains(crc)) {
                ++dups;
            } else {
                pdsMap.add(crc);
            }
            ++count;
        }
        raf.close();
        f.format("PDS duplicates = %d / %d for %s%n%n", dups, count, mfile.getPath());
        this.countPDS += count;
        this.countPDSdup += dups;
    }

    private void doPdsSummary(Formatter f, CollectionManager dcm, boolean useIndex) throws IOException {
        if (useIndex) {
            f.format("Check Grib-2 PDS probability and statistical variables%n", new Object[0]);
            this.total = 0;
            this.prob = 0;
            for (MFile mfile : dcm.getFiles()) {
                f.format("%n %s%n", mfile.getPath());
                this.doPdsSummaryIndexed(f, mfile);
            }
            f.format("problems = %d/%d%n", this.prob, this.total);
        } else {
            ReportPanel.Counter templateSet = new ReportPanel.Counter(this, "template");
            ReportPanel.Counter timeUnitSet = new ReportPanel.Counter(this, "timeUnit");
            ReportPanel.Counter levelTypeSet = new ReportPanel.Counter(this, "levelType");
            ReportPanel.Counter processType = new ReportPanel.Counter(this, "genProcessType");
            ReportPanel.Counter processId = new ReportPanel.Counter(this, "genProcessId");
            ReportPanel.Counter levelScale = new ReportPanel.Counter(this, "levelScale");
            ReportPanel.Counter ncoords = new ReportPanel.Counter(this, "nExtraCoords");
            for (MFile mfile : dcm.getFiles()) {
                f.format(" %s%n", mfile.getPath());
                this.doPdsSummary(f, mfile, templateSet, timeUnitSet, processType, processId, levelScale, levelTypeSet, ncoords);
            }
            templateSet.show(f);
            timeUnitSet.show(f);
            levelTypeSet.show(f);
            processType.show(f);
            processId.show(f);
            levelScale.show(f);
            ncoords.show(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPdsSummaryIndexed(Formatter fm, MFile ff) throws IOException {
        String path = ff.getPath();
        Grib2Index index = this.createIndex(ff, fm);
        if (index == null) {
            return;
        }
        GribCollection gc = Grib2CollectionBuilder.readOrCreateIndexFromSingleFile((MFile)ff, (CollectionManager.Force)CollectionManager.Force.nocheck, null, (Logger)logger);
        gc.close();
        GridDataset ncfile = null;
        try {
            ncfile = GridDataset.open((String)(path + ".ncx"));
            for (GridDatatype dt : ncfile.getGrids()) {
                int type;
                int statType;
                String currName = dt.getName();
                ++this.total;
                Attribute att = dt.findAttributeIgnoreCase("Grib_Probability_Type");
                if (att != null) {
                    fm.format("  %s (PROB) desc=%s %n", currName, dt.getDescription());
                    ++this.prob;
                }
                if ((att = dt.findAttributeIgnoreCase("Grib_Statistical_Interval_Type")) != null && ((statType = att.getNumericValue().intValue()) == 7 || statType == 9)) {
                    fm.format("  %s (STAT type %s) desc=%s %n", currName, statType, dt.getDescription());
                    ++this.prob;
                }
                if ((att = dt.findAttributeIgnoreCase("Grib_Ensemble_Derived_Type")) == null || (type = att.getNumericValue().intValue()) <= 9) continue;
                fm.format("  %s (DERIVED type %s) desc=%s %n", currName, type, dt.getDescription());
                ++this.prob;
            }
        }
        catch (Throwable ioe) {
            fm.format("Failed on %s == %s%n", path, ioe.getMessage());
            System.out.printf("Failed on %s%n", path);
            ioe.printStackTrace();
        }
        finally {
            if (ncfile != null) {
                ncfile.close();
            }
        }
    }

    private void doPdsSummary(Formatter f, MFile mf, ReportPanel.Counter templateSet, ReportPanel.Counter timeUnitSet, ReportPanel.Counter processType, ReportPanel.Counter processId, ReportPanel.Counter levelScale, ReportPanel.Counter levelTypeSet, ReportPanel.Counter ncoords) throws IOException {
        boolean showLevel = true;
        boolean showCoords = true;
        int firstPtype = -1;
        boolean shutup = false;
        Grib2Index index = this.createIndex(mf, f);
        if (index == null) {
            return;
        }
        for (Grib2Record gr : index.getRecords()) {
            Grib2Pds pds = gr.getPDS();
            templateSet.count(pds.getTemplateNumber());
            timeUnitSet.count(pds.getTimeUnit());
            levelTypeSet.count(pds.getLevelType1());
            if (showLevel && pds.getLevelType1() == 105) {
                showLevel = false;
                f.format(" level = 105 : %s%n", mf.getPath());
            }
            int n = pds.getExtraCoordinatesCount();
            ncoords.count(n);
            if (showCoords && n > 0) {
                showCoords = false;
                f.format(" ncoords > 0 : %s%n", mf.getPath());
            }
            int ptype = pds.getGenProcessType();
            processType.count(ptype);
            if (firstPtype < 0) {
                firstPtype = ptype;
            } else if (firstPtype != ptype && !shutup) {
                f.format(" getGenProcessType differs in %s %s == %d%n", mf.getPath(), gr.getPDS().getParameterNumber(), ptype);
                shutup = true;
            }
            processId.count(pds.getGenProcessId());
            if (pds.getLevelScale1() <= 127 || !Grib2Utils.isLevelUsed((int)pds.getLevelType1())) continue;
            f.format(" LevelScale > 127: %s %s == %d%n", mf.getPath(), gr.getPDS().getParameterNumber(), pds.getLevelScale1());
            levelScale.count(pds.getLevelScale1());
        }
    }

    private void doIdProblems(Formatter f, CollectionManager dcm, boolean useIndex) throws IOException {
        f.format("Look for ID Problems%n", new Object[0]);
        ReportPanel.Counter disciplineSet = new ReportPanel.Counter(this, "discipline");
        ReportPanel.Counter masterTable = new ReportPanel.Counter(this, "masterTable");
        ReportPanel.Counter localTable = new ReportPanel.Counter(this, "localTable");
        ReportPanel.Counter centerId = new ReportPanel.Counter(this, "centerId");
        ReportPanel.Counter subcenterId = new ReportPanel.Counter(this, "subcenterId");
        ReportPanel.Counter genProcess = new ReportPanel.Counter(this, "genProcess");
        ReportPanel.Counter backProcess = new ReportPanel.Counter(this, "backProcess");
        ReportPanel.Counter sigRefProcess = new ReportPanel.Counter(this, "significanceOfReference");
        for (MFile mfile : dcm.getFiles()) {
            f.format(" %s%n", mfile.getPath());
            this.doIdProblems(f, mfile, useIndex, disciplineSet, masterTable, localTable, centerId, subcenterId, genProcess, backProcess, sigRefProcess);
        }
        disciplineSet.show(f);
        masterTable.show(f);
        localTable.show(f);
        centerId.show(f);
        subcenterId.show(f);
        genProcess.show(f);
        backProcess.show(f);
        sigRefProcess.show(f);
    }

    private void doIdProblems(Formatter f, MFile mf, boolean showProblems, ReportPanel.Counter disciplineSet, ReportPanel.Counter masterTable, ReportPanel.Counter localTable, ReportPanel.Counter centerId, ReportPanel.Counter subcenterId, ReportPanel.Counter genProcessC, ReportPanel.Counter backProcessC, ReportPanel.Counter sigRefProcess) throws IOException {
        Grib2Index index = this.createIndex(mf, f);
        if (index == null) {
            return;
        }
        int center = -1;
        int subcenter = -1;
        int master = -1;
        int local = -1;
        int genProcess = -1;
        int backProcess = -1;
        int sigRef = -1;
        for (Grib2Record gr : index.getRecords()) {
            disciplineSet.count(gr.getDiscipline());
            masterTable.count(gr.getId().getMaster_table_version());
            localTable.count(gr.getId().getLocal_table_version());
            centerId.count(gr.getId().getCenter_id());
            subcenterId.count(gr.getId().getSubcenter_id());
            genProcessC.count(gr.getPDS().getGenProcessId());
            backProcessC.count(gr.getPDS().getBackProcessId());
            sigRefProcess.count(gr.getId().getSignificanceOfRT());
            if (!showProblems) continue;
            if (gr.getDiscipline() == 255) {
                f.format("  bad discipline= ", new Object[0]);
                gr.show(f);
                f.format("%n", new Object[0]);
            }
            int val = gr.getId().getCenter_id();
            if (center < 0) {
                center = val;
            } else if (center != val) {
                f.format("  center %d != %d ", center, val);
                gr.show(f);
                f.format(" %s%n", gr.getId());
            }
            val = gr.getId().getSubcenter_id();
            if (subcenter < 0) {
                subcenter = val;
            } else if (subcenter != val) {
                f.format("  subcenter %d != %d ", subcenter, val);
                gr.show(f);
                f.format(" %s%n", gr.getId());
            }
            val = gr.getId().getMaster_table_version();
            if (master < 0) {
                master = val;
            } else if (master != val) {
                f.format("  master %d != %d ", master, val);
                gr.show(f);
                f.format(" %s%n", gr.getId());
            }
            val = gr.getId().getLocal_table_version();
            if (local < 0) {
                local = val;
            } else if (local != val) {
                f.format("  local %d != %d ", local, val);
                gr.show(f);
                f.format(" %s%n", gr.getId());
            }
            val = gr.getPDS().getGenProcessId();
            if (genProcess < 0) {
                genProcess = val;
            } else if (genProcess != val) {
                f.format("  genProcess %d != %d ", genProcess, val);
                gr.show(f);
                f.format(" %s%n", gr.getId());
            }
            val = gr.getPDS().getBackProcessId();
            if (backProcess < 0) {
                backProcess = val;
            } else if (backProcess != val) {
                f.format("  backProcess %d != %d ", backProcess, val);
                gr.show(f);
                f.format(" %s%n", gr.getId());
            }
            val = gr.getId().getSignificanceOfRT();
            if (sigRef < 0) {
                sigRef = val;
                continue;
            }
            if (sigRef == val) continue;
            f.format("  sigRef %d != %d ", sigRef, val);
            gr.show(f);
            f.format(" %s%n", gr.getId());
        }
    }

    private void doDrsSummary(Formatter f, CollectionManager dcm, boolean useIndex, boolean eachFile, boolean extra) throws IOException {
        f.format("Show Unique DRS Templates%n", new Object[0]);
        ReportPanel.Counter template = new ReportPanel.Counter(this, "DRS template");
        ReportPanel.Counter bitmapRepeat = new ReportPanel.Counter(this, "BMS indicator");
        ReportPanel.Counter prob = new ReportPanel.Counter(this, "DRS template 40 signed problem");
        ReportPanel.Counter nbitsC = new ReportPanel.Counter(this, "Number of Bits");
        for (MFile mfile : dcm.getFiles()) {
            if (eachFile) {
                template.reset();
                bitmapRepeat.reset();
                if (extra) {
                    prob.reset();
                }
            }
            f.format("------- %s%n", mfile.getPath());
            if (useIndex) {
                this.doDrsSummaryIndex(f, mfile, extra, template, bitmapRepeat, prob);
            } else {
                this.doDrsSummaryScan(f, mfile, extra, template, bitmapRepeat, prob, nbitsC);
            }
            if (!eachFile) continue;
            template.show(f);
            bitmapRepeat.show(f);
            if (!useIndex) {
                nbitsC.show(f);
            }
            if (extra) {
                prob.show(f);
            }
            f.format("%n", new Object[0]);
        }
        if (!eachFile) {
            template.show(f);
            bitmapRepeat.show(f);
            if (!useIndex) {
                nbitsC.show(f);
            }
            if (extra) {
                prob.show(f);
            }
        }
    }

    private void doDrsSummaryIndex(Formatter f, MFile mf, boolean extra, ReportPanel.Counter templateC, ReportPanel.Counter bitmapRepeat, ReportPanel.Counter probC) throws IOException {
        Grib2Index index = this.createIndex(mf, f);
        if (index == null) {
            return;
        }
        String path = mf.getPath();
        RandomAccessFile raf = new RandomAccessFile(path, "r");
        for (Grib2Record gr : index.getRecords()) {
            Grib2Drs.Type40 drs40;
            Grib2SectionDataRepresentation drss = gr.getDataRepresentationSection();
            int template = drss.getDataTemplate();
            templateC.count(template);
            bitmapRepeat.count(gr.repeat);
            if (!extra || template != 40 || (drs40 = gr.readDataTest(raf)) == null) continue;
            if (drs40.hasSignedProblem()) {
                probC.count(1);
                continue;
            }
            probC.count(0);
        }
        raf.close();
    }

    private void doDrsSummaryScan(Formatter f, MFile mf, boolean extra, ReportPanel.Counter templateC, ReportPanel.Counter bitmapRepeat, ReportPanel.Counter probC, ReportPanel.Counter nbitsC) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(mf.getPath(), "r");
        Grib2RecordScanner scan = new Grib2RecordScanner(raf);
        while (scan.hasNext()) {
            Grib2Record gr = scan.next();
            this.doDrsSummary(gr, raf, extra, templateC, bitmapRepeat, probC, nbitsC);
        }
        raf.close();
    }

    private void doDrsSummary(Grib2Record gr, RandomAccessFile raf, boolean extra, ReportPanel.Counter templateC, ReportPanel.Counter bitmapRepeat, ReportPanel.Counter probC, ReportPanel.Counter nbitsC) throws IOException {
        Grib2Drs.Type40 drs40;
        Grib2SectionDataRepresentation drss = gr.getDataRepresentationSection();
        int template = drss.getDataTemplate();
        templateC.count(template);
        bitmapRepeat.count(gr.repeat);
        Grib2Drs gdrs = drss.getDrs(raf);
        nbitsC.count(gdrs.getNBits());
        if (extra && template == 40 && (drs40 = gr.readDataTest(raf)) != null) {
            if (drs40.hasSignedProblem()) {
                probC.count(1);
            } else {
                probC.count(0);
            }
        }
    }

    private void doGdsTemplate(Formatter f, CollectionManager dcm, boolean useIndex) throws IOException {
        f.format("Show Unique GDS Templates%n", new Object[0]);
        HashMap<Integer, Integer> drsSet = new HashMap<Integer, Integer>();
        for (MFile mfile : dcm.getFiles()) {
            f.format(" %s%n", mfile.getPath());
            this.doGdsTemplate(f, mfile, drsSet);
        }
        Iterator<Object> i$ = drsSet.keySet().iterator();
        while (i$.hasNext()) {
            int template = (Integer)i$.next();
            int count = (Integer)drsSet.get(template);
            f.format("%nGDS template = %d count = %d%n", template, count);
        }
    }

    private void doGdsTemplate(Formatter f, MFile mf, Map<Integer, Integer> gdsSet) throws IOException {
        Grib2Index index = this.createIndex(mf, f);
        if (index == null) {
            return;
        }
        for (Grib2SectionGridDefinition gds : index.getGds()) {
            int template = gds.getGDSTemplateNumber();
            Integer count = gdsSet.get(template);
            if (count == null) {
                gdsSet.put(template, 1);
                continue;
            }
            gdsSet.put(template, count + 1);
        }
    }

    private void doTimeCoord(Formatter f, CollectionManager dcm, boolean useIndex) throws IOException {
        ReportPanel.Counter templateSet = new ReportPanel.Counter(this, "template");
        ReportPanel.Counter timeUnitSet = new ReportPanel.Counter(this, "timeUnit");
        ReportPanel.Counter statTypeSet = new ReportPanel.Counter(this, "statType");
        ReportPanel.Counter NTimeIntervals = new ReportPanel.Counter(this, "NumberTimeIntervals");
        ReportPanel.Counter TinvDiffer = new ReportPanel.Counter(this, "TimeIntervalsDiffer");
        ReportPanel.Counter TinvLength = new ReportPanel.Counter(this, "TimeIntervalsLength");
        int count = 0;
        for (MFile mfile : dcm.getFiles()) {
            f.format(" %s%n", mfile.getPath());
            count += this.doTimeCoord(f, mfile, templateSet, timeUnitSet, statTypeSet, NTimeIntervals, TinvDiffer, TinvLength);
        }
        f.format("total records = %d%n", count);
        templateSet.show(f);
        timeUnitSet.show(f);
        statTypeSet.show(f);
        NTimeIntervals.show(f);
        TinvDiffer.show(f);
        TinvLength.show(f);
    }

    private int doTimeCoord(Formatter f, MFile mf, ReportPanel.Counter templateSet, ReportPanel.Counter timeUnitSet, ReportPanel.Counter statTypeSet, ReportPanel.Counter NTimeIntervals, ReportPanel.Counter TinvDiffer, ReportPanel.Counter TinvLength) throws IOException {
        boolean showTinvDiffers = true;
        boolean showNint = true;
        boolean shutup = false;
        Grib2Index index = this.createIndex(mf, f);
        if (index == null) {
            return 0;
        }
        Grib2Customizer cust = null;
        int count = 0;
        for (Grib2Record gr : index.getRecords()) {
            Grib2Pds pds = gr.getPDS();
            templateSet.count(pds.getTemplateNumber());
            int timeUnit = pds.getTimeUnit();
            timeUnitSet.count(timeUnit);
            if (pds instanceof Grib2Pds.PdsInterval) {
                Grib2Pds.PdsInterval pdsi = (Grib2Pds.PdsInterval)pds;
                for (Grib2Pds.TimeInterval ti : pdsi.getTimeIntervals()) {
                    statTypeSet.count(ti.statProcessType);
                    if (ti.timeRangeUnit == timeUnit && (ti.timeIncrementUnit == timeUnit || ti.timeIncrementUnit == 255 || ti.timeIncrement == 0)) continue;
                    TinvDiffer.count(ti.timeRangeUnit);
                    if (!showTinvDiffers) continue;
                    f.format("  TimeInterval has different units timeUnit= %s file=%s%n  ", timeUnit, mf.getName());
                    pds.show(f);
                    f.format("%n", new Object[0]);
                }
                NTimeIntervals.count(pdsi.getTimeIntervals().length);
                if (showNint && !shutup && pdsi.getTimeIntervals().length > 1) {
                    f.format("  TimeIntervals > 1 = %s file=%s%n  ", this.getId(gr), mf.getName());
                    shutup = true;
                }
                if (cust == null) {
                    cust = Grib2Customizer.factory((Grib2Record)gr);
                }
                double len = cust.getForecastTimeIntervalSizeInHours(gr);
                TinvLength.count((int)len);
                int[] intv = cust.getForecastTimeIntervalOffset(gr);
                if (intv[0] == 0 && intv[1] == 0) {
                    f.format("  TimeInterval [0,0] = %s file=%s%n  ", this.getId(gr), mf.getName());
                }
            }
            ++count;
        }
        return count;
    }

    String getId(Grib2Record gr) {
        Grib2SectionIndicator is = gr.getIs();
        Grib2Pds pds = gr.getPDS();
        return is.getDiscipline() + "-" + pds.getParameterCategory() + "-" + pds.getParameterNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRenameCheck(Formatter f, CollectionManager dcm, boolean useIndex) throws IOException {
        f.format("CHECK Renaming uniqueness %s%n", dcm.getCollectionName());
        GribVariableRenamer renamer = new GribVariableRenamer();
        int fail = 0;
        int multiple = 0;
        int ok = 0;
        for (MFile mfile : dcm.getFiles()) {
            f.format("%n%s%n", mfile.getPath());
            NetcdfFile ncfileOld = null;
            GridDataset gdsNew = null;
            try {
                ncfileOld = NetcdfFile.open((String)mfile.getPath(), (String)"ucar.nc2.iosp.grib.GribServiceProvider", (int)-1, null, null);
                NetcdfDataset ncdOld = new NetcdfDataset(ncfileOld);
                GridDataset gridOld = new GridDataset(ncdOld);
                gdsNew = GridDataset.open((String)mfile.getPath());
                for (GridDatatype grid : gridOld.getGrids()) {
                    List newNames = renamer.matchNcepNames((ucar.nc2.dt.GridDataset)gdsNew, grid.getShortName());
                    if (newNames.size() == 0) {
                        f.format(" ***FAIL %s%n", grid.getShortName());
                        ++fail;
                        continue;
                    }
                    if (newNames.size() != 1) {
                        f.format(" *** %s multiple matches on %n", grid.getShortName());
                        for (String newName : newNames) {
                            f.format("    %s%n", newName);
                        }
                        f.format("%n", new Object[0]);
                        ++multiple;
                        continue;
                    }
                    if (!useIndex) continue;
                    f.format(" %s%n %s%n%n", grid.getShortName(), newNames.get(0));
                    ++ok;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                if (ncfileOld != null) {
                    ncfileOld.close();
                }
                if (gdsNew == null) continue;
                gdsNew.close();
            }
        }
        f.format("Fail=%d multiple=%d ok=%d%n", fail, multiple, ok);
    }

    private void doRename(Formatter f, CollectionManager dcm, boolean useIndex) throws IOException {
        f.format("CHECK Grib-2 Names: Old vs New for collection %s%n", dcm.getCollectionName());
        ArrayList<VarName> varNames = new ArrayList<VarName>(3000);
        HashMap gridsAll = new HashMap(1000);
        int countExactMatch = 0;
        int countExactMatchIg = 0;
        int countOldVars = 0;
        for (MFile mfile : dcm.getFiles()) {
            GridMatch match;
            f.format("%n%s%n", mfile.getPath());
            Map<Integer, GridMatch> gridsNew = this.getGridsNew(mfile, f);
            Map<Integer, GridMatch> gridsOld = this.getGridsOld(mfile, f);
            HashSet<String> namesNew = new HashSet<String>(gridsNew.size());
            for (GridMatch gm : gridsNew.values()) {
                namesNew.add(gm.grid.getFullName());
            }
            for (GridMatch gm : gridsOld.values()) {
                if (namesNew.contains(gm.grid.getFullName())) {
                    ++countExactMatch;
                }
                ++countOldVars;
            }
            for (GridMatch gm : gridsNew.values()) {
                match = gridsOld.get(gm.hashCode());
                if (match == null) continue;
                gm.match = match;
                match.match = gm;
            }
            for (GridMatch gm : gridsNew.values()) {
                if (gm.match != null || (match = this.altMatch(gm, gridsOld.values())) == null) continue;
                gm.match = match;
                match.match = gm;
            }
            f.format("%n", new Object[0]);
            ArrayList<GridMatch> listNew = new ArrayList<GridMatch>(gridsNew.values());
            Collections.sort(listNew);
            for (GridMatch gm : listNew) {
                f.format(" %s%n", gm.grid.findAttributeIgnoreCase("Grib_Variable_Id"));
                f.format(" %s (%d)%n", gm.grid.getFullName(), gm.hashCode());
                if (gm.match != null) {
                    boolean exactIg;
                    boolean exact = gm.match.grid.getFullName().equals(gm.grid.getFullName());
                    boolean bl = exactIg = !exact && gm.match.grid.getFullName().equalsIgnoreCase(gm.grid.getFullName());
                    if (exactIg) {
                        ++countExactMatchIg;
                    }
                    String status = exact ? " " : (exactIg ? "**" : " *");
                    f.format("%s%s (%d)%n", status, gm.match.grid.getFullName(), gm.match.hashCode());
                }
                f.format("%n", new Object[0]);
            }
            f.format("%nMISSING MATCHES IN NEW%n", new Object[0]);
            ArrayList<GridMatch> list = new ArrayList<GridMatch>(gridsNew.values());
            Collections.sort(list);
            for (GridMatch gm : list) {
                if (gm.match != null) continue;
                f.format(" %s (%s) == %s%n", gm.grid.getFullName(), gm.show(), gm.grid.getDescription());
            }
            f.format("%nMISSING MATCHES IN OLD%n", new Object[0]);
            ArrayList<GridMatch> listOld = new ArrayList<GridMatch>(gridsOld.values());
            Collections.sort(listOld);
            for (GridMatch gm : listOld) {
                if (gm.match != null) continue;
                f.format(" %s (%s)%n", gm.grid.getFullName(), gm.show());
            }
            for (GridMatch gmOld : listOld) {
                String keyNew;
                String key = gmOld.grid.getShortName();
                ArrayList<String> newGrids = (ArrayList<String>)gridsAll.get(key);
                if (newGrids == null) {
                    newGrids = new ArrayList<String>();
                    gridsAll.put(key, newGrids);
                }
                if (gmOld.match == null || newGrids.contains(keyNew = gmOld.match.grid.getShortName())) continue;
                newGrids.add(keyNew);
            }
            for (GridMatch gmOld : listOld) {
                if (gmOld.match == null) {
                    f.format("MISSING %s (%s)%n", gmOld.grid.getFullName(), gmOld.show());
                    continue;
                }
                Attribute att = gmOld.match.grid.findAttributeIgnoreCase("Grib_Variable_Id");
                String varId = att == null ? "" : att.getStringValue();
                varNames.add(new VarName(mfile.getName(), gmOld.grid.getShortName(), gmOld.match.grid.getShortName(), varId));
            }
        }
        f.format("%nOLD -> NEW MAPPINGS%n", new Object[0]);
        ArrayList keys = new ArrayList(gridsAll.keySet());
        int total = keys.size();
        int dups = 0;
        Collections.sort(keys);
        for (String key : keys) {
            f.format(" OLD %s%n", key);
            List newGrids = (List)gridsAll.get(key);
            Collections.sort(newGrids);
            if (newGrids.size() > 1) {
                ++dups;
            }
            for (String newKey : newGrids) {
                f.format(" NEW %s%n", newKey);
            }
            f.format("%n", new Object[0]);
        }
        f.format("Exact matches=%d  Exact ignore case=%d  totalOldVars=%d%n", countExactMatch, countExactMatchIg, countOldVars);
        f.format("Number with more than one map=%d total=%d%n", dups, total);
        if (!useIndex) {
            Element rootElem = new Element("gribVarMap");
            Document doc = new Document(rootElem);
            rootElem.setAttribute("collection", dcm.getCollectionName());
            String currentDs = null;
            Element dsElem = null;
            for (VarName vn : varNames) {
                if (!vn.dataset.equals(currentDs)) {
                    dsElem = new Element("dataset");
                    rootElem.addContent((Content)dsElem);
                    dsElem.setAttribute("name", vn.dataset);
                    currentDs = vn.dataset;
                }
                Element param = new Element("param");
                dsElem.addContent((Content)param);
                param.setAttribute("oldName", vn.oldVar);
                param.setAttribute("newName", vn.newVar);
                param.setAttribute("varId", vn.varId);
            }
            FileOutputStream fout = new FileOutputStream("C:/tmp/grib2VarMap.xml");
            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
            fmt.output(doc, (OutputStream)fout);
            fout.close();
        }
    }

    private GridMatch altMatch(GridMatch want, Collection<GridMatch> test) {
        for (GridMatch gm : test) {
            if (gm.match != null || !gm.altMatch(want)) continue;
            return gm;
        }
        for (GridMatch gm : test) {
            if (gm.match != null || !gm.altMatchNoProb(want)) continue;
            return gm;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, GridMatch> getGridsNew(MFile ff, Formatter f) throws IOException {
        HashMap<Integer, GridMatch> grids = new HashMap<Integer, GridMatch>(100);
        GridDataset ncfile = null;
        try {
            ncfile = GridDataset.open((String)ff.getPath());
            for (GridDatatype dt : ncfile.getGrids()) {
                GridMatch gm = new GridMatch(dt, true);
                GridMatch dup = (GridMatch)grids.get(gm.hashCode());
                if (dup != null) {
                    f.format(" DUP NEW (%d == %d) = %s (%s) and DUP %s (%s)%n", gm.hashCode(), dup.hashCode(), gm.grid.getFullName(), gm.show(), dup.grid.getFullName(), dup.show());
                    continue;
                }
                grids.put(gm.hashCode(), gm);
            }
        }
        finally {
            if (ncfile != null) {
                ncfile.close();
            }
        }
        return grids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, GridMatch> getGridsOld(MFile ff, Formatter f) throws IOException {
        HashMap<Integer, GridMatch> grids = new HashMap<Integer, GridMatch>(100);
        NetcdfFile ncfile = null;
        try {
            ncfile = NetcdfFile.open((String)ff.getPath(), (String)"ucar.nc2.iosp.grib.GribServiceProvider", (int)-1, null, null);
            NetcdfDataset ncd = new NetcdfDataset(ncfile);
            GridDataset grid = new GridDataset(ncd);
            for (GridDatatype dt : grid.getGrids()) {
                GridMatch gm = new GridMatch(dt, false);
                GridMatch dup = (GridMatch)grids.get(gm.hashCode());
                if (dup != null) {
                    f.format(" DUP OLD (%d == %d) = %s (%s) and DUP %s (%s)%n", gm.hashCode(), dup.hashCode(), gm.grid.getFullName(), gm.show(), dup.grid.getFullName(), dup.show());
                    continue;
                }
                grids.put(gm.hashCode(), gm);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (ncfile != null) {
                ncfile.close();
            }
        }
        return grids;
    }

    private class GridMatch
    implements Comparable<GridMatch> {
        GridDatatype grid;
        GridMatch match;
        boolean isNew;
        int[] param = new int[3];
        int level;
        boolean isLayer;
        boolean isError;
        int interval = -1;
        int prob = -1;
        int ens = -1;
        int probLimit = Integer.MAX_VALUE;

        private GridMatch(GridDatatype grid, boolean aNew) {
            this.grid = grid;
            this.isNew = aNew;
            GridCoordSystem gcs = grid.getCoordinateSystem();
            CoordinateAxis1D zaxis = gcs.getVerticalAxis();
            if (zaxis != null) {
                this.isLayer = zaxis.isInterval();
            }
            if (this.isNew) {
                int intv;
                Attribute att = grid.findAttributeIgnoreCase("Grib2_Parameter");
                for (int i = 0; i < 3; ++i) {
                    this.param[i] = att.getNumericValue(i).intValue();
                }
                att = grid.findAttributeIgnoreCase("Grib2_Level_Type");
                this.level = att.getNumericValue().intValue();
                this.isError = grid.getName().contains("error");
                att = grid.findAttributeIgnoreCase("Grib2_Statistical_Interval_Type");
                if (att != null && (intv = att.getNumericValue().intValue()) != 255) {
                    this.interval = intv;
                }
                if ((att = grid.findAttributeIgnoreCase("Grib2_Probability_Type")) != null) {
                    this.prob = att.getNumericValue().intValue();
                }
                if ((att = grid.findAttributeIgnoreCase("Grib2_Probability_Name")) != null) {
                    String pname = att.getStringValue();
                    int pos = pname.indexOf(95);
                    pname = pname.substring(pos + 1);
                    this.probLimit = (int)(1000.0 * Double.parseDouble(pname));
                }
                if ((att = grid.findAttributeIgnoreCase("Grib2_Ensemble_Derived_Type")) != null) {
                    this.ens = att.getNumericValue().intValue();
                }
            } else {
                Attribute att = grid.findAttributeIgnoreCase("GRIB_param_id");
                for (int i = 0; i < 3; ++i) {
                    this.param[i] = att.getNumericValue(i + 1).intValue();
                }
                att = grid.findAttributeIgnoreCase("GRIB_level_type");
                this.level = att.getNumericValue().intValue();
                this.isError = grid.getName().contains("error");
                att = grid.findAttributeIgnoreCase("GRIB_interval_stat_type");
                if (att != null) {
                    String intName = att.getStringValue();
                    this.interval = GribStatType.getStatTypeNumber((String)intName);
                }
                if ((att = grid.findAttributeIgnoreCase("GRIB_probability_type")) != null) {
                    this.prob = att.getNumericValue().intValue();
                }
                if (this.prob == 0) {
                    att = grid.findAttributeIgnoreCase("GRIB_probability_lower_limit");
                    if (att != null) {
                        this.probLimit = (int)(1000.0 * att.getNumericValue().doubleValue());
                    }
                } else if (this.prob == 1 && (att = grid.findAttributeIgnoreCase("GRIB_probability_upper_limit")) != null) {
                    this.probLimit = (int)(1000.0 * att.getNumericValue().doubleValue());
                }
                if ((att = grid.findAttributeIgnoreCase("GRIB_ensemble_derived_type")) != null) {
                    this.ens = att.getNumericValue().intValue();
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GridMatch gridMatch = (GridMatch)o;
            if (this.ens != gridMatch.ens) {
                return false;
            }
            if (this.interval != gridMatch.interval) {
                return false;
            }
            if (this.isError != gridMatch.isError) {
                return false;
            }
            if (this.isLayer != gridMatch.isLayer) {
                return false;
            }
            if (this.level != gridMatch.level) {
                return false;
            }
            if (this.prob != gridMatch.prob) {
                return false;
            }
            if (this.probLimit != gridMatch.probLimit) {
                return false;
            }
            return Arrays.equals(this.param, gridMatch.param);
        }

        public boolean altMatch(GridMatch gridMatch) {
            if (!this.altMatchNoProb(gridMatch)) {
                return false;
            }
            if (this.probLimit / 1000 == gridMatch.probLimit) {
                return true;
            }
            return this.probLimit == gridMatch.probLimit / 1000;
        }

        public boolean altMatchNoProb(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GridMatch gridMatch = (GridMatch)o;
            if (!Arrays.equals(this.param, gridMatch.param)) {
                return false;
            }
            if (this.ens != gridMatch.ens) {
                return false;
            }
            if (this.interval != gridMatch.interval) {
                return false;
            }
            if (this.isError != gridMatch.isError) {
                return false;
            }
            if (this.isLayer != gridMatch.isLayer) {
                return false;
            }
            if (this.level != gridMatch.level) {
                return false;
            }
            return this.prob == gridMatch.prob;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.level;
            result = 31 * result + this.param[0];
            result = 31 * result + (this.isLayer ? 1 : 0);
            result = 31 * result + this.param[1];
            result = 31 * result + (this.isError ? 1 : 0);
            if (this.interval >= 0) {
                result = 31 * result + this.interval;
            }
            if (this.prob >= 0) {
                result = 31 * result + this.prob;
            }
            result = 31 * result + this.param[2];
            if (this.ens >= 0) {
                result = 31 * result + this.ens;
            }
            if (this.probLimit != Integer.MAX_VALUE) {
                result = 31 * result + this.probLimit;
            }
            return result;
        }

        @Override
        public int compareTo(GridMatch o) {
            return this.grid.compareTo((Object)o.grid);
        }

        String show() {
            Formatter f = new Formatter();
            for (int i = 0; i < 3; ++i) {
                f.format("%d-", this.param[i]);
            }
            f.format("%d", this.level);
            if (this.isLayer) {
                f.format("_layer", new Object[0]);
            }
            if (this.interval >= 0) {
                f.format("_intv%d", this.interval);
            }
            if (this.prob >= 0) {
                f.format("_prob%d_%d", this.prob, this.probLimit);
            }
            if (this.ens >= 0) {
                f.format("_ens%d", this.ens);
            }
            if (this.isError) {
                f.format("_error", new Object[0]);
            }
            return f.toString();
        }
    }

    private class VarName {
        String dataset;
        String oldVar;
        String newVar;
        String varId;

        private VarName(String dataset, String oldVar, String newVar, String varId) {
            this.dataset = dataset;
            this.oldVar = oldVar;
            this.newVar = newVar;
            this.varId = varId;
        }
    }

    private class FileCount {
        MFile f;
        int count = 0;
        int countGds = 0;

        private FileCount(MFile f, int countGds) {
            this.f = f;
            this.countGds = countGds;
        }
    }

    private class GdsList {
        Grib2Gds gds;
        List<FileCount> fileList = new ArrayList<FileCount>();

        private GdsList(Grib2Gds gds) {
            this.gds = gds;
        }

        FileCount contains(MFile f) {
            for (FileCount fc : this.fileList) {
                if (!fc.f.getPath().equals(f.getPath())) continue;
                return fc;
            }
            return null;
        }
    }

    public static enum Report {
        checkTables,
        localUseSection,
        uniqueGds,
        duplicatePds,
        drsSummary,
        gdsTemplate,
        pdsSummary,
        idProblems,
        timeCoord,
        rename,
        renameCheck,
        copyCompress;

    }
}

