/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.coverage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.fmrc.GridDatasetInv;
import ucar.nc2.ft.grid.Coverage;
import ucar.nc2.ft.grid.CoverageCS;
import ucar.nc2.ft.grid.CoverageDataset;
import ucar.nc2.ft.grid.impl.CoverageDatasetImpl;
import ucar.nc2.ui.dialog.NetcdfOutputChooser;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class CoverageTable
extends JPanel {
    private PreferencesExt prefs;
    private CoverageDataset gridDataset;
    private BeanTableSorted varTable;
    private BeanTableSorted csTable = null;
    private BeanTableSorted axisTable = null;
    private JSplitPane split = null;
    private JSplitPane split2 = null;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private NetcdfOutputChooser outChooser;

    public CoverageTable(PreferencesExt prefs) {
        this.prefs = prefs;
        this.varTable = new BeanTableSorted(CoverageBean.class, (PreferencesExt)prefs.node("GeogridBeans"), false);
        JTable jtable = this.varTable.getJTable();
        PopupMenu csPopup = new PopupMenu(jtable, "Options");
        csPopup.addAction("Show Declaration", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageBean vb = (CoverageBean)CoverageTable.this.varTable.getSelectedBean();
                CoverageTable.this.infoTA.clear();
                CoverageTable.this.infoTA.appendLine("Coverage " + vb.geogrid.getName() + " :");
                CoverageTable.this.infoTA.appendLine(vb.geogrid.toString());
                CoverageTable.this.infoTA.gotoTop();
                CoverageTable.this.infoWindow.show();
            }
        });
        csPopup.addAction("Show Coordinates", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageBean vb = (CoverageBean)CoverageTable.this.varTable.getSelectedBean();
                Formatter f = new Formatter();
                CoverageTable.this.showCoordinates(vb, f);
                CoverageTable.this.infoTA.setText(f.toString());
                CoverageTable.this.infoTA.gotoTop();
                CoverageTable.this.infoWindow.show();
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Variable Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.csTable = new BeanTableSorted(CoverageCSBean.class, (PreferencesExt)prefs.node("GeoCoordinateSystemBean"), false);
        this.axisTable = new BeanTableSorted(AxisBean.class, (PreferencesExt)prefs.node("GeoCoordinateAxisBean"), false);
        this.split = new JSplitPane(0, false, this.varTable, this.csTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.split2 = new JSplitPane(0, false, this.split, this.axisTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split2, "Center");
    }

    public void addExtra(JPanel buttPanel, FileManager fileChooser) {
        AbstractButton infoButton = BAMutil.makeButtcon("Information", "Parse Info", false);
        infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CoverageTable.this.gridDataset != null && CoverageTable.this.gridDataset instanceof GridDataset) {
                    GridDataset gdsImpl = (GridDataset)CoverageTable.this.gridDataset;
                    CoverageTable.this.infoTA.clear();
                    CoverageTable.this.infoTA.appendLine(gdsImpl.getDetailInfo());
                    CoverageTable.this.infoTA.gotoTop();
                    CoverageTable.this.infoWindow.show();
                }
            }
        });
        buttPanel.add(infoButton);
        JButton invButton = new JButton("GridInv");
        invButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CoverageTable.this.gridDataset == null) {
                    return;
                }
                GridDatasetInv inv = new GridDatasetInv((GridDataset)CoverageTable.this.gridDataset, null);
                try {
                    CoverageTable.this.infoTA.setText(inv.writeXML(new Date()));
                    CoverageTable.this.infoTA.gotoTop();
                    CoverageTable.this.infoWindow.show();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        buttPanel.add(invButton);
    }

    private void showCoordinates(CoverageBean vb, Formatter f) {
        CoverageCS gcs = vb.geogrid.getCoordinateSystem();
        gcs.show(f, true);
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.varTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
        if (this.split2 != null) {
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        }
        if (this.csTable != null) {
            this.csTable.saveState(false);
        }
        if (this.axisTable != null) {
            this.axisTable.saveState(false);
        }
    }

    public void setDataset(NetcdfDataset ds, Formatter parseInfo) throws IOException {
        this.gridDataset = new CoverageDatasetImpl(ds, parseInfo);
        ArrayList<CoverageBean> beanList = new ArrayList<CoverageBean>();
        List list = this.gridDataset.getCoverages();
        for (Coverage g : list) {
            beanList.add(new CoverageBean(g));
        }
        this.varTable.setBeans(beanList);
        if (this.csTable != null) {
            ArrayList<CoverageCSBean> csList = new ArrayList<CoverageCSBean>();
            ArrayList<AxisBean> axisList = new ArrayList<AxisBean>();
            for (CoverageDataset.CoverageSet gset : this.gridDataset.getCoverageSets()) {
                csList.add(new CoverageCSBean(gset));
                CoverageCS gsys = gset.getCoverageCS();
                List axes = gsys.getCoordinateAxes();
                for (int i = 0; i < axes.size(); ++i) {
                    CoordinateAxis axis = (CoordinateAxis)axes.get(i);
                    AxisBean axisBean = new AxisBean(axis);
                    if (this.contains(axisList, axisBean.getName())) continue;
                    axisList.add(axisBean);
                }
            }
            this.csTable.setBeans(csList);
            this.axisTable.setBeans(axisList);
        }
    }

    public void setDataset(CoverageDataset gds) throws IOException {
        this.gridDataset = gds;
        ArrayList<CoverageBean> beanList = new ArrayList<CoverageBean>();
        List list = this.gridDataset.getCoverages();
        for (Coverage g : list) {
            beanList.add(new CoverageBean(g));
        }
        this.varTable.setBeans(beanList);
        if (this.csTable != null) {
            ArrayList<CoverageCSBean> csList = new ArrayList<CoverageCSBean>();
            ArrayList<AxisBean> axisList = new ArrayList<AxisBean>();
            for (CoverageDataset.CoverageSet gset : this.gridDataset.getCoverageSets()) {
                csList.add(new CoverageCSBean(gset));
                CoverageCS gsys = gset.getCoverageCS();
                List axes = gsys.getCoordinateAxes();
                for (int i = 0; i < axes.size(); ++i) {
                    CoordinateAxis axis = (CoordinateAxis)axes.get(i);
                    AxisBean axisBean = new AxisBean(axis);
                    if (this.contains(axisList, axisBean.getName())) continue;
                    axisList.add(axisBean);
                }
            }
            this.csTable.setBeans(csList);
            this.axisTable.setBeans(axisList);
        }
    }

    private boolean contains(List<AxisBean> axisList, String name) {
        for (AxisBean axis : axisList) {
            if (!axis.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public CoverageDataset getCoverageDataset() {
        return this.gridDataset;
    }

    public List<String> getSelectedGrids() {
        List grids = this.varTable.getSelectedBeans();
        ArrayList<String> result = new ArrayList<String>();
        for (Object bean : grids) {
            CoverageBean gbean = (CoverageBean)bean;
            result.add(gbean.getName());
        }
        return result;
    }

    public Coverage getGrid() {
        CoverageBean vb = (CoverageBean)this.varTable.getSelectedBean();
        if (vb == null) {
            List grids = this.gridDataset.getCoverages();
            if (grids.size() > 0) {
                return (Coverage)grids.get(0);
            }
            return null;
        }
        return this.gridDataset.findCoverage(vb.getName());
    }

    public JDialog makeDialog(RootPaneContainer parent, String title, boolean modal) {
        return new Dialog(parent, title, modal);
    }

    private class Dialog
    extends JDialog {
        private Dialog(RootPaneContainer parent, String title, boolean modal) {
            super(parent instanceof Frame ? (Frame)((Object)parent) : null, title, modal);
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("lookAndFeel")) {
                        SwingUtilities.updateComponentTreeUI(Dialog.this);
                    }
                }
            });
            Container cp = this.getContentPane();
            cp.setLayout(new BorderLayout());
            cp.add((Component)CoverageTable.this, "Center");
            this.pack();
        }
    }

    public class AxisBean {
        CoordinateAxis axis;
        CoordinateSystem firstCoordSys = null;
        String name;
        String desc;
        String units;
        String axisType = "";
        String positive = "";
        String incr = "";
        String dims;
        String shape;
        String csNames;
        boolean isCoordVar;

        public AxisBean() {
        }

        public AxisBean(CoordinateAxis v) {
            CoordinateAxis1D v1;
            String p;
            this.axis = v;
            this.setName(v.getFullName());
            this.setCoordVar(v.isCoordinateVariable());
            this.setDescription(v.getDescription());
            this.setUnits(v.getUnitsString());
            StringBuffer lens = new StringBuffer();
            StringBuffer names = new StringBuffer();
            List dims = v.getDimensions();
            for (int j = 0; j < dims.size(); ++j) {
                Dimension dim = (Dimension)dims.get(j);
                if (j > 0) {
                    lens.append(",");
                    names.append(",");
                }
                String name = dim.isShared() ? dim.getShortName() : "anon";
                names.append(name);
                lens.append(dim.getLength());
            }
            this.setDims(names.toString());
            this.setShape(lens.toString());
            AxisType at = v.getAxisType();
            if (at != null) {
                this.setAxisType(at.toString());
            }
            if ((p = v.getPositive()) != null) {
                this.setPositive(p);
            }
            if (v instanceof CoordinateAxis1D && (v1 = (CoordinateAxis1D)v).isRegular()) {
                this.setRegular(Double.toString(v1.getIncrement()));
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isCoordVar() {
            return this.isCoordVar;
        }

        public void setCoordVar(boolean isCoordVar) {
            this.isCoordVar = isCoordVar;
        }

        public String getShape() {
            return this.shape;
        }

        public void setShape(String shape) {
            this.shape = shape;
        }

        public String getAxisType() {
            return this.axisType;
        }

        public void setAxisType(String axisType) {
            this.axisType = axisType;
        }

        public String getDims() {
            return this.dims;
        }

        public void setDims(String dims) {
            this.dims = dims;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units == null ? "null" : units;
        }

        public String getPositive() {
            return this.positive;
        }

        public void setPositive(String positive) {
            this.positive = positive;
        }

        public String getRegular() {
            return this.incr;
        }

        public void setRegular(String incr) {
            this.incr = incr;
        }
    }

    public class CoverageCSBean {
        private CoverageCS gcs;
        private String proj;
        private String coordTrans;
        private int ngrids = -1;

        public CoverageCSBean() {
        }

        public CoverageCSBean(CoverageDataset.CoverageSet gset) {
            this.gcs = gset.getCoverageCS();
            this.setNGrids(gset.getCoverages().size());
            ProjectionImpl proj = this.gcs.getProjection();
            if (proj != null) {
                this.setProjection(proj.getClassName());
            }
            int count = 0;
            StringBuffer buff = new StringBuffer();
            List ctList = this.gcs.getCoordinateTransforms();
            for (int i = 0; i < ctList.size(); ++i) {
                ProjectionCT pct;
                CoordinateTransform ct = (CoordinateTransform)ctList.get(i);
                if (count > 0) {
                    buff.append("; ");
                }
                if (ct instanceof VerticalCT) {
                    buff.append(((VerticalCT)ct).getVerticalTransformType());
                    ++count;
                }
                if (!(ct instanceof ProjectionCT) || (pct = (ProjectionCT)ct).getProjection() != null) continue;
                buff.append("-").append(pct.getName());
                ++count;
            }
            this.setCoordTransforms(buff.toString());
        }

        public String getName() {
            return this.gcs.getName();
        }

        public String getCoverage() {
            return this.gcs.toString();
        }

        public int getDomainRank() {
            return this.gcs.getDomain().size();
        }

        public int getRangeRank() {
            return this.gcs.getCoordinateAxes().size();
        }

        public int getNGrids() {
            return this.ngrids;
        }

        public void setNGrids(int ngrids) {
            this.ngrids = ngrids;
        }

        public String getProjection() {
            return this.proj;
        }

        public void setProjection(String proj) {
            this.proj = proj;
        }

        public String getCoordTransforms() {
            return this.coordTrans;
        }

        public void setCoordTransforms(String coordTrans) {
            this.coordTrans = coordTrans;
        }
    }

    public class CoverageBean {
        Coverage geogrid;
        String name;
        String desc;
        String units;
        String extra;
        String dims;
        String x;
        String y;
        String z;
        String t;

        public CoverageBean() {
        }

        public CoverageBean(Coverage geogrid) {
            this.geogrid = geogrid;
            this.setName(geogrid.getName());
            this.setDescription(geogrid.getDescription());
            this.setUnits(geogrid.getUnitsString());
            StringBuffer buff = new StringBuffer();
            List dims = geogrid.getDimensions();
            for (int j = 0; j < dims.size(); ++j) {
                Dimension dim = (Dimension)dims.get(j);
                if (j > 0) {
                    buff.append(",");
                }
                buff.append(dim.getLength());
            }
            this.setShape(buff.toString());
            CoverageCS gcs = geogrid.getCoordinateSystem();
            this.x = this.getAxisName(gcs.getXHorizAxis());
            this.y = this.getAxisName(gcs.getYHorizAxis());
            this.z = this.getAxisName(gcs.getVerticalAxis());
            this.t = this.getAxisName(gcs.getTimeAxis());
            Formatter f = new Formatter();
            List domain = gcs.getDomain();
            int count = 0;
            for (Dimension d : geogrid.getDimensions()) {
                if (domain.contains(d)) continue;
                if (count++ > 0) {
                    f.format(",", new Object[0]);
                }
                f.format("%s", d.getShortName());
            }
            this.extra = f.toString();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units;
        }

        public String getCoordSystem() {
            return this.geogrid.getCoordinateSystem().toString();
        }

        public String getX() {
            return this.x;
        }

        public String getY() {
            return this.y;
        }

        public String getZ() {
            return this.z;
        }

        public String getT() {
            return this.t;
        }

        public String getShape() {
            return this.dims;
        }

        public void setShape(String dims) {
            this.dims = dims;
        }

        public String getExtraDim() {
            return this.extra;
        }

        private String getAxisName(CoordinateAxis axis) {
            if (axis != null) {
                return axis.isCoordinateVariable() ? axis.getShortName() : axis.getNameAndDimensions(false);
            }
            return "";
        }
    }
}

