/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import thredds.inventory.CollectionManager;
import thredds.inventory.MFile;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.fmrc.FmrInv;
import ucar.nc2.ft.fmrc.Fmrc;
import ucar.nc2.ft.fmrc.FmrcInv;
import ucar.nc2.ft.fmrc.FmrcInvLite;
import ucar.nc2.ft.fmrc.GridDatasetInv;
import ucar.nc2.ft.fmrc.TimeCoord;
import ucar.nc2.ft.fmrc.TimeInventory;
import ucar.nc2.ft.fmrc.VertCoord;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.ui.dialog.Fmrc2Dialog;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.units.DateFormatter;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class Fmrc2Panel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable fmrTable;
    private BeanTable invTable;
    private BeanTable coordTable;
    private BeanTable gridTable;
    private JSplitPane split;
    private JSplitPane split2;
    private JSplitPane splitV;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private Fmrc fmrc;
    private FmrcInv fmrcInv;
    private FmrcInvLite lite;
    private Formatter errlog;
    private Formatter debug;
    private DateFormatter df = new DateFormatter();
    private static final String fmrBeanDesc = "FmrInv: one for each runtime";
    private static final String dataBeanDesc = "GridDatasetInv: one for each file in the run";
    private static final String coordBeanDesc = "unique TimeCoords (from RunSeq), VertCoords";
    private static final String gridBeanDesc = "UberGrids from the FmrcInv";
    private Fmrc2Dialog dialog = null;

    public Fmrc2Panel(PreferencesExt prefs) {
        this.prefs = prefs;
        this.fmrTable = new BeanTable(FmrBean.class, (PreferencesExt)prefs.node("DatasetBean"), false, "FmrInv", fmrBeanDesc, null);
        this.fmrTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FmrBean fmrBean = (FmrBean)Fmrc2Panel.this.fmrTable.getSelectedBean();
                Fmrc2Panel.this.setFmr(fmrBean.fmr);
            }
        });
        this.invTable = new BeanTable(InvBean.class, (PreferencesExt)prefs.node("DataBean"), false, "GridDatasetInv", dataBeanDesc, null);
        this.invTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                InvBean invBean = (InvBean)Fmrc2Panel.this.invTable.getSelectedBean();
            }
        });
        this.coordTable = new BeanTable(CoordBean.class, (PreferencesExt)prefs.node("CoordBean"), false, "Time,Vert coords", coordBeanDesc, null);
        this.coordTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CoordBean coordBean = (CoordBean)Fmrc2Panel.this.coordTable.getSelectedBean();
            }
        });
        this.coordTable.setSelectionMode(2);
        this.gridTable = new BeanTable(GridBean.class, (PreferencesExt)prefs.node("GridBean"), false, "UberGrids", gridBeanDesc, null);
        this.gridTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GridBean gridBean = (GridBean)Fmrc2Panel.this.gridTable.getSelectedBean();
                Fmrc2Panel.this.setSelectedCoord(gridBean);
            }
        });
        PopupMenu varPopup = new PopupMenu(this.invTable.getJTable(), "Options");
        varPopup.addAction("Open in NetcdfFile Viewer", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvBean dsb = (InvBean)Fmrc2Panel.this.invTable.getSelectedBean();
                if (dsb == null) {
                    return;
                }
                Fmrc2Panel.this.firePropertyChange("openNetcdfFile", null, dsb.fmrInv.getLocation());
            }
        });
        varPopup.addAction("Open in CoordSys tab", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvBean dsb = (InvBean)Fmrc2Panel.this.invTable.getSelectedBean();
                if (dsb == null) {
                    return;
                }
                Fmrc2Panel.this.firePropertyChange("openCoordSys", null, dsb.fmrInv.getLocation());
            }
        });
        varPopup.addAction("Open in GridDataset tab", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvBean dsb = (InvBean)Fmrc2Panel.this.invTable.getSelectedBean();
                if (dsb == null) {
                    return;
                }
                Fmrc2Panel.this.firePropertyChange("openGridDataset", null, dsb.fmrInv.getLocation());
            }
        });
        varPopup.addAction("show GridInventory XML", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvBean dsb = (InvBean)Fmrc2Panel.this.invTable.getSelectedBean();
                if (dsb == null) {
                    return;
                }
                Fmrc2Panel.this.infoTA.setText(dsb.fmrInv.writeXML(null));
                Fmrc2Panel.this.infoWindow.show();
            }
        });
        varPopup = new PopupMenu(this.coordTable.getJTable(), "Options");
        varPopup.addAction("Show Inv", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordBean bean = (CoordBean)Fmrc2Panel.this.coordTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                Fmrc2Panel.this.showCoordInv(bean);
            }
        });
        varPopup = new PopupMenu(this.gridTable.getJTable(), "Options");
        varPopup.addAction("Show Inv Coords", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridBean bean = (GridBean)Fmrc2Panel.this.gridTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                Fmrc2Panel.this.showGridInv(bean);
            }
        });
        this.infoTA = new TextHistoryPane(false, 5000, 50, true, false, 14);
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.splitV = new JSplitPane(1, false, this.fmrTable, this.invTable);
        this.splitV.setDividerLocation(prefs.getInt("splitPosV", 500));
        this.split = new JSplitPane(0, false, this.splitV, this.coordTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.split2 = new JSplitPane(0, false, this.split, this.gridTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split2, "Center");
    }

    public void save() {
        this.fmrTable.saveState(false);
        this.invTable.saveState(false);
        this.coordTable.saveState(false);
        this.gridTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        this.prefs.putInt("splitPosV", this.splitV.getDividerLocation());
    }

    public void closeOpenFiles() throws IOException {
        if (this.fmrc != null) {
            this.fmrc.close();
        }
        this.fmrc = null;
    }

    public void setFmrc(String collectionSpec) throws IOException {
        this.closeOpenFiles();
        long start = System.currentTimeMillis();
        this.errlog = new Formatter();
        this.fmrc = Fmrc.open((String)collectionSpec, (Formatter)this.errlog);
        if (this.fmrc == null) {
            this.infoTA.setText(this.errlog.toString());
            this.infoTA.gotoTop();
            this.infoWindow.show();
            return;
        }
        if (!this.showCollectionInfo(false)) {
            return;
        }
        this.debug = new Formatter();
        this.fmrcInv = this.fmrc.getFmrcInv(this.debug);
        this.lite = new FmrcInvLite(this.fmrcInv);
        ArrayList<FmrBean> beanList = new ArrayList<FmrBean>();
        for (FmrInv fmr : this.fmrcInv.getFmrList()) {
            beanList.add(new FmrBean(fmr));
        }
        this.fmrTable.setBeans(beanList);
        this.invTable.setBeans(new ArrayList());
        this.setCoords(this.fmrcInv);
        this.setGrids(this.fmrcInv);
        long took = System.currentTimeMillis() - start;
        System.out.printf("that took %f secs%n", (double)took / 1000.0);
    }

    public boolean showCollectionInfo(boolean alwaysShow) {
        if (this.fmrc == null) {
            this.infoTA.setText("No fmrc, errlog=");
            this.infoTA.appendLine(this.errlog.toString());
            this.infoTA.appendLine("\ndebug=");
            this.infoTA.appendLine(this.debug.toString());
            this.infoTA.gotoTop();
            this.infoWindow.show();
            return false;
        }
        this.infoTA.clear();
        CollectionManager cm = this.fmrc.getManager();
        this.infoTA.appendLine("CollectionManager= ");
        this.infoTA.appendLine(cm.toString());
        try {
            cm.scan(true);
        }
        catch (IOException e1) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(5000);
            e1.printStackTrace(new PrintStream(bos));
            this.infoTA.appendLine(bos.toString());
            this.infoTA.gotoTop();
            this.infoWindow.show();
            return false;
        }
        boolean status = false;
        int count = 0;
        this.infoTA.appendLine("Files found=");
        for (MFile mfile : cm.getFiles()) {
            this.infoTA.appendLine(" " + mfile.getPath() + " " + new Date(mfile.getLastModified()) + " " + mfile.getLength());
            ++count;
        }
        this.infoTA.appendLine("total files=" + count);
        status = true;
        if (alwaysShow) {
            this.infoWindow.show();
        }
        return status;
    }

    public void showDataset() throws IOException {
        if (this.fmrcInv == null) {
            return;
        }
        if (this.dialog == null) {
            this.dialog = new Fmrc2Dialog(null);
            this.dialog.pack();
            this.dialog.addPropertyChangeListener("OK", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Fmrc2Dialog.Data data = (Fmrc2Dialog.Data)evt.getNewValue();
                    if (data.type == null || data.where == null) {
                        return;
                    }
                    Fmrc2Panel.this.processDialog(data);
                }
            });
        }
        this.dialog.setFmrc(this.fmrc);
        this.dialog.setVisible(true);
    }

    private void processDialog(Fmrc2Dialog.Data data) {
        if (data.where.startsWith("Selected UberGrid")) {
            GridBean bean = (GridBean)this.gridTable.getSelectedBean();
            if (bean == null) {
                return;
            }
            this.showGridInv(data, bean);
            return;
        }
        GridDataset gds = null;
        try {
            if (data.type.equals("Dataset2D")) {
                gds = this.fmrc.getDataset2D(null);
            } else if (data.type.equals("Best")) {
                gds = this.fmrc.getDatasetBest();
            } else if (data.type.equals("Run")) {
                CalendarDate date = CalendarDate.parseISOformat(null, (String)((String)data.param));
                gds = this.fmrc.getRunTimeDataset(date);
            } else if (data.type.equals("ConstantForecast")) {
                CalendarDate date = CalendarDate.parseISOformat(null, (String)((String)data.param));
                gds = this.fmrc.getConstantForecastDataset(date);
            } else if (data.type.equals("ConstantOffset")) {
                gds = this.fmrc.getConstantOffsetDataset(((Double)data.param).doubleValue());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (data.where.startsWith("NetcdfFile")) {
            this.firePropertyChange("openNetcdfFile", null, gds.getNetcdfFile());
        } else if (data.where.startsWith("CoordSys")) {
            this.firePropertyChange("openCoordSys", null, gds.getNetcdfFile());
        } else if (data.where.startsWith("GridDataset")) {
            this.showGridDatasetInfo((ucar.nc2.dt.GridDataset)gds);
        } else if (data.where.startsWith("Grid")) {
            this.firePropertyChange("openGridDataset", null, gds);
        }
    }

    private void showGridDatasetInfo(ucar.nc2.dt.GridDataset gds) {
        this.infoTA.setText(gds.getDetailInfo());
        this.infoWindow.show();
    }

    private void setFmr(FmrInv fmr) {
        if (fmr == null) {
            return;
        }
        ArrayList<InvBean> beanList = new ArrayList<InvBean>();
        for (GridDatasetInv fmrInv : fmr.getInventoryList()) {
            beanList.add(new InvBean(fmrInv));
        }
        this.invTable.setBeans(beanList);
    }

    private void setCoords(FmrcInv fmrInv) {
        if (fmrInv == null) {
            return;
        }
        ArrayList<CoordBean> beanList = new ArrayList<CoordBean>();
        for (FmrcInv.RunSeq tc : fmrInv.getRunSeqs()) {
            beanList.add(new TimeCoordBean(tc));
        }
        for (VertCoord vc : fmrInv.getVertCoords()) {
            beanList.add(new VertCoordBean(vc));
        }
        this.coordTable.setBeans(beanList);
    }

    private void setGrids(FmrcInv fmrInv) {
        if (fmrInv == null) {
            return;
        }
        ArrayList<GridBean> beanList = new ArrayList<GridBean>();
        for (FmrcInv.UberGrid grid : fmrInv.getUberGrids()) {
            beanList.add(new GridBean(grid));
        }
        this.gridTable.setBeans(beanList);
    }

    private void setSelectedCoord(GridBean gridBean) {
        List beans = this.coordTable.getBeans();
        ArrayList<CoordBean> selected = new ArrayList<CoordBean>();
        for (CoordBean bean : beans) {
            if (bean instanceof TimeCoordBean) {
                TimeCoordBean tbean = (TimeCoordBean)bean;
                if (!tbean.runSeq.getName().equals(gridBean.getTimeCoordName())) continue;
                selected.add(bean);
                continue;
            }
            if (!(bean instanceof VertCoordBean)) continue;
            VertCoordBean vbean = (VertCoordBean)bean;
            if (!vbean.vc.getName().equals(gridBean.getVertCoordName())) continue;
            selected.add(bean);
        }
        this.coordTable.setSelectedBeans(selected);
    }

    private void showCoordInv(CoordBean coordBean) {
        Formatter out = new Formatter();
        if (coordBean instanceof TimeCoordBean) {
            FmrcInv.RunSeq runSeq = ((TimeCoordBean)coordBean).runSeq;
            out.format("Time coordinate %s %n%n", runSeq.getName());
            for (TimeCoord tc : runSeq.getTimes()) {
                if (tc == null) {
                    out.format(" NULL%n", new Object[0]);
                    continue;
                }
                out.format(" %s : 0x%x %n", tc, tc.hashCode());
            }
            out.format("%n Used by Grids:%n", new Object[0]);
            List ugrids = runSeq.getUberGrids();
            if (ugrids != null) {
                for (FmrcInv.UberGrid ugrid : ugrids) {
                    out.format(" %s%n", ugrid.getName());
                }
            }
        } else if (coordBean instanceof VertCoordBean) {
            VertCoord vc = ((VertCoordBean)coordBean).vc;
            out.format("Compare Vert coordinate %s %n%n", vc.getName());
            out.format(" Uber %s%n", vc.toString());
            for (FmrInv fmr : this.fmrcInv.getFmrList()) {
                out.format(" Fmr %s%n", fmr.getRunDate());
                for (VertCoord vc2 : fmr.getVertCoords()) {
                    if (!vc2.getName().equals(vc.getName())) continue;
                    String isSame = vc.equalsData(vc2) ? "" : "DIFF";
                    out.format("      %s %s%n", vc2.toString(), isSame);
                }
            }
        }
        this.infoTA.setText(out.toString());
        this.infoWindow.show();
    }

    public void showInfo(Formatter result) throws IOException {
        if (this.debug != null) {
            result.format("%s%n", this.debug.toString());
        }
        if (this.fmrc != null) {
            this.fmrc.showDetails(result);
        }
    }

    private void showGridInv(GridBean bean) {
        Formatter out = new Formatter();
        FmrcInv.UberGrid ugrid = bean.grid;
        out.format("Show FmrcInv.UberGrid name= %s%n% 3d expected inventory %n%n", ugrid.getName(), ugrid.countExpected());
        TimeCoord union = ugrid.getUnionTimeCoord();
        int w2 = union.isInterval() ? 9 : 6;
        out.format("                              ", new Object[0]);
        for (int i = 0; i < union.getNCoords(); ++i) {
            out.format("%" + w2 + "d ", i);
        }
        out.format("%n", new Object[0]);
        out.format("     RunTime             Total ", new Object[0]);
        this.showCoords(union, out);
        out.format("%n", new Object[0]);
        int count = 0;
        int runidx = 0;
        for (FmrInv.GridVariable run : ugrid.getRuns()) {
            for (GridDatasetInv.Grid inv : run.getInventory()) {
                out.format(" %3d %s ", runidx, CalendarDateFormatter.toDateTimeString((CalendarDate)run.getRunDate()));
                count += this.showActualInventory(inv, union, w2, out);
                out.format(" %s%n", inv.getLocation());
            }
            ++runidx;
        }
        out.format("%n%3d counted inventory%n%n%n", count);
        this.lite.showGridInfo(ugrid.getName(), out);
        this.infoTA.setText(out.toString());
        this.infoWindow.show();
    }

    private int showActualInventory(GridDatasetInv.Grid inv, TimeCoord union, int w, Formatter out) {
        TimeCoord tc = inv.getTimeCoord();
        int nverts = inv.getVertCoordLength();
        out.format("%3d ", inv.countTotal());
        if (tc.isInterval()) {
            for (int i = 0; i < union.getNCoords(); ++i) {
                boolean hasInventory;
                boolean bl = hasInventory = tc.findInterval(union.getBound1()[i], union.getBound2()[i]) >= 0;
                if (hasInventory) {
                    out.format("%" + w + "d ", nverts);
                    continue;
                }
                out.format("%" + w + "s ", Character.valueOf(' '));
            }
        } else {
            for (int i = 0; i < union.getNCoords(); ++i) {
                boolean hasInventory;
                boolean bl = hasInventory = tc.findIndex(union.getOffsetTimes()[i]) >= 0;
                if (hasInventory) {
                    out.format("%" + w + "d ", nverts);
                    continue;
                }
                out.format("%" + w + "s ", Character.valueOf(' '));
            }
        }
        return inv.countTotal();
    }

    private void showCoords(TimeCoord tc, Formatter f) {
        if (!tc.isInterval()) {
            for (double off : tc.getOffsetTimes()) {
                f.format("%6.0f,", off);
            }
        } else {
            double[] bound1 = tc.getBound1();
            double[] bound2 = tc.getBound2();
            for (int i = 0; i < bound1.length; ++i) {
                f.format("%4.0f-%4.0f,", bound1[i], bound2[i]);
            }
        }
    }

    private void showCoords(FmrcInvLite.ValueB timeCoords, Formatter out) {
        if (timeCoords.bounds == null) {
            for (double rc : timeCoords.offset) {
                out.format("%9.0f,", rc);
            }
        } else {
            for (int i = 0; i < timeCoords.bounds.length; i += 2) {
                out.format("%4.0f-%4.0f,", timeCoords.bounds[i], timeCoords.bounds[i + 1]);
            }
        }
    }

    private void showGridInv(Fmrc2Dialog.Data ddata, GridBean bean) {
        Formatter out = new Formatter();
        FmrcInv.UberGrid ugrid = bean.grid;
        FmrcInvLite.Gridset gset = this.lite.findGridset(ugrid.getName());
        TimeInventory ti = null;
        try {
            CalendarDate date;
            if (ddata.type.equals("Best")) {
                ti = this.lite.makeBestDatasetInventory();
            } else if (ddata.type.equals("Run")) {
                date = CalendarDate.parseISOformat(null, (String)((String)ddata.param));
                ti = this.lite.makeRunTimeDatasetInventory(date);
            } else if (ddata.type.equals("ConstantForecast")) {
                date = CalendarDate.parseISOformat(null, (String)((String)ddata.param));
                ti = this.lite.getConstantForecastDataset(date);
            } else if (ddata.type.equals("ConstantOffset")) {
                ti = this.lite.getConstantOffsetDataset(((Double)ddata.param).doubleValue());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        out.format("Show UberGrid '%s' for dataset '%s'%n", ugrid.getName(), ti.getName());
        double[] runCoords = ti.getRunTimeCoords(gset);
        FmrcInvLite.ValueB timeCoords = ti.getTimeCoords(gset);
        double[] offsetCoords = ti.getOffsetCoords(gset);
        out.format("                ", new Object[0]);
        for (int i = 0; i < ti.getTimeLength(gset); ++i) {
            out.format("%9d,", i);
        }
        out.format("%n", new Object[0]);
        if (runCoords != null) {
            out.format("RunTimeCoords = ", new Object[0]);
            for (double rc : runCoords) {
                out.format("%9.2f,", rc);
            }
            out.format("%n", new Object[0]);
        }
        if (offsetCoords != null) {
            out.format("offsetCoords = ", new Object[0]);
            for (double rc : offsetCoords) {
                out.format("%9.2f,", rc);
            }
            out.format("%n", new Object[0]);
        }
        if (timeCoords != null) {
            out.format("  timeCoords = ", new Object[0]);
            this.showCoords(timeCoords, out);
            out.format("%n", new Object[0]);
        }
        FmrcInvLite.Gridset.Grid grid = this.lite.findGrid(ugrid.getName());
        int ntimes = ti.getTimeLength(gset);
        out.format("%nInventory%n", new Object[0]);
        for (int i = 0; i < ntimes; ++i) {
            TimeInventory.Instance ins = ti.getInstance(grid, i);
            if (ins != null) {
                out.format(" %3d: %3d, %s%n", i, ins.getDatasetIndex(), ins.getDatasetLocation());
                continue;
            }
            out.format(" %3d: MISSING%n", i);
        }
        this.infoTA.setText(out.toString());
        this.infoWindow.show();
    }

    public class VertCoordBean
    extends CoordBean {
        VertCoord vc;

        public VertCoordBean() {
        }

        public VertCoordBean(VertCoord tc) {
            this.vc = tc;
        }

        @Override
        public String getType() {
            return "vert";
        }

        @Override
        public String getName() {
            return this.vc.getName();
        }

        @Override
        public String getCoords() {
            Formatter sb = new Formatter();
            double[] values1 = this.vc.getValues1();
            double[] values2 = this.vc.getValues2();
            if (values2 == null) {
                for (double lev : values1) {
                    sb.format("%s ", lev);
                }
            } else {
                for (int i = 0; i < values1.length; ++i) {
                    sb.format("(%f,%f) ", values1[i], values2[i]);
                }
            }
            return sb.toString();
        }
    }

    public class TimeCoordBean
    extends CoordBean {
        FmrcInv.RunSeq runSeq;

        public TimeCoordBean() {
        }

        public TimeCoordBean(FmrcInv.RunSeq tc) {
            this.runSeq = tc;
        }

        @Override
        public String getType() {
            return "time";
        }

        @Override
        public String getName() {
            return this.runSeq.getName();
        }

        @Override
        public String getCoords() {
            Formatter sb = new Formatter();
            TimeCoord tc = this.runSeq.getUnionTimeCoord();
            if (!tc.isInterval()) {
                for (double off : tc.getOffsetTimes()) {
                    sb.format("%f,", off);
                }
            } else {
                double[] bound1 = tc.getBound1();
                double[] bound2 = tc.getBound2();
                for (int i = 0; i < bound1.length; ++i) {
                    sb.format("(%f %f),", bound1[i], bound2[i]);
                }
            }
            return sb.toString();
        }
    }

    public abstract class CoordBean {
        public abstract String getType();

        public abstract String getName();

        public abstract String getCoords();
    }

    public class GridBean {
        FmrcInv.UberGrid grid;

        public GridBean() {
        }

        public GridBean(FmrcInv.UberGrid grid) {
            this.grid = grid;
        }

        public String getName() {
            return this.grid.getName();
        }

        public String getTimeCoordName() {
            return this.grid.getTimeCoordName();
        }

        public String getVertCoordName() {
            return this.grid.getVertCoordName();
        }

        public int getCount() {
            return this.grid.countTotal();
        }

        public int getExpected() {
            return this.grid.countExpected();
        }

        public boolean getStatus() {
            return this.getExpected() == this.getCount();
        }
    }

    public class InvBean {
        GridDatasetInv fmrInv;

        public InvBean() {
        }

        public InvBean(GridDatasetInv fmr) {
            this.fmrInv = fmr;
        }

        public String getLocation() {
            return this.fmrInv.getLocation();
        }
    }

    public class FmrBean {
        FmrInv fmr;

        public FmrBean() {
        }

        public FmrBean(FmrInv fmr) {
            this.fmr = fmr;
        }

        public CalendarDate getRunDate() throws IOException {
            return this.fmr.getRunDate();
        }
    }
}

