/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import thredds.inventory.bdb.MetadataManager;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.unidata.util.StringUtil2;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class FmrcCollectionTable
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable collectionNameTable;
    private BeanTable dataTable;
    private JSplitPane split;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;

    public FmrcCollectionTable(PreferencesExt prefs) {
        this.prefs = prefs;
        this.collectionNameTable = new BeanTable(CollectionBean.class, (PreferencesExt)prefs.node("DatasetBean"), false);
        this.collectionNameTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CollectionBean bean = (CollectionBean)FmrcCollectionTable.this.collectionNameTable.getSelectedBean();
                FmrcCollectionTable.this.setCollection(bean.name);
            }
        });
        PopupMenu varPopup = new PopupMenu(this.collectionNameTable.getJTable(), "Options");
        varPopup.addAction("Show Collection Stats", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionBean bean = (CollectionBean)FmrcCollectionTable.this.collectionNameTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                FmrcCollectionTable.this.showCollectionInfo(bean.name);
            }
        });
        varPopup.addAction("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionBean bean = (CollectionBean)FmrcCollectionTable.this.collectionNameTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                try {
                    MetadataManager.deleteCollection((String)bean.name);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                FmrcCollectionTable.this.refresh();
            }
        });
        this.dataTable = new BeanTable(DataBean.class, (PreferencesExt)prefs.node("DataBean"), false);
        this.dataTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DataBean bean = (DataBean)FmrcCollectionTable.this.dataTable.getSelectedBean();
                FmrcCollectionTable.this.showData(bean);
            }
        });
        varPopup = new PopupMenu(this.dataTable.getJTable(), "Options");
        varPopup.addAction("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionBean cbean = (CollectionBean)FmrcCollectionTable.this.collectionNameTable.getSelectedBean();
                DataBean bean = (DataBean)FmrcCollectionTable.this.dataTable.getSelectedBean();
                if (cbean == null || bean == null) {
                    return;
                }
                MetadataManager.delete((String)cbean.name, (String)bean.getKey());
                FmrcCollectionTable.this.setCollection(cbean.name);
            }
        });
        this.infoTA = new TextHistoryPane(false, 5000, 50, true, false, 14);
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.split = new JSplitPane(0, false, this.collectionNameTable, this.dataTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
        this.refresh();
    }

    private void showData(DataBean bean) {
        this.infoTA.setText(bean.getValue());
        this.infoWindow.show();
    }

    public void save() {
        this.collectionNameTable.saveState(false);
        this.dataTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    public void refresh() {
        ArrayList<CollectionBean> beanList = new ArrayList<CollectionBean>();
        for (String name : MetadataManager.getCollectionNames()) {
            beanList.add(new CollectionBean(name));
        }
        this.collectionNameTable.setBeans(beanList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCollection(String name) {
        ArrayList<DataBean> beans = new ArrayList<DataBean>();
        MetadataManager mm = null;
        try {
            mm = new MetadataManager(name);
            for (MetadataManager.KeyValue data : mm.getContent()) {
                beans.add(new DataBean(data));
            }
            this.dataTable.setBeans(beans);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (mm != null) {
                mm.close();
            }
        }
    }

    public void showInfo(Formatter result) throws IOException {
        MetadataManager.showEnvStats((Formatter)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showCollectionInfo(String name) {
        MetadataManager mm = null;
        try {
            Formatter f = new Formatter();
            mm = new MetadataManager(name);
            mm.showStats(f);
            this.infoTA.setText(f.toString());
            this.infoTA.gotoTop();
            this.infoWindow.show();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (mm != null) {
                mm.close();
            }
        }
    }

    public class DataBean {
        MetadataManager.KeyValue data;

        public DataBean() {
        }

        public DataBean(MetadataManager.KeyValue data) {
            this.data = data;
        }

        public String getKey() {
            return this.data.key;
        }

        public String getValue() {
            return this.data.value;
        }

        public int getSize() {
            return this.data.value.length();
        }
    }

    public class CollectionBean {
        String name;

        public CollectionBean() {
        }

        public CollectionBean(String name) {
            this.name = name;
        }

        public String getName() throws IOException {
            return this.name;
        }

        public String getNameDecoded() throws IOException {
            return StringUtil2.unescape((String)this.name);
        }
    }
}

