/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.image.image.ImageArrayAdapter;
import ucar.nc2.ui.image.ImageViewPanel;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.units.DateUnit;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class RadialDatasetTable
extends JPanel {
    private PreferencesExt prefs;
    private RadialDatasetSweep radialDataset;
    private DateUnit dateUnit;
    private BeanTable varTable;
    private BeanTable sweepTable = null;
    private JSplitPane split = null;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private static final String ImageViewer_WindowSize = "RadialImageViewer_WindowSize";
    private IndependentWindow imageWindow = null;
    private ImageViewPanel imageView = null;

    public RadialDatasetTable(PreferencesExt prefs) {
        this.prefs = prefs;
        this.varTable = new BeanTable(VariableBean.class, (PreferencesExt)prefs.node("VariableBeans"), false);
        this.varTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VariableBean vb = (VariableBean)RadialDatasetTable.this.varTable.getSelectedBean();
                RadialDatasetTable.this.setVariable(vb);
            }
        });
        JTable jtable = this.varTable.getJTable();
        PopupMenu csPopup = new PopupMenu(jtable, "Options");
        csPopup.addAction("Show Declaration", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariableBean vb = (VariableBean)RadialDatasetTable.this.varTable.getSelectedBean();
                VariableSimpleIF v = RadialDatasetTable.this.radialDataset.getDataVariable(vb.getName());
                RadialDatasetTable.this.infoTA.clear();
                RadialDatasetTable.this.infoTA.appendLine(v.toString());
                RadialDatasetTable.this.infoTA.gotoTop();
                RadialDatasetTable.this.infoWindow.show();
            }
        });
        csPopup.addAction("Show Info", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariableBean vb = (VariableBean)RadialDatasetTable.this.varTable.getSelectedBean();
                Formatter f = new Formatter();
                RadialDatasetTable.this.showInfo(RadialDatasetTable.this.radialDataset, vb.getName(), f);
                RadialDatasetTable.this.infoTA.clear();
                RadialDatasetTable.this.infoTA.appendLine(f.toString());
                RadialDatasetTable.this.infoTA.gotoTop();
                RadialDatasetTable.this.infoWindow.show();
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Variable Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.sweepTable = new BeanTable(SweepBean.class, (PreferencesExt)prefs.node("SweepBean"), false);
        PopupMenu sweepPopup = new PopupMenu(this.sweepTable.getJTable(), "Options");
        sweepPopup.addAction("Show Image", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RadialDatasetTable.this.showImage((SweepBean)RadialDatasetTable.this.sweepTable.getSelectedBean());
            }
        });
        this.split = new JSplitPane(0, false, this.varTable, this.sweepTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.varTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
        if (this.sweepTable != null) {
            this.sweepTable.saveState(false);
        }
    }

    public void clear() {
        this.varTable.setBeans(new ArrayList());
        this.sweepTable.setBeans(new ArrayList());
    }

    public void setDataset(RadialDatasetSweep rds) {
        this.radialDataset = rds;
        this.dateUnit = rds.getTimeUnits();
        this.varTable.setBeans(this.getVariableBeans(rds));
        this.sweepTable.setBeans(new ArrayList());
    }

    public RadialDatasetSweep getRadialDataset() {
        return this.radialDataset;
    }

    public List<VariableBean> getVariableBeans(RadialDatasetSweep rds) {
        ArrayList<VariableBean> vlist = new ArrayList<VariableBean>();
        List list = rds.getDataVariables();
        for (int i = 0; i < list.size(); ++i) {
            RadialDatasetSweep.RadialVariable v = (RadialDatasetSweep.RadialVariable)list.get(i);
            vlist.add(new VariableBean(v));
        }
        return vlist;
    }

    public void setVariable(VariableBean vb) {
        ArrayList<SweepBean> sweeps = new ArrayList<SweepBean>();
        int n = vb.v.getNumSweeps();
        for (int i = 0; i < n; ++i) {
            RadialDatasetSweep.Sweep sweep = vb.v.getSweep(i);
            sweeps.add(new SweepBean(sweep));
        }
        this.sweepTable.setBeans(sweeps);
    }

    private void showInfo(RadialDatasetSweep rds, String varName, Formatter f) {
        f.format("Radial Dataset %s%n", rds.getLocation());
        String stationID = rds.getRadarID();
        String stationName = rds.getRadarName();
        boolean isVolume = rds.isVolume();
        f.format("  stationName = %s%n", stationName);
        f.format("  isVolume = %s%n", isVolume);
        RadialDatasetSweep.RadialVariable v = (RadialDatasetSweep.RadialVariable)rds.getDataVariable(varName);
        f.format("  info for variable = %s%n", varName);
        f.format("  number of sweeps = %d%n", v.getNumSweeps());
        for (int sweep = 0; sweep < v.getNumSweeps(); ++sweep) {
            RadialDatasetSweep.Sweep sw = v.getSweep(sweep);
            float me = sw.getMeanElevation();
            int nrays = sw.getRadialNumber();
            int ngates = sw.getGateNumber();
            f.format("    %d : elev=%f nrays=%d ngates=%d%n", sweep, Float.valueOf(me), nrays, ngates);
            try {
                for (int j = 0; j < nrays; ++j) {
                    float azi = sw.getAzimuth(j);
                    float ele = sw.getElevation(j);
                    float[] data = sw.readData(j);
                    f.format("      %d : azimuth=%f elev=%f data len=%d%n", j, Float.valueOf(azi), Float.valueOf(ele), data.length);
                }
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void showImage(SweepBean bean) {
        if (bean == null) {
            return;
        }
        if (this.imageWindow == null) {
            this.imageWindow = new IndependentWindow("Image Viewer", BAMutil.getImage("ImageData"));
            this.imageView = new ImageViewPanel(null);
            this.imageWindow.setComponent(new JScrollPane(this.imageView));
            Rectangle b = (Rectangle)this.prefs.getBean(ImageViewer_WindowSize, new Rectangle(99, 33, 700, 900));
            this.imageWindow.setBounds(b);
        }
        try {
            float[] data = bean.sweep.readData();
            int[] shape = new int[]{bean.getNumRadial(), bean.getNumGates()};
            Array arrData = Array.factory((Class)DataType.FLOAT.getPrimitiveClassType(), (int[])shape, (Object)data);
            this.imageView.setImage(ImageArrayAdapter.makeGrayscaleImage((Array)arrData));
            this.imageWindow.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class SweepBean {
        RadialDatasetSweep.Sweep sweep;

        public SweepBean() {
        }

        public SweepBean(RadialDatasetSweep.Sweep sweep) {
            this.sweep = sweep;
        }

        public String getType() {
            RadialDatasetSweep.Type type = this.sweep.getType();
            return type == null ? "" : type.toString();
        }

        public int getNumRadial() {
            return this.sweep.getRadialNumber();
        }

        public int getNumGates() {
            return this.sweep.getGateNumber();
        }

        public float getBeamWidth() {
            return this.sweep.getBeamWidth();
        }

        public float getNyqFreq() {
            return this.sweep.getNyquistFrequency();
        }

        public float getFirstGate() {
            return this.sweep.getRangeToFirstGate();
        }

        public float getGateSize() {
            return this.sweep.getGateSize();
        }

        public float getMeanElevation() {
            return this.sweep.getMeanElevation();
        }

        public float getMeanAzimuth() {
            return this.sweep.getMeanAzimuth();
        }

        public Date getStartingTime() {
            return this.sweep.getStartingTime();
        }

        public Date getEndingTime() {
            return this.sweep.getEndingTime();
        }
    }

    public class VariableBean {
        RadialDatasetSweep.RadialVariable v;
        private String name;
        private String desc;
        private String units;
        private String dataType;
        String dims;
        String r;
        String elev;
        String azi;
        String t;

        public VariableBean() {
        }

        public VariableBean(RadialDatasetSweep.RadialVariable v) {
            this.v = v;
            this.setName(v.getShortName());
            this.setDescription(v.getDescription());
            this.setUnits(v.getUnitsString());
            this.dataType = v.getDataType().toString();
            StringBuffer buff = new StringBuffer();
            int[] shape = v.getShape();
            for (int j = 0; j < shape.length; ++j) {
                if (j > 0) {
                    buff.append(",");
                }
                buff.append(shape[j]);
            }
            this.dims = buff.toString();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units;
        }

        public String getDataType() {
            return this.dataType;
        }

        public String getDims() {
            return this.dims;
        }
    }
}

