/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.geoloc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import ucar.nc2.ui.geoloc.NPController;
import ucar.nc2.ui.geoloc.NavigatedPanel;
import ucar.nc2.ui.geoloc.NewMapAreaEvent;
import ucar.nc2.ui.geoloc.NewMapAreaListener;
import ucar.nc2.ui.geoloc.ProjectionManager;
import ucar.nc2.ui.geoloc.ProjectionParamPanel;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.util.Format;
import ucar.util.prefs.ui.ComboBox;

public class NewProjectionDialog
extends JDialog {
    private static final int min_sigfig = 6;
    private ProjectionManager pm;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panel1;
    private JButton cancelButton;
    private JButton okButton;
    private JButton applyButton;
    private JPanel MapArePanel;
    private JTextField maxy;
    private JLabel label3;
    private JTextField minx;
    private JTextField maxx;
    private JTextField miny;
    private JLabel label4;
    private JLabel label5;
    private JLabel label6;
    private JPanel ProjPanel;
    private ComboBox cbProjectionType;
    private ProjectionParamPanel projectionParamPanel1;
    private NPController navPanel;
    private JPanel buttonBar;

    public NewProjectionDialog(Frame owner) {
        super(owner);
        this.initComponents();
        this.wire();
    }

    public NewProjectionDialog(Dialog owner) {
        super(owner);
        this.initComponents();
        this.wire();
    }

    public void setProjectionManager(ProjectionManager pm, Collection<Object> types) {
        this.pm = pm;
        this.cbProjectionType.setItemList(types);
    }

    public NPController getNPController() {
        return this.navPanel;
    }

    private void wire() {
        NavigatedPanel mapEditPanel = this.navPanel.getNavigatedPanel();
        mapEditPanel.addNewMapAreaListener(new NewMapAreaListener(){

            @Override
            public void actionPerformed(NewMapAreaEvent e) {
                ProjectionRect rect = e.getMapArea();
                NewProjectionDialog.this.minx.setText(Format.d((double)rect.getMinX(), (int)6));
                NewProjectionDialog.this.maxx.setText(Format.d((double)rect.getMaxX(), (int)6));
                NewProjectionDialog.this.miny.setText(Format.d((double)rect.getMinY(), (int)6));
                NewProjectionDialog.this.maxy.setText(Format.d((double)rect.getMaxY(), (int)6));
            }
        });
        this.cbProjectionType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectionManager.ProjectionClass pc = (ProjectionManager.ProjectionClass)NewProjectionDialog.this.cbProjectionType.getSelectedItem();
                NewProjectionDialog.this.projectionParamPanel1.setProjection(pc);
                pc.makeDefaultProjection();
                pc.putParamIntoDialog((Projection)pc.projInstance);
                NewProjectionDialog.this.navPanel.setProjection(pc.projInstance);
                NewProjectionDialog.this.invalidate();
                NewProjectionDialog.this.validate();
            }
        });
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectionManager.ProjectionClass pc = (ProjectionManager.ProjectionClass)NewProjectionDialog.this.cbProjectionType.getSelectedItem();
                pc.setProjFromDialog((Projection)pc.projInstance);
                System.out.printf("Projection = %s%n", pc.projInstance);
                ProjectionRect mapArea = NewProjectionDialog.this.getMapAreaFromDialog();
                if (mapArea != null) {
                    pc.projInstance.setDefaultMapArea(mapArea);
                    System.out.printf("mapArea = %s%n", mapArea.toString2());
                }
                NewProjectionDialog.this.projectionParamPanel1.setProjection(pc);
                pc.putParamIntoDialog((Projection)pc.projInstance);
                NewProjectionDialog.this.navPanel.setProjection(pc.projInstance);
                if (mapArea != null) {
                    NewProjectionDialog.this.navPanel.getNavigatedPanel().setMapArea(mapArea);
                }
                NewProjectionDialog.this.invalidate();
                NewProjectionDialog.this.validate();
            }
        });
    }

    ProjectionRect getMapAreaFromDialog() {
        try {
            double minxv = Double.parseDouble(this.minx.getText());
            double maxxv = Double.parseDouble(this.maxx.getText());
            double minyv = Double.parseDouble(this.miny.getText());
            double maxyv = Double.parseDouble(this.maxy.getText());
            return new ProjectionRect(minxv, minyv, maxxv, maxyv);
        }
        catch (Exception e) {
            System.out.printf("Illegal value %s%n", e);
            return null;
        }
    }

    private void comboBox1ItemStateChanged(ItemEvent e) {
        System.out.printf("%s%n", e);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panel1 = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.applyButton = new JButton();
        this.MapArePanel = new JPanel();
        this.maxy = new JTextField();
        this.label3 = new JLabel();
        this.minx = new JTextField();
        this.maxx = new JTextField();
        this.miny = new JTextField();
        this.label4 = new JLabel();
        this.label5 = new JLabel();
        this.label6 = new JLabel();
        this.ProjPanel = new JPanel();
        this.cbProjectionType = new ComboBox();
        this.projectionParamPanel1 = new ProjectionParamPanel();
        this.navPanel = new NPController();
        this.buttonBar = new JPanel();
        this.setTitle("Projection Manager");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.cancelButton.setText("Cancel");
        this.okButton.setText("Save");
        this.applyButton.setText("Apply");
        this.MapArePanel.setBorder(new TitledBorder(null, "Map Area", 2, 2));
        this.label3.setText("max y");
        this.label4.setText("min y");
        this.label5.setText("min x");
        this.label6.setText("max x");
        GroupLayout MapArePanelLayout = new GroupLayout(this.MapArePanel);
        this.MapArePanel.setLayout(MapArePanelLayout);
        MapArePanelLayout.setHorizontalGroup(MapArePanelLayout.createParallelGroup().addGroup(MapArePanelLayout.createSequentialGroup().addComponent(this.minx, -2, 109, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxx)).addGroup(MapArePanelLayout.createSequentialGroup().addGroup(MapArePanelLayout.createParallelGroup().addGroup(MapArePanelLayout.createSequentialGroup().addGap(84, 84, 84).addComponent(this.label3)).addGroup(MapArePanelLayout.createSequentialGroup().addGap(89, 89, 89).addComponent(this.label4))).addGap(0, 0, Short.MAX_VALUE)).addGroup(MapArePanelLayout.createSequentialGroup().addContainerGap().addGroup(MapArePanelLayout.createParallelGroup().addGroup(MapArePanelLayout.createSequentialGroup().addComponent(this.label5).addGap(18, 18, 18).addComponent(this.maxy).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.label6).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, MapArePanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.miny, -2, 121, -2).addGap(44, 44, 44)))));
        MapArePanelLayout.setVerticalGroup(MapArePanelLayout.createParallelGroup().addGroup(MapArePanelLayout.createSequentialGroup().addContainerGap().addGroup(MapArePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(MapArePanelLayout.createParallelGroup().addGroup(MapArePanelLayout.createSequentialGroup().addComponent(this.label3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxy, -2, -1, -2)).addComponent(this.label6, GroupLayout.Alignment.TRAILING)).addComponent(this.label5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(MapArePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxx, -2, -1, -2).addComponent(this.minx, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.miny, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.label4).addContainerGap(14, Short.MAX_VALUE)));
        this.ProjPanel.setBorder(new TitledBorder(null, "Projection Class", 2, 2));
        this.ProjPanel.setLayout(new BoxLayout(this.ProjPanel, 0));
        this.cbProjectionType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NewProjectionDialog.this.comboBox1ItemStateChanged(e);
            }
        });
        this.ProjPanel.add(this.cbProjectionType);
        this.projectionParamPanel1.setBorder(new TitledBorder(null, "Parameters", 2, 2));
        GroupLayout panel1Layout = new GroupLayout(this.panel1);
        this.panel1.setLayout(panel1Layout);
        panel1Layout.setHorizontalGroup(panel1Layout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, panel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.applyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(panel1Layout.createSequentialGroup().addContainerGap().addGroup(panel1Layout.createParallelGroup().addComponent(this.ProjPanel, -1, 235, Short.MAX_VALUE).addComponent(this.MapArePanel, -1, -1, Short.MAX_VALUE).addComponent(this.projectionParamPanel1, -1, 235, Short.MAX_VALUE)).addContainerGap()));
        panel1Layout.setVerticalGroup(panel1Layout.createParallelGroup().addGroup(panel1Layout.createSequentialGroup().addContainerGap().addComponent(this.ProjPanel, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.projectionParamPanel1, -2, 252, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.MapArePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 72, Short.MAX_VALUE).addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.applyButton)).addContainerGap()));
        this.contentPanel.add((Component)this.panel1, "East");
        this.navPanel.setPreferredSize(new Dimension(500, 250));
        this.contentPanel.add((Component)this.navPanel, "Center");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new FlowLayout());
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

