/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Formatter;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.ma2.Array;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ui.StructureTable;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.CompareNetcdf2;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class AggTable
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable datasetTable;
    private JSplitPane split;
    private TextHistoryPane infoTA;
    private TextHistoryPane aggTA;
    private IndependentWindow infoWindow;
    private StructureTable dataTable;
    private IndependentWindow dataWindow;
    private NetcdfDataset current;

    public AggTable(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.datasetTable = new BeanTable(DatasetBean.class, (PreferencesExt)prefs.node("DatasetBean"), false);
        this.datasetTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DatasetBean mb = (DatasetBean)AggTable.this.datasetTable.getSelectedBean();
            }
        });
        PopupMenu varPopup = new PopupMenu(this.datasetTable.getJTable(), "Options");
        varPopup.addAction("Open as NetcdfFile", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetBean dsb = (DatasetBean)AggTable.this.datasetTable.getSelectedBean();
                if (dsb == null) {
                    return;
                }
                AggTable.this.firePropertyChange("openNetcdfFile", null, dsb.acquireFile());
            }
        });
        varPopup.addAction("Check CoordSystems", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetBean dsb = (DatasetBean)AggTable.this.datasetTable.getSelectedBean();
                if (dsb == null) {
                    return;
                }
                AggTable.this.firePropertyChange("openCoordSystems", null, dsb.acquireFile());
            }
        });
        varPopup.addAction("Open as GridDataset", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetBean dsb = (DatasetBean)AggTable.this.datasetTable.getSelectedBean();
                if (dsb == null) {
                    return;
                }
                AggTable.this.firePropertyChange("openGridDataset", null, dsb.acquireFile());
            }
        });
        AbstractButton compareButton = BAMutil.makeButtcon("Select", "Check files", false);
        compareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                AggTable.this.compare(f);
                AggTable.this.checkAggCoordinate(f);
                AggTable.this.infoTA.setText(f.toString());
                AggTable.this.infoTA.gotoTop();
                AggTable.this.infoWindow.show();
            }
        });
        buttPanel.add(compareButton);
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.aggTA = new TextHistoryPane();
        this.split = new JSplitPane(0, false, this.datasetTable, this.aggTA);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.datasetTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    public void setAggDataset(NetcdfDataset ncd) throws IOException {
        this.current = ncd;
        Aggregation agg = ncd.getAggregation();
        ArrayList<DatasetBean> beanList = new ArrayList<DatasetBean>();
        for (Aggregation.Dataset dataset : agg.getDatasets()) {
            beanList.add(new DatasetBean(dataset));
        }
        this.datasetTable.setBeans(beanList);
        Formatter f = new Formatter();
        agg.getDetailInfo(f);
        this.aggTA.setText(f.toString());
    }

    private void checkAggCoordinate(Formatter f) {
        if (null == this.current) {
            return;
        }
        try {
            Aggregation agg = this.current.getAggregation();
            String aggDimName = agg.getDimensionName();
            Variable aggCoord = this.current.findVariable(aggDimName);
            Array data = aggCoord.read();
            f.format("   Aggregated coordinate variable %s%n", aggCoord);
            f.format(NCdumpW.printArray((Array)data, (String)aggDimName, null), new Object[0]);
            for (Object bean : this.datasetTable.getBeans()) {
                DatasetBean dbean = (DatasetBean)bean;
                Aggregation.Dataset ads = dbean.ds;
                NetcdfFile aggFile = ads.acquireFile(null);
                f.format("   Component file %s%n", aggFile.getLocation());
                Variable aggCoordp = aggFile.findVariable(aggDimName);
                if (aggCoordp == null) {
                    f.format("   doesnt have coordinate variable%n", new Object[0]);
                    continue;
                }
                data = aggCoordp.read();
                f.format(NCdumpW.printArray((Array)data, (String)(aggCoordp.getNameAndDimensions() + " (" + aggCoordp.getUnitsString() + ")"), null), new Object[0]);
            }
        }
        catch (Throwable t) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            t.printStackTrace(new PrintStream(bos));
            f.format(bos.toString(), new Object[0]);
        }
    }

    private void compare(Formatter f) {
        try {
            NetcdfFile org = null;
            for (Object bean : this.datasetTable.getBeans()) {
                DatasetBean dbean = (DatasetBean)bean;
                Aggregation.Dataset ads = dbean.ds;
                NetcdfFile ncd = ads.acquireFile(null);
                if (org == null) {
                    org = ncd;
                    continue;
                }
                CompareNetcdf2 cn = new CompareNetcdf2(f, false, false, false);
                cn.compareVariables(org, ncd);
                ncd.close();
                f.format("--------------------------------%n", new Object[0]);
            }
            if (org != null) {
                org.close();
            }
        }
        catch (Throwable t) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            t.printStackTrace(new PrintStream(bos));
            f.format(bos.toString(), new Object[0]);
        }
    }

    public class DatasetBean {
        Aggregation.Dataset ds;

        protected NetcdfFile acquireFile() {
            try {
                return this.ds.acquireFile(null);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public DatasetBean() {
        }

        public DatasetBean(Aggregation.Dataset ds) {
            this.ds = ds;
        }

        public String getLocation() throws IOException {
            return this.ds.getLocation();
        }

        public String getCacheLocation() {
            return this.ds.getCacheLocation();
        }

        public String getId() {
            return this.ds.getId();
        }
    }
}

