/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public abstract class ReportPanel
extends JPanel {
    protected PreferencesExt prefs;
    protected TextHistoryPane reportPane;

    protected ReportPanel(PreferencesExt prefs) {
        this.prefs = prefs;
        this.reportPane = new TextHistoryPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.reportPane, "Center");
    }

    protected void addOptions(JPanel buttPanel) {
    }

    public void save() {
    }

    public abstract Object[] getOptions();

    public void doReport(String spec, boolean useIndex, boolean eachFile, boolean extra, Object option) throws IOException {
        Formatter f = new Formatter();
        f.format("%s on %s useIndex=%s eachFile=%s extra=%s%n", option, spec, useIndex, eachFile, extra);
        try (MCollection dcm = this.getCollection(spec, f);){
            if (dcm == null) {
                return;
            }
            f.format("top dir = %s%n", dcm.getRoot());
            this.reportPane.setText(f.toString());
            File top = new File(dcm.getRoot());
            if (!top.exists()) {
                f.format("top dir = %s does not exist%n", dcm.getRoot());
            } else {
                this.doReport(f, option, dcm, useIndex, eachFile, extra);
            }
            this.reportPane.setText(f.toString());
            this.reportPane.gotoTop();
        }
        catch (IOException ioe) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(50000);
            ioe.printStackTrace(new PrintStream(bos));
            f.format(bos.toString(), new Object[0]);
            ioe.printStackTrace();
        }
    }

    protected abstract void doReport(Formatter var1, Object var2, MCollection var3, boolean var4, boolean var5, boolean var6) throws IOException;

    protected boolean showCollection(String spec) {
        Formatter f = new Formatter();
        f.format("collection = %s%n", spec);
        boolean hasFiles = false;
        try (MCollection dcm = this.getCollection(spec, f);){
            if (dcm == null) {
                boolean bl = false;
                return bl;
            }
            try {
                for (MFile mfile : dcm.getFilesSorted()) {
                    f.format(" %s%n", mfile.getPath());
                    hasFiles = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.reportPane.setText(f.toString());
            this.reportPane.gotoTop();
            boolean bl = hasFiles;
            return bl;
        }
    }

    MCollection getCollection(String spec, Formatter f) {
        try {
            return CollectionAbstract.open((String)spec, (String)spec, null, (Formatter)f);
        }
        catch (Exception e) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            e.printStackTrace(new PrintStream(bos));
            this.reportPane.setText(bos.toString());
            return null;
        }
    }

    protected class CounterS {
        Map<String, Integer> set = new HashMap<String, Integer>();
        String name;

        CounterS(String name) {
            this.name = name;
        }

        void count(String value) {
            Integer count = this.set.get(value);
            if (count == null) {
                this.set.put(value, 1);
            } else {
                this.set.put(value, count + 1);
            }
        }

        void show(Formatter f) {
            f.format("%n%s%n", this.name);
            ArrayList<String> list = new ArrayList<String>(this.set.keySet());
            Collections.sort(list);
            for (String key : list) {
                int count = this.set.get(key);
                f.format("   %10s: count = %d%n", key, count);
            }
        }
    }

    protected class Counter {
        Map<Integer, Integer> set = new HashMap<Integer, Integer>();
        String name;

        Counter(String name) {
            this.name = name;
        }

        void reset() {
            this.set = new HashMap<Integer, Integer>();
        }

        void count(int value) {
            Integer count = this.set.get(value);
            if (count == null) {
                this.set.put(value, 1);
            } else {
                this.set.put(value, count + 1);
            }
        }

        void add(Counter sub) {
            for (int key : sub.set.keySet()) {
                Integer value = sub.set.get(key);
                Integer count = this.set.get(key);
                if (count == null) {
                    count = 0;
                }
                this.set.put(key, count + value);
            }
        }

        void show(Formatter f) {
            f.format("%n%s%n", this.name);
            ArrayList<Integer> list = new ArrayList<Integer>(this.set.keySet());
            Collections.sort(list);
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                int template = (Integer)i$.next();
                int count = this.set.get(template);
                f.format("   %3d: count = %d%n", template, count);
            }
        }
    }
}

