/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.NCdumpW;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dt.PointObsDatatype;
import ucar.nc2.dt.TrajectoryObsDatatype;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ui.table.ColumnWidthsResizer;
import ucar.nc2.ui.table.HidableTableColumnModel;
import ucar.nc2.ui.table.TableAligner;
import ucar.nc2.ui.table.TableAppearanceAction;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.HashMapLRU;
import ucar.nc2.util.Indent;
import ucar.util.prefs.PreferencesExt;

public class StructureTable
extends JPanel {
    private PreferencesExt prefs;
    private StructureTableModel dataModel;
    private JTable jtable;
    private PopupMenu popup;
    private FileManager fileChooser;
    private TextHistoryPane dumpTA;
    private IndependentWindow dumpWindow;
    private EventListenerList listeners = new EventListenerList();
    private static HashMap<String, IndependentWindow> windows = new HashMap();

    public StructureTable(PreferencesExt prefs) {
        this.prefs = prefs;
        this.jtable = new JTable();
        this.setLayout(new BorderLayout());
        this.jtable.setAutoResizeMode(0);
        ToolTipManager.sharedInstance().registerComponent(this.jtable);
        this.add((Component)new JScrollPane(this.jtable), "Center");
        this.dumpTA = new TextHistoryPane(false);
        this.dumpWindow = new IndependentWindow("Show Data", BAMutil.getImage("netcdfUI"), this.dumpTA);
        if (prefs != null) {
            this.dumpWindow.setBounds((Rectangle)prefs.getBean("DumpWindowBounds", new Rectangle(300, 300, 600, 600)));
        } else {
            this.dumpWindow.setBounds(new Rectangle(300, 300, 600, 600));
        }
        PreferencesExt fcPrefs = prefs == null ? null : (PreferencesExt)prefs.node("FileManager");
        this.fileChooser = new FileManager(null, null, "csv", "comma seperated values", fcPrefs);
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.listeners.add(ListSelectionListener.class, l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.listeners.remove(ListSelectionListener.class, l);
    }

    private void fireEvent(ListSelectionEvent event) {
        Object[] llist = this.listeners.getListenerList();
        for (int i = llist.length - 2; i >= 0; i -= 2) {
            ((ListSelectionListener)llist[i + 1]).valueChanged(event);
        }
    }

    public void addActionToPopupMenu(String title, AbstractAction act) {
        if (this.popup == null) {
            this.popup = new PopupMenu(this.jtable, "Options");
        }
        this.popup.addAction(title, act);
    }

    public void clear() {
        if (this.dataModel != null) {
            this.dataModel.clear();
        }
    }

    public void saveState() {
        this.fileChooser.save();
        if (this.prefs != null) {
            this.prefs.getBean("DumpWindowBounds", this.dumpWindow.getBounds());
        }
    }

    public void setStructure(Structure s) throws IOException {
        this.dataModel = s.getDataType() == DataType.SEQUENCE ? new SequenceModel(s, true) : new StructureModel(s);
        this.initTable(this.dataModel);
    }

    public void setStructureData(List<StructureData> structureData) throws IOException {
        this.dataModel = new StructureDataModel(structureData);
        this.initTable(this.dataModel);
    }

    public void setStructureData(ArrayStructure as) {
        this.dataModel = new ArrayStructureModel(as);
        this.initTable(this.dataModel);
    }

    public void setSequenceData(Structure s, ArraySequence seq) {
        this.dataModel = new ArraySequenceModel(s, seq);
        this.initTable(this.dataModel);
    }

    public void setTrajectory(TrajectoryObsDatatype traj) throws IOException {
        this.dataModel = new TrajectoryModel(traj);
        this.initTable(this.dataModel);
    }

    public void setPointObsData(List<PointObsDatatype> obsData) throws IOException {
        this.dataModel = new PointObsDataModel(obsData);
        this.initTable(this.dataModel);
    }

    public void setPointFeatureData(List<PointFeature> obsData) throws IOException {
        this.dataModel = new PointFeatureDataModel(obsData);
        this.initTable(this.dataModel);
    }

    private void initTable(StructureTableModel m) {
        HidableTableColumnModel tcm = new HidableTableColumnModel(m);
        this.jtable = new JTable(m, tcm);
        this.jtable.setAutoCreateRowSorter(true);
        ((JComponent)((Object)this.jtable.getDefaultRenderer(Boolean.class))).setOpaque(true);
        ColumnWidthsResizer resizer = new ColumnWidthsResizer(this.jtable);
        this.jtable.getModel().addTableModelListener(resizer);
        this.jtable.getColumnModel().addColumnModelListener(resizer);
        TableAligner aligner = new TableAligner(this.jtable, 10);
        this.jtable.getColumnModel().addColumnModelListener(aligner);
        this.jtable.setAutoResizeMode(0);
        ListSelectionModel rowSM = this.jtable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    StructureTable.this.fireEvent(e);
                }
            }
        });
        if (m.wantDate) {
            this.jtable.getColumnModel().getColumn(0).setCellRenderer(new DateRenderer());
            this.jtable.getColumnModel().getColumn(1).setCellRenderer(new DateRenderer());
        }
        this.popup = null;
        this.addActionToPopupMenu("Show", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StructureTable.this.showData();
            }
        });
        this.addActionToPopupMenu("Export", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StructureTable.this.export();
            }
        });
        this.addActionToPopupMenu("Show Internal", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StructureTable.this.showDataInternal();
            }
        });
        for (Structure s : m.subtables) {
            this.addActionToPopupMenu("Data Table for " + s.getShortName(), new SubtableAbstractAction(s));
        }
        this.removeAll();
        JButton cornerButton = new JButton(new TableAppearanceAction(this.jtable));
        cornerButton.setHideActionText(true);
        cornerButton.setContentAreaFilled(false);
        JScrollPane scrollPane = new JScrollPane(this.jtable);
        scrollPane.setCorner("UPPER_RIGHT_CORNER", cornerButton);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.add((Component)scrollPane, "Center");
        this.revalidate();
    }

    private void export() {
        String filename = this.fileChooser.chooseFilename();
        if (filename == null) {
            return;
        }
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(new File(filename)));
            TableModel model = this.jtable.getModel();
            for (int col = 0; col < model.getColumnCount(); ++col) {
                if (col > 0) {
                    ps.print(",");
                }
                ps.print(model.getColumnName(col));
            }
            ps.println();
            for (int row = 0; row < model.getRowCount(); ++row) {
                for (int col = 0; col < model.getColumnCount(); ++col) {
                    if (col > 0) {
                        ps.print(",");
                    }
                    ps.print(model.getValueAt(row, col).toString());
                }
                ps.println();
            }
            ps.close();
            JOptionPane.showMessageDialog(this, "File successfully written");
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    private void showData() {
        StructureData sd = this.getSelectedStructureData();
        if (sd == null) {
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
        try {
            NCdumpW.printStructureData((PrintWriter)new PrintWriter(bos), (StructureData)sd);
        }
        catch (IOException e) {
            String mess = e.getMessage();
            bos.write(mess.getBytes(), 0, mess.length());
        }
        this.dumpTA.setText(bos.toString());
        this.dumpWindow.setVisible(true);
    }

    private void showDataInternal() {
        StructureData sd = this.getSelectedStructureData();
        if (sd == null) {
            return;
        }
        Formatter f = new Formatter();
        sd.showInternalMembers(f, new Indent(2));
        f.format("%n", new Object[0]);
        sd.showInternal(f, new Indent(2));
        this.dumpTA.setText(f.toString());
        this.dumpWindow.setVisible(true);
    }

    private StructureData getSelectedStructureData() {
        int viewRowIdx = this.jtable.getSelectedRow();
        if (viewRowIdx < 0) {
            return null;
        }
        int modelRowIndex = this.jtable.convertRowIndexToModel(viewRowIdx);
        try {
            return this.dataModel.getStructureData(modelRowIndex);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "ERROR: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public Object getSelectedRow() {
        int viewRowIdx = this.jtable.getSelectedRow();
        if (viewRowIdx < 0) {
            return null;
        }
        int modelRowIndex = this.jtable.convertRowIndexToModel(viewRowIdx);
        try {
            return this.dataModel.getRow(modelRowIndex);
        }
        catch (InvalidRangeException e) {
            JOptionPane.showMessageDialog(this, "ERROR: " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "ERROR: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    static class DateRenderer
    extends DefaultTableCellRenderer {
        private SimpleDateFormat newForm;
        private SimpleDateFormat oldForm = new SimpleDateFormat("yyyy MMM dd HH:mm z");
        private Date cutoff;

        DateRenderer() {
            this.oldForm.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.newForm = new SimpleDateFormat("MMM dd, HH:mm z");
            this.newForm.setTimeZone(TimeZone.getTimeZone("GMT"));
            Calendar cal = Calendar.getInstance();
            cal.setTimeZone(TimeZone.getTimeZone("GMT"));
            cal.add(1, -1);
            this.cutoff = cal.getTime();
        }

        @Override
        public void setValue(Object value) {
            if (value == null) {
                this.setText("");
            } else {
                Date date = (Date)value;
                if (date.before(this.cutoff)) {
                    this.setText(this.oldForm.format(date));
                } else {
                    this.setText(this.newForm.format(date));
                }
            }
        }
    }

    private class PointFeatureDataModel
    extends StructureTableModel {
        private List<PointFeature> obsData;

        PointFeatureDataModel(List<PointFeature> obsData) throws IOException {
            this.wantDate = true;
            this.obsData = obsData;
            if (obsData.size() > 0) {
                StructureData sd;
                try {
                    sd = this.getStructureData(0);
                }
                catch (InvalidRangeException e) {
                    JOptionPane.showMessageDialog(null, "ERROR: " + e.getMessage());
                    throw new IOException(e.getMessage());
                }
                this.members = sd.getStructureMembers();
            }
        }

        @Override
        public Date getObsDate(int row) {
            PointFeature obs = this.obsData.get(row);
            return obs.getObservationTimeAsDate();
        }

        @Override
        public Date getNomDate(int row) {
            PointFeature obs = this.obsData.get(row);
            return obs.getNominalTimeAsDate();
        }

        @Override
        public int getRowCount() {
            return this.obsData.size();
        }

        @Override
        public StructureData getStructureData(int row) throws InvalidRangeException, IOException {
            PointFeature obs = this.obsData.get(row);
            return obs.getData();
        }

        @Override
        public Object getRow(int row) throws InvalidRangeException, IOException {
            return this.obsData.get(row);
        }

        @Override
        public void clear() {
            this.obsData = new ArrayList<PointFeature>();
            this.fireTableDataChanged();
        }
    }

    private class PointObsDataModel
    extends StructureTableModel {
        private List<PointObsDatatype> obsData;

        PointObsDataModel(List<PointObsDatatype> obsData) throws IOException {
            this.wantDate = true;
            this.obsData = obsData;
            if (obsData.size() > 0) {
                StructureData sd;
                try {
                    sd = this.getStructureData(0);
                }
                catch (InvalidRangeException e) {
                    JOptionPane.showMessageDialog(null, "ERROR: " + e.getMessage());
                    throw new IOException(e.getMessage());
                }
                this.members = sd.getStructureMembers();
            }
        }

        @Override
        public Date getObsDate(int row) {
            PointObsDatatype obs = this.obsData.get(row);
            return obs.getObservationTimeAsDate();
        }

        @Override
        public Date getNomDate(int row) {
            PointObsDatatype obs = this.obsData.get(row);
            return obs.getNominalTimeAsDate();
        }

        @Override
        public int getRowCount() {
            return this.obsData.size();
        }

        @Override
        public StructureData getStructureData(int row) throws InvalidRangeException, IOException {
            PointObsDatatype obs = this.obsData.get(row);
            return obs.getData();
        }

        @Override
        public Object getRow(int row) throws InvalidRangeException, IOException {
            return this.obsData.get(row);
        }

        @Override
        public void clear() {
            this.obsData = new ArrayList<PointObsDatatype>();
            this.fireTableDataChanged();
        }
    }

    private class TrajectoryModel
    extends StructureTableModel {
        private TrajectoryObsDatatype traj;

        TrajectoryModel(TrajectoryObsDatatype traj) throws IOException {
            this.traj = traj;
            if (traj.getNumberPoints() > 0) {
                try {
                    StructureData sd = traj.getData(0);
                    this.members = sd.getStructureMembers();
                }
                catch (InvalidRangeException e) {
                    JOptionPane.showMessageDialog(null, "ERROR: " + e.getMessage());
                    throw new IOException(e.getMessage());
                }
            }
            this.wantDate = true;
        }

        @Override
        public Date getObsDate(int row) {
            try {
                return this.traj.getTime(row);
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public Date getNomDate(int row) {
            return null;
        }

        public Date getDate(int row) {
            try {
                return this.traj.getTime(row);
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public int getRowCount() {
            return this.traj == null ? 0 : this.traj.getNumberPoints();
        }

        @Override
        public Object getRow(int row) throws InvalidRangeException, IOException {
            return this.traj.getPointObsData(row);
        }

        @Override
        public StructureData getStructureData(int row) throws InvalidRangeException, IOException {
            return this.traj.getData(row);
        }

        @Override
        public void clear() {
            this.traj = null;
            this.fireTableDataChanged();
        }
    }

    private class ArrayStructureModel
    extends StructureTableModel {
        private ArrayStructure as;

        ArrayStructureModel(ArrayStructure as) {
            this.as = as;
            this.members = as.getStructureMembers();
        }

        @Override
        public Date getObsDate(int row) {
            return null;
        }

        @Override
        public Date getNomDate(int row) {
            return null;
        }

        @Override
        public int getRowCount() {
            return this.as == null ? 0 : (int)this.as.getSize();
        }

        @Override
        public StructureData getStructureData(int row) throws InvalidRangeException, IOException {
            return this.as.getStructureData(row);
        }

        @Override
        public void clear() {
            this.as = null;
            this.fireTableDataChanged();
        }
    }

    private class StructureDataModel
    extends StructureTableModel {
        private List<StructureData> structureData;

        StructureDataModel(List<StructureData> structureData) {
            this.structureData = structureData;
            if (structureData.size() > 0) {
                StructureData sd = structureData.get(0);
                this.members = sd.getStructureMembers();
            }
        }

        @Override
        public Date getObsDate(int row) {
            return null;
        }

        @Override
        public Date getNomDate(int row) {
            return null;
        }

        @Override
        public int getRowCount() {
            return this.structureData.size();
        }

        @Override
        public StructureData getStructureData(int row) throws InvalidRangeException, IOException {
            return this.structureData.get(row);
        }

        @Override
        public void clear() {
            this.structureData = new ArrayList<StructureData>();
            this.fireTableDataChanged();
        }
    }

    private class ArraySequenceModel
    extends SequenceModel {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ArraySequenceModel(Structure s, ArraySequence seq) {
            super(s, false);
            this.members = seq.getStructureMembers();
            this.sdataList = new ArrayList();
            try {
                StructureDataIterator iter = seq.getStructureDataIterator();
                try {
                    while (iter.hasNext()) {
                        this.sdataList.add(iter.next());
                    }
                }
                finally {
                    iter.finish();
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "ERROR: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private class SequenceModel
    extends StructureModel {
        protected List<StructureData> sdataList;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SequenceModel(Structure seq, boolean readData) {
            super(seq);
            if (readData) {
                this.sdataList = new ArrayList<StructureData>();
                try {
                    StructureDataIterator iter = seq.getStructureIterator();
                    try {
                        while (iter.hasNext()) {
                            this.sdataList.add(iter.next());
                        }
                    }
                    finally {
                        iter.finish();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public Date getObsDate(int row) {
            return null;
        }

        @Override
        public Date getNomDate(int row) {
            return null;
        }

        @Override
        public int getRowCount() {
            return this.sdataList.size();
        }

        @Override
        public StructureData getStructureData(int row) throws InvalidRangeException, IOException {
            return this.sdataList.get(row);
        }

        @Override
        public Object getValueAt(int row, int column) {
            StructureData sd = this.sdataList.get(row);
            return sd.getScalarObject(sd.getStructureMembers().getMember(column));
        }

        @Override
        public void clear() {
            this.sdataList = new ArrayList<StructureData>();
            this.fireTableDataChanged();
        }
    }

    private class StructureModel
    extends StructureTableModel {
        private Structure struct;

        StructureModel(Structure s) {
            this.struct = s;
            this.members = s.makeStructureMembers();
            for (Variable v : s.getVariables()) {
                if (!(v instanceof Structure)) continue;
                this.subtables.add((Structure)v);
            }
        }

        @Override
        public Date getObsDate(int row) {
            return null;
        }

        @Override
        public Date getNomDate(int row) {
            return null;
        }

        @Override
        public int getRowCount() {
            if (this.struct == null) {
                return 0;
            }
            return (int)this.struct.getSize();
        }

        @Override
        public StructureData getStructureData(int row) throws InvalidRangeException, IOException {
            return this.struct.readStructure(row);
        }

        @Override
        public void clear() {
            this.struct = null;
            this.fireTableDataChanged();
        }

        @Override
        String enumLookup(StructureMembers.Member m, Number val) {
            Variable v = this.struct.findVariable(m.getName());
            return v.lookupEnumString(val.intValue());
        }
    }

    private abstract class StructureTableModel
    extends AbstractTableModel {
        protected HashMapLRU rowHash = new HashMapLRU(500, 500);
        protected StructureMembers members;
        protected boolean wantDate = false;
        protected List<Structure> subtables = new ArrayList<Structure>();

        private StructureTableModel() {
        }

        public abstract StructureData getStructureData(int var1) throws InvalidRangeException, IOException;

        public abstract void clear();

        public abstract Date getObsDate(int var1);

        public abstract Date getNomDate(int var1);

        public Object getRow(int row) throws InvalidRangeException, IOException {
            return this.getStructureData(row);
        }

        @Override
        public int getColumnCount() {
            if (this.members == null) {
                return 0;
            }
            return this.members.getMembers().size() + (this.wantDate ? 2 : 0);
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (this.wantDate && columnIndex == 0) {
                return "obsDate";
            }
            if (this.wantDate && columnIndex == 1) {
                return "nomDate";
            }
            int memberCol = this.wantDate ? columnIndex - 2 : columnIndex;
            return this.members.getMember(memberCol).getName();
        }

        public StructureData getStructureDataHash(int row) throws InvalidRangeException, IOException {
            StructureData sd = (StructureData)this.rowHash.get((Object)row);
            if (sd == null) {
                sd = this.getStructureData(row);
                this.rowHash.put((Object)row, (Object)sd);
            }
            return sd;
        }

        @Override
        public Object getValueAt(int row, int column) {
            StructureData sd;
            if (this.wantDate && column == 0) {
                return this.getObsDate(row);
            }
            if (this.wantDate && column == 1) {
                return this.getNomDate(row);
            }
            try {
                sd = this.getStructureDataHash(row);
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                return "ERROR " + e.getMessage();
            }
            catch (IOException e) {
                e.printStackTrace();
                return "ERROR " + e.getMessage();
            }
            String colName = this.getColumnName(column);
            return sd.getScalarObject(colName);
        }

        String enumLookup(StructureMembers.Member m, Number val) {
            return "sorry";
        }
    }

    private class SubtableAbstractAction
    extends AbstractAction {
        Structure s;
        StructureTable dataTable;
        IndependentWindow dataWindow;

        SubtableAbstractAction(Structure s) {
            this.s = s;
            this.dataTable = new StructureTable(null);
            this.dataWindow = (IndependentWindow)windows.get(s.getFullName());
            if (this.dataWindow == null) {
                this.dataWindow = new IndependentWindow("Data Table", BAMutil.getImage("netcdfUI"), this.dataTable);
                windows.put(s.getFullName(), this.dataWindow);
            } else {
                this.dataWindow.setComponent(this.dataTable);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StructureData sd = StructureTable.this.getSelectedStructureData();
            if (sd == null) {
                return;
            }
            StructureMembers.Member m = sd.findMember(this.s.getShortName());
            if (m == null) {
                throw new IllegalStateException("cant find member = " + this.s.getShortName());
            }
            if (m.getDataType() == DataType.STRUCTURE) {
                ArrayStructure as = sd.getArrayStructure(m);
                this.dataTable.setStructureData(as);
            } else if (m.getDataType() == DataType.SEQUENCE) {
                ArraySequence seq = sd.getArraySequence(m);
                this.dataTable.setSequenceData(this.s, seq);
            } else {
                throw new IllegalStateException("data type = " + m.getDataType());
            }
            this.dataWindow.show();
        }
    }
}

