/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.table;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.RandomStringUtils;
import ucar.nc2.ui.table.ColumnWidthsResizer;
import ucar.nc2.ui.table.HidableTableColumnModel;
import ucar.nc2.ui.table.TableAligner;
import ucar.nc2.ui.table.TableAppearanceAction;

public abstract class TableDemo {
    private static final int numRows = 5;
    private static final int numCols = 5;

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultTableModel model = TableDemo.createTableModel(5, 5);
                HidableTableColumnModel tcm = new HidableTableColumnModel(model);
                JTable table = new JTable(model, tcm);
                table.setAutoCreateRowSorter(true);
                ColumnWidthsResizer resizer = new ColumnWidthsResizer(table);
                table.getModel().addTableModelListener(resizer);
                table.getColumnModel().addColumnModelListener(resizer);
                TableAligner aligner = new TableAligner(table, 10);
                table.getColumnModel().addColumnModelListener(aligner);
                JButton removeColumnButton = new JButton(new RemoveColumnAction(table));
                JButton removeRowButton = new JButton(new RemoveRowAction(table));
                JButton addColumnButton = new JButton(new AddColumnAction(table));
                JButton addRowButton = new JButton(new AddRowAction(table));
                JButton resetButton = new JButton(new ResetAction(table));
                JPanel buttonPanel = new JPanel();
                buttonPanel.add(removeRowButton);
                buttonPanel.add(removeColumnButton);
                buttonPanel.add(resetButton);
                buttonPanel.add(addColumnButton);
                buttonPanel.add(addRowButton);
                JButton cornerButton = new JButton(new TableAppearanceAction(table));
                cornerButton.setHideActionText(true);
                cornerButton.setContentAreaFilled(false);
                JScrollPane scrollPane = new JScrollPane(table);
                scrollPane.setCorner("UPPER_RIGHT_CORNER", cornerButton);
                scrollPane.setVerticalScrollBarPolicy(22);
                JFrame frame = new JFrame("Test ResizeColumnWidthsListener");
                frame.add((Component)scrollPane, "Center");
                frame.add((Component)buttonPanel, "South");
                frame.setDefaultCloseOperation(3);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    private static DefaultTableModel createTableModel(int numRows, int numCols) {
        DefaultTableModel model = new DefaultTableModel(numRows, 0);
        for (int col = 0; col < numCols; ++col) {
            String columnName = Integer.toString(model.getColumnCount());
            Object[] columnData = TableDemo.genColumnData(model);
            model.addColumn((Object)columnName, columnData);
        }
        return model;
    }

    private static Object[] genColumnData(TableModel model) {
        Object[] data = new Object[model.getRowCount()];
        int cellValLen = (model.getColumnCount() + 1) * 5;
        for (int row = 0; row < model.getRowCount(); ++row) {
            data[row] = RandomStringUtils.randomAlphabetic((int)cellValLen);
        }
        return data;
    }

    private TableDemo() {
    }

    public static class AddRowAction
    extends AbstractAction {
        private final JTable table;

        public AddRowAction(JTable table) {
            super("+Row");
            this.table = table;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultTableModel model = (DefaultTableModel)this.table.getModel();
            Object[] rowData = new Object[model.getColumnCount()];
            int shift = 1;
            for (int iCol = 0; iCol < model.getColumnCount(); ++iCol) {
                rowData[iCol] = model.getValueAt(model.getRowCount() - 1, (iCol + shift) % model.getColumnCount());
            }
            model.insertRow(model.getRowCount(), rowData);
        }
    }

    public static class AddColumnAction
    extends AbstractAction {
        private final JTable table;

        public AddColumnAction(JTable table) {
            super("+Col");
            this.table = table;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultTableModel model = (DefaultTableModel)this.table.getModel();
            String columnName = Integer.toString(model.getColumnCount());
            Object[] columnData = TableDemo.genColumnData(model);
            model.addColumn((Object)columnName, columnData);
        }
    }

    public static class ResetAction
    extends AbstractAction {
        private final JTable table;

        public ResetAction(JTable table) {
            super("Reset");
            this.table = table;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultTableModel model = TableDemo.createTableModel(5, 5);
            HidableTableColumnModel tcm = new HidableTableColumnModel(model);
            this.table.setModel(model);
            this.table.setColumnModel(tcm);
            ColumnWidthsResizer resizer = new ColumnWidthsResizer(this.table);
            this.table.getModel().addTableModelListener(resizer);
            this.table.getColumnModel().addColumnModelListener(resizer);
            TableAligner aligner = new TableAligner(this.table, 10);
            this.table.getColumnModel().addColumnModelListener(aligner);
        }
    }

    public static class RemoveColumnAction
    extends AbstractAction {
        private final JTable table;

        public RemoveColumnAction(JTable table) {
            super("-Col");
            this.table = table;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultTableModel model = (DefaultTableModel)this.table.getModel();
            if (model.getColumnCount() > 0) {
                model.setColumnCount(model.getColumnCount() - 1);
            }
        }
    }

    public static class RemoveRowAction
    extends AbstractAction {
        private final JTable table;

        public RemoveRowAction(JTable table) {
            super("-Row");
            this.table = table;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultTableModel model = (DefaultTableModel)this.table.getModel();
            if (model.getRowCount() > 0) {
                model.setRowCount(model.getRowCount() - 1);
            }
        }
    }
}

