/*
 * Decompiled with CFR 0.152.
 */
package thredds.logs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import thredds.logs.AccessLogParser;
import ucar.unidata.util.StringUtil2;

public class LogReader {
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private int maxLines = -1;
    private LogParser parser;

    public LogReader(LogParser parser) {
        this.parser = parser;
    }

    public void readAll(File dir, FileFilter ff, Closure closure, LogFilter logf, Stats stat) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            System.out.printf("Dir has no files= %s%n", dir);
            return;
        }
        List<File> list = Arrays.asList(files);
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            File f = list.get(i);
            if (ff != null && !ff.accept(f)) continue;
            if (f.isDirectory()) {
                this.readAll(f, ff, closure, logf, stat);
                continue;
            }
            this.scanLogFile(f, closure, logf, stat);
        }
    }

    public void scanLogFile(File file, Closure closure, LogFilter logf, Stats stat) throws IOException {
        try (FileInputStream ios = new FileInputStream(file);){
            Log log;
            System.out.printf("-----Reading %s %n", file.getPath());
            BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios), 40000);
            int total = 0;
            int count = 0;
            while ((this.maxLines < 0 || count < this.maxLines) && (log = this.parser.nextLog(dataIS)) != null) {
                ++total;
                if (logf != null && !logf.pass(log)) continue;
                closure.process(log);
                ++count;
            }
            if (stat != null) {
                stat.total += (long)total;
                stat.passed += (long)count;
            }
            System.out.printf("----- %s total requests=%d passed=%d %n", file.getPath(), total, count);
        }
    }

    public static void main(String[] args) throws IOException {
        LogReader reader = new LogReader(new AccessLogParser());
        long startElapsed = System.nanoTime();
        Stats stats = new Stats();
        reader.readAll(new File("d:/mlode/logs/all/"), new MyFF(), new Closure(){
            long count = 0L;

            @Override
            public void process(Log log) throws IOException {
                if (this.count % 1000L == 0L) {
                    System.out.printf("%s %s %s%n", log.path, log.client, log.ip);
                }
                ++this.count;
            }
        }, new MyFilter(), stats);
        long elapsedTime = System.nanoTime() - startElapsed;
        System.out.printf(" total= %d passed=%d%n", stats.total, stats.passed);
        System.out.printf(" elapsed=%d secs%n", elapsedTime / 1000000000L);
    }

    static class MyFF
    implements FileFilter {
        MyFF() {
        }

        @Override
        public boolean accept(File f) {
            return f.getPath().endsWith(".log");
        }
    }

    static class MyFilter
    implements LogFilter {
        MyFilter() {
        }

        @Override
        public boolean pass(Log log) {
            return log.path.startsWith("/thredds/catalog/");
        }
    }

    public static class FilterNoop
    implements LogFilter {
        @Override
        public boolean pass(Log log) {
            return true;
        }
    }

    public static class ErrorOnlyFilter
    implements LogFilter {
        LogFilter chain;

        public ErrorOnlyFilter(LogFilter chain) {
            this.chain = chain;
        }

        @Override
        public boolean pass(Log log) {
            if (this.chain != null && !this.chain.pass(log)) {
                return false;
            }
            int status = log.getStatus();
            return status >= 400 && status < 1000;
        }
    }

    public static class IpFilter
    implements LogFilter {
        String[] match;
        LogFilter chain;

        public IpFilter(String[] match, LogFilter chain) {
            this.match = match;
            this.chain = chain;
        }

        @Override
        public boolean pass(Log log) {
            if (this.chain != null && !this.chain.pass(log)) {
                return false;
            }
            for (String s : this.match) {
                if (!log.getIp().startsWith(s)) continue;
                return false;
            }
            return true;
        }
    }

    public static class DateFilter
    implements LogFilter {
        long start;
        long end;
        LogFilter chain;

        public DateFilter(long start, long end, LogFilter chain) {
            this.start = start;
            this.end = end;
            this.chain = chain;
        }

        @Override
        public boolean pass(Log log) {
            if (this.chain != null && !this.chain.pass(log)) {
                return false;
            }
            return log.date >= this.start && log.date <= this.end;
        }
    }

    public static interface LogFilter {
        public boolean pass(Log var1);
    }

    public static class Stats {
        public long total;
        public long passed;
    }

    public static interface Closure {
        public void process(Log var1) throws IOException;
    }

    public static class Log {
        public long date;
        String verb;
        String referrer;
        String client;
        int returnCode;
        long msecs;
        long sizeBytes;
        String ip;
        String path;
        String http;

        public String getIp() {
            return this.ip;
        }

        public long getDateMillisec() {
            return this.date;
        }

        public String getDate() {
            return df.format(new Date(this.date));
        }

        public String getReferrer() {
            return this.referrer;
        }

        public String getClient() {
            return this.client;
        }

        public int getStatus() {
            return this.returnCode;
        }

        public long getMsecs() {
            return this.msecs;
        }

        public long getBytes() {
            return this.sizeBytes;
        }

        public String getPath() {
            return this.path == null ? null : StringUtil2.unescape((String)this.path);
        }

        public String toCSV() {
            return this.ip + "," + this.getDate() + "," + this.verb + ",\"" + this.getPath() + "\"," + this.returnCode + "," + this.sizeBytes + ",\"" + this.referrer + "\",\"" + this.client + "\"," + this.msecs;
        }

        public String toString() {
            return this.ip + " [" + this.getDate() + "] " + this.verb + " " + this.getPath() + " " + this.http + " " + this.returnCode + " " + this.sizeBytes + " " + this.referrer + " " + this.client + " " + this.msecs;
        }

        public void toString(Formatter f) {
            f.format("path = %s%n", this.path);
            int pos = this.path.indexOf(63);
            if (pos > 0) {
                f.format("  path = %s%n", this.path.substring(0, pos));
                f.format("  query = %s%n", this.path.substring(pos + 1));
            }
            f.format("%n", new Object[0]);
            f.format("date = %s%n", this.getDate());
            f.format("verb = %s%n", this.verb);
            f.format("status = %d%n", this.returnCode);
            f.format("took = %d msecs%n", this.msecs);
            f.format("size = %d bytes%n", this.sizeBytes);
            f.format("from address = %s%n", this.ip);
            f.format("client = %s%n", this.client);
            f.format("referrer = %s%n", this.referrer);
        }
    }

    public static interface LogParser {
        public Log nextLog(BufferedReader var1) throws IOException;
    }
}

