/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.util;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import javax.swing.ImageIcon;

public class Resource {
    static Class cl = new Resource().getClass();
    private static boolean debug = false;
    private static boolean debugIcon = false;

    public static ImageIcon getIcon(String fullIconName, boolean errMsg) {
        ImageIcon icon = null;
        URL iconR = cl.getResource(fullIconName);
        if (debugIcon) {
            System.out.println("classLoader " + cl.getClassLoader());
            System.out.println("  Resource.getIcon on " + fullIconName + " = " + iconR);
        }
        if (iconR != null) {
            icon = new ImageIcon(iconR);
        }
        if (icon == null && errMsg) {
            System.out.println("  ERROR: Resource.getIcon failed on " + fullIconName);
        } else if (debugIcon) {
            System.out.println("  Resource.getIcon ok on " + fullIconName);
        }
        return icon;
    }

    public static Image getImage(String fullImageName) {
        Image image = null;
        URL url = cl.getResource(fullImageName);
        if (url != null) {
            image = Toolkit.getDefaultToolkit().createImage(url);
        }
        if (image == null) {
            System.out.println("  ERROR: Resource.getImageResource failed on " + fullImageName);
        }
        return image;
    }

    public static URL getURL(String filename) {
        return cl.getResource(filename);
    }

    public static Cursor makeCursor(String name) {
        Cursor cursor;
        Image image = Resource.getImage(name);
        if (null == image) {
            return null;
        }
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            if (debug) {
                ImageObserver obs = new ImageObserver(){

                    @Override
                    public boolean imageUpdate(Image image, int flags, int x, int y, int width, int height) {
                        return true;
                    }
                };
                System.out.println(" bestCursorSize = " + tk.getBestCursorSize(image.getWidth(obs), image.getHeight(obs)));
                System.out.println(" getMaximumCursorColors = " + tk.getMaximumCursorColors());
            }
            cursor = tk.createCustomCursor(image, new Point(17, 17), name);
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("NavigatedPanel createCustomCursor failed " + e);
            return null;
        }
        return cursor;
    }

    public static InputStream getFileResource(String resourcePath) {
        InputStream is;
        block8: {
            is = cl.getResourceAsStream(resourcePath);
            if (is != null) {
                if (debug) {
                    System.out.println("Resource.getResourceAsStream ok on " + resourcePath);
                }
                return is;
            }
            if (debug) {
                System.out.println("Resource.getResourceAsStream failed on (" + resourcePath + ")");
            }
            try {
                is = new FileInputStream(resourcePath);
                if (debug) {
                    System.out.println("Resource.FileInputStream ok on " + resourcePath);
                }
            }
            catch (FileNotFoundException e) {
                if (debug) {
                    System.out.println("  FileNotFoundException: Resource.getFile failed on " + resourcePath);
                }
            }
            catch (AccessControlException e) {
                if (!debug) break block8;
                System.out.println("  AccessControlException: Resource.getFile failed on " + resourcePath);
            }
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        block17: {
            System.out.println("java.class.path = " + System.getProperty("java.class.path"));
            System.out.println("Class = " + cl);
            System.out.println("Class Loader = " + cl.getClassLoader());
            InputStream is = Resource.getFileResource("/ucar.unidata.util/Resource.java");
            Throwable throwable = null;
            if (is != null) {
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    is.close();
                }
            }
            is = Resource.getFileResource("Resource.java");
            throwable = null;
            if (is != null) {
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    is.close();
                }
            }
            is = Resource.getFileResource("test/test/Resource.java");
            throwable = null;
            if (is == null) break block17;
            if (throwable != null) {
                try {
                    is.close();
                }
                catch (Throwable x2) {
                    throwable.addSuppressed(x2);
                }
            } else {
                is.close();
            }
        }
    }
}

