/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.entity.StringEntity;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSession;
import ucar.nc2.util.IO;
import ucar.unidata.util.Urlencoded;

public class HttpClientManager {
    private static boolean debug = false;
    private static int timeout = 0;

    public static void init(CredentialsProvider provider, String userAgent) {
        if (provider != null) {
            HTTPSession.setGlobalCredentialsProvider((CredentialsProvider)provider);
        }
        if (userAgent != null) {
            HTTPSession.setGlobalUserAgent((String)(userAgent + "/NetcdfJava/HttpClient"));
        } else {
            HTTPSession.setGlobalUserAgent((String)"NetcdfJava/HttpClient");
        }
    }

    public static void clearState() {
    }

    @Urlencoded
    public static String getContentAsString(String urlencoded) throws IOException {
        return HttpClientManager.getContentAsString(null, urlencoded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Urlencoded
    public static String getContentAsString(HTTPSession session, String urlencoded) throws IOException {
        HTTPSession useSession = session;
        try {
            if (useSession == null) {
                useSession = HTTPFactory.newSession();
            }
            HTTPMethod m = HTTPFactory.Get((HTTPSession)useSession, (String)urlencoded);
            m.execute();
            String string = m.getResponseAsString();
            return string;
        }
        finally {
            if (session == null && useSession != null) {
                useSession.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int putContent(String urlencoded, String content) throws IOException {
        try (HTTPSession session = null;){
            Header locationHeader;
            session = HTTPFactory.newSession((String)urlencoded);
            HTTPMethod m = HTTPFactory.Put((HTTPSession)session);
            m.setRequestContent((HttpEntity)new StringEntity(content, "application/text", "UTF-8"));
            m.execute();
            int resultCode = m.getStatusCode();
            if (resultCode == 302 && (locationHeader = m.getResponseHeader("location")) != null) {
                String redirectLocation = locationHeader.getValue();
                resultCode = HttpClientManager.putContent(redirectLocation, content);
            }
            int n = resultCode;
            return n;
        }
    }

    public static String getUrlContentsAsString(String urlencoded, int maxKbytes) throws IOException {
        return HttpClientManager.getUrlContentsAsString(null, urlencoded, maxKbytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String getUrlContentsAsString(HTTPSession session, String urlencoded, int maxKbytes) throws IOException {
        HTTPSession useSession = session;
        try {
            Header h;
            String encoding;
            if (useSession == null) {
                useSession = HTTPFactory.newSession((String)urlencoded);
            }
            HTTPMethod m = HTTPFactory.Get((HTTPSession)useSession, (String)urlencoded);
            m.setFollowRedirects(true);
            m.setRequestHeader("Accept-Encoding", "gzip,deflate");
            int status = m.execute();
            if (status != 200) {
                throw new RuntimeException("failed status = " + status);
            }
            String charset = m.getResponseCharSet();
            if (charset == null) {
                charset = "UTF-8";
            }
            String string = encoding = (h = m.getResponseHeader("content-encoding")) == null ? null : h.getValue();
            if (encoding != null && encoding.equals("deflate")) {
                byte[] body = m.getResponseAsBytes();
                BufferedInputStream is = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(body)), 10000);
                String string2 = HttpClientManager.readContents(is, charset, maxKbytes);
                return string2;
            }
            if (encoding != null && encoding.equals("gzip")) {
                byte[] body = m.getResponseAsBytes();
                BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(body)), 10000);
                String string3 = HttpClientManager.readContents(is, charset, maxKbytes);
                return string3;
            }
            byte[] body = m.getResponseAsBytes(maxKbytes * 1000);
            String string4 = new String(body, charset);
            return string4;
        }
        finally {
            if (session == null && useSession != null) {
                useSession.close();
            }
        }
    }

    private static String readContents(InputStream is, String charset, int maxKbytes) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1000 * maxKbytes);
        IO.copy((InputStream)is, (OutputStream)bout, (int)(1000 * maxKbytes));
        return bout.toString(charset);
    }

    public static void copyUrlContentsToFile(String urlencoded, File file) throws IOException {
        HttpClientManager.copyUrlContentsToFile(null, urlencoded, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void copyUrlContentsToFile(HTTPSession session, String urlencoded, File file) throws IOException {
        HTTPSession useSession = session;
        try {
            Header h;
            String encoding;
            if (useSession == null) {
                useSession = HTTPFactory.newSession((String)urlencoded);
            }
            HTTPMethod m = HTTPFactory.Get((HTTPSession)useSession, (String)urlencoded);
            m.setRequestHeader("Accept-Encoding", "gzip,deflate");
            int status = m.execute();
            if (status != 200) {
                throw new IOException("failed status = " + status);
            }
            String charset = m.getResponseCharSet();
            if (charset == null) {
                charset = "UTF-8";
            }
            String string = encoding = (h = m.getResponseHeader("content-encoding")) == null ? null : h.getValue();
            if (encoding != null && encoding.equals("deflate")) {
                BufferedInputStream is = new BufferedInputStream(new InflaterInputStream(m.getResponseAsStream()), 10000);
                IO.writeToFile((InputStream)is, (String)file.getPath());
            } else if (encoding != null && encoding.equals("gzip")) {
                BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(m.getResponseAsStream()), 10000);
                IO.writeToFile((InputStream)is, (String)file.getPath());
            } else {
                IO.writeToFile((InputStream)m.getResponseAsStream(), (String)file.getPath());
            }
        }
        finally {
            if (session == null && useSession != null) {
                useSession.close();
            }
        }
    }

    public static long appendUrlContentsToFile(String urlencoded, File file, long start, long end) throws IOException {
        return HttpClientManager.appendUrlContentsToFile(null, urlencoded, file, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static long appendUrlContentsToFile(HTTPSession session, String urlencoded, File file, long start, long end) throws IOException {
        HTTPSession useSession = session;
        long nbytes = 0L;
        try {
            Header h;
            String encoding;
            if (useSession == null) {
                useSession = HTTPFactory.newSession((String)urlencoded);
            }
            HTTPMethod m = HTTPFactory.Get((HTTPSession)useSession, (String)urlencoded);
            m.setRequestHeader("Accept-Encoding", "gzip,deflate");
            m.setRequestHeader("Range", "bytes=" + start + "-" + end);
            int status = m.execute();
            if (status != 200 && status != 206) {
                throw new RuntimeException("failed status = " + status);
            }
            String charset = m.getResponseCharSet();
            if (charset == null) {
                charset = "UTF-8";
            }
            String string = encoding = (h = m.getResponseHeader("content-encoding")) == null ? null : h.getValue();
            if (encoding != null && encoding.equals("deflate")) {
                BufferedInputStream is = new BufferedInputStream(new InflaterInputStream(m.getResponseAsStream()), 10000);
                nbytes = IO.appendToFile((InputStream)is, (String)file.getPath());
            } else if (encoding != null && encoding.equals("gzip")) {
                BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(m.getResponseAsStream()), 10000);
                nbytes = IO.appendToFile((InputStream)is, (String)file.getPath());
            } else {
                nbytes = IO.appendToFile((InputStream)m.getResponseAsStream(), (String)file.getPath());
            }
        }
        finally {
            if (session == null && useSession != null) {
                session.close();
            }
        }
        return nbytes;
    }
}

