/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import thredds.inventory.CollectionUpdateType;
import ucar.nc2.grib.grib1.Grib1Index;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class GribIndexPanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable recordTable;
    private JSplitPane split;
    private JSplitPane split2;
    private JSplitPane split3;
    private TextHistoryPane infoPopup;
    private TextHistoryPane detailTA;
    private IndependentWindow infoWindow;
    private IndependentWindow detailWindow;
    Object gc = null;

    public GribIndexPanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.recordTable = new BeanTable(RecordBean.class, (PreferencesExt)prefs.node("Grib2RecordBean"), false);
        PopupMenu popup = new PopupMenu(this.recordTable.getJTable(), "Options");
        popup.addAction("Show Record", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordBean bean = (RecordBean)GribIndexPanel.this.recordTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    bean.show(f);
                    GribIndexPanel.this.infoPopup.setText(f.toString());
                    GribIndexPanel.this.infoPopup.gotoTop();
                    GribIndexPanel.this.infoWindow.show();
                }
            }
        });
        this.infoPopup = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.detailTA = new TextHistoryPane();
        this.detailWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.detailTA);
        this.detailWindow.setBounds((Rectangle)prefs.getBean("DetailWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.setLayout(new BorderLayout());
        this.add((Component)this.recordTable, "Center");
    }

    public void save() {
        this.recordTable.saveState(false);
    }

    public void closeOpenFiles() throws IOException {
        this.gc = null;
    }

    public void setIndexFile(String indexFile) throws IOException {
        block14: {
            this.closeOpenFiles();
            try (RandomAccessFile raf = new RandomAccessFile(indexFile, "r");){
                raf.seek(0L);
                String magic = raf.readString("Grib2Index".getBytes().length);
                if (magic.equals("Grib2Index")) {
                    this.readIndex2(indexFile);
                    break block14;
                }
                if (magic.equals("Grib1Index")) {
                    this.readIndex1(indexFile);
                    break block14;
                }
                throw new IOException("Not a grib index file =" + magic);
            }
        }
    }

    public void readIndex1(String filename) throws IOException {
        if (filename.endsWith(".gbx9")) {
            filename = filename.substring(0, filename.length() - ".gbx9".length());
        }
        Grib1Index g1idx = new Grib1Index();
        g1idx.readIndex(filename, 0L, CollectionUpdateType.nocheck);
        ArrayList<RecordBean> records = new ArrayList<RecordBean>();
        for (Grib1Record gr : g1idx.getRecords()) {
            records.add(new RecordBean(gr));
        }
        this.recordTable.setBeans(records);
    }

    public void readIndex2(String filename) throws IOException {
        if (filename.endsWith(".gbx9")) {
            filename = filename.substring(0, filename.length() - ".gbx9".length());
        }
        Grib2Index g2idx = new Grib2Index();
        g2idx.readIndex(filename, 0L, CollectionUpdateType.nocheck);
        ArrayList<RecordBean> records = new ArrayList<RecordBean>();
        for (Grib2Record gr : g2idx.getRecords()) {
            records.add(new RecordBean(gr));
        }
        this.recordTable.setBeans(records);
    }

    public class RecordBean {
        Grib1Record gr1;
        Grib2Record gr2;

        public RecordBean() {
        }

        public RecordBean(Grib2Record gr) {
            this.gr2 = gr;
        }

        public RecordBean(Grib1Record gr) {
            this.gr1 = gr;
        }

        public int getFile() {
            return this.gr2 == null ? this.gr1.getFile() : this.gr2.getFile();
        }

        public String getReferenceDate() {
            return this.gr2 == null ? this.gr1.getReferenceDate().toString() : this.gr2.getReferenceDate().toString();
        }

        public long getStart() {
            return this.gr2 == null ? this.gr1.getIs().getStartPos() : this.gr2.getIs().getStartPos();
        }

        public long getLength() {
            return this.gr2 == null ? this.gr1.getIs().getMessageLength() : this.gr2.getIs().getMessageLength();
        }

        private void show(Formatter f) {
            if (this.gr2 == null) {
                this.show(this.gr1, f);
            } else {
                this.show(this.gr2, f);
            }
        }

        private void show(Grib1Record gr1, Formatter f) {
            Grib1SectionProductDefinition pds = gr1.getPDSsection();
            Grib1Customizer cust = Grib1Customizer.factory((Grib1Record)gr1, null);
            pds.showPds(cust, f);
        }

        private void show(Grib2Record gr2, Formatter f) {
            gr2.show(f);
        }
    }
}

