/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Formatter;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.ma2.Array;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.hdf5.H5diag;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.iosp.hdf5.H5iosp;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class Hdf5DataTable
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable objectTable;
    private JSplitPane splitH;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoTA;
    private H5iosp iosp;
    private String location;

    public Hdf5DataTable(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.objectTable = new BeanTable(VarBean.class, (PreferencesExt)prefs.node("Hdf5Object"), false, "H5header.DataObject", "Level 2A data object header", null);
        this.objectTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VarBean vb = (VarBean)Hdf5DataTable.this.objectTable.getSelectedBean();
                vb.count(true);
                vb.show();
            }
        });
        AbstractAction calcAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Hdf5DataTable.this.calcStorage();
            }
        };
        BAMutil.setActionProperties(calcAction, "Dataset", "calc storage", false, 68, -1);
        BAMutil.addActionToContainer(buttPanel, calcAction);
        PopupMenu varPopup = new PopupMenu(this.objectTable.getJTable(), "Options");
        varPopup.addAction("deflate", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VarBean mb = (VarBean)Hdf5DataTable.this.objectTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                Hdf5DataTable.this.infoTA.clear();
                Formatter f = new Formatter();
                Hdf5DataTable.this.deflate(f, mb);
                Hdf5DataTable.this.infoTA.appendLine(f.toString());
                Hdf5DataTable.this.infoTA.gotoTop();
            }
        });
        varPopup.addAction("show storage", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VarBean mb = (VarBean)Hdf5DataTable.this.objectTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                Hdf5DataTable.this.infoTA.clear();
                Formatter f = new Formatter();
                Hdf5DataTable.this.showStorage(f, mb);
                Hdf5DataTable.this.infoTA.appendLine(f.toString());
                Hdf5DataTable.this.infoTA.gotoTop();
            }
        });
        varPopup.addAction("show vlen", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VarBean mb = (VarBean)Hdf5DataTable.this.objectTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                Hdf5DataTable.this.infoTA.clear();
                Formatter f = new Formatter();
                Hdf5DataTable.this.showVlen(f, mb);
                Hdf5DataTable.this.infoTA.appendLine(f.toString());
                Hdf5DataTable.this.infoTA.gotoTop();
            }
        });
        this.infoTA = new TextHistoryPane();
        this.splitH = new JSplitPane(0, false, this.objectTable, this.infoTA);
        this.splitH.setDividerLocation(prefs.getInt("splitPosH", 600));
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitH, "Center");
    }

    public void save() {
        this.objectTable.saveState(false);
        this.prefs.putInt("splitPosH", this.splitH.getDividerLocation());
    }

    public void closeOpenFiles() throws IOException {
        if (this.iosp != null) {
            this.iosp.close();
        }
        this.iosp = null;
    }

    public void setHdf5File(RandomAccessFile raf) throws IOException {
        this.closeOpenFiles();
        this.location = raf.getLocation();
        long start = System.nanoTime();
        ArrayList<VarBean> beanList = new ArrayList<VarBean>();
        this.iosp = new H5iosp();
        MyNetcdfFile ncfile = new MyNetcdfFile(this.iosp, this.location);
        try {
            this.iosp.open(raf, (NetcdfFile)ncfile, null);
        }
        catch (Throwable t) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(20000);
            PrintStream s = new PrintStream(bos);
            t.printStackTrace(s);
            this.infoTA.setText(bos.toString());
        }
        for (Variable v : ncfile.getVariables()) {
            beanList.add(new VarBean(v));
        }
        this.objectTable.setBeans(beanList);
    }

    public void showInfo(Formatter f) throws IOException {
        if (this.iosp == null) {
            return;
        }
        H5diag header = new H5diag(this.iosp);
        header.showCompress(f);
    }

    public void calcStorage() {
        if (this.iosp == null) {
            return;
        }
        long totalVars = 0L;
        long totalStorage = 0L;
        long totalCount = 0L;
        Formatter f = new Formatter();
        for (Object obean : this.objectTable.getBeans()) {
            VarBean bean = (VarBean)obean;
            bean.count(false);
            totalStorage += bean.getStorage();
            totalCount += bean.getNchunks();
            totalVars += bean.getSizeBytes();
        }
        f.format("%n", new Object[0]);
        f.format(" total bytes   = %,d%n", totalVars);
        f.format(" total storage = %,d%n", totalStorage);
        File raf = new File(this.location);
        f.format("  file size    = %,d%n", raf.length());
        float ratio = totalStorage == 0L ? 0.0f : (float)raf.length() / (float)totalStorage;
        f.format("  overhead     = %f%n", Float.valueOf(ratio));
        ratio = totalStorage == 0L ? 0.0f : (float)totalVars / (float)totalStorage;
        f.format("   compression = %f%n", Float.valueOf(ratio));
        f.format("   nchunks     = %d%n", totalCount);
        this.infoTA.setText(f.toString());
    }

    private void deflate(Formatter f, VarBean bean) {
        H5diag header = new H5diag(this.iosp);
        try {
            header.showCompress(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void showStorage(Formatter f, VarBean bean) {
        try {
            bean.vinfo.countStorageSize(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void showVlen(Formatter f, VarBean bean) {
        if (!bean.v.isVariableLength()) {
            f.format("Variable %s must be variable length", bean.v.getFullName());
            return;
        }
        try {
            int countRows = 0;
            long countElems = 0L;
            Array result = bean.v.read();
            f.format("class = %s%n", result.getClass().getName());
            while (result.hasNext()) {
                Array line = (Array)result.next();
                long size = line.getSize();
                countElems += size;
                f.format("  row %d size=%d%n", ++countRows, size);
            }
            float avg = countRows == 0 ? 0.0f : (float)countElems / (float)countRows;
            f.format("%n  nrows = %d totalElems=%d avg=%f%n", countRows, countElems, Float.valueOf(avg));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public class VarBean {
        Variable v;
        H5header.Vinfo vinfo;
        long[] countResult;

        public VarBean() {
        }

        public VarBean(Variable v) {
            this.v = v;
            this.vinfo = (H5header.Vinfo)v.getSPobject();
        }

        public String getName() {
            return this.v.getShortName();
        }

        public boolean isUseFill() {
            return this.vinfo.useFillValue();
        }

        public boolean isChunk() {
            return this.vinfo.isChunked();
        }

        public String getDims() {
            Formatter f = new Formatter();
            for (Dimension d : this.v.getDimensions()) {
                f.format("%d ", d.getLength());
            }
            return f.toString();
        }

        public String getChunks() {
            if (!this.vinfo.isChunked()) {
                return "";
            }
            int[] chunk = this.vinfo.getChunking();
            Formatter f = new Formatter();
            for (int i : chunk) {
                f.format("%d ", i);
            }
            return f.toString();
        }

        public int getChunkSize() {
            if (!this.vinfo.isChunked()) {
                return -1;
            }
            int[] chunks = this.vinfo.getChunking();
            int total = 1;
            for (int chunk : chunks) {
                total *= chunk;
            }
            return total;
        }

        public long getNelems() {
            return this.v.getSize();
        }

        public long getSizeBytes() {
            return this.v.getSize() * (long)this.v.getElementSize();
        }

        public long getNchunks() {
            return this.countResult == null ? 0L : this.countResult[1];
        }

        public long getStorage() {
            return this.countResult == null ? 0L : this.countResult[0];
        }

        public float getRatio() {
            if (this.countResult == null) {
                return 0.0f;
            }
            if (this.countResult[0] == 0L) {
                return 0.0f;
            }
            return (float)this.getSizeBytes() / (float)this.countResult[0];
        }

        public String getDataType() {
            return this.v.getDataType().toString();
        }

        public String getCompression() {
            return this.vinfo.getCompression();
        }

        void count(boolean force) {
            if (!force && this.countResult != null) {
                return;
            }
            if (this.vinfo.useFillValue()) {
                this.countResult = new long[2];
                this.countResult[0] = 0L;
                this.countResult[1] = 0L;
                return;
            }
            if (!this.vinfo.isChunked()) {
                this.countResult = new long[2];
                this.countResult[0] = this.getSizeBytes();
                this.countResult[1] = 1L;
                return;
            }
            try {
                this.countResult = this.vinfo.countStorageSize(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        void show() {
            Formatter f = new Formatter();
            f.format("vinfo = %s%n%n", this.vinfo.toString());
            f.format("      = %s%n", this.vinfo.extraInfo());
            Hdf5DataTable.this.infoTA.setText(f.toString());
        }
    }

    private static class MyNetcdfFile
    extends NetcdfFile {
        private MyNetcdfFile(H5iosp iosp, String location) {
            this.spi = iosp;
            this.location = location;
        }
    }
}

