/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.gis.shapefile;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import ucar.nc2.ui.gis.shapefile.DbaseData;
import ucar.nc2.ui.gis.shapefile.DbaseFieldDesc;
import ucar.nc2.ui.gis.shapefile.Swap;

public class DbaseFile {
    public static int DBASEIII = 0;
    public static int DBASEIV = 1;
    public static int DBASE5DOS = 2;
    public static int DBASE5WIN = 3;
    URL url;
    byte filetype;
    byte updateYear;
    byte updateMonth;
    byte updateDay;
    int nrecords;
    int nfields;
    short nbytesheader;
    short nbytesrecord;
    DbaseFieldDesc[] FieldDesc;
    DbaseData[] data;
    byte[] Header;
    private boolean headerLoaded = false;
    private boolean dataLoaded = false;
    InputStream stream = null;
    DataInputStream ds = null;

    public DbaseFile(URL url) throws IOException {
        this.url = url;
        this.stream = url.openStream();
    }

    public DbaseFile(String spec) throws IOException {
        try {
            this.url = new URL(spec);
            this.stream = this.url.openStream();
        }
        catch (MalformedURLException e) {
            this.stream = new FileInputStream(spec);
        }
    }

    public DbaseFile(File file) {
        try {
            this.stream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            System.out.println("Failed to open file " + file);
            this.stream = null;
        }
    }

    public DbaseFile(InputStream s) {
        this.stream = s;
    }

    private int loadHeader() {
        if (this.headerLoaded) {
            return 0;
        }
        InputStream s = this.stream;
        if (s == null) {
            return -1;
        }
        try {
            BufferedInputStream bs = new BufferedInputStream(s);
            this.ds = new DataInputStream(bs);
            this.Header = new byte[32];
            this.ds.readFully(this.Header);
            if (this.Header[0] == 60) {
                this.close(this.ds);
                return -1;
            }
            this.filetype = this.Header[0];
            this.updateYear = this.Header[1];
            this.updateMonth = this.Header[2];
            this.updateDay = this.Header[3];
            this.nrecords = Swap.swapInt(this.Header, 4);
            this.nbytesheader = Swap.swapShort(this.Header, 8);
            this.nbytesrecord = Swap.swapShort(this.Header, 10);
            this.nfields = this.nbytesheader / 32 - 1;
            if (this.nfields < 1) {
                System.out.println("nfields = " + this.nfields);
                System.out.println("nbytesheader = " + this.nbytesheader);
                return -1;
            }
            this.FieldDesc = new DbaseFieldDesc[this.nfields];
            this.data = new DbaseData[this.nfields];
            for (int i = 0; i < this.nfields; ++i) {
                this.FieldDesc[i] = new DbaseFieldDesc(this.ds, this.filetype);
                this.data[i] = new DbaseData(this.FieldDesc[i], this.nrecords);
            }
            this.ds.readByte();
            this.headerLoaded = true;
        }
        catch (IOException e) {
            this.close(s);
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private int loadData() {
        if (!this.headerLoaded) {
            return -1;
        }
        if (this.dataLoaded) {
            return 0;
        }
        s = this.stream;
        if (s == null) {
            return -1;
        }
lbl8:
        // 3 sources

        try {
            for (i = 0; i < this.nrecords; ++i) {
                block11: {
                    recbyte = this.ds.readByte();
                    if (recbyte != 32) break block11;
                    for (j = 0; j < this.nfields; ++j) {
                        this.data[j].readRowN(this.ds, i);
                    }
                    ** GOTO lbl8
                }
                --this.nrecords;
                --i;
            }
            this.dataLoaded = true;
        }
        catch (IOException e) {
            this.close(s);
            var3_5 = -1;
            return var3_5;
        }
        finally {
            this.close(s);
        }
        return 0;
    }

    private void close(InputStream d) {
        if (d == null) {
            return;
        }
        try {
            d.close();
        }
        catch (IOException e) {
            System.out.printf("filed to close %s%n", e);
        }
    }

    public DbaseData getField(int index) {
        if (index < 0 || index >= this.nfields) {
            return null;
        }
        return this.data[index];
    }

    public DbaseData getField(String Name2) {
        for (int i = 0; i < this.nfields; ++i) {
            if (!this.FieldDesc[i].Name.equals(Name2)) continue;
            return this.data[i];
        }
        return null;
    }

    public double[] getDoublesByName(String Name2) {
        DbaseData d = this.getField(Name2);
        if (d == null) {
            return null;
        }
        if (d.getType() == 0) {
            String[] s = d.getStrings();
            double[] dd = new double[s.length];
            for (int i = 0; i < s.length; ++i) {
                dd[i] = Double.valueOf(s[i]);
            }
            return dd;
        }
        if (d.getType() == 2) {
            boolean[] b = d.getBooleans();
            double[] dd = new double[b.length];
            for (int i = 0; i < b.length; ++i) {
                dd[i] = b[i] ? 1.0 : 0.0;
            }
            return dd;
        }
        return d.getDoubles();
    }

    public String[] getStringsByName(String Name2) {
        DbaseData d = this.getField(Name2);
        if (d == null) {
            return null;
        }
        if (d.getType() != 0) {
            return null;
        }
        return d.getStrings();
    }

    public boolean[] getBooleansByName(String Name2) {
        DbaseData d = this.getField(Name2);
        if (d == null) {
            return null;
        }
        if (d.getType() != 2) {
            return null;
        }
        return d.getBooleans();
    }

    public String getFieldName(int i) {
        if (i >= this.nfields || i < 0) {
            return null;
        }
        return this.FieldDesc[i].Name;
    }

    public String[] getFieldNames() {
        String[] s = new String[this.nfields];
        for (int i = 0; i < this.nfields; ++i) {
            s[i] = this.getFieldName(i);
        }
        return s;
    }

    public int getNumFields() {
        return this.nfields;
    }

    public int getNumRecords() {
        return this.nrecords;
    }

    public boolean isLoaded() {
        return this.dataLoaded;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("filename or URL required");
            System.exit(-1);
        }
        for (String s : args) {
            System.out.println("*** Dump of Dbase " + s + ":");
            try {
                DbaseFile dbf = new DbaseFile(s);
                if (dbf.loadHeader() != 0) {
                    System.out.println("Error loading header" + s);
                    System.exit(-1);
                }
                String[] fieldNames = dbf.getFieldNames();
                System.out.print("[");
                int nf = dbf.getNumFields();
                DbaseData[] dbd = new DbaseData[nf];
                for (int field = 0; field < nf; ++field) {
                    dbd[field] = dbf.getField(field);
                    switch (dbd[field].getType()) {
                        case 2: {
                            System.out.print("boolean ");
                            break;
                        }
                        case 0: {
                            System.out.print("String ");
                            break;
                        }
                        case 1: {
                            System.out.print("double ");
                        }
                    }
                    System.out.print(fieldNames[field]);
                    if (field >= nf - 1) continue;
                    System.out.print(", ");
                }
                System.out.println("]");
                if (dbf.loadData() != 0) {
                    System.out.println("Error loading data" + s);
                    System.exit(-1);
                }
                for (int rec = 0; rec < dbf.getNumRecords(); ++rec) {
                    for (int field = 0; field < nf; ++field) {
                        System.out.print(dbd[field].getData(rec));
                        if (field < nf - 1) {
                            System.out.print(", ");
                            continue;
                        }
                        System.out.println();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                break;
            }
        }
    }
}

