/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.image;

import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ucar.nc2.ui.image.SourcePicture;
import ucar.nc2.ui.image.Tools;

public class PictureCache {
    private static Hashtable pictureCache = new Hashtable();
    public static Vector cacheLoadsInProgress = new Vector();
    private static Vector removalQueue = new Vector();
    private static int maxCache = 10;

    public static synchronized void removeLeastPopular() {
        String removeElement;
        Tools.log("PictureCache.removeLeastPopular:");
        Enumeration<Object> e = removalQueue.elements();
        while (e.hasMoreElements() && pictureCache.size() >= maxCache) {
            removeElement = (String)e.nextElement();
            Tools.log("PictureCache.remove: " + removeElement);
            pictureCache.remove(removeElement);
            removalQueue.remove(removeElement);
        }
        e = pictureCache.keys();
        while (pictureCache.size() >= maxCache && e.hasMoreElements()) {
            removeElement = (String)e.nextElement();
            Tools.log("PictureCache.remove: " + removeElement);
            pictureCache.remove(removeElement);
        }
    }

    public static synchronized boolean isInCache(URL url) {
        return PictureCache.isInCache(url.toString());
    }

    public static synchronized boolean isInCache(String urlString) {
        return pictureCache.containsKey(urlString);
    }

    public static synchronized void add(URL url, SourcePicture sp) {
        Tools.log("PictureCache.add: " + url.toString());
        if (sp.getSourceBufferedImage() == null) {
            Tools.log("PictureCache.add: invoked with a null picture! Not cached!");
            return;
        }
        if (maxCache < 1) {
            Tools.log("PictureCache.add: cache is diabled. Not adding picture.");
            return;
        }
        if (PictureCache.isInCache(url)) {
            Tools.log("Picture " + url.toString() + " is already in the cache. Not adding again.");
            return;
        }
        if (pictureCache.size() >= maxCache) {
            PictureCache.removeLeastPopular();
        }
        if (pictureCache.size() < maxCache) {
            pictureCache.put(url.toString(), sp);
        }
    }

    public static synchronized void remove(String urlString) {
        if (PictureCache.isInCache(urlString)) {
            pictureCache.remove(urlString);
        }
    }

    public static synchronized SourcePicture getSourcePicture(URL url) {
        return (SourcePicture)pictureCache.get(url.toString());
    }

    public static void clear() {
        Tools.log("PictureCache.clear: Zapping entire cache");
        pictureCache.clear();
    }

    public static void reportCache() {
        Tools.log("   PictureCache.reportCache: cache contains: " + Integer.toString(pictureCache.size()) + " max: " + Integer.toString(maxCache));
        Enumeration e = pictureCache.keys();
        while (e.hasMoreElements()) {
            Tools.log("   Cache contains: " + (String)e.nextElement());
        }
        Tools.log("  End of cache contents");
    }

    public static void stopBackgroundLoading() {
        Enumeration e = cacheLoadsInProgress.elements();
        while (e.hasMoreElements()) {
            ((SourcePicture)e.nextElement()).stopLoading();
        }
    }

    public static boolean stopBackgroundLoadingExcept(URL exemptionURL) {
        String exemptionURLString = exemptionURL.toString();
        Enumeration e = cacheLoadsInProgress.elements();
        boolean inProgress = false;
        while (e.hasMoreElements()) {
            SourcePicture sp = (SourcePicture)e.nextElement();
            if (!sp.getUrlString().equals(exemptionURLString)) {
                sp.stopLoading();
                continue;
            }
            Tools.log("PictureCache.stopBackgroundLoading: picture was already loading");
            inProgress = true;
        }
        return inProgress;
    }
}

