/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.catalog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import thredds.catalog.DatasetFilter;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ServiceType;
import thredds.ui.catalog.CatalogChooser;
import thredds.ui.catalog.query.QueryChooser;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.XMLStore;

public class ThreddsDatasetChooser
extends JPanel {
    private static final String FRAME_SIZE = "FrameSize";
    private CatalogChooser catalogChooser;
    private QueryChooser queryChooser;
    private JTabbedPane tabbedPane;
    private boolean doResolve = false;
    private boolean pipeOut = true;
    private boolean messageOut = false;
    private JFrame frame;
    private boolean debugResolve = false;
    private static ThreddsDatasetChooser chooser;
    private static PreferencesExt p;
    private static XMLStore store;

    public ThreddsDatasetChooser(PreferencesExt prefs, JTabbedPane tabs) {
        this(prefs, tabs, null, false, false, false);
    }

    public ThreddsDatasetChooser(PreferencesExt prefs, JTabbedPane tabs, JFrame frame, boolean pipeOutput, boolean messageOutput, boolean addDqc) {
        this.frame = frame;
        this.pipeOut = pipeOutput;
        this.messageOut = messageOutput;
        PreferencesExt node = prefs == null ? null : (PreferencesExt)prefs.node("catChooser");
        this.catalogChooser = new CatalogChooser(node, true, true, true);
        this.catalogChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("InvAccess")) {
                    InvAccess qcAccess = (InvAccess)e.getNewValue();
                    if (ThreddsDatasetChooser.this.queryChooser != null && qcAccess.getService().getServiceType() == ServiceType.QC) {
                        ThreddsDatasetChooser.this.queryChooser.setDataset(qcAccess.getDataset());
                        ThreddsDatasetChooser.this.tabbedPane.setSelectedComponent(ThreddsDatasetChooser.this.queryChooser);
                        return;
                    }
                    ThreddsDatasetChooser.this.firePropertyChangeEvent(e);
                    return;
                }
                if (e.getPropertyName().equals("Dataset") || e.getPropertyName().equals("CoordSys") || e.getPropertyName().equals("File")) {
                    InvDataset ds = (InvDataset)e.getNewValue();
                    InvAccess qcAccess = ds.getAccess(ServiceType.QC);
                    if (ThreddsDatasetChooser.this.queryChooser != null && qcAccess != null) {
                        ThreddsDatasetChooser.this.queryChooser.setDataset(ds);
                        ThreddsDatasetChooser.this.tabbedPane.setSelectedComponent(ThreddsDatasetChooser.this.queryChooser);
                        return;
                    }
                    qcAccess = ds.getAccess(ServiceType.RESOLVER);
                    if (qcAccess != null && ThreddsDatasetChooser.this.doResolve) {
                        ThreddsDatasetChooser.this.resolve(ds);
                        return;
                    }
                    ThreddsDatasetChooser.this.firePropertyChangeEvent(e);
                }
            }
        });
        this.tabbedPane = tabs == null ? new JTabbedPane(1) : tabs;
        this.tabbedPane.addTab("Catalog Chooser", this.catalogChooser);
        if (addDqc) {
            node = prefs == null ? null : (PreferencesExt)prefs.node("dqc");
            this.queryChooser = new QueryChooser(node, true);
            this.queryChooser.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    ThreddsDatasetChooser.this.firePropertyChangeEvent(e);
                }
            });
            this.tabbedPane.addTab("DQC Chooser", this.queryChooser);
        }
        this.tabbedPane.setSelectedComponent(this.catalogChooser);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    public void setDatasetFilter(DatasetFilter filter) {
        this.catalogChooser.setDatasetFilter(filter);
    }

    public void setDoResolve(boolean doResolve) {
        this.doResolve = doResolve;
    }

    public QueryChooser getQueryChooser() {
        return this.queryChooser;
    }

    public CatalogChooser getCatalogChooser() {
        return this.catalogChooser;
    }

    public void save() {
        this.catalogChooser.save();
        if (this.queryChooser != null) {
            this.queryChooser.save();
        }
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.pipeOut) {
            this.pipeEvent(event);
        }
        if (this.messageOut) {
            this.messageEvent(event);
        }
        this.firePropertyChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
    }

    private void messageEvent(PropertyChangeEvent e) {
        Formatter buff = new Formatter();
        buff.format("Event propertyName = %s", e.getPropertyName());
        Object newValue = e.getNewValue();
        if (newValue != null) {
            buff.format(", class = %s", newValue.getClass().getName());
        }
        buff.format("%n", new Object[0]);
        if (e.getPropertyName().equals("Dataset")) {
            this.showDatasetInfo(buff, (InvDataset)e.getNewValue());
        } else if (e.getPropertyName().equals("Datasets")) {
            Object[] ds = (Object[])e.getNewValue();
            buff.format(" element class = %s%n", ds[0].getClass().getName());
            for (int i = 0; i < ds.length; ++i) {
                if (!(ds[i] instanceof InvDataset)) continue;
                this.showDatasetInfo(buff, (InvDataset)ds[i]);
            }
        }
        try {
            JOptionPane.showMessageDialog(this.frame, buff);
        }
        catch (HeadlessException he) {
            // empty catch block
        }
    }

    private void pipeEvent(PropertyChangeEvent e) {
        Formatter buff = new Formatter();
        if (e.getPropertyName().equals("Dataset")) {
            this.getAccessURLs(buff, (InvDataset)e.getNewValue());
        } else if (e.getPropertyName().equals("Datasets")) {
            Object[] ds = (Object[])e.getNewValue();
            for (int i = 0; i < ds.length; ++i) {
                if (!(ds[i] instanceof InvDataset)) continue;
                this.getAccessURLs(buff, (InvDataset)ds[i]);
            }
        }
        System.out.println(buff);
    }

    private void getAccessURLs(Formatter buff, InvDataset ds) {
        for (InvAccess ac : ds.getAccess()) {
            buff.format("%s %s %n", ac.getStandardUrlName(), ac.getService().getServiceType());
        }
    }

    private void showDatasetInfo(Formatter buff, InvDataset ds) {
        buff.format(" Dataset = %s", ds.getName());
        buff.format(", dataType = %s%n", ds.getDataType());
        for (InvAccess ac : ds.getAccess()) {
            buff.format("  service = %s, url = %s%n", ac.getService().getServiceType(), ac.getStandardUrlName());
        }
    }

    private void resolve(InvDataset ds) {
        InvAccess resolverAccess = ds.getAccess(ServiceType.RESOLVER);
        if (null != resolverAccess) {
            String urlName = resolverAccess.getStandardUrlName();
            if (this.debugResolve) {
                System.out.println(" resolve=" + urlName);
            }
            try {
                InvCatalogFactory factory = InvCatalogFactory.getDefaultFactory((boolean)true);
                InvCatalogImpl catalog = factory.readXML(urlName);
                if (catalog == null) {
                    return;
                }
                StringBuilder buff = new StringBuilder();
                if (!catalog.check(buff)) {
                    JOptionPane.showMessageDialog(this, "Invalid catalog <" + urlName + ">\n" + buff.toString());
                    if (this.debugResolve) {
                        System.out.println("Invalid catalog <" + urlName + ">\n" + buff.toString());
                    }
                    return;
                }
                InvDatasetImpl top = catalog.getDataset();
                if (top.hasAccess()) {
                    this.firePropertyChangeEvent(new PropertyChangeEvent(this, "Dataset", null, top));
                } else {
                    List dsets = top.getDatasets();
                    InvDataset[] dsa = dsets.toArray(new InvDataset[dsets.size()]);
                    this.firePropertyChangeEvent(new PropertyChangeEvent(this, "Datasets", null, dsa));
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public JDialog makeDialog(JFrame parent, String title, boolean modal) {
        return new Dialog(this.frame, title, modal);
    }

    public static void main(String[] args) {
        boolean usePopup = false;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-usePopup")) continue;
            usePopup = true;
        }
        try {
            store = XMLStore.createFromFile("ThreddsDatasetChooser", null);
            p = store.getPreferences();
        }
        catch (IOException e) {
            System.out.println("XMLStore Creation failed " + e);
        }
        final JFrame frame = new JFrame("Thredds Dataset Chooser");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                chooser.save();
                Rectangle bounds = frame.getBounds();
                p.putBeanObject(ThreddsDatasetChooser.FRAME_SIZE, bounds);
                try {
                    store.save();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                System.exit(0);
            }
        });
        chooser = new ThreddsDatasetChooser(p, null, frame, true, usePopup, false);
        chooser.setDoResolve(true);
        frame.getContentPane().add(chooser);
        Rectangle bounds = (Rectangle)p.getBean(FRAME_SIZE, new Rectangle(50, 50, 800, 450));
        frame.setBounds(bounds);
        frame.pack();
        frame.setBounds(bounds);
        frame.setVisible(true);
    }

    private class Dialog
    extends JDialog {
        private Dialog(JFrame frame, String title, boolean modal) {
            super(frame, title, modal);
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("lookAndFeel")) {
                        SwingUtilities.updateComponentTreeUI(Dialog.this);
                    }
                }
            });
            JButton dismissButton = new JButton("Dismiss");
            dismissButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Dialog.this.setVisible(false);
                }
            });
            Container cp = this.getContentPane();
            cp.setLayout(new BorderLayout());
            cp.add((Component)ThreddsDatasetChooser.this, "Center");
            this.pack();
        }
    }
}

