/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public abstract class ReportPanel
extends JPanel {
    protected PreferencesExt prefs;
    protected TextHistoryPane reportPane;

    protected ReportPanel(PreferencesExt prefs) {
        this.prefs = prefs;
        this.reportPane = new TextHistoryPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.reportPane, "Center");
    }

    protected void addOptions(JPanel buttPanel) {
    }

    public void save() {
    }

    public abstract Object[] getOptions();

    public void doReport(String spec, boolean useIndex, boolean eachFile, boolean extra, Object option) throws IOException {
        Formatter f = new Formatter();
        f.format("%s on %s useIndex=%s eachFile=%s extra=%s%n", option, spec, useIndex, eachFile, extra);
        try (MCollection dcm = this.getCollection(spec, f);){
            if (dcm == null) {
                return;
            }
            f.format("top dir = %s%n", dcm.getRoot());
            this.reportPane.setText(f.toString());
            File top = new File(dcm.getRoot());
            if (!top.exists()) {
                f.format("top dir = %s does not exist%n", dcm.getRoot());
            } else {
                this.doReport(f, option, dcm, useIndex, eachFile, extra);
            }
            this.reportPane.setText(f.toString());
            this.reportPane.gotoTop();
        }
        catch (IOException ioe) {
            StringWriter sw = new StringWriter(50000);
            ioe.printStackTrace(new PrintWriter(sw));
            f.format(sw.toString(), new Object[0]);
            ioe.printStackTrace();
        }
    }

    protected abstract void doReport(Formatter var1, Object var2, MCollection var3, boolean var4, boolean var5, boolean var6) throws IOException;

    protected boolean showCollection(String spec) {
        Formatter f = new Formatter();
        f.format("collection = %s%n", spec);
        boolean hasFiles = false;
        try (MCollection dcm = this.getCollection(spec, f);){
            if (dcm == null) {
                boolean bl = false;
                return bl;
            }
            try {
                for (MFile mfile : dcm.getFilesSorted()) {
                    f.format(" %s%n", mfile.getPath());
                    hasFiles = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.reportPane.setText(f.toString());
            this.reportPane.gotoTop();
            boolean bl = hasFiles;
            return bl;
        }
    }

    MCollection getCollection(String spec, Formatter f) {
        try {
            return CollectionAbstract.open((String)spec, (String)spec, null, (Formatter)f);
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter(10000);
            e.printStackTrace(new PrintWriter(sw));
            this.reportPane.setText(sw.toString());
            return null;
        }
    }

    public static class CounterOfString
    implements Counter {
        private Map<String, Integer> set = new HashMap<String, Integer>();
        private String name;

        @Override
        public String getName() {
            return this.name;
        }

        public CounterOfString(String name) {
            this.name = name;
        }

        public void count(String value) {
            Integer count = this.set.get(value);
            if (count == null) {
                this.set.put(value, 1);
            } else {
                this.set.put(value, count + 1);
            }
        }

        @Override
        public void addTo(Counter sub) {
            CounterOfString subs = (CounterOfString)sub;
            for (Map.Entry<String, Integer> entry : subs.set.entrySet()) {
                Integer count = this.set.get(entry.getKey());
                if (count == null) {
                    count = 0;
                }
                this.set.put(entry.getKey(), count + entry.getValue());
            }
        }

        @Override
        public void show(Formatter f) {
            f.format("%n%s%n", this.name);
            ArrayList<String> list = new ArrayList<String>(this.set.keySet());
            Collections.sort(list);
            for (String key : list) {
                int count = this.set.get(key);
                f.format("   %10s: count = %d%n", key, count);
            }
        }
    }

    public static class CounterOfInt
    implements Counter {
        private Map<Integer, Integer> set = new HashMap<Integer, Integer>();
        private String name;

        @Override
        public String getName() {
            return this.name;
        }

        public CounterOfInt(String name) {
            this.name = name;
        }

        public void reset() {
            this.set = new HashMap<Integer, Integer>();
        }

        public void count(int value) {
            Integer count = this.set.get(value);
            if (count == null) {
                this.set.put(value, 1);
            } else {
                this.set.put(value, count + 1);
            }
        }

        @Override
        public void addTo(Counter sub) {
            CounterOfInt subi = (CounterOfInt)sub;
            for (Map.Entry<Integer, Integer> entry : subi.set.entrySet()) {
                Integer count = this.set.get(entry.getKey());
                if (count == null) {
                    count = 0;
                }
                this.set.put(entry.getKey(), count + entry.getValue());
            }
        }

        @Override
        public void show(Formatter f) {
            f.format("%n%s%n", this.name);
            ArrayList<Integer> list = new ArrayList<Integer>(this.set.keySet());
            Collections.sort(list);
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                int template = (Integer)i$.next();
                int count = this.set.get(template);
                f.format("   %3d: count = %d%n", template, count);
            }
        }
    }

    public static interface Counter {
        public void show(Formatter var1);

        public String getName();

        public void addTo(Counter var1);
    }

    public static class Counters {
        List<Counter> counters = new ArrayList<Counter>();
        Map<String, Counter> map = new HashMap<String, Counter>();

        public void add(Counter c) {
            this.counters.add(c);
            this.map.put(c.getName(), c);
        }

        public void show(Formatter f) {
            for (Counter c : this.counters) {
                c.show(f);
            }
        }

        public void count(String name, int value) {
            CounterOfInt counter = (CounterOfInt)this.map.get(name);
            counter.count(value);
        }

        public void countS(String name, String value) {
            CounterOfString counter = (CounterOfString)this.map.get(name);
            counter.count(value);
        }

        public void addTo(Counters sub) {
            for (Counter subC : sub.counters) {
                Counter all = this.map.get(subC.getName());
                all.addTo(subC);
            }
        }

        public Counters makeSubCounters() {
            Counters result = new Counters();
            for (Counter c : this.counters) {
                if (c instanceof CounterOfInt) {
                    result.add(new CounterOfInt(c.getName()));
                    continue;
                }
                result.add(new CounterOfString(c.getName()));
            }
            return result;
        }
    }
}

