/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import thredds.catalog.DataFormatType;
import thredds.catalog.DatasetFilter;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvDataset;
import thredds.catalog.ServiceType;
import thredds.ui.catalog.CatalogChooser;
import thredds.ui.catalog.ThreddsDatasetChooser;
import thredds.ui.catalog.query.QueryChooser;
import thredds.ui.catalog.tools.CatalogCopier;
import thredds.ui.catalog.tools.CatalogEnhancer;
import thredds.ui.catalog.tools.DLCrawler;
import thredds.ui.catalog.tools.TDServerConfigurator;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentDialog;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.TextGetPutPane;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.IO;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.Debug;

public class ThreddsUI
extends JPanel {
    private static final String VIEWER_SIZE = "ViewerSize";
    private static final String SOURCE_WINDOW_SIZE = "SourceWindowSize";
    private static final String XML_WINDOW_SIZE = "XmlWindowSize";
    private PreferencesExt store;
    private Component parent;
    private ThreddsDatasetChooser datasetChooser = null;
    private CatalogEnhancer catEditor = null;
    private CatalogCopier catCopier = null;
    private DLCrawler catCrawler = null;
    private TDServerConfigurator serverConfigure = null;
    private TextGetPutPane sourcePane;
    private JTabbedPane tabbedPane;
    private TextHistoryPane xmlPane;
    private IndependentDialog xmlWindow = null;
    private IndependentWindow sourceWindow = null;
    FileManager fileChooser = null;
    private boolean debugSelection = false;
    private boolean debugTab = false;

    public ThreddsUI(JFrame parent, PreferencesExt store) {
        this.store = store;
        this.parent = parent;
        this.enableEvents(64L);
        Dimension d = (Dimension)store.getBean(VIEWER_SIZE, null);
        int defaultWidth = 700;
        int defaultHeight = 350;
        this.setPreferredSize(d != null ? d : new Dimension(defaultWidth, defaultHeight));
        try {
            this.makeActionsSystem();
            this.makeActionsDataset();
            this.makeUI();
        }
        catch (Exception e) {
            System.out.println("UI creation Exception");
            e.printStackTrace();
        }
        PreferencesExt fcPrefs = (PreferencesExt)store.node("FileManager");
        FileFilter[] filters = new FileFilter[]{new FileManager.NetcdfExtFilter()};
        this.fileChooser = new FileManager(parent, null, filters, fcPrefs);
    }

    private void makeUI() throws Exception {
        this.tabbedPane = new JTabbedPane(1);
        this.datasetChooser = this.makeDatasetChooser();
        this.tabbedPane.addTab("Catalog Crawler", new JLabel("Catalog Crawler"));
        this.tabbedPane.addTab("Catalog Enhancer", new JLabel("Catalog Enhancer"));
        this.tabbedPane.addTab("Catalog Copier", new JLabel("Catalog Copier"));
        this.tabbedPane.addTab("TDS Configure", new JLabel("TDS Configure"));
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component c = ThreddsUI.this.tabbedPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ThreddsUI.this.tabbedPane.getSelectedIndex();
                    String title = ThreddsUI.this.tabbedPane.getTitleAt(idx);
                    ThreddsUI.this.makeComponent(ThreddsUI.this.tabbedPane, title);
                }
            }
        });
        this.sourcePane = new TextGetPutPane((PreferencesExt)this.store.node("getputPane"));
        this.sourceWindow = new IndependentWindow("Source", BAMutil.getImage("thredds"), this.sourcePane);
        this.sourceWindow.setBounds((Rectangle)this.store.getBean(SOURCE_WINDOW_SIZE, new Rectangle(50, 50, 725, 450)));
        this.xmlPane = new TextHistoryPane(false);
        this.xmlWindow = new IndependentDialog(null, false, "XML data", this.xmlPane);
        this.xmlWindow.setBounds((Rectangle)this.store.getBean(XML_WINDOW_SIZE, new Rectangle(50, 50, 725, 450)));
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    private ThreddsDatasetChooser makeDatasetChooser() {
        this.datasetChooser = new ThreddsDatasetChooser((PreferencesExt)this.store.node("ThreddsDatasetChooser"), this.tabbedPane);
        if (Debug.isSet("System/filterDataset")) {
            this.datasetChooser.setDatasetFilter((DatasetFilter)new DatasetFilter.ByServiceType(ServiceType.DODS));
        }
        this.datasetChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("InvAccess")) {
                    ThreddsUI.this.firePropertyChangeEvent(e);
                    return;
                }
                if (e.getPropertyName().equals("Dataset") || e.getPropertyName().equals("CoordSys") || e.getPropertyName().equals("File")) {
                    DataFormatType format;
                    InvDataset ds = (InvDataset)e.getNewValue();
                    InvAccess access = ds.getAccess(ServiceType.HTTPServer);
                    if (access != null && ((format = access.getDataFormatType()) == DataFormatType.PLAIN || format == DataFormatType.XML)) {
                        String urlString = access.getWrappedUrlName();
                        IO.readURLcontents((String)urlString);
                        ThreddsUI.this.xmlPane.setText(IO.readURLcontents((String)urlString));
                        ThreddsUI.this.xmlPane.gotoTop();
                        ThreddsUI.this.xmlWindow.setVisible(true);
                        return;
                    }
                    ThreddsUI.this.firePropertyChangeEvent(e);
                }
            }
        });
        JButton catSource = new JButton("Source");
        catSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogChooser cc = ThreddsUI.this.datasetChooser.getCatalogChooser();
                String catURL = cc.getCurrentURL();
                if (ThreddsUI.this.debugSelection) {
                    System.out.println("Catalog Source: url = " + catURL);
                }
                ThreddsUI.this.sourcePane.setURL(catURL);
                ThreddsUI.this.sourcePane.gotoTop();
                ThreddsUI.this.sourceWindow.show();
            }
        });
        this.datasetChooser.getCatalogChooser().addButton(catSource);
        QueryChooser queryChooser = this.datasetChooser.getQueryChooser();
        if (queryChooser != null) {
            JButton dcqSource = new JButton("Source");
            dcqSource.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String catURL = ThreddsUI.this.datasetChooser.getQueryChooser().getCurrentURL();
                    ThreddsUI.this.sourcePane.setURL(catURL);
                    ThreddsUI.this.sourcePane.gotoTop();
                    ThreddsUI.this.sourceWindow.show();
                }
            });
            queryChooser.addButton(dcqSource);
            JButton dqcCatSource = new JButton("Source");
            dqcCatSource.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String catURL = ThreddsUI.this.datasetChooser.getQueryChooser().getCatalogChooser().getCurrentURL();
                    System.out.println("DQC Catalog Source: url = " + catURL);
                    ThreddsUI.this.sourcePane.setURL(catURL);
                    ThreddsUI.this.sourcePane.gotoTop();
                    ThreddsUI.this.sourceWindow.show();
                }
            });
            queryChooser.getCatalogChooser().addButton(dqcCatSource);
        }
        return this.datasetChooser;
    }

    private void makeComponent(JTabbedPane parent, String title) {
        JPanel c;
        String cTitle;
        int idx;
        if (parent == null) {
            parent = this.tabbedPane;
        }
        int n = parent.getTabCount();
        for (idx = 0; idx < n && !(cTitle = parent.getTitleAt(idx)).equals(title); ++idx) {
        }
        if (idx >= n) {
            if (this.debugTab) {
                System.out.println("Cant find " + title + " in " + parent);
            }
            return;
        }
        if (title.equals("Catalog Crawler")) {
            c = this.catCrawler = new DLCrawler((PreferencesExt)this.store.node("catCrawler"), parent);
        } else if (title.equals("Catalog Enhancer")) {
            this.catEditor = new CatalogEnhancer((PreferencesExt)this.store.node("catEditor"), parent);
            c = this.catEditor;
        } else if (title.equals("Catalog Copier")) {
            this.catCopier = new CatalogCopier((PreferencesExt)this.store.node("catCopier"), parent);
            c = this.catCopier;
        } else if (title.equals("TDS Configure")) {
            this.serverConfigure = new TDServerConfigurator((PreferencesExt)this.store.node("serverConfigure"), parent);
            c = this.serverConfigure;
        } else {
            System.out.println("tabbedPane unknown component " + title);
            return;
        }
        parent.setComponentAt(idx, c);
        if (this.debugTab) {
            System.out.println("tabbedPane changed " + title + " added ");
        }
    }

    public void storePersistentData() {
        this.store.putBeanObject(VIEWER_SIZE, this.getSize());
        this.store.putBeanObject(SOURCE_WINDOW_SIZE, this.sourceWindow.getBounds());
        if (this.fileChooser != null) {
            this.fileChooser.save();
        }
        if (this.datasetChooser != null) {
            this.datasetChooser.save();
        }
        if (this.sourcePane != null) {
            this.sourcePane.save();
        }
        if (this.catEditor != null) {
            this.catEditor.save();
        }
        if (this.catCrawler != null) {
            this.catCrawler.save();
        }
        if (this.serverConfigure != null) {
            this.serverConfigure.save();
        }
        if (this.catCopier != null) {
            this.catCopier.save();
        }
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        this.firePropertyChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
    }

    public void setDataset(String location) {
        this.datasetChooser.getCatalogChooser().setCatalog(location);
        this.tabbedPane.setSelectedComponent(this.datasetChooser.getCatalogChooser());
    }

    private void makeActionsSystem() {
        AbstractAction clearDebugFlagsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        BAMutil.setActionProperties(clearDebugFlagsAction, null, "Clear Debug Flags", false, 68, -1);
        AbstractAction setDebugFlagsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvCatalogFactory.debugURL = Debug.isSet("InvCatalogFactory/debugURL");
                InvCatalogFactory.debugOpen = Debug.isSet("InvCatalogFactory/debugOpen");
                InvCatalogFactory.debugVersion = Debug.isSet("InvCatalogFactory/debugVersion");
                InvCatalogFactory.showParsedXML = Debug.isSet("InvCatalogFactory/showParsedXML");
                InvCatalogFactory.showStackTrace = Debug.isSet("InvCatalogFactory/showStackTrace");
                InvCatalogFactory.debugXML = Debug.isSet("InvCatalogFactory/debugXML");
                InvCatalogFactory.debugDBurl = Debug.isSet("InvCatalogFactory/debugDBurl");
                InvCatalogFactory.debugXMLopen = Debug.isSet("InvCatalogFactory/debugXMLopen");
                InvCatalogFactory.showCatalogXML = Debug.isSet("InvCatalogFactory/showCatalogXML");
            }
        };
        BAMutil.setActionProperties(setDebugFlagsAction, null, "Set Debug Flags", false, 83, -1);
    }

    private void makeActionsDataset() {
    }
}

