/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.catalog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JOptionPane;
import thredds.catalog.CatalogSetCallback;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSession;
import ucar.nc2.ui.widget.ProgressMonitor;
import ucar.nc2.ui.widget.ProgressMonitorTask;

public class CatalogFactoryCancellable
extends InvCatalogFactory {
    private Component parent;
    private boolean callbackDone = true;
    private boolean taskDone = true;
    private boolean debug = false;
    private OpenCatalogTask openTask;
    private CatalogSetCallback callback;

    public CatalogFactoryCancellable(Component parent, String name, boolean validate) {
        super(name, validate);
        this.parent = parent;
    }

    public void readXMLasynch(String catalogName, CatalogSetCallback callbacker) {
        this.callback = callbacker;
        this.callbackDone = false;
        this.taskDone = false;
        this.openTask = new OpenCatalogTask(catalogName);
        ProgressMonitor pm = new ProgressMonitor(this.openTask, 5000, 5000);
        pm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CatalogFactoryCancellable.this.debug) {
                    System.out.println("ProgressMonitor event  " + e.getActionCommand());
                }
                if (e.getActionCommand().equals("success")) {
                    CatalogFactoryCancellable.this.checkFailure();
                } else {
                    CatalogFactoryCancellable.this.callback.failed();
                }
                CatalogFactoryCancellable.this.callbackDone = true;
            }
        });
        pm.start(this.parent, "Open catalog " + catalogName, 20);
    }

    private void checkFailure() {
        StringBuilder buff = new StringBuilder();
        this.openTask.catalog.check(buff);
        if (this.openTask.catalog.hasFatalError()) {
            String catalogName = this.openTask.catalog.getName();
            JOptionPane.showMessageDialog(null, "Catalog Read Failed on " + catalogName + "\n" + buff.toString());
            this.callback.failed();
            return;
        }
        this.callback.setCatalog(this.openTask.catalog);
    }

    public boolean isBusy() {
        return !this.taskDone || !this.callbackDone;
    }

    private class OpenCatalogTask
    extends ProgressMonitorTask {
        String catalogName;
        URI catalogURI;
        InvCatalogImpl catalog;

        OpenCatalogTask(String catalogName) {
            this.catalogName = catalogName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.catalogURI = new URI(this.catalogName);
            }
            catch (URISyntaxException e) {
                this.catalog = new InvCatalogImpl(this.catalogName, null, null);
                this.catalog.appendErrorMessage("**Fatal:  InvCatalogFactory.readXML URISyntaxException on URL (" + this.catalogName + ") " + e.getMessage() + "\n", true);
                this.success = false;
                this.done = true;
                CatalogFactoryCancellable.this.taskDone = true;
                return;
            }
            if (CatalogFactoryCancellable.this.debug) {
                System.out.println("CatalogFactoryCancellable run task on " + this.catalogName);
            }
            if (this.catalogURI.getScheme() != null && this.catalogURI.getScheme().equals("file")) {
                this.catalog = CatalogFactoryCancellable.super.readXML(this.catalogURI);
                this.success = !this.cancel;
                this.done = true;
                CatalogFactoryCancellable.this.taskDone = true;
                return;
            }
            HTTPMethod m = null;
            try (HTTPSession client = null;){
                client = HTTPFactory.newSession((String)this.catalogName);
                m = HTTPFactory.Get((HTTPSession)client);
                int statusCode = m.execute();
                if (statusCode == 404) {
                    throw new FileNotFoundException(m.getPath() + " " + m.getStatusLine());
                }
                if (statusCode >= 300) {
                    throw new IOException(m.getPath() + " " + m.getStatusLine());
                }
                InputStream stream = m.getResponseBodyAsStream();
                this.catalog = CatalogFactoryCancellable.super.readXML(stream, this.catalogURI);
            }
            this.success = !this.cancel;
            this.done = true;
            CatalogFactoryCancellable.this.taskDone = true;
        }
    }
}

