/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.catalog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import thredds.catalog.CatalogSetCallback;
import thredds.catalog.DatasetFilter;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import thredds.catalog.InvDocumentation;
import thredds.catalog.ServiceType;
import thredds.ui.catalog.CatalogFactoryCancellable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.PopupMenu;

public class CatalogTreeView
extends JPanel
implements CatalogSetCallback {
    private InvCatalogImpl catalog;
    private DatasetFilter filter = null;
    private boolean accessOnly = true;
    private String catalogURL = "";
    private boolean openCatalogReferences = true;
    private boolean openDatasetScans = true;
    private JTree tree = new JTree(new DefaultTreeModel(new DefaultMutableTreeNode(null, false)));
    private InvCatalogTreeModel model;
    private boolean debugRef = false;
    private boolean debugTree = false;
    private CatalogFactoryCancellable factory = null;

    public CatalogTreeView() {
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setToggleClickCount(1);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                int selRow = CatalogTreeView.this.tree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    CatalogTreeView.this.checkForCatref();
                    InvCatalogTreeNode node = (InvCatalogTreeNode)CatalogTreeView.this.tree.getLastSelectedPathComponent();
                    if (node != null) {
                        CatalogTreeView.this.firePropertyChangeEvent(new PropertyChangeEvent(this, "Selection", null, node.ds));
                    }
                }
                if (selRow != -1 && e.getClickCount() == 2) {
                    CatalogTreeView.this.acceptSelected();
                }
            }
        });
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent evt) {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent evt) {
                InvCatalogTreeNode node = (InvCatalogTreeNode)evt.getPath().getLastPathComponent();
                if (node.ds instanceof InvCatalogRef) {
                    boolean isDatasetScan;
                    InvCatalogRef catref = (InvCatalogRef)node.ds;
                    boolean bl = isDatasetScan = catref.findProperty("DatasetScan") != null;
                    if (!catref.isRead() && CatalogTreeView.this.openCatalogReferences && (CatalogTreeView.this.openDatasetScans || !isDatasetScan)) {
                        node.readCatref();
                    }
                }
            }
        });
        PopupMenu varPopup = new PopupMenu(this.tree, "Options");
        varPopup.addAction("Open all children", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvCatalogTreeNode node = (InvCatalogTreeNode)CatalogTreeView.this.tree.getLastSelectedPathComponent();
                if (node != null) {
                    CatalogTreeView.this.open(node, true);
                }
            }
        });
        varPopup.addAction("Open one level of children", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvCatalogTreeNode node = (InvCatalogTreeNode)CatalogTreeView.this.tree.getLastSelectedPathComponent();
                if (node != null) {
                    node.makeChildren(true);
                    for (InvCatalogTreeNode child : node.children) {
                        CatalogTreeView.this.tree.expandPath(CatalogTreeView.this.makeTreePath(child));
                    }
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    public JTree getJTree() {
        return this.tree;
    }

    public void setDatasetFilter(DatasetFilter filter) {
        this.filter = filter;
    }

    public void setOpenCatalogReferences(boolean openCatalogReferences) {
        this.openCatalogReferences = openCatalogReferences;
    }

    public void setOpenDatasetScans(boolean openDatasetScans) {
        this.openDatasetScans = openDatasetScans;
    }

    private void firePropertyChangeEvent(InvDataset ds) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "Dataset", null, ds);
        this.firePropertyChangeEvent(event);
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        this.firePropertyChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
    }

    public void setAccessOnly(boolean accessOnly) {
        this.accessOnly = accessOnly;
    }

    public InvCatalogImpl getCatalog() {
        return this.catalog;
    }

    public String getCatalogURL() {
        return this.catalogURL;
    }

    private void setCatalogURL(String catalogURL) {
        this.catalogURL = catalogURL;
    }

    public InvDataset getSelectedDataset() {
        InvCatalogTreeNode tnode = this.getSelectedNode();
        return tnode == null ? null : tnode.ds;
    }

    private InvCatalogTreeNode getSelectedNode() {
        Object node = this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        if (!(node instanceof InvCatalogTreeNode)) {
            return null;
        }
        return (InvCatalogTreeNode)node;
    }

    public void setSelectedDataset(InvDatasetImpl ds) {
        if (ds == null) {
            return;
        }
        TreePath path = this.makePath(ds);
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    TreePath makePath(InvDatasetImpl ds) {
        TreeNode node = (TreeNode)ds.getUserProperty((Object)"TreeNode");
        return this.makeTreePath(node);
    }

    TreePath makeTreePath(TreeNode node) {
        ArrayList<TreeNode> path = new ArrayList<TreeNode>();
        path.add(node);
        for (TreeNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            path.add(0, parent);
        }
        Object[] paths = path.toArray();
        return new TreePath(paths);
    }

    public void openAll(boolean includeCatref) {
        if (this.catalog == null) {
            return;
        }
        this.open((InvCatalogTreeNode)this.model.getRoot(), includeCatref);
        this.tree.repaint();
    }

    private void open(InvCatalogTreeNode node, boolean includeCatref) {
        if (node == null) {
            return;
        }
        node.makeChildren(includeCatref);
        this.tree.expandPath(this.makeTreePath(node));
        Enumeration e = node.children();
        while (e.hasMoreElements()) {
            InvCatalogTreeNode child = (InvCatalogTreeNode)e.nextElement();
            this.open(child, includeCatref);
        }
    }

    void checkForCatref() {
        InvDataset ds = this.getSelectedDataset();
        if (ds == null) {
            return;
        }
        if (ds instanceof InvCatalogRef) {
            InvCatalogTreeNode tnode;
            boolean isDatasetScan;
            InvCatalogRef catref = (InvCatalogRef)ds;
            boolean bl = isDatasetScan = catref.findProperty("DatasetScan") != null;
            if (!catref.isRead() && this.openCatalogReferences && (this.openDatasetScans || !isDatasetScan) && (tnode = this.getSelectedNode()) != null) {
                tnode.readCatref();
            }
        }
    }

    void acceptSelected() {
        InvDataset ds = this.getSelectedDataset();
        if (ds == null) {
            return;
        }
        if (this.accessOnly && !ds.hasAccess()) {
            return;
        }
        this.firePropertyChangeEvent(ds);
    }

    public void setCatalog(String catalogName) {
        this.getCatalogFactory().readXMLasynch(catalogName, this);
    }

    private CatalogFactoryCancellable getCatalogFactory() {
        if (this.factory == null || this.factory.isBusy()) {
            this.factory = new CatalogFactoryCancellable(this, "cancel", true);
        }
        return this.factory;
    }

    public void failed() {
    }

    public void redisplay() {
        this.setCatalog(this.catalog);
    }

    public void setCatalog(InvCatalogImpl catalog) {
        String id;
        InvDataset dataset;
        if (catalog == null) {
            return;
        }
        String catalogName = catalog.getBaseURI().toString();
        StringBuilder buff = new StringBuilder();
        if (!catalog.check(buff)) {
            JOptionPane.showMessageDialog(this, "Invalid catalog <" + catalogName + ">\n" + buff.toString());
            System.out.println("Invalid catalog <" + catalogName + ">\n" + buff.toString());
            this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(null, false)));
            return;
        }
        if (this.filter != null) {
            catalog.filter(this.filter);
        }
        this.catalog = catalog;
        this.setCatalogURL(catalogName);
        this.model = new InvCatalogTreeModel(catalog.getDataset());
        this.tree.setModel(this.model);
        int pos = catalogName.indexOf(35);
        if (pos >= 0 && (dataset = catalog.findDatasetByID(id = catalogName.substring(pos + 1))) != null) {
            this.setSelectedDataset((InvDatasetImpl)dataset);
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, "Selection", null, dataset));
        }
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, "Catalog", null, catalogName));
    }

    private void showNode(TreeModel tree, Object node) {
        if (node == null) {
            return;
        }
        InvCatalogTreeNode tnode = (InvCatalogTreeNode)node;
        InvDataset cp = tnode.ds;
        System.out.println(" node= " + cp.getFullName() + " leaf= " + tree.isLeaf(node));
        for (int i = 0; i < tree.getChildCount(node); ++i) {
            this.showNode(tree, tree.getChild(node, i));
        }
    }

    private static class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon refIcon = BAMutil.getIcon("CatalogRef", true);
        ImageIcon refReadIcon = BAMutil.getIcon("CatalogRefRead", true);
        ImageIcon gridIcon = BAMutil.getIcon("GridData", true);
        ImageIcon imageIcon = BAMutil.getIcon("ImageData", true);
        ImageIcon dqcIcon = BAMutil.getIcon("DQCData", true);
        ImageIcon dsScanIcon = BAMutil.getIcon("DatasetScan", true);

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof InvCatalogTreeNode) {
                InvCatalogTreeNode node = (InvCatalogTreeNode)value;
                InvDataset ds = node.ds;
                String doc = this.makeDocs(ds.getDocumentation());
                if (doc != null) {
                    ((JComponent)c).setToolTipText(doc);
                }
                if (ds instanceof InvDatasetScan) {
                    this.setIcon(this.dsScanIcon);
                } else if (ds instanceof InvCatalogRef) {
                    if (((InvCatalogRef)ds).isRead()) {
                        this.setIcon(this.refReadIcon);
                    } else {
                        this.setIcon(this.refIcon);
                    }
                } else if (leaf) {
                    if (null != ds.getAccess(ServiceType.QC)) {
                        this.setIcon(this.dqcIcon);
                    } else if (ds.getDataType() == FeatureType.GRID) {
                        this.setIcon(this.gridIcon);
                    } else if (ds.getDataType() == FeatureType.IMAGE) {
                        this.setIcon(this.imageIcon);
                    }
                }
            }
            return c;
        }

        private String makeDocs(List<InvDocumentation> docs) {
            if (docs == null) {
                return null;
            }
            StringBuilder sbuff = new StringBuilder(1000);
            for (InvDocumentation doc : docs) {
                sbuff.append(doc.getInlineContent());
            }
            return sbuff.toString();
        }
    }

    private class InvCatalogTreeNode
    implements TreeNode,
    CatalogSetCallback {
        InvDataset ds;
        private InvCatalogTreeNode parent;
        private ArrayList<InvCatalogTreeNode> children = null;
        private boolean isReading = false;

        InvCatalogTreeNode(InvCatalogTreeNode parent, InvDatasetImpl ds) {
            this.parent = parent;
            this.ds = ds;
            ds.setUserProperty((Object)"TreeNode", (Object)this);
            if (CatalogTreeView.this.debugTree) {
                System.out.println("new=" + ds.getName() + " ");
            }
            CatalogTreeView.this.firePropertyChangeEvent(new PropertyChangeEvent(this, "TreeNode", null, ds));
        }

        public Enumeration children() {
            if (CatalogTreeView.this.debugTree) {
                System.out.println("children=" + this.ds.getName() + " ");
            }
            if (this.children == null) {
                return Collections.enumeration(new ArrayList());
            }
            return Collections.enumeration(this.children);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int index) {
            if (CatalogTreeView.this.debugTree) {
                System.out.println("getChildAt=" + this.ds.getName() + " " + index);
            }
            return this.children.get(index);
        }

        @Override
        public int getChildCount() {
            if (this.children == null) {
                this.makeChildren(false);
            }
            if (this.children == null) {
                return 0;
            }
            return this.children.size();
        }

        void makeChildren(boolean force) {
            if (this.children == null) {
                if (this.ds instanceof InvCatalogRef) {
                    InvCatalogRef catref = (InvCatalogRef)this.ds;
                    if (CatalogTreeView.this.debugRef) {
                        System.out.println("getChildCount on catref=" + this.ds.getName() + " " + catref.isRead() + " " + this.isReading);
                    }
                    if (!catref.isRead() && !force) {
                        return;
                    }
                }
                if (CatalogTreeView.this.debugRef) {
                    System.out.println("getChildCount on ds=" + this.ds.getName() + " ");
                }
                this.children = new ArrayList();
                for (InvDataset nested : this.ds.getDatasets()) {
                    this.children.add(new InvCatalogTreeNode(this, (InvDatasetImpl)nested));
                }
            }
        }

        void readCatref() {
            InvCatalogRef catref = (InvCatalogRef)this.ds;
            if (CatalogTreeView.this.debugRef) {
                System.out.println("readCatref on =" + this.ds.getName() + " " + this.isReading);
            }
            if (!this.isReading) {
                this.isReading = true;
                catref.readAsynch((InvCatalogFactory)CatalogTreeView.this.getCatalogFactory(), (CatalogSetCallback)this);
            }
        }

        @Override
        public int getIndex(TreeNode child) {
            if (CatalogTreeView.this.debugTree) {
                System.out.println("getIndex=" + this.ds.getName() + " " + child);
            }
            return this.children.indexOf(child);
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            InvCatalogRef catref;
            if (CatalogTreeView.this.debugTree) {
                System.out.println("isLeaf=" + this.ds.getName());
            }
            if (this.ds instanceof InvCatalogRef && !(catref = (InvCatalogRef)this.ds).isRead()) {
                return false;
            }
            return !this.ds.hasNestedDatasets();
        }

        public String toString() {
            return this.ds.getName();
        }

        public void setCatalog(InvCatalogImpl catalog) {
            this.children = new ArrayList();
            List datasets = this.ds.getDatasets();
            int[] childIndices = new int[datasets.size()];
            for (int count = 0; count < datasets.size(); ++count) {
                this.children.add(new InvCatalogTreeNode(this, (InvDatasetImpl)datasets.get(count)));
                childIndices[count] = count;
            }
            CatalogTreeView.this.model.nodesWereInserted(this, childIndices);
            CatalogTreeView.this.tree.expandPath(CatalogTreeView.this.makeTreePath(this));
            if (CatalogTreeView.this.debugRef) {
                System.out.println("model.nodeStructureChanged on " + this);
            }
            this.isReading = false;
        }

        public void failed() {
            if (CatalogTreeView.this.debugRef) {
                System.out.println("failed called on " + this);
            }
            this.isReading = false;
        }
    }

    private class InvCatalogTreeModel
    extends DefaultTreeModel {
        InvCatalogTreeModel(InvDatasetImpl top) {
            super(new InvCatalogTreeNode(null, top), false);
        }
    }
}

