/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.monitor;

import java.io.File;
import java.io.IOException;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import thredds.ui.monitor.LogLocalManager;
import thredds.ui.monitor.ManageForm;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSession;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.net.HttpClientManager;

public class TdsDownloader {
    private static final String latestServletLog = "threddsServlet.log";
    private ManageForm.Data config;
    private Type type;
    private File localDir;
    private JTextArea ta;
    private CancelTask cancel;
    private HTTPSession session;

    TdsDownloader(JTextArea ta, ManageForm.Data config, Type type) throws IOException {
        this.ta = ta;
        this.config = config;
        this.type = type;
        this.session = HTTPFactory.newSession((String)config.getServerPrefix());
        this.localDir = LogLocalManager.getDirectory(config.server, type.toString());
        if (!this.localDir.exists() && !this.localDir.mkdirs()) {
            ta.setText(String.format("Failed to create local directory in = %s%n%n", this.localDir));
            return;
        }
    }

    public void getRemoteFiles(CancelTask _cancel) {
        this.cancel = _cancel;
        String urls = this.config.getServerPrefix() + "/thredds/admin/log/" + (Object)((Object)this.type) + "/";
        this.ta.append(String.format("Download URL = %s%n", urls));
        String contents = null;
        try (HTTPMethod method = HTTPFactory.Get((HTTPSession)this.session, (String)urls);){
            int statusCode = method.execute();
            if (statusCode == 200) {
                contents = method.getResponseAsString();
            }
            if (contents == null || contents.length() == 0) {
                this.ta.append(String.format("Failed to get logs at URL = %s%n%n", urls));
                return;
            }
            this.ta.append(String.format("Logs at URL = %s%n%s%n", urls, contents));
        }
        catch (Throwable t) {
            this.ta.append(String.format("Failed to get logs at URL = %s error = %s%n%n", urls, t.getMessage()));
            t.printStackTrace();
            return;
        }
        final String list = contents;
        SwingWorker<String, Void> worker = new SwingWorker<String, Void>(){

            @Override
            protected String doInBackground() throws Exception {
                try {
                    String[] lines;
                    TdsDownloader.this.ta.append(String.format("Local log files stored in = %s%n%n", TdsDownloader.this.localDir));
                    for (String line : lines = list.split("\n")) {
                        new RemoteLog(line.trim());
                        if (!TdsDownloader.this.cancel.isCancel()) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return null;
            }

            @Override
            public void done() {
                if (TdsDownloader.this.cancel.isCancel()) {
                    TdsDownloader.this.ta.append(String.format("Download was cancelled for %s%n", new Object[]{TdsDownloader.this.type}));
                } else {
                    TdsDownloader.this.ta.append(String.format("Download complete for %s%n", new Object[]{TdsDownloader.this.type}));
                }
            }
        };
        worker.execute();
    }

    private class RemoteLog {
        String name;
        long size;
        File localFile;

        RemoteLog(String line) throws IOException {
            String[] tokes = line.split(" ");
            this.name = tokes[0];
            this.size = Long.parseLong(tokes[1]);
            this.localFile = new File(TdsDownloader.this.localDir, this.name);
            if (!this.localFile.exists() || this.localFile.length() > this.size || this.name.equals(TdsDownloader.latestServletLog)) {
                TdsDownloader.this.ta.append(String.format("Read RemoteLog length=%6d Kb for %s%n", this.size / 1000L, this.name));
                this.read();
            } else if (this.localFile.length() < this.size) {
                TdsDownloader.this.ta.append(String.format("Append RemoteLog length=%6d Kb to local=%6d Kb for %s%n", this.size / 1000L, this.localFile.length() / 1000L, this.name));
                this.append();
            } else {
                TdsDownloader.this.ta.append(String.format("Ok RemoteLog length=%6d local=%6d (kb) for %s%n", this.size / 1000L, this.localFile.length() / 1000L, this.name));
            }
            TdsDownloader.this.ta.setCaretPosition(TdsDownloader.this.ta.getText().length());
        }

        void read() throws IOException {
            String urls = TdsDownloader.this.config.getServerPrefix() + "/thredds/admin/log/" + (Object)((Object)TdsDownloader.this.type) + "/" + this.name;
            TdsDownloader.this.ta.append(String.format(" reading %s to %s%n", urls, this.localFile.getPath()));
            HttpClientManager.copyUrlContentsToFile(TdsDownloader.this.session, urls, this.localFile);
        }

        void append() throws IOException {
            long got;
            String urls = TdsDownloader.this.config.getServerPrefix() + "/thredds/admin/log/" + (Object)((Object)TdsDownloader.this.type) + "/" + this.name;
            long start = this.localFile.length();
            long want = this.size - start;
            if (want == (got = HttpClientManager.appendUrlContentsToFile(TdsDownloader.this.session, urls, this.localFile, start, this.size))) {
                TdsDownloader.this.ta.append(String.format(" append %d bytes to %s %n", got, this.localFile.getPath()));
            } else {
                TdsDownloader.this.ta.append(String.format(" *** append got=%d want=%d bytes to %s %n", got, want, this.localFile.getPath()));
            }
        }

        public String toString() {
            return "RemoteLog{name='" + this.name + '\'' + ", size=" + this.size + '}';
        }
    }

    public static enum Type {
        access,
        thredds;

    }
}

