/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NCdumpW;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dt.grid.GridCoordSys;
import ucar.nc2.dt.radial.RadialCoordSys;
import ucar.nc2.ft.grid.impl.CoverageCSFactory;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.unidata.util.Parameter;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class CoordSysTable
extends JPanel {
    private PreferencesExt prefs;
    private NetcdfDataset ds;
    private BeanTable varTable;
    private BeanTable csTable;
    private BeanTable axisTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private IndependentWindow attWindow;
    private Formatter parseInfo = new Formatter();
    private BeanTable attTable;

    public CoordSysTable(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        if (buttPanel != null) {
            AbstractAction attAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CoordSysTable.this.showAtts();
                }
            };
            BAMutil.setActionProperties(attAction, "FontDecr", "global attributes", false, 65, -1);
            BAMutil.addActionToContainer(buttPanel, attAction);
        }
        this.varTable = new BeanTable(VariableBean.class, (PreferencesExt)prefs.node("VariableBeans"), false);
        this.varTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VariableBean vb = (VariableBean)CoordSysTable.this.varTable.getSelectedBean();
                if (null != vb.firstCoordSys) {
                    CoordSysTable.this.setSelectedCoordinateSystem(vb.firstCoordSys);
                }
            }
        });
        this.csTable = new BeanTable(CoordinateSystemBean.class, (PreferencesExt)prefs.node("CoordinateSystemBean"), false);
        this.csTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CoordinateSystemBean csb = (CoordinateSystemBean)CoordSysTable.this.csTable.getSelectedBean();
                CoordSysTable.this.setSelectedCoordinateAxes(csb.coordSys);
            }
        });
        this.axisTable = new BeanTable(AxisBean.class, (PreferencesExt)prefs.node("CoordinateAxisBean"), false);
        PopupMenu varPopup = new PopupMenu(this.varTable.getJTable(), "Options");
        varPopup.addAction("Show Declaration", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariableBean vb = (VariableBean)CoordSysTable.this.varTable.getSelectedBean();
                Variable v = CoordSysTable.this.ds.findVariable(vb.getName());
                if (v == null) {
                    return;
                }
                CoordSysTable.this.infoTA.clear();
                CoordSysTable.this.infoTA.appendLine(v.toString());
                CoordSysTable.this.infoTA.appendLine(CoordSysTable.this.showMissing(v));
                CoordSysTable.this.infoTA.gotoTop();
                CoordSysTable.this.infoWindow.show();
            }
        });
        varPopup.addAction("Try as Grid", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariableBean vb = (VariableBean)CoordSysTable.this.varTable.getSelectedBean();
                VariableEnhanced v = (VariableEnhanced)CoordSysTable.this.ds.findVariable(vb.getName());
                if (v == null) {
                    return;
                }
                CoordSysTable.this.infoTA.clear();
                CoordSysTable.this.infoTA.appendLine(CoordSysTable.this.tryGrid(v));
                CoordSysTable.this.infoTA.gotoTop();
                CoordSysTable.this.infoWindow.show();
            }
        });
        PopupMenu csPopup = new PopupMenu(this.csTable.getJTable(), "Options");
        csPopup.addAction("Show CoordSys", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordinateSystemBean csb = (CoordinateSystemBean)CoordSysTable.this.csTable.getSelectedBean();
                CoordinateSystem coordSys = csb.coordSys;
                CoordSysTable.this.infoTA.clear();
                CoordSysTable.this.infoTA.appendLine("Coordinate System = " + coordSys.getName());
                for (CoordinateAxis axis : coordSys.getCoordinateAxes()) {
                    CoordSysTable.this.infoTA.appendLine("  " + axis.getAxisType() + " " + axis.writeCDL(true, false));
                }
                CoordSysTable.this.infoTA.appendLine(" Coordinate Transforms");
                for (CoordinateTransform ct : coordSys.getCoordinateTransforms()) {
                    ProjectionCT pct;
                    CoordSysTable.this.infoTA.appendLine("  " + ct.getName() + " type=" + ct.getTransformType());
                    for (Parameter p : ct.getParameters()) {
                        CoordSysTable.this.infoTA.appendLine("    " + p);
                    }
                    if (ct instanceof ProjectionCT && (pct = (ProjectionCT)ct).getProjection() != null) {
                        CoordSysTable.this.infoTA.appendLine("    impl.class= " + pct.getProjection().getClass().getName());
                        pct.getProjection();
                    }
                    if (!(ct instanceof VerticalCT)) continue;
                    VerticalCT vct = (VerticalCT)ct;
                    CoordSysTable.this.infoTA.appendLine("  VerticalCT= " + vct);
                }
                CoordSysTable.this.infoTA.gotoTop();
                CoordSysTable.this.infoWindow.show();
            }
        });
        PopupMenu axisPopup = new PopupMenu(this.axisTable.getJTable(), "Options");
        axisPopup.addAction("Show Declaration", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisBean bean = (AxisBean)CoordSysTable.this.axisTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                VariableDS axis = (VariableDS)CoordSysTable.this.ds.findVariable(bean.getName());
                if (axis == null) {
                    return;
                }
                CoordSysTable.this.infoTA.clear();
                CoordSysTable.this.infoTA.appendLine(axis.toString());
                CoordSysTable.this.infoTA.appendLine(CoordSysTable.this.showMissing((Variable)axis));
                CoordSysTable.this.infoTA.gotoTop();
                CoordSysTable.this.infoWindow.show();
            }
        });
        axisPopup.addAction("Show Values", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisBean bean = (AxisBean)CoordSysTable.this.axisTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                CoordSysTable.this.infoTA.clear();
                CoordSysTable.this.showValues(bean.axis);
                CoordSysTable.this.infoTA.gotoTop();
                CoordSysTable.this.infoWindow.show();
            }
        });
        axisPopup.addAction("Show Value Differences", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisBean bean = (AxisBean)CoordSysTable.this.axisTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                CoordSysTable.this.infoTA.clear();
                CoordSysTable.this.showValueDiffs(bean.axis);
                CoordSysTable.this.infoTA.gotoTop();
                CoordSysTable.this.infoWindow.show();
            }
        });
        axisPopup.addAction("Show Values as Date", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisBean bean = (AxisBean)CoordSysTable.this.axisTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                CoordSysTable.this.infoTA.clear();
                CoordSysTable.this.showValuesAsDates(bean.axis);
                CoordSysTable.this.infoTA.gotoTop();
                CoordSysTable.this.infoWindow.show();
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.split = new JSplitPane(0, false, this.varTable, this.csTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.split2 = new JSplitPane(0, false, this.split, this.axisTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split2, "Center");
    }

    public void showAtts() {
        if (this.ds == null) {
            return;
        }
        if (this.attTable == null) {
            this.attTable = new BeanTable(AttributeBean.class, (PreferencesExt)this.prefs.node("AttributeBeans"), false);
            PopupMenu varPopup = new PopupMenu(this.attTable.getJTable(), "Options");
            varPopup.addAction("Show Attribute", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeBean bean = (AttributeBean)CoordSysTable.this.attTable.getSelectedBean();
                    if (bean != null) {
                        CoordSysTable.this.infoTA.setText(bean.att.toString());
                        CoordSysTable.this.infoTA.gotoTop();
                        CoordSysTable.this.infoWindow.show();
                    }
                }
            });
            this.attWindow = new IndependentWindow("Global Attributes", BAMutil.getImage("netcdfUI"), this.attTable);
            this.attWindow.setBounds((Rectangle)this.prefs.getBean("AttWindowBounds", new Rectangle(300, 100, 500, 800)));
        }
        ArrayList<AttributeBean> attlist = new ArrayList<AttributeBean>();
        for (Attribute att : this.ds.getGlobalAttributes()) {
            attlist.add(new AttributeBean(att));
        }
        this.attTable.setBeans(attlist);
        this.attWindow.show();
    }

    private void showValues(CoordinateAxis axis) {
        try {
            if (axis instanceof CoordinateAxis1D && axis.isNumeric()) {
                CoordinateAxis1D axis1D = (CoordinateAxis1D)axis;
                this.printArray("midpoints=", axis1D.getCoordValues());
                if (!axis1D.isInterval()) {
                    this.printArray("edges=", axis1D.getCoordEdges());
                } else {
                    this.printArray("bound1=", axis1D.getBound1());
                    this.printArray("bound2=", axis1D.getBound2());
                    Formatter f = new Formatter();
                    double[] mid = axis1D.getCoordValues();
                    double[] b1 = axis1D.getBound1();
                    double[] b2 = axis1D.getBound2();
                    for (int i = 0; i < b1.length; ++i) {
                        f.format("%f (%f,%f) = %f%n", mid[i], b1[i], b2[i], b2[i] - b1[i]);
                    }
                    this.infoTA.appendLine(f.toString());
                }
            } else if (axis instanceof CoordinateAxis2D && axis.isNumeric()) {
                this.infoTA.appendLine(NCdumpW.printVariableData((VariableIF)axis, null));
                this.showValues2D((CoordinateAxis2D)axis);
            } else {
                this.infoTA.appendLine(NCdumpW.printVariableData((VariableIF)axis, null));
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.infoTA.appendLine(e1.getMessage());
        }
    }

    private void showValues2D(CoordinateAxis2D axis2D) {
        Formatter f = new Formatter();
        if (axis2D.isInterval()) {
            ArrayDouble.D2 coords = axis2D.getCoordValuesArray();
            ArrayDouble.D3 bounds = axis2D.getCoordBoundsArray();
            if (bounds == null) {
                this.infoTA.appendLine("No bounds for interval " + axis2D.getFullName());
                return;
            }
            IndexIterator coordIter = coords.getIndexIterator();
            IndexIterator boundsIter = bounds.getIndexIterator();
            while (coordIter.hasNext()) {
                double coordValue = coordIter.getDoubleNext();
                if (!boundsIter.hasNext()) break;
                double bounds1 = boundsIter.getDoubleNext();
                if (boundsIter.hasNext()) {
                    double bounds2 = boundsIter.getDoubleNext();
                    f.format("%f (%f,%f) = %f%n", coordValue, bounds1, bounds2, bounds2 - bounds1);
                    continue;
                }
                break;
            }
        } else {
            ArrayDouble.D2 coords = axis2D.getCoordValuesArray();
            IndexIterator coordIter = coords.getIndexIterator();
            while (coordIter.hasNext()) {
                double coordValue = coordIter.getDoubleNext();
                f.format("%f%n", coordValue);
            }
        }
        this.infoTA.appendLine(f.toString());
    }

    private void showValueDiffs(CoordinateAxis axis) {
        if (!axis.isNumeric()) {
            return;
        }
        try {
            if (axis instanceof CoordinateAxis1D) {
                CoordinateAxis1D axis1D = (CoordinateAxis1D)axis;
                double[] mids = axis1D.getCoordValues();
                for (int i = 0; i < mids.length - 1; ++i) {
                    mids[i] = mids[i + 1] - mids[i];
                }
                mids[mids.length - 1] = 0.0;
                this.printArray("midpoint differences=", mids);
            } else if (axis instanceof CoordinateAxis2D) {
                CoordinateAxis2D axis2D = (CoordinateAxis2D)axis;
                ArrayDouble.D2 mids = axis2D.getCoordValuesArray();
                int[] shape = mids.getShape();
                ArrayDouble.D2 diffx = (ArrayDouble.D2)Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{shape[0], shape[1] - 1});
                for (int j = 0; j < shape[0]; ++j) {
                    for (int i = 0; i < shape[1] - 1; ++i) {
                        double diff = mids.get(j, i + 1) - mids.get(j, i);
                        diffx.set(j, i, diff);
                    }
                }
                this.infoTA.appendLine(NCdumpW.toString((Array)diffx, (String)"diff in x", null));
                ArrayDouble.D2 diffy = (ArrayDouble.D2)Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{shape[0] - 1, shape[1]});
                for (int j = 0; j < shape[0] - 1; ++j) {
                    for (int i = 0; i < shape[1]; ++i) {
                        double diff = mids.get(j + 1, i) - mids.get(j, i);
                        diffy.set(j, i, diff);
                    }
                }
                this.infoTA.appendLine("\n\n\n");
                this.infoTA.appendLine(NCdumpW.toString((Array)diffy, (String)"diff in y", null));
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            this.infoTA.appendLine(e1.getMessage());
        }
    }

    private void showValuesAsDates(CoordinateAxis axis) {
        String units = axis.getUnitsString();
        String cal = this.getCalendarAttribute((VariableEnhanced)axis);
        CalendarDateUnit cdu = CalendarDateUnit.of((String)cal, (String)units);
        try {
            this.infoTA.appendLine(units);
            this.infoTA.appendLine(NCdumpW.printVariableData((VariableIF)axis, null));
            if (axis.getDataType().isNumeric()) {
                if (axis instanceof CoordinateAxis2D) {
                    this.showDates2D((CoordinateAxis2D)axis, cdu);
                } else if (axis instanceof CoordinateAxis1D) {
                    this.showDates1D((CoordinateAxis1D)axis, cdu);
                } else {
                    Array data = axis.read();
                    IndexIterator ii = data.getIndexIterator();
                    while (ii.hasNext()) {
                        double val = ii.getDoubleNext();
                        this.infoTA.appendLine(this.makeCalendarDateStringOrMissing(cdu, val));
                    }
                }
            } else {
                Array data = axis.read();
                Formatter f = new Formatter();
                if (data instanceof ArrayChar) {
                    ArrayChar dataS = (ArrayChar)data;
                    ArrayChar.StringIterator iter = dataS.getStringIterator();
                    while (iter.hasNext()) {
                        f.format(" %s%n", iter.next());
                    }
                    this.infoTA.appendLine(f.toString());
                } else if (data instanceof ArrayObject) {
                    IndexIterator iter = data.getIndexIterator();
                    while (iter.hasNext()) {
                        f.format(" %s%n", iter.next());
                    }
                    this.infoTA.appendLine(f.toString());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.infoTA.appendLine(ex.getMessage());
        }
    }

    private void showDates2D(CoordinateAxis2D axis2D, CalendarDateUnit cdu) {
        Formatter f = new Formatter();
        if (axis2D.isInterval()) {
            ArrayDouble.D2 coords = axis2D.getCoordValuesArray();
            ArrayDouble.D3 bounds = axis2D.getCoordBoundsArray();
            if (bounds == null) {
                this.infoTA.appendLine("No bounds for interval " + axis2D.getFullName());
                return;
            }
            IndexIterator coordIter = coords.getIndexIterator();
            IndexIterator boundsIter = bounds.getIndexIterator();
            while (coordIter.hasNext()) {
                double coordValue = coordIter.getDoubleNext();
                if (!boundsIter.hasNext()) break;
                double bounds1 = boundsIter.getDoubleNext();
                if (boundsIter.hasNext()) {
                    double bounds2 = boundsIter.getDoubleNext();
                    f.format("%s (%s,%s)%n", this.makeCalendarDateStringOrMissing(cdu, coordValue), this.makeCalendarDateStringOrMissing(cdu, bounds1), this.makeCalendarDateStringOrMissing(cdu, bounds2));
                    continue;
                }
                break;
            }
        } else {
            ArrayDouble.D2 coords = axis2D.getCoordValuesArray();
            IndexIterator coordIter = coords.getIndexIterator();
            while (coordIter.hasNext()) {
                double coordValue = coordIter.getDoubleNext();
                f.format("%s%n", this.makeCalendarDateStringOrMissing(cdu, coordValue));
            }
        }
        this.infoTA.appendLine(f.toString());
    }

    private String makeCalendarDateStringOrMissing(CalendarDateUnit cdu, double value) {
        if (Double.isNaN(value)) {
            return "missing";
        }
        return cdu.makeCalendarDate(value).toString();
    }

    private String getCalendarAttribute(VariableEnhanced vds) {
        Attribute cal = vds.findAttribute("calendar");
        return cal == null ? null : cal.getStringValue();
    }

    private void showDates1D(CoordinateAxis1D axis1D, CalendarDateUnit cdu) {
        if (!axis1D.isInterval()) {
            for (double val : axis1D.getCoordValues()) {
                if (Double.isNaN(val)) {
                    this.infoTA.appendLine(" N/A");
                    continue;
                }
                this.infoTA.appendLine(" " + cdu.makeCalendarDate(val));
            }
        } else {
            Formatter f = new Formatter();
            double[] b1 = axis1D.getBound1();
            double[] b2 = axis1D.getBound2();
            for (int i = 0; i < b1.length; ++i) {
                f.format(" (%f, %f) == (%s, %s)%n", b1[i], b2[i], cdu.makeCalendarDate(b1[i]), cdu.makeCalendarDate(b2[i]));
            }
            this.infoTA.appendLine(f.toString());
        }
    }

    private void printArray(String title, double[] vals) {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append(" ").append(title);
        for (double val : vals) {
            sbuff.append(" ").append(val);
        }
        sbuff.append("\n");
        this.infoTA.appendLine(sbuff.toString());
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.varTable.saveState(false);
        this.csTable.saveState(false);
        this.axisTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        if (this.attWindow != null) {
            this.prefs.putBeanObject("AttWindowBounds", this.attWindow.getBounds());
        }
    }

    public void clear() {
        this.ds = null;
        this.varTable.clearBeans();
        this.axisTable.clearBeans();
        this.csTable.clearBeans();
    }

    public void setDataset(NetcdfDataset ds) {
        this.ds = ds;
        this.parseInfo = new Formatter();
        ArrayList<VariableBean> beanList = new ArrayList<VariableBean>();
        ArrayList<AxisBean> axisList = new ArrayList<AxisBean>();
        this.setVariables(ds.getVariables(), axisList, beanList);
        this.varTable.setBeans(beanList);
        this.axisTable.setBeans(axisList);
        this.csTable.setBeans(this.getCoordinateSystemBeans(ds));
    }

    private void setVariables(List<Variable> varList, List<AxisBean> axisList, List<VariableBean> beanList) {
        for (Variable aVarList : varList) {
            VariableEnhanced v = (VariableEnhanced)aVarList;
            if (v instanceof CoordinateAxis) {
                axisList.add(new AxisBean((CoordinateAxis)v));
            } else {
                beanList.add(new VariableBean(v));
            }
            if (!(v instanceof Structure)) continue;
            List nested = ((Structure)v).getVariables();
            this.setVariables(nested, axisList, beanList);
        }
    }

    public List<CoordinateSystemBean> getCoordinateSystemBeans(NetcdfDataset ds) {
        ArrayList<CoordinateSystemBean> vlist = new ArrayList<CoordinateSystemBean>();
        for (CoordinateSystem elem : ds.getCoordinateSystems()) {
            vlist.add(new CoordinateSystemBean(elem));
        }
        return vlist;
    }

    private void setSelectedCoordinateSystem(CoordinateSystem coordSys) {
        List beans = this.csTable.getBeans();
        for (Object bean1 : beans) {
            CoordinateSystemBean bean = (CoordinateSystemBean)bean1;
            if (bean.coordSys != coordSys) continue;
            this.csTable.setSelectedBean(bean);
            return;
        }
    }

    private void setSelectedCoordinateAxes(CoordinateSystem cs) {
        List axesList = cs.getCoordinateAxes();
        if (axesList.size() == 0) {
            return;
        }
        CoordinateAxis axis = (CoordinateAxis)axesList.get(0);
        List beans = this.axisTable.getBeans();
        for (Object bean1 : beans) {
            AxisBean bean = (AxisBean)bean1;
            if (bean.axis != axis) continue;
            this.axisTable.setSelectedBean(bean);
            return;
        }
    }

    private String tryGrid(VariableEnhanced v) {
        Formatter buff = new Formatter();
        buff.format("%s:", v.getFullName());
        List csList = v.getCoordinateSystems();
        if (csList.size() == 0) {
            buff.format(" No Coord System found", new Object[0]);
        } else {
            for (CoordinateSystem cs : csList) {
                buff.format("%s:", cs.getName());
                if (GridCoordSys.isGridCoordSys((Formatter)buff, (CoordinateSystem)cs, (VariableEnhanced)v)) {
                    buff.format("GRID OK%n", new Object[0]);
                    continue;
                }
                buff.format(" NOT GRID", new Object[0]);
            }
        }
        return buff.toString();
    }

    private String showMissing(Variable v) {
        if (!(v instanceof VariableDS)) {
            return "";
        }
        VariableDS ve = (VariableDS)v;
        Formatter buff = new Formatter();
        buff.format("%s:", v.getFullName());
        EnumSet enhanceMode = ve.getEnhanceMode();
        buff.format("enhanceMode= %s%n", enhanceMode);
        ve.showScaleMissingProxy(buff);
        return buff.toString();
    }

    public class AxisBean {
        CoordinateAxis axis;
        CoordinateSystem firstCoordSys = null;
        String name;
        String desc;
        String units;
        String axisType = "";
        String positive = "";
        String incr = "";
        String dims;
        String shape;
        boolean isCoordVar;
        boolean isLayer;
        boolean isInterval;

        public AxisBean() {
        }

        public AxisBean(CoordinateAxis v) {
            CoordinateAxis1D v1;
            String p;
            this.axis = v;
            this.setName(v.getFullName());
            this.setCoordVar(v.isCoordinateVariable());
            this.setDescription(v.getDescription());
            this.setUnits(v.getUnitsString());
            StringBuilder lens = new StringBuilder();
            StringBuilder names = new StringBuilder();
            List dims = v.getDimensions();
            for (int j = 0; j < dims.size(); ++j) {
                Dimension dim = (Dimension)dims.get(j);
                if (j > 0) {
                    lens.append(",");
                    names.append(",");
                }
                String name = dim.isShared() ? dim.getShortName() : "anon";
                names.append(name);
                lens.append(dim.getLength());
            }
            this.setDims(names.toString());
            this.setShape(lens.toString());
            AxisType at = v.getAxisType();
            if (at != null) {
                this.setAxisType(at.toString());
            }
            if ((p = v.getPositive()) != null) {
                this.setPositive(p);
            }
            if (v instanceof CoordinateAxis1D && (v1 = (CoordinateAxis1D)v).isRegular()) {
                this.setRegular(Double.toString(v1.getIncrement()));
            }
            this.isLayer = null != this.axis.findAttribute("_CoordinateZisLayer");
            this.isInterval = this.axis.isInterval();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isCoordVar() {
            return this.isCoordVar;
        }

        public void setCoordVar(boolean isCoordVar) {
            this.isCoordVar = isCoordVar;
        }

        public boolean isContig() {
            return this.axis.isContiguous();
        }

        public boolean isInterval() {
            return this.isInterval;
        }

        public String getShape() {
            return this.shape;
        }

        public void setShape(String shape) {
            this.shape = shape;
        }

        public String getAxisType() {
            return this.axisType;
        }

        public void setAxisType(String axisType) {
            this.axisType = axisType;
        }

        public String getDims() {
            return this.dims;
        }

        public void setDims(String dims) {
            this.dims = dims;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units == null ? "null" : units;
        }

        public String getPositive() {
            return this.positive;
        }

        public void setPositive(String positive) {
            this.positive = positive;
        }

        public String getRegular() {
            return this.incr;
        }

        public void setRegular(String incr) {
            this.incr = incr;
        }
    }

    public class AttributeBean {
        private Attribute att;

        public AttributeBean() {
        }

        public AttributeBean(Attribute att) {
            this.att = att;
        }

        public String getName() {
            return this.att.getShortName();
        }

        public String getValue() {
            Array value = this.att.getValues();
            return NCdumpW.toString((Array)value, null, null);
        }
    }

    public class CoordinateSystemBean {
        CoordinateSystem coordSys;
        private String name;
        private String ctNames;
        private String dataType = "";
        private String coverageType;
        private int domainRank;
        private int rangeRank;
        private boolean isGeoXY;
        private boolean isLatLon;
        private boolean isProductSet;
        private boolean isRegular;

        public CoordinateSystemBean() {
        }

        public CoordinateSystemBean(CoordinateSystem cs) {
            this.coordSys = cs;
            this.setCoordSys(cs.getName());
            this.setGeoXY(cs.isGeoXY());
            this.setLatLon(cs.isLatLon());
            this.setProductSet(cs.isProductSet());
            this.setRegular(cs.isRegular());
            this.setDomainRank(cs.getDomain().size());
            this.setRangeRank(cs.getCoordinateAxes().size());
            this.coverageType = CoverageCSFactory.describe(null, (CoordinateSystem)cs);
            if (GridCoordSys.isGridCoordSys((Formatter)CoordSysTable.this.parseInfo, (CoordinateSystem)cs, null)) {
                this.addDataType("grid");
            }
            if (RadialCoordSys.isRadialCoordSys((Formatter)CoordSysTable.this.parseInfo, (CoordinateSystem)cs)) {
                this.addDataType("radial");
            }
            StringBuilder buff = new StringBuilder();
            List ctList = cs.getCoordinateTransforms();
            for (int i = 0; i < ctList.size(); ++i) {
                ProjectionCT pct;
                CoordinateTransform ct = (CoordinateTransform)ctList.get(i);
                if (i > 0) {
                    buff.append(" ");
                }
                buff.append(ct.getTransformType());
                if (ct instanceof VerticalCT) {
                    buff.append("(").append(((VerticalCT)ct).getVerticalTransformType()).append(")");
                }
                if (!(ct instanceof ProjectionCT) || (pct = (ProjectionCT)ct).getProjection() == null) continue;
                buff.append("(").append(pct.getProjection().getClassName()).append(")");
            }
            this.setCoordTransforms(buff.toString());
        }

        public String getCoordSys() {
            return this.name;
        }

        public void setCoordSys(String name) {
            this.name = name;
        }

        public boolean isGeoXY() {
            return this.isGeoXY;
        }

        public void setGeoXY(boolean isGeoXY) {
            this.isGeoXY = isGeoXY;
        }

        public boolean getLatLon() {
            return this.isLatLon;
        }

        public void setLatLon(boolean isLatLon) {
            this.isLatLon = isLatLon;
        }

        public boolean isProductSet() {
            return this.isProductSet;
        }

        public void setProductSet(boolean isProductSet) {
            this.isProductSet = isProductSet;
        }

        public boolean isRegular() {
            return this.isRegular;
        }

        public void setRegular(boolean isRegular) {
            this.isRegular = isRegular;
        }

        public int getDomainRank() {
            return this.domainRank;
        }

        public void setDomainRank(int domainRank) {
            this.domainRank = domainRank;
        }

        public int getRangeRank() {
            return this.rangeRank;
        }

        public void setRangeRank(int rangeRank) {
            this.rangeRank = rangeRank;
        }

        public String getCoordTransforms() {
            return this.ctNames;
        }

        public void setCoordTransforms(String ctNames) {
            this.ctNames = ctNames;
        }

        public String getDataType() {
            return this.dataType;
        }

        void addDataType(String dt) {
            this.dataType = this.dataType + " " + dt;
        }

        public boolean isImplicit() {
            return this.coordSys.isImplicit();
        }

        public String getCoverage() {
            return this.coverageType;
        }
    }

    public class VariableBean {
        VariableEnhanced ve;
        CoordinateSystem firstCoordSys = null;
        String name;
        String desc;
        String units;
        String dims;
        String shape;
        String csNames;
        String dataType = "";

        public VariableBean() {
        }

        public VariableBean(VariableEnhanced v) {
            this.ve = v;
            this.setName(v.getFullName());
            this.setDescription(v.getDescription());
            this.setUnits(v.getUnitsString());
            StringBuilder lens = new StringBuilder();
            StringBuilder names = new StringBuilder();
            List dims = v.getDimensions();
            for (int j = 0; j < dims.size(); ++j) {
                Dimension dim = (Dimension)dims.get(j);
                if (j > 0) {
                    lens.append(",");
                    names.append(",");
                }
                String name = dim.isShared() ? dim.getShortName() : "anon";
                names.append(name);
                lens.append(dim.getLength());
            }
            this.setDims(names.toString());
            this.setShape(lens.toString());
            StringBuilder buff = new StringBuilder();
            List csList = v.getCoordinateSystems();
            for (CoordinateSystem cs : csList) {
                if (this.firstCoordSys == null) {
                    this.firstCoordSys = cs;
                } else {
                    buff.append("; ");
                }
                buff.append(cs.getName());
                Formatter gridBuff = new Formatter();
                if (!GridCoordSys.isGridCoordSys((Formatter)gridBuff, (CoordinateSystem)cs, (VariableEnhanced)v)) continue;
                this.addDataType("grid");
            }
            this.setCoordSys(buff.toString());
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDataType() {
            return this.dataType;
        }

        void addDataType(String dt) {
            this.dataType = this.dataType + " " + dt;
        }

        public String getDims() {
            return this.dims;
        }

        public void setDims(String dims) {
            this.dims = dims;
        }

        public String getShape() {
            return this.shape;
        }

        public void setShape(String shape) {
            this.shape = shape;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getUnits() {
            return this.units;
        }

        public String getAbbrev() {
            Attribute att = this.ve.findAttributeIgnoreCase("abbreviation");
            return att == null ? null : att.getStringValue();
        }

        public void setUnits(String units) {
            this.units = units == null ? "null" : units;
        }

        public String getCoordSys() {
            return this.csNames;
        }

        public void setCoordSys(String csNames) {
            this.csNames = csNames;
        }
    }
}

