/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Rectangle;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.time.CalendarDate;
import ucar.util.prefs.PreferencesExt;

public class VariablePlot
extends JPanel {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final TimeSeriesCollection dataset;
    final JFreeChart chart;
    NetcdfFile file;

    public VariablePlot(PreferencesExt prefs) {
        this.setLayout(new BorderLayout());
        this.dataset = this.createDataset();
        this.chart = this.createChart(this.dataset);
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setPreferredSize(new java.awt.Dimension(800, 600));
        chartPanel.setMouseZoomable(true, false);
        if (prefs != null) {
            chartPanel.setBounds((Rectangle)prefs.getBean("PlotWindowBounds", new Rectangle(300, 300, 600, 600)));
        } else {
            chartPanel.setBounds(new Rectangle(300, 300, 600, 600));
        }
        XYPlot plot = this.chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.GRAY);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.GRAY);
        plot.setAxisOffset(RectangleInsets.ZERO_INSETS);
        LegendTitle legend = this.chart.getLegend();
        if (legend != null) {
            legend.setPosition(RectangleEdge.RIGHT);
        }
        this.add((Component)chartPanel);
    }

    private JFreeChart createChart(TimeSeriesCollection dataset) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)"Variable Plot", (String)"Date", (String)"Value", (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        XYItemRenderer renderer = chart.getXYPlot().getRenderer();
        StandardXYToolTipGenerator g = new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0.00"));
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)g);
        return chart;
    }

    private TimeSeriesCollection createDataset() {
        return new TimeSeriesCollection();
    }

    public void setDataset(NetcdfFile ncFile) {
        this.file = ncFile;
    }

    public void autoScale() {
        this.chart.getXYPlot().getRangeAxis().setAutoRange(true);
        this.chart.getXYPlot().getDomainAxis().setAutoRange(true);
    }

    public void clear() {
        this.dataset.removeAllSeries();
    }

    public void setVariable(Variable v) throws IOException {
        Variable varT;
        this.log.info("variable " + v.getShortName());
        Dimension dim = v.getDimension(0);
        String dimName = dim.getShortName();
        Attribute title = this.file.findGlobalAttribute("title");
        if (title != null) {
            this.chart.setTitle(title.getStringValue());
        }
        if ((varT = this.file.findVariable(null, dimName)) == null) {
            return;
        }
        Attribute tunit = varT.findAttribute("units");
        Attribute vunit = v.findAttribute("units");
        Attribute vfill = v.findAttribute("_FillValue");
        double dfill = Double.NaN;
        if (vfill != null) {
            dfill = vfill.getNumericValue().doubleValue();
        }
        this.chart.getXYPlot().getRangeAxis().setLabel(vunit.getStringValue());
        this.log.info("Time type " + tunit.getDataType() + " value " + tunit.toString());
        NetcdfDataset fds = new NetcdfDataset(this.file);
        CoordinateAxis1DTime tm = CoordinateAxis1DTime.factory((NetcdfDataset)fds, (VariableDS)new VariableDS(null, varT, true), null);
        List dates = tm.getCalendarDates();
        Array a = v.read();
        Index idx = a.getIndex();
        idx.setCurrentCounter(0);
        int d2 = 1;
        int rank = idx.getRank();
        for (int k = 1; k < rank; ++k) {
            d2 *= idx.getShape(k);
        }
        this.log.info(v.getShortName() + " DIMS " + v.getDimensionsString() + " RANK " + rank + " D2 " + d2);
        for (int j = 0; j < d2; ++j) {
            if (rank > 1) {
                idx.set1(j);
            }
            String name = v.getShortName();
            if (d2 > 1) {
                name = name + "-" + j;
            }
            TimeSeries s1 = new TimeSeries((Comparable)((Object)name));
            for (int i = 0; i < idx.getShape(0); ++i) {
                idx.set0(i);
                float f = a.getFloat(idx);
                if ((double)f == dfill) continue;
                Date ts = new Date(((CalendarDate)dates.get(i)).getMillis());
                s1.addOrUpdate((RegularTimePeriod)new Second(ts), (double)f);
            }
            this.dataset.addSeries(s1);
        }
    }
}

