/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.gis.worldmap;

import java.awt.geom.Rectangle2D;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ucar.nc2.ui.gis.AbstractGisFeature;
import ucar.nc2.ui.gis.GisFeatureRenderer;
import ucar.nc2.ui.gis.GisPart;
import ucar.nc2.ui.util.Resource;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LatLonProjection;

public class WorldMap
extends GisFeatureRenderer {
    private static final double SECS_PER_DEG = 3600.0;
    private static ArrayList gisList;
    private static ArrayList partList;
    private static int total_pts;
    private static WorldMapFeature worldMapFeature;
    private static boolean debug;
    private static boolean debugTime;
    private ProjectionImpl dataProject = new LatLonProjection("Cylindrical Equidistant");
    private LatLonRect defaultLLBB = new LatLonRect((LatLonPoint)new LatLonPointImpl(-180.0, -90.0), 360.0, 180.0);

    private static boolean readWorldMap() {
        String filename = "/resources/nj22/ui/maps/cil_100km.mapr";
        InputStream is = null;
        long secs = System.currentTimeMillis();
        is = Resource.getFileResource(filename);
        if (is == null) {
            System.err.println("WorldMap read failed on resource " + filename);
            return false;
        }
        DataInputStream dis = new DataInputStream(is);
        worldMapFeature = new WorldMapFeature();
        gisList = new ArrayList();
        gisList.add(worldMapFeature);
        partList = new ArrayList();
        try {
            while (true) {
                int npts = dis.readInt();
                dis.readInt();
                dis.readInt();
                dis.readInt();
                dis.readInt();
                MapRun run = new MapRun(npts);
                for (int i = 0; i < npts; ++i) {
                    run.wx[i] = (double)dis.readInt() / 3600.0;
                    run.wy[i] = (double)dis.readInt() / 3600.0;
                }
                partList.add(run);
                total_pts += npts;
            }
        }
        catch (EOFException ex) {
        }
        catch (Exception ex) {
            System.err.println("WorldMap exception " + ex);
        }
        try {
            is.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (debugTime) {
            secs = System.currentTimeMillis() - secs;
            System.out.println("WorldMap read file: " + (double)secs * 0.001 + " seconds");
        }
        return true;
    }

    public static AbstractGisFeature getWorldMap() {
        if (worldMapFeature == null) {
            WorldMap.readWorldMap();
        }
        return worldMapFeature;
    }

    public WorldMap() {
        if (partList == null) {
            WorldMap.readWorldMap();
        }
        this.dataProject = new LatLonProjection("Cylindrical Equidistant");
    }

    @Override
    public LatLonRect getPreferredArea() {
        return this.defaultLLBB;
    }

    @Override
    protected List getFeatures() {
        return gisList;
    }

    @Override
    protected ProjectionImpl getDataProjection() {
        return this.dataProject;
    }

    static {
        partList = null;
        total_pts = 0;
        worldMapFeature = null;
        debug = false;
        debugTime = false;
    }

    private static class MapRun
    implements GisPart {
        int npts;
        double[] wx;
        double[] wy;

        MapRun(int npts) {
            this.npts = npts;
            this.wx = new double[npts];
            this.wy = new double[npts];
        }

        @Override
        public int getNumPoints() {
            return this.npts;
        }

        @Override
        public double[] getX() {
            return this.wx;
        }

        @Override
        public double[] getY() {
            return this.wy;
        }
    }

    private static class WorldMapFeature
    extends AbstractGisFeature {
        private WorldMapFeature() {
        }

        @Override
        public Rectangle2D getBounds2D() {
            return null;
        }

        @Override
        public int getNumPoints() {
            return total_pts;
        }

        @Override
        public int getNumParts() {
            return partList.size();
        }

        @Override
        public Iterator getGisParts() {
            return partList.iterator();
        }
    }
}

