/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.widget;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import ucar.nc2.ui.widget.IndependentDialog;
import ucar.util.prefs.ui.Field;
import ucar.util.prefs.ui.PrefPanel;

public class UrlAuthenticatorDialog
extends Authenticator
implements CredentialsProvider {
    private IndependentDialog dialog;
    private UsernamePasswordCredentials pwa = null;
    private Field.Text serverF;
    private Field.Text realmF;
    private Field.Text userF;
    private Field.Password passwF;
    private boolean debug = false;

    public UrlAuthenticatorDialog(JFrame parent) {
        PrefPanel pp = new PrefPanel("UrlAuthenticatorDialog", null);
        this.serverF = pp.addTextField("server", "Server", "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww");
        this.realmF = pp.addTextField("realm", "Realm", "");
        this.serverF.setEditable(false);
        this.realmF.setEditable(false);
        this.userF = pp.addTextField("user", "User", "");
        this.passwF = pp.addPasswordField("password", "Password", "");
        pp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                char[] pw = UrlAuthenticatorDialog.this.passwF.getPassword();
                if (pw == null) {
                    return;
                }
                UrlAuthenticatorDialog.this.pwa = new UsernamePasswordCredentials(UrlAuthenticatorDialog.this.userF.getText(), new String(pw));
                UrlAuthenticatorDialog.this.dialog.setVisible(false);
            }
        });
        JButton cancel = new JButton("Cancel");
        pp.addButton(cancel);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UrlAuthenticatorDialog.this.pwa = null;
                UrlAuthenticatorDialog.this.dialog.setVisible(false);
            }
        });
        pp.finish();
        this.dialog = new IndependentDialog(parent, true, "HTTP Authentication", pp);
        this.dialog.setLocationRelativeTo(parent);
        this.dialog.setLocation(100, 100);
    }

    public void clear() {
    }

    public void setCredentials(AuthScope scope, Credentials cred) {
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        if (this.pwa == null) {
            throw new IllegalStateException();
        }
        if (this.debug) {
            System.out.println("site= " + this.getRequestingSite());
            System.out.println("port= " + this.getRequestingPort());
            System.out.println("protocol= " + this.getRequestingProtocol());
            System.out.println("prompt= " + this.getRequestingPrompt());
            System.out.println("scheme= " + this.getRequestingScheme());
        }
        this.serverF.setText(this.getRequestingHost() + ":" + this.getRequestingPort());
        this.realmF.setText(this.getRequestingPrompt());
        this.dialog.setVisible(true);
        if (this.debug) {
            System.out.println("user= (" + this.pwa.getUserName() + ")");
            System.out.println("password= (" + this.pwa.getPassword() + ")");
        }
        return new PasswordAuthentication(this.pwa.getUserName(), this.pwa.getPassword().toCharArray());
    }

    public Credentials getCredentials(AuthScope scope) {
        if (this.debug) {
            System.out.println(scope.getHost() + ":" + scope.getPort() + " requires authentication with the realm '" + scope.getRealm() + "'");
        }
        this.serverF.setText(scope.getHost() + ":" + scope.getPort());
        this.realmF.setText(scope.getRealm());
        this.dialog.setVisible(true);
        if (this.pwa == null) {
            throw new IllegalStateException();
        }
        if (this.debug) {
            System.out.println("user= (" + this.pwa.getUserName() + ")");
            System.out.println("password= (" + new String(this.pwa.getPassword()) + ")");
        }
        return new UsernamePasswordCredentials(this.pwa.getUserName(), new String(this.pwa.getPassword()));
    }
}

