/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.catalog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.DatasetNode;
import thredds.client.catalog.builder.CatalogBuilder;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.PopupMenu;

public class CatalogTreeView
extends JPanel {
    private Catalog catalog;
    private boolean accessOnly = true;
    private String catalogURL = "";
    private boolean openCatalogReferences = true;
    private boolean openDatasetScans = true;
    private JTree tree = new JTree(new DefaultTreeModel(new DefaultMutableTreeNode(null, false)));
    private InvCatalogTreeModel model;
    private boolean debugRef = false;
    private boolean debugTree = false;

    public CatalogTreeView() {
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setToggleClickCount(1);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                int selRow = CatalogTreeView.this.tree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    CatalogTreeView.this.checkForCatref();
                    InvCatalogTreeNode node = (InvCatalogTreeNode)CatalogTreeView.this.tree.getLastSelectedPathComponent();
                    if (node != null) {
                        CatalogTreeView.this.firePropertyChangeEvent(new PropertyChangeEvent(this, "Selection", null, node.ds));
                    }
                }
                if (selRow != -1 && e.getClickCount() == 2) {
                    CatalogTreeView.this.acceptSelected();
                }
            }
        });
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent evt) {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent evt) {
                CatalogRef catref;
                InvCatalogTreeNode node = (InvCatalogTreeNode)evt.getPath().getLastPathComponent();
                if (node.ds instanceof CatalogRef && !(catref = (CatalogRef)node.ds).isRead() && CatalogTreeView.this.openCatalogReferences) {
                    node.readCatref();
                }
            }
        });
        PopupMenu varPopup = new PopupMenu(this.tree, "Options");
        varPopup.addAction("Open all children", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvCatalogTreeNode node = (InvCatalogTreeNode)CatalogTreeView.this.tree.getLastSelectedPathComponent();
                if (node != null) {
                    CatalogTreeView.this.open(node, true);
                }
            }
        });
        varPopup.addAction("Open one level of children", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvCatalogTreeNode node = (InvCatalogTreeNode)CatalogTreeView.this.tree.getLastSelectedPathComponent();
                if (node != null) {
                    node.makeChildren(true);
                    for (InvCatalogTreeNode child : node.children) {
                        CatalogTreeView.this.tree.expandPath(CatalogTreeView.this.makeTreePath(child));
                    }
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    public void setOpenCatalogReferences(boolean openCatalogReferences) {
        this.openCatalogReferences = openCatalogReferences;
    }

    public void setOpenDatasetScans(boolean openDatasetScans) {
        this.openDatasetScans = openDatasetScans;
    }

    private void firePropertyChangeEvent(DatasetNode ds) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "Dataset", null, ds);
        this.firePropertyChangeEvent(event);
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        this.firePropertyChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
    }

    public void setAccessOnly(boolean accessOnly) {
        this.accessOnly = accessOnly;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public String getCatalogURL() {
        return this.catalogURL;
    }

    private void setCatalogURL(String catalogURL) {
        this.catalogURL = catalogURL;
    }

    public DatasetNode getSelectedDataset() {
        InvCatalogTreeNode tnode = this.getSelectedNode();
        return tnode == null ? null : tnode.ds;
    }

    private InvCatalogTreeNode getSelectedNode() {
        Object node = this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        if (!(node instanceof InvCatalogTreeNode)) {
            return null;
        }
        return (InvCatalogTreeNode)node;
    }

    public void setSelectedDataset(Dataset ds) {
        if (ds == null) {
            return;
        }
        TreePath path = this.makePath(ds);
        if (path == null) {
            return;
        }
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    TreePath makePath(Dataset ds) {
        return null;
    }

    TreePath makeTreePath(TreeNode node) {
        ArrayList<TreeNode> path = new ArrayList<TreeNode>();
        path.add(node);
        for (TreeNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            path.add(0, parent);
        }
        Object[] paths = path.toArray();
        return new TreePath(paths);
    }

    public void openAll(boolean includeCatref) {
        if (this.catalog == null) {
            return;
        }
        this.open((InvCatalogTreeNode)this.model.getRoot(), includeCatref);
        this.tree.repaint();
    }

    private void open(InvCatalogTreeNode node, boolean includeCatref) {
        if (node == null) {
            return;
        }
        node.makeChildren(includeCatref);
        this.tree.expandPath(this.makeTreePath(node));
        Enumeration e = node.children();
        while (e.hasMoreElements()) {
            InvCatalogTreeNode child = (InvCatalogTreeNode)e.nextElement();
            this.open(child, includeCatref);
        }
    }

    void checkForCatref() {
        InvCatalogTreeNode tnode;
        CatalogRef catref;
        DatasetNode ds = this.getSelectedDataset();
        if (ds == null) {
            return;
        }
        if (ds instanceof CatalogRef && !(catref = (CatalogRef)ds).isRead() && this.openCatalogReferences && (tnode = this.getSelectedNode()) != null) {
            tnode.readCatref();
        }
    }

    void acceptSelected() {
        Dataset ds;
        DatasetNode dsn = this.getSelectedDataset();
        if (dsn == null) {
            return;
        }
        if (this.accessOnly && dsn instanceof Dataset && !(ds = (Dataset)dsn).hasAccess()) {
            return;
        }
        this.firePropertyChangeEvent(dsn);
    }

    public void setCatalog(String location) {
        CatalogBuilder builder = new CatalogBuilder();
        try {
            Catalog cat = builder.buildFromLocation(location);
            this.setCatalog(cat);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Error opening catalog location " + location + " err=" + builder.getErrorMessage());
        }
    }

    public void redisplay() {
        this.setCatalog(this.catalog);
    }

    public void setCatalog(Catalog catalog) {
        String id;
        Dataset dataset;
        int pos;
        if (catalog == null) {
            return;
        }
        String catalogName = catalog.getBaseURI().toString();
        this.catalog = catalog;
        this.setCatalogURL(catalogName);
        this.model = new InvCatalogTreeModel((DatasetNode)catalog);
        this.tree.setModel(this.model);
        if (this.debugTree) {
            System.out.println("*** catalog/showJTree =");
            this.showNode(this.tree.getModel(), this.tree.getModel().getRoot());
            System.out.println("*** ");
        }
        if ((pos = catalogName.indexOf(35)) >= 0 && (dataset = catalog.findDatasetByID(id = catalogName.substring(pos + 1))) != null) {
            this.setSelectedDataset(dataset);
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, "Selection", null, dataset));
        }
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, "Catalog", null, catalogName));
    }

    private void showNode(TreeModel tree, Object node) {
        if (node == null) {
            return;
        }
        InvCatalogTreeNode tnode = (InvCatalogTreeNode)node;
        DatasetNode cp = tnode.ds;
        System.out.println(" node= " + cp.getName() + " leaf= " + tree.isLeaf(node));
        for (int i = 0; i < tree.getChildCount(node); ++i) {
            this.showNode(tree, tree.getChild(node, i));
        }
    }

    private static class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon refIcon = BAMutil.getIcon("CatalogRef", true);
        ImageIcon refReadIcon = BAMutil.getIcon("CatalogRefRead", true);
        ImageIcon gridIcon = BAMutil.getIcon("GridData", true);
        ImageIcon imageIcon = BAMutil.getIcon("ImageData", true);
        ImageIcon dqcIcon = BAMutil.getIcon("DQCData", true);
        ImageIcon dsScanIcon = BAMutil.getIcon("DatasetScan", true);

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof InvCatalogTreeNode) {
                InvCatalogTreeNode node = (InvCatalogTreeNode)value;
                DatasetNode ds = node.ds;
                String doc = ds.toString();
                if (doc != null) {
                    ((JComponent)c).setToolTipText(doc);
                }
                if (ds instanceof CatalogRef) {
                    if (((CatalogRef)ds).isRead()) {
                        this.setIcon(this.refReadIcon);
                    } else {
                        this.setIcon(this.refIcon);
                    }
                } else if (leaf) {
                    this.setIcon(this.gridIcon);
                }
            }
            return c;
        }
    }

    private class InvCatalogTreeNode
    implements TreeNode,
    CatalogBuilder.Callback {
        DatasetNode ds;
        private InvCatalogTreeNode parent;
        private ArrayList<InvCatalogTreeNode> children = null;
        private boolean isReading = false;

        InvCatalogTreeNode(InvCatalogTreeNode parent, DatasetNode ds) {
            this.parent = parent;
            this.ds = ds;
            if (CatalogTreeView.this.debugTree) {
                System.out.println("new=" + ds.getName() + " ");
            }
            CatalogTreeView.this.firePropertyChangeEvent(new PropertyChangeEvent(this, "TreeNode", null, ds));
        }

        public Enumeration children() {
            if (CatalogTreeView.this.debugTree) {
                System.out.println("children=" + this.ds.getName() + " ");
            }
            if (this.children == null) {
                return Collections.enumeration(new ArrayList());
            }
            return Collections.enumeration(this.children);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int index) {
            if (CatalogTreeView.this.debugTree) {
                System.out.println("getChildAt=" + this.ds.getName() + " " + index);
            }
            return this.children.get(index);
        }

        @Override
        public int getChildCount() {
            if (this.children == null) {
                this.makeChildren(false);
            }
            if (this.children == null) {
                return 0;
            }
            return this.children.size();
        }

        void makeChildren(boolean force) {
            if (this.children == null) {
                if (this.ds instanceof CatalogRef) {
                    CatalogRef catref = (CatalogRef)this.ds;
                    if (CatalogTreeView.this.debugRef) {
                        System.out.println("getChildCount on catref=" + this.ds.getName() + " " + catref.isRead() + " " + this.isReading);
                    }
                    if (!catref.isRead() && !force) {
                        return;
                    }
                }
                if (CatalogTreeView.this.debugRef) {
                    System.out.println("getChildCount on ds=" + this.ds.getName() + " ");
                }
                this.children = new ArrayList();
                for (Dataset nested : this.ds.getDatasets()) {
                    this.children.add(new InvCatalogTreeNode(this, (DatasetNode)nested));
                }
            }
        }

        void readCatref() {
            CatalogRef catref = (CatalogRef)this.ds;
            if (CatalogTreeView.this.debugRef) {
                System.out.println("readCatref on =" + this.ds.getName() + " " + this.isReading);
            }
            if (!this.isReading) {
                this.isReading = true;
                CatalogBuilder builder = new CatalogBuilder();
                try {
                    Catalog cat = builder.buildFromCatref(catref);
                    if (builder.hasFatalError() || cat == null) {
                        JOptionPane.showMessageDialog(CatalogTreeView.this, "Error reading catref " + catref.getName() + " err=" + builder.getErrorMessage());
                        return;
                    }
                    this.setCatalog(cat);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(CatalogTreeView.this, "Error reading catref " + catref.getName() + " err=" + e.getMessage());
                }
            }
        }

        @Override
        public int getIndex(TreeNode child) {
            if (CatalogTreeView.this.debugTree) {
                System.out.println("getIndex=" + this.ds.getName() + " " + child);
            }
            return this.children.indexOf(child);
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            if (CatalogTreeView.this.debugTree) {
                System.out.println("isLeaf=" + this.ds.getName());
            }
            if (this.ds instanceof CatalogRef) {
                return false;
            }
            return !this.ds.hasNestedDatasets();
        }

        public String toString() {
            return this.ds.getName();
        }

        public void setCatalog(Catalog catalog) {
            Dataset top;
            this.children = new ArrayList();
            List datasets = catalog.getDatasets();
            if (datasets.size() == 1 && (top = (Dataset)datasets.get(0)).getName().equalsIgnoreCase(this.ds.getName())) {
                this.ds = top;
                datasets = top.getDatasets();
            }
            int[] childIndices = new int[datasets.size()];
            for (int count = 0; count < datasets.size(); ++count) {
                this.children.add(new InvCatalogTreeNode(this, (DatasetNode)datasets.get(count)));
                childIndices[count] = count;
            }
            CatalogTreeView.this.model.nodesWereInserted(this, childIndices);
            CatalogTreeView.this.tree.expandPath(CatalogTreeView.this.makeTreePath(this));
            if (CatalogTreeView.this.debugRef) {
                System.out.println("model.nodeStructureChanged on " + this);
            }
            this.isReading = false;
        }

        public void failed() {
            if (CatalogTreeView.this.debugRef) {
                System.out.println("failed called on " + this);
            }
            this.isReading = false;
        }
    }

    private class InvCatalogTreeModel
    extends DefaultTreeModel {
        InvCatalogTreeModel(DatasetNode top) {
            super(new InvCatalogTreeNode(null, top), false);
        }
    }
}

