/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.MFile;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeAbstract;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.SparseArray;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.PartitionCollectionImmutable;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.ui.MFileTable;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.Indent;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class CdmIndex2Panel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(CdmIndex2Panel.class);
    private PreferencesExt prefs;
    private BeanTable groupTable;
    private BeanTable varTable;
    private BeanTable coordTable;
    private JSplitPane split;
    private JSplitPane split2;
    private JSplitPane split3;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private MFileTable fileTable;
    Path indexFile;
    GribCollectionImmutable gc;
    Collection<MFile> gcFiles;
    FeatureCollectionConfig config = new FeatureCollectionConfig();

    public CdmIndex2Panel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        if (buttPanel != null) {
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Show Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    CdmIndex2Panel.this.showInfo(f);
                    CdmIndex2Panel.this.infoTA.setText(f.toString());
                    CdmIndex2Panel.this.infoTA.gotoTop();
                    CdmIndex2Panel.this.infoWindow.show();
                }
            });
            buttPanel.add(infoButton);
            AbstractButton filesButton = BAMutil.makeButtcon("Information", "Show Files", false);
            filesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CdmIndex2Panel.this.gc != null) {
                        CdmIndex2Panel.this.showFileTable(CdmIndex2Panel.this.gc, null);
                    }
                }
            });
            buttPanel.add(filesButton);
            AbstractButton rawButton = BAMutil.makeButtcon("Information", "Estimate memory use", false);
            rawButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    CdmIndex2Panel.this.showMemoryEst(f);
                    CdmIndex2Panel.this.infoTA.setText(f.toString());
                    CdmIndex2Panel.this.infoTA.gotoTop();
                    CdmIndex2Panel.this.infoWindow.show();
                }
            });
            buttPanel.add(rawButton);
        }
        this.groupTable = new BeanTable(GroupBean.class, (PreferencesExt)prefs.node("GroupBean"), false, "GDS group", "GribCollectionImmutable.GroupHcs", null);
        this.groupTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GroupBean bean = (GroupBean)CdmIndex2Panel.this.groupTable.getSelectedBean();
                if (bean != null) {
                    CdmIndex2Panel.this.setGroup(bean);
                }
            }
        });
        PopupMenu varPopup = new PopupMenu(this.groupTable.getJTable(), "Options");
        varPopup.addAction("Show Group Info", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupBean bean = (GroupBean)CdmIndex2Panel.this.groupTable.getSelectedBean();
                if (bean != null && bean.group != null) {
                    Formatter f = new Formatter();
                    bean.group.show(f);
                    CdmIndex2Panel.this.infoTA.setText(f.toString());
                    CdmIndex2Panel.this.infoTA.gotoTop();
                    CdmIndex2Panel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Show Files Used", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupBean bean = (GroupBean)CdmIndex2Panel.this.groupTable.getSelectedBean();
                if (bean != null && bean.group != null) {
                    CdmIndex2Panel.this.showFileTable(CdmIndex2Panel.this.gc, bean.group);
                }
            }
        });
        this.varTable = new BeanTable(VarBean.class, (PreferencesExt)prefs.node("Grib2Bean"), false, "Variables in group", "GribCollectionImmutable.VariableIndex", null);
        varPopup = new PopupMenu(this.varTable.getJTable(), "Options");
        varPopup.addAction("Show Variable(s)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List beans = CdmIndex2Panel.this.varTable.getSelectedBeans();
                CdmIndex2Panel.this.infoTA.clear();
                for (VarBean bean : beans) {
                    CdmIndex2Panel.this.infoTA.appendLine(bean.v.toStringFrom());
                }
                CdmIndex2Panel.this.infoTA.gotoTop();
                CdmIndex2Panel.this.infoWindow.show();
            }
        });
        varPopup.addAction("Show Sparse Array", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VarBean bean = (VarBean)CdmIndex2Panel.this.varTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    bean.showSparseArray(f);
                    CdmIndex2Panel.this.infoTA.setText(f.toString());
                    CdmIndex2Panel.this.infoTA.gotoTop();
                    CdmIndex2Panel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Make Variable(s) GribConfig", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List beans = CdmIndex2Panel.this.varTable.getSelectedBeans();
                CdmIndex2Panel.this.infoTA.clear();
                Formatter f = new Formatter();
                for (VarBean bean : beans) {
                    bean.makeGribConfig(f);
                }
                CdmIndex2Panel.this.infoTA.appendLine(f.toString());
                CdmIndex2Panel.this.infoTA.gotoTop();
                CdmIndex2Panel.this.infoWindow.show();
            }
        });
        this.coordTable = new BeanTable(CoordBean.class, (PreferencesExt)prefs.node("CoordBean"), false, "Coordinates in group", "Coordinates", null);
        varPopup = new PopupMenu(this.coordTable.getJTable(), "Options");
        varPopup.addAction("Show", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordBean bean = (CoordBean)CdmIndex2Panel.this.coordTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    bean.coord.showCoords(f);
                    CdmIndex2Panel.this.infoTA.setText(f.toString());
                    CdmIndex2Panel.this.infoTA.gotoTop();
                    CdmIndex2Panel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("ShowCompact", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordBean bean = (CoordBean)CdmIndex2Panel.this.coordTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    bean.coord.showInfo(f, new Indent(2));
                    CdmIndex2Panel.this.infoTA.setText(f.toString());
                    CdmIndex2Panel.this.infoTA.gotoTop();
                    CdmIndex2Panel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Test Time2D isRegular", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordBean bean = (CoordBean)CdmIndex2Panel.this.coordTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    CdmIndex2Panel.this.testOrthogonal(f, bean.coord);
                    CdmIndex2Panel.this.testRegular(f, bean.coord);
                    CdmIndex2Panel.this.infoTA.setText(f.toString());
                    CdmIndex2Panel.this.infoTA.gotoTop();
                    CdmIndex2Panel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Compare", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List beans = CdmIndex2Panel.this.coordTable.getSelectedBeans();
                if (beans.size() == 2) {
                    Formatter f = new Formatter();
                    CoordBean bean1 = (CoordBean)beans.get(0);
                    CoordBean bean2 = (CoordBean)beans.get(1);
                    if (bean1.coord.getType() == Coordinate.Type.time2D && bean2.coord.getType() == Coordinate.Type.time2D) {
                        CdmIndex2Panel.this.compareCoords2D(f, (CoordinateTime2D)bean1.coord, (CoordinateTime2D)bean2.coord);
                    } else {
                        CdmIndex2Panel.this.compareCoords(f, bean1.coord, bean2.coord);
                    }
                    CdmIndex2Panel.this.infoTA.setText(f.toString());
                    CdmIndex2Panel.this.infoTA.gotoTop();
                    CdmIndex2Panel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Try to Merge", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List beans = CdmIndex2Panel.this.coordTable.getSelectedBeans();
                if (beans.size() == 2) {
                    Formatter f = new Formatter();
                    CoordBean bean1 = (CoordBean)beans.get(0);
                    CoordBean bean2 = (CoordBean)beans.get(1);
                    if (bean1.coord.getType() == Coordinate.Type.time2D && bean2.coord.getType() == Coordinate.Type.time2D) {
                        CdmIndex2Panel.this.mergeCoords2D(f, (CoordinateTime2D)bean1.coord, (CoordinateTime2D)bean2.coord);
                    } else {
                        f.format("CoordinateTime2D only", new Object[0]);
                    }
                    CdmIndex2Panel.this.infoTA.setText(f.toString());
                    CdmIndex2Panel.this.infoTA.gotoTop();
                    CdmIndex2Panel.this.infoWindow.show();
                }
            }
        });
        this.fileTable = new MFileTable((PreferencesExt)prefs.node("MFileTable"), true);
        this.fileTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CdmIndex2Panel.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.setLayout(new BorderLayout());
        this.split3 = new JSplitPane(0, false, this.groupTable, this.varTable);
        this.split3.setDividerLocation(prefs.getInt("splitPos3", 800));
        this.split2 = new JSplitPane(0, false, this.split3, this.coordTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.add((Component)this.split2, "Center");
    }

    public void save() {
        this.groupTable.saveState(false);
        this.varTable.saveState(false);
        this.coordTable.saveState(false);
        this.fileTable.save();
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
        if (this.split2 != null) {
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        }
        if (this.split3 != null) {
            this.prefs.putInt("splitPos3", this.split3.getDividerLocation());
        }
    }

    public void clear() {
        if (this.gc != null) {
            try {
                this.gc.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.gc = null;
        this.groupTable.clearBeans();
        this.varTable.clearBeans();
        this.coordTable.clearBeans();
    }

    public void showInfo(Formatter f) {
        if (this.gc == null) {
            return;
        }
        this.gc.showIndex(f);
        f.format("%n", new Object[0]);
        f.format("Groups%n", new Object[0]);
        List groups = this.groupTable.getBeans();
        for (GroupBean bean : groups) {
            f.format("%-50s %-50s %d%n", bean.getGroupId(), bean.getDescription(), bean.getGdsHash());
            bean.group.show(f);
        }
        f.format("%n", new Object[0]);
    }

    private void showFileTable(GribCollectionImmutable gc, GribCollectionImmutable.GroupGC group) {
        File dir = gc.getDirectory();
        Collection files = group == null ? gc.getFiles() : group.getFiles();
        this.fileTable.setFiles(dir, files);
    }

    public void showMemoryEst(Formatter f) {
        if (this.gc == null) {
            return;
        }
        for (GribCollectionImmutable.Dataset ds : this.gc.getDatasets()) {
            f.format("Dataset %s%n", ds.getType());
            int bytesTotal = 0;
            int bytesSATotal = 0;
            int coordsAllTotal = 0;
            for (GribCollectionImmutable.GroupGC g : ds.getGroups()) {
                f.format(" Group %s%n", g.getDescription());
                ArrayList<SortBySize> sortList = new ArrayList<SortBySize>(g.getCoordinates().size());
                for (Coordinate vc : g.getCoordinates()) {
                    sortList.add(new SortBySize(vc, vc.estMemorySize()));
                }
                Collections.sort(sortList);
                int coordsTotal = 0;
                f.format("  totalKB  type Coordinate%n", new Object[0]);
                for (SortBySize ss : sortList) {
                    Coordinate vc = (Coordinate)ss.obj;
                    f.format("  %6d %-8s %-40s%n", vc.estMemorySize() / 1000, vc.getType(), vc.getName());
                    bytesTotal += vc.estMemorySize();
                    coordsTotal += vc.estMemorySize();
                }
                f.format(" %7d KBytes%n", coordsTotal / 1000);
                f.format("%n", new Object[0]);
                coordsAllTotal += coordsTotal;
                int count = 0;
                for (GribCollectionImmutable.VariableIndex v : g.getVariables()) {
                    VarBean bean = new VarBean(v, g);
                    if (v instanceof PartitionCollectionImmutable.VariableIndexPartitioned) {
                        if (count == 0) {
                            f.format(" total   VariablePartitioned%n", new Object[0]);
                        }
                        PartitionCollectionImmutable.VariableIndexPartitioned vip = (PartitionCollectionImmutable.VariableIndexPartitioned)v;
                        int nparts = vip.getNparts();
                        int memEstBytes = 368 + nparts * 4;
                        bytesTotal += memEstBytes;
                        f.format("%6d %-50s nparts=%6d%n", memEstBytes, bean.getName(), nparts);
                    } else {
                        if (count == 0) {
                            f.format(" total   SA  Variable%n", new Object[0]);
                        }
                        try {
                            v.readRecords();
                            SparseArray sa = v.getSparseArray();
                            int ntracks = sa.getTotalSize();
                            int nrecords = sa.getContent().size();
                            int memEstForSA = 276 + nrecords * 40 + ntracks * 4;
                            int memEstBytes = 280 + memEstForSA;
                            f.format("%6d %6d %-50s nrecords=%6d%n", memEstBytes, memEstForSA, bean.getName(), nrecords);
                            bytesTotal += memEstBytes;
                            bytesSATotal += memEstForSA;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    ++count;
                }
            }
            int noSA = bytesTotal - bytesSATotal;
            f.format("%n total KBytes=%d kbSATotal=%d kbNoSA=%d coordsAllTotal=%d%n", bytesTotal / 1000, bytesSATotal / 1000, noSA / 1000, coordsAllTotal / 1000);
            f.format("%n", new Object[0]);
        }
    }

    private void compareCoords(Formatter f, Coordinate coord1, Coordinate coord2) {
        boolean missing;
        List vals1 = coord1.getValues();
        List vals2 = coord2.getValues();
        f.format("Coordinate %s%n", coord1.getName());
        for (Object val1 : vals1) {
            missing = !vals2.contains(val1);
            f.format(" %s %s%n", val1, missing ? "MISSING IN 2" : "");
        }
        f.format("%nCoordinate %s%n", coord2.getName());
        for (Object val2 : vals2) {
            missing = !vals1.contains(val2);
            f.format(" %s %s%n", val2, missing ? "MISSING IN 1" : "");
        }
    }

    private void compareCoords2D(Formatter f, CoordinateTime2D coord1, CoordinateTime2D coord2) {
        int n2;
        CoordinateRuntime runtimes1 = coord1.getRuntimeCoordinate();
        CoordinateRuntime runtimes2 = coord2.getRuntimeCoordinate();
        int n1 = coord1.getNruns();
        if (n1 != (n2 = coord2.getNruns())) {
            f.format("Coordinate 1 has %d runtimes, Coordinate 2 has %d runtimes, %n", n1, n2);
        }
        int min = Math.min(n1, n2);
        for (int idx = 0; idx < min; ++idx) {
            CoordinateTimeAbstract time1 = coord1.getTimeCoordinate(idx);
            CoordinateTimeAbstract time2 = coord2.getTimeCoordinate(idx);
            f.format("Run %d %n", idx);
            if (!runtimes1.getValue(idx).equals(runtimes2.getValue(idx))) {
                f.format("Runtime 1 %s != %s runtime 2%n", runtimes1.getValue(idx), runtimes2.getValue(idx));
            }
            this.compareCoords(f, (Coordinate)time1, (Coordinate)time2);
        }
    }

    private void mergeCoords2D(Formatter f, CoordinateTime2D coord1, CoordinateTime2D coord2) {
        int n2;
        if (coord1.isTimeInterval() != coord2.isTimeInterval()) {
            f.format("Coordinate 1 isTimeInterval %s != Coordinate 2 isTimeInterval %s %n", coord1.isTimeInterval(), coord2.isTimeInterval());
            return;
        }
        CoordinateRuntime runtimes1 = coord1.getRuntimeCoordinate();
        CoordinateRuntime runtimes2 = coord2.getRuntimeCoordinate();
        int n1 = coord1.getNruns();
        if (n1 != (n2 = coord2.getNruns())) {
            f.format("Coordinate 1 has %d runtimes, Coordinate 2 has %d runtimes, %n", n1, n2);
        }
        int min = Math.min(n1, n2);
        for (int idx = 0; idx < min; ++idx) {
            if (runtimes1.getValue(idx).equals(runtimes2.getValue(idx))) continue;
            f.format("Runtime 1 %s != %s runtime 2%n", runtimes1.getValue(idx), runtimes2.getValue(idx));
        }
        Set<Object> set1 = this.makeCoordSet(coord1);
        List list1 = coord1.getOffsetsSorted();
        Set<Object> set2 = this.makeCoordSet(coord2);
        List list2 = coord2.getOffsetsSorted();
        f.format("%nCoordinate %s%n", coord1.getName());
        for (Object val : list1) {
            f.format(" %s,", val);
        }
        f.format(" n=(%d)%n", list1.size());
        this.testMissing(f, list1, set2);
        f.format("%nCoordinate %s%n", coord2.getName());
        for (Object val : list2) {
            f.format(" %s,", val);
        }
        f.format(" (n=%d)%n", list2.size());
        this.testMissing(f, list2, set1);
    }

    private Set<Object> makeCoordSet(CoordinateTime2D time2D) {
        HashSet<Object> result = new HashSet<Object>(100);
        for (int runIdx = 0; runIdx < time2D.getNruns(); ++runIdx) {
            CoordinateTimeAbstract coord = time2D.getTimeCoordinate(runIdx);
            for (Object val : coord.getValues()) {
                result.add(val);
            }
        }
        return result;
    }

    private void testMissing(Formatter f, List<? extends Object> test, Set<Object> against) {
        int countMissing = 0;
        for (Object object : test) {
            if (against.contains(object)) continue;
            f.format(" %d: %s MISSING%n", countMissing++, object);
        }
        f.format("TOTAL MISSING %s%n", countMissing);
    }

    private boolean testOrthogonal(Formatter f, Coordinate c) {
        if (!(c instanceof CoordinateTime2D)) {
            f.format("Must be CoordinateTime2D", new Object[0]);
            return false;
        }
        CoordinateTime2D time2D = (CoordinateTime2D)c;
        ArrayList<CoordinateTimeAbstract> coords = new ArrayList<CoordinateTimeAbstract>();
        for (int runIdx = 0; runIdx < time2D.getNruns(); ++runIdx) {
            coords.add(time2D.getTimeCoordinate(runIdx));
        }
        return this.testOrthogonal(f, coords);
    }

    private boolean testRegular(Formatter f, Coordinate c) {
        if (!(c instanceof CoordinateTime2D)) {
            f.format("Must be CoordinateTime2D", new Object[0]);
            return false;
        }
        f.format("Test isRegular by Offset Hour%n", new Object[0]);
        CoordinateTime2D time2D = (CoordinateTime2D)c;
        HashMap<Integer, ArrayList<CoordinateTimeAbstract>> hourMap = new HashMap<Integer, ArrayList<CoordinateTimeAbstract>>();
        for (int runIdx = 0; runIdx < time2D.getNruns(); ++runIdx) {
            CoordinateTimeAbstract coord = time2D.getTimeCoordinate(runIdx);
            CalendarDate runDate = coord.getRefDate();
            int hour = runDate.getHourOfDay();
            ArrayList<CoordinateTimeAbstract> hg = (ArrayList<CoordinateTimeAbstract>)hourMap.get(hour);
            if (hg == null) {
                hg = new ArrayList<CoordinateTimeAbstract>();
                hourMap.put(hour, hg);
            }
            hg.add(coord);
        }
        boolean ok = true;
        Iterator i$ = hourMap.keySet().iterator();
        while (i$.hasNext()) {
            int hour = (Integer)i$.next();
            List hg = (List)hourMap.get(hour);
            f.format("Hour %d: ", hour);
            for (CoordinateTimeAbstract coord : hg) {
                f.format("%s,", coord.getRefDate());
            }
            f.format("%n", new Object[0]);
            ok &= this.testOrthogonal(f, hg);
        }
        f.format("%nAll orthogonal: %s%n", ok);
        return ok;
    }

    private boolean testOrthogonal(Formatter f, List<CoordinateTimeAbstract> times) {
        int max = 0;
        HashSet allCoords = new HashSet(100);
        for (CoordinateTimeAbstract coord : times) {
            max = Math.max(max, coord.getSize());
            for (Object val : coord.getValues()) {
                allCoords.add(val);
            }
        }
        int totalMax = allCoords.size();
        boolean isOrthogonal = totalMax == max;
        f.format("isOrthogonal %s : totalMax = %d max=%d %n%n", isOrthogonal, totalMax, max);
        return isOrthogonal;
    }

    private void compareSortedList(Formatter f, Iterator<String> i1, Iterator<String> i2) {
        String s1 = null;
        String s2 = null;
        boolean need1 = true;
        boolean need2 = true;
        while (true) {
            if (need1) {
                String string = s1 = i1.hasNext() ? i1.next() : null;
            }
            if (need2) {
                s2 = i2.hasNext() ? i2.next() : null;
            }
            need1 = true;
            need2 = true;
            if (s1 == null && s2 == null) break;
            if (s1 == null) {
                f.format(" extra file = %s%n", s2);
                continue;
            }
            if (s2 == null) {
                f.format(" missing file = %s%n", s1);
                continue;
            }
            int pos = s1.lastIndexOf("/");
            String name1 = s1.substring(pos);
            name1 = name1.substring(1, name1.indexOf("gdas"));
            String name2 = s2.substring(pos);
            int val = name1.compareTo(name2 = name2.substring(1, name2.indexOf("gdas")));
            if (val < 0) {
                f.format(" missing file = %s%n", s1);
                need2 = false;
                continue;
            }
            if (val <= 0) continue;
            f.format(" extra file = %s%n", s2);
            need1 = false;
        }
    }

    public void setIndexFile(Path indexFile, FeatureCollectionConfig config) throws IOException {
        if (this.gc != null) {
            this.gc.close();
        }
        this.indexFile = indexFile;
        this.config = config;
        this.gc = GribCdmIndex.openCdmIndex((String)indexFile.toString(), (FeatureCollectionConfig)config, (boolean)false, (Logger)logger);
        if (this.gc == null) {
            throw new IOException("Not a grib collection index file");
        }
        ArrayList<GroupBean> groups = new ArrayList<GroupBean>();
        for (GribCollectionImmutable.Dataset ds : this.gc.getDatasets()) {
            for (GribCollectionImmutable.GroupGC g : ds.getGroups()) {
                groups.add(new GroupBean(g, ds.getType().toString()));
            }
        }
        if (groups.size() > 0) {
            this.setGroup((GroupBean)groups.get(0));
        } else {
            this.varTable.clearBeans();
            this.coordTable.clearBeans();
        }
        this.groupTable.setBeans(groups);
        this.groupTable.setHeader(indexFile.toString());
        this.gcFiles = this.gc.getFiles();
    }

    private void setGroup(GroupBean bean) {
        bean.clear();
        ArrayList<VarBean> vars = new ArrayList<VarBean>();
        for (GribCollectionImmutable.VariableIndex v : bean.group.getVariables()) {
            VarBean vbean = new VarBean(v, bean.group);
            vars.add(vbean);
            bean.nrecords += vbean.getNrecords();
            bean.ndups += vbean.getNdups();
            bean.nmissing += vbean.getNmissing();
        }
        this.varTable.setBeans(vars);
        int count = 0;
        ArrayList<CoordBean> coords = new ArrayList<CoordBean>();
        for (Coordinate vc : bean.group.getCoordinates()) {
            coords.add(new CoordBean(vc, count++));
        }
        this.coordTable.setBeans(coords);
    }

    public class VarBean {
        GribCollectionImmutable.VariableIndex v;
        GribCollectionImmutable.GroupGC group;
        String name;

        public VarBean() {
        }

        public VarBean(GribCollectionImmutable.VariableIndex vindex, GribCollectionImmutable.GroupGC group) {
            this.v = vindex;
            this.group = group;
            this.name = vindex.makeVariableName();
        }

        public String getIndexes() {
            Formatter f = new Formatter();
            Iterator i$ = this.v.getCoordinateIndex().iterator();
            while (i$.hasNext()) {
                int idx = (Integer)i$.next();
                f.format("%d,", idx);
            }
            return f.toString();
        }

        public String getIntvName() {
            return this.v.getIntvName();
        }

        public int getCdmHash() {
            return this.v.hashCode();
        }

        public String getGroupId() {
            return this.group.getId();
        }

        public String getVariableId() {
            return this.v.getDiscipline() + "-" + this.v.getCategory() + "-" + this.v.getParameter();
        }

        public String getName() {
            return this.name;
        }

        public int getNdups() {
            return this.v.getNdups();
        }

        public int getNrecords() {
            return this.v.getNrecords();
        }

        public int getNmissing() {
            int n = this.v.getSize();
            return n - this.v.getNrecords();
        }

        public int getSize() {
            return this.v.getSize();
        }

        public void makeGribConfig(Formatter f) {
            f.format("<variable id='%s'/>%n", this.getVariableId());
        }

        private void showSparseArray(Formatter f) {
            if (this.v instanceof PartitionCollectionImmutable.VariableIndexPartitioned) {
                PartitionCollectionImmutable.VariableIndexPartitioned vip = (PartitionCollectionImmutable.VariableIndexPartitioned)this.v;
                vip.show(f);
            } else {
                try {
                    this.v.readRecords();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
                if (this.v.getSparseArray() != null) {
                    SparseArray sa = this.v.getSparseArray();
                    sa.showInfo(f, null);
                    f.format("%n", new Object[0]);
                    sa.showContent(f);
                }
            }
        }
    }

    public class CoordBean
    implements Comparable<CoordBean> {
        Coordinate coord;
        int idx;

        public CoordBean() {
        }

        public String getType() {
            if (this.coord instanceof CoordinateTime2D) {
                CoordinateTime2D c2d = (CoordinateTime2D)this.coord;
                Formatter f = new Formatter();
                f.format("%s %s", this.coord.getType(), c2d.isTimeInterval() ? "intv" : "offs");
                if (c2d.isOrthogonal()) {
                    f.format(" ort", new Object[0]);
                }
                if (c2d.isRegular()) {
                    f.format(" reg", new Object[0]);
                }
                return f.toString();
            }
            return this.coord.getType().toString();
        }

        public CoordBean(Coordinate coord, int idx) {
            this.coord = coord;
            this.idx = idx;
        }

        public String getValues() {
            Formatter f = new Formatter();
            if (this.coord instanceof CoordinateRuntime) {
                CoordinateRuntime runtime = (CoordinateRuntime)this.coord;
                f.format("%s-%s", runtime.getFirstDate(), runtime.getLastDate());
            } else if (this.coord instanceof CoordinateTime2D) {
                CoordinateTime2D coord2D = (CoordinateTime2D)this.coord;
                CoordinateRuntime runtime = coord2D.getRuntimeCoordinate();
                f.format("%s-%s", runtime.getFirstDate(), runtime.getLastDate());
            } else {
                if (this.coord.getValues() == null) {
                    return "";
                }
                for (Object val : this.coord.getValues()) {
                    f.format("%s,", val);
                }
            }
            return f.toString();
        }

        public String getSize() {
            if (this.coord instanceof CoordinateTime2D) {
                CoordinateTime2D c2d = (CoordinateTime2D)this.coord;
                Formatter f = new Formatter();
                f.format("%d X %d (%d)", c2d.getRuntimeCoordinate().getSize(), c2d.getNtimes(), this.coord.getSize());
                return f.toString();
            }
            return Integer.toString(this.coord.getSize());
        }

        public int getCode() {
            return this.coord.getCode();
        }

        public int getIndex() {
            return this.idx;
        }

        public String getUnit() {
            return this.coord.getUnit();
        }

        public String getName() {
            CoordinateTimeIntv timeiCoord;
            String intvName = null;
            if (this.coord instanceof CoordinateTimeIntv) {
                timeiCoord = (CoordinateTimeIntv)this.coord;
                intvName = timeiCoord.getTimeIntervalName();
            }
            if (this.coord instanceof CoordinateTime2D) {
                timeiCoord = (CoordinateTime2D)this.coord;
                intvName = timeiCoord.getTimeIntervalName();
            }
            return intvName == null ? this.coord.getName() : this.coord.getName() + " (" + intvName + ")";
        }

        @Override
        public int compareTo(CoordBean o) {
            return this.getType().compareTo(o.getType());
        }

        void showCoords(Formatter f) {
            this.coord.showCoords(f);
        }
    }

    public class GroupBean {
        GribCollectionImmutable.GroupGC group;
        String type;
        int nrecords;
        int nmissing;
        int ndups;

        public GroupBean() {
        }

        public GroupBean(GribCollectionImmutable.GroupGC g, String type) {
            this.group = g;
            this.type = type;
            for (GribCollectionImmutable.VariableIndex vi : this.group.getVariables()) {
                this.nrecords += vi.getNrecords();
                this.ndups += vi.getNdups();
                this.nmissing += vi.getNmissing();
            }
        }

        void clear() {
            this.nmissing = 0;
            this.ndups = 0;
            this.nrecords = 0;
        }

        public String getGroupId() {
            return this.group.getId();
        }

        public int getGdsHash() {
            return this.group.getGdsHash().hashCode();
        }

        public int getNrecords() {
            return this.nrecords;
        }

        public String getType() {
            return this.type;
        }

        public int getNFiles() {
            int n = this.group.getNFiles();
            if (n == 0 && CdmIndex2Panel.this.gc instanceof PartitionCollectionImmutable) {
                n = ((PartitionCollectionImmutable)CdmIndex2Panel.this.gc).getPartitionSize();
            }
            return n;
        }

        public int getNruntimes() {
            return this.group.getNruntimes();
        }

        public int getNCoords() {
            return this.group.getCoordinates().size();
        }

        public int getNVariables() {
            return this.group.getVariables().size();
        }

        public String getDescription() {
            return this.group.getDescription();
        }

        public int getNmissing() {
            return this.nmissing;
        }

        public int getNdups() {
            return this.ndups;
        }
    }

    private static class SortBySize
    implements Comparable<SortBySize> {
        Object obj;
        int size;

        private SortBySize(Object obj, int size) {
            this.obj = obj;
            this.size = size;
        }

        @Override
        public int compareTo(SortBySize o) {
            return Integer.compare(this.size, o.size);
        }
    }
}

