/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;
import ucar.nc2.constants.CDM;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Indent;
import ucar.nc2.util.URLnaming;
import ucar.unidata.util.StringUtil2;

public class Ncdumpx {
    private static String usage = "usage: NCdumpW <filename> [-unsigned] [-cdl | -ncml] [-c | -vall] [-v varName1;varName2;..] [-v varName(0:1,:,12)]\n";
    static boolean useUnsigned = false;
    public static final BigInteger BIG_UMASK64 = new BigInteger("FFFFFFFFFFFFFFFF", 16);
    private static char[] org = new char[]{'\b', '\f', '\n', '\r', '\t', '\\', '\'', '\"'};
    private static String[] replace = new String[]{"\\b", "\\f", "\\n", "\\r", "\\t", "\\\\", "\\'", "\\\""};

    static Object fixUnsigned(Object o, boolean isunsigned) {
        if (!(useUnsigned && isunsigned && o instanceof Number)) {
            return o;
        }
        if (o instanceof Byte) {
            int i = ((Byte)o).intValue();
            return i &= 0xFF;
        }
        if (o instanceof Short) {
            int i = ((Short)o).intValue();
            return i &= 0xFFFF;
        }
        if (o instanceof Integer) {
            long l = ((Integer)o).longValue();
            return l &= 0xFFFFFFFFL;
        }
        if (o instanceof Long) {
            long l = (Long)o;
            BigInteger bi = BigInteger.valueOf(l);
            bi = bi.and(BIG_UMASK64);
            return bi;
        }
        return o;
    }

    public static boolean printHeader(String fileName, Writer out) throws IOException {
        return Ncdumpx.print(fileName, out, false, false, false, false, null, null);
    }

    public static boolean printNcML(String fileName, Writer out) throws IOException {
        return Ncdumpx.print(fileName, out, false, true, true, false, null, null);
    }

    public static boolean print(String command, Writer out) throws IOException {
        return Ncdumpx.print(command, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean print(String command, Writer out, CancelTask ct) throws IOException {
        StringTokenizer stoke = new StringTokenizer(command);
        if (!stoke.hasMoreTokens()) {
            out.write(usage);
            return false;
        }
        String filename = stoke.nextToken();
        NetcdfFile nc = null;
        try {
            nc = NetcdfDataset.openFile((String)filename, (CancelTask)ct);
            int pos = command.indexOf(filename);
            command = command.substring(pos + filename.length());
            boolean bl = Ncdumpx.print(nc, command, out, ct);
            return bl;
        }
        catch (FileNotFoundException e) {
            out.write("file not found= ");
            out.write(filename);
            boolean bl = false;
            return bl;
        }
        finally {
            if (nc != null) {
                nc.close();
            }
            out.flush();
        }
    }

    public static boolean print(NetcdfFile nc, String command, Writer out, CancelTask ct) throws IOException {
        WantValues showValues = WantValues.none;
        boolean ncml = false;
        boolean strict = false;
        String varNames = null;
        useUnsigned = false;
        if (command != null) {
            StringTokenizer stoke = new StringTokenizer(command);
            while (stoke.hasMoreTokens()) {
                String toke = stoke.nextToken();
                if (toke.equalsIgnoreCase("-help")) {
                    out.write(usage);
                    out.write(10);
                    return true;
                }
                if (toke.equalsIgnoreCase("-vall")) {
                    showValues = WantValues.all;
                }
                if (toke.equalsIgnoreCase("-c") && showValues == WantValues.none) {
                    showValues = WantValues.coordsOnly;
                }
                if (toke.equalsIgnoreCase("-ncml")) {
                    ncml = true;
                }
                if (toke.equalsIgnoreCase("-unsigned")) {
                    useUnsigned = true;
                }
                if (toke.equalsIgnoreCase("-cdl") || toke.equalsIgnoreCase("-strict")) {
                    strict = true;
                }
                if (!toke.equalsIgnoreCase("-v") || !stoke.hasMoreTokens()) continue;
                varNames = stoke.nextToken();
            }
        }
        return Ncdumpx.print(nc, out, showValues, ncml, strict, varNames, ct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean print(String filename, Writer out, boolean showAll, boolean showCoords, boolean ncml, boolean strict, String varNames, CancelTask ct) throws IOException {
        try (NetcdfFile nc = null;){
            nc = NetcdfDataset.openFile((String)filename, (CancelTask)ct);
            boolean bl = Ncdumpx.print(nc, out, showAll, showCoords, ncml, strict, varNames, ct);
            return bl;
        }
    }

    public static boolean print(NetcdfFile nc, Writer out, boolean showAll, boolean showCoords, boolean ncml, boolean strict, String varNames, CancelTask ct) throws IOException {
        WantValues showValues = WantValues.none;
        if (showAll) {
            showValues = WantValues.all;
        } else if (showCoords) {
            showValues = WantValues.coordsOnly;
        }
        return Ncdumpx.print(nc, out, showValues, ncml, strict, varNames, ct);
    }

    public static boolean print(NetcdfFile nc, Writer out, WantValues showValues, boolean ncml, boolean strict, String varNames, CancelTask ct) throws IOException {
        block16: {
            boolean headerOnly = showValues == WantValues.none && varNames == null;
            try {
                if (ncml) {
                    Ncdumpx.writeNcML(nc, out, showValues, null);
                    break block16;
                }
                if (headerOnly) {
                    nc.writeCDL(new PrintWriter(out), strict);
                    break block16;
                }
                PrintWriter ps = new PrintWriter(out);
                nc.toStringStart(ps, strict);
                ps.print(" data:\n");
                if (showValues == WantValues.all) {
                    for (Variable v : nc.getVariables()) {
                        Ncdumpx.printArray(v.read(), v.getFullName(), ps, ct);
                        if (ct == null || !ct.isCancel()) continue;
                        return false;
                    }
                } else if (showValues == WantValues.coordsOnly) {
                    for (Variable v : nc.getVariables()) {
                        if (v.isCoordinateVariable()) {
                            Ncdumpx.printArray(v.read(), v.getFullName(), ps, ct);
                        }
                        if (ct == null || !ct.isCancel()) continue;
                        return false;
                    }
                }
                if (showValues != WantValues.all && varNames != null) {
                    StringTokenizer stoke = new StringTokenizer(varNames, ";");
                    while (stoke.hasMoreTokens()) {
                        String varSubset = stoke.nextToken();
                        if (varSubset.indexOf(40) >= 0) {
                            Array data = nc.readSection(varSubset);
                            Ncdumpx.printArray(data, varSubset, ps, ct);
                        } else {
                            Variable v = nc.findVariable(varSubset);
                            if (v == null) {
                                ps.print(" cant find variable: " + varSubset + "\n   " + usage);
                                continue;
                            }
                            if (showValues != WantValues.coordsOnly || v.isCoordinateVariable()) {
                                Ncdumpx.printArray(v.read(), v.getFullName(), ps, ct);
                            }
                        }
                        if (ct == null || !ct.isCancel()) continue;
                        return false;
                    }
                }
                nc.toStringEnd(ps);
            }
            catch (Exception e) {
                e.printStackTrace();
                out.write(e.getMessage());
                out.flush();
                return false;
            }
        }
        out.flush();
        return true;
    }

    public static String printVariableData(VariableIF v, CancelTask ct) throws IOException {
        Array data = v.read();
        StringWriter writer = new StringWriter(10000);
        Ncdumpx.printArray(data, v.getFullName(), new PrintWriter(writer), ct);
        return writer.toString();
    }

    public static String printVariableDataSection(Variable v, String sectionSpec, CancelTask ct) throws IOException, InvalidRangeException {
        Array data = v.read(sectionSpec);
        StringWriter writer = new StringWriter(20000);
        Ncdumpx.printArray(data, v.getFullName(), new PrintWriter(writer), ct);
        return writer.toString();
    }

    public static void printArray(Array array, String name, PrintWriter out, CancelTask ct) throws IOException {
        Ncdumpx.printArray(array, name, null, out, new Indent(2), ct, true);
        out.flush();
    }

    public static String printArray(Array array, String name, CancelTask ct) {
        return Ncdumpx.toString(array, name, ct);
    }

    public static String toString(Array array, String name, CancelTask ct) {
        CharArrayWriter carray = new CharArrayWriter(100000);
        PrintWriter pw = new PrintWriter(carray);
        Ncdumpx.printArray(array, name, null, pw, new Indent(2), ct, true);
        return carray.toString();
    }

    private static void printArray(Array array, String name, String units, PrintWriter out, Indent ilev, CancelTask ct, boolean printSeq) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        if (name != null) {
            out.print(ilev + name + " =");
        }
        ilev.incr();
        if (array == null) {
            out.println("null array for " + name);
            ilev.decr();
            return;
        }
        if (array instanceof ArrayChar && array.getRank() > 0) {
            Ncdumpx.printStringArray(out, (ArrayChar)array, ilev, ct);
        } else if (array.getElementType() == String.class) {
            Ncdumpx.printStringArray(out, array, ilev, ct);
        } else if (array instanceof ArraySequence) {
            if (printSeq) {
                Ncdumpx.printSequence(out, (ArraySequence)array, ilev, ct);
            }
        } else if (array instanceof ArrayStructure) {
            if (array.getSize() == 1L) {
                Ncdumpx.printStructureData(out, (StructureData)array.getObject(array.getIndex()), ilev, ct);
            } else {
                Ncdumpx.printStructureDataArray(out, (ArrayStructure)array, ilev, ct);
            }
        } else if (array.getElementType() == ByteBuffer.class) {
            array.resetLocalIterator();
            while (array.hasNext()) {
                Ncdumpx.printByteBuffer(out, (ByteBuffer)array.next(), ilev);
                out.println(array.hasNext() ? "," : ";");
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
        } else if (array instanceof ArrayObject) {
            Ncdumpx.printVariableArray(out, (ArrayObject)array, ilev, ct);
        } else {
            Ncdumpx.printArray(array, out, ilev, ct);
        }
        if (units != null) {
            out.print(" " + units);
        }
        out.print("\n");
        ilev.decr();
        out.flush();
    }

    private static void printArray(Array ma, PrintWriter out, Indent indent, CancelTask ct) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        Index ima = ma.getIndex();
        if (rank == 0) {
            Object o = ma.getObject(ima);
            o = Ncdumpx.fixUnsigned(o, ma.isUnsigned());
            out.print(o.toString());
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.print("\n" + indent + "{");
        if (rank == 1 && ma.getElementType() != StructureData.class) {
            for (int ii = 0; ii < last; ++ii) {
                Object o = ma.getObject(ima.set(ii));
                o = Ncdumpx.fixUnsigned(o, ma.isUnsigned());
                out.print(o.toString());
                if (ii != last - 1) {
                    out.print(", ");
                }
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
            out.print("}");
            return;
        }
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            Array slice = ma.slice(0, ii);
            Ncdumpx.printArray(slice, out, indent, ct);
            if (ii != last - 1) {
                out.print(",");
            }
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
        indent.decr();
        out.print("\n" + indent + "}");
    }

    static void printStringArray(PrintWriter out, ArrayChar ma, Indent indent, CancelTask ct) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        if (rank == 1) {
            out.print("  \"" + ma.getString() + "\"");
            return;
        }
        if (rank == 2) {
            boolean first = true;
            ArrayChar.StringIterator iter = ma.getStringIterator();
            while (iter.hasNext()) {
                if (!first) {
                    out.print(", ");
                }
                out.print("\"" + iter.next() + "\"");
                first = false;
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.print("\n" + indent + "{");
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            ArrayChar slice = (ArrayChar)ma.slice(0, ii);
            Ncdumpx.printStringArray(out, slice, indent, ct);
            if (ii != last - 1) {
                out.print(",");
            }
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
        indent.decr();
        out.print("\n" + indent + "}");
    }

    private static void printByteBuffer(PrintWriter out, ByteBuffer bb, Indent indent) {
        out.print(indent + "0x");
        int last = bb.limit() - 1;
        if (last < 0) {
            out.printf("00", new Object[0]);
        } else {
            for (int i = 0; i <= last; ++i) {
                out.printf("%02x", bb.get(i));
            }
        }
    }

    static void printStringArray(PrintWriter out, Array ma, Indent indent, CancelTask ct) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        Index ima = ma.getIndex();
        if (rank == 0) {
            out.print("  \"" + ma.getObject(ima) + "\"");
            return;
        }
        if (rank == 1) {
            boolean first = true;
            int i = 0;
            while ((long)i < ma.getSize()) {
                if (!first) {
                    out.print(", ");
                }
                out.print("  \"" + ma.getObject(ima.set(i)) + "\"");
                first = false;
                ++i;
            }
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.print("\n" + indent + "{");
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            ArrayObject slice = (ArrayObject)ma.slice(0, ii);
            Ncdumpx.printStringArray(out, (Array)slice, indent, ct);
            if (ii == last - 1) continue;
            out.print(",");
        }
        indent.decr();
        out.print("\n" + indent + "}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printStructureDataArray(PrintWriter out, ArrayStructure array, Indent indent, CancelTask ct) {
        StructureDataIterator sdataIter = array.getStructureDataIterator();
        int count = 0;
        try {
            while (sdataIter.hasNext()) {
                StructureData sdata = sdataIter.next();
                out.println("\n" + indent + "{");
                Ncdumpx.printStructureData(out, sdata, indent, ct);
                out.print(indent + "} " + sdata.getName() + "(" + count + ")");
                if (ct != null && ct.isCancel()) {
                    return;
                }
                ++count;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            sdataIter.finish();
        }
    }

    private static void printVariableArray(PrintWriter out, ArrayObject array, Indent indent, CancelTask ct) {
        out.println("\n" + indent + "{");
        indent.incr();
        IndexIterator iter = array.getIndexIterator();
        while (iter.hasNext()) {
            Array data = (Array)iter.next();
            Ncdumpx.printArray(data, out, indent, ct);
        }
        indent.decr();
        out.print(indent + "}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printSequence(PrintWriter out, ArraySequence seq, Indent indent, CancelTask ct) {
        StructureDataIterator iter = seq.getStructureDataIterator();
        try {
            while (iter.hasNext()) {
                StructureData sdata = iter.next();
                out.println("\n" + indent + "{");
                Ncdumpx.printStructureData(out, sdata, indent, ct);
                out.print(indent + "} " + sdata.getName());
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            iter.finish();
        }
    }

    public static void printStructureData(PrintWriter out, StructureData sdata) throws IOException {
        Ncdumpx.printStructureData(out, sdata, new Indent(2), null);
        out.flush();
    }

    private static void printStructureData(PrintWriter out, StructureData sdata, Indent indent, CancelTask ct) {
        indent.incr();
        for (StructureMembers.Member m : sdata.getMembers()) {
            Array sdataArray = sdata.getArray(m);
            Ncdumpx.printArray(sdataArray, m.getName(), m.getUnitsString(), out, indent, ct, true);
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
        indent.decr();
    }

    public static String toString(StructureData sdata) throws IOException {
        CharArrayWriter carray = new CharArrayWriter(1000);
        PrintWriter pw = new PrintWriter(carray);
        for (StructureMembers.Member m : sdata.getMembers()) {
            Array memData = sdata.getArray(m);
            if (memData instanceof ArrayChar) {
                pw.print(((ArrayChar)memData).getString());
            } else {
                Ncdumpx.printArray(memData, pw);
            }
            pw.print(',');
        }
        return carray.toString();
    }

    public static void printArray(Array ma, PrintWriter out) {
        ma.resetLocalIterator();
        while (ma.hasNext()) {
            out.print(ma.next());
            out.print(' ');
        }
    }

    public static void printArray(Array ma) {
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, CDM.utf8Charset));
        Ncdumpx.printArray(ma, out);
        out.flush();
    }

    public static String toString(Array ma) throws IOException {
        return Ncdumpx.toString(ma, "", null);
    }

    public static void writeNcML(NetcdfFile ncfile, Writer os, boolean showCoords, String url) throws IOException {
        Ncdumpx.writeNcML(ncfile, os, showCoords ? WantValues.coordsOnly : WantValues.none, url);
    }

    public static void writeNcML(NetcdfFile ncfile, Writer os, WantValues showValues, String url) throws IOException {
        Ncdumpx.writeNcML(ncfile, new Formatter(os), showValues, url);
    }

    public static void writeNcML(NetcdfFile ncfile, Formatter out, WantValues showValues, String url) throws IOException {
        out.format("<?xml version='1.0' encoding='UTF-8'?>%n", new Object[0]);
        out.format("<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'%n", new Object[0]);
        if (url != null) {
            out.format("    location='%s' >%n%n", StringUtil2.quoteXmlAttribute((String)url));
        } else {
            out.format("    location='%s' >%n%n", StringUtil2.quoteXmlAttribute((String)URLnaming.canonicalizeWrite((String)ncfile.getLocation())));
        }
        if (ncfile.getId() != null) {
            out.format("    id='%s'%n", StringUtil2.quoteXmlAttribute((String)ncfile.getId()));
        }
        if (ncfile.getTitle() != null) {
            out.format("    title='%s'%n", StringUtil2.quoteXmlAttribute((String)ncfile.getTitle()));
        }
        Ncdumpx.writeNcMLGroup(ncfile, ncfile.getRootGroup(), out, new Indent(2), showValues);
        out.format("</netcdf>%n", new Object[0]);
        out.flush();
    }

    public static void writeNcMLVariable(Variable v, Formatter out) throws IOException {
        if (v instanceof Structure) {
            Ncdumpx.writeNcMLStructure((Structure)v, out, new Indent(2), WantValues.none);
        } else {
            Ncdumpx.writeNcMLVariable(v, out, new Indent(2), WantValues.none);
        }
    }

    private static void writeNcMLGroup(NetcdfFile ncfile, Group g, Formatter out, Indent indent, WantValues showValues) throws IOException {
        if (g != ncfile.getRootGroup()) {
            out.format("%s<group name='%s' >%n", indent, StringUtil2.quoteXmlAttribute((String)g.getShortName()));
        }
        indent.incr();
        List dimList = g.getDimensions();
        for (Dimension dim : dimList) {
            out.format("%s<dimension name='%s' length='%s'", indent, StringUtil2.quoteXmlAttribute((String)dim.getShortName()), dim.getLength());
            if (dim.isUnlimited()) {
                out.format(" isUnlimited='true'", new Object[0]);
            }
            out.format(" />%n", new Object[0]);
        }
        if (dimList.size() > 0) {
            out.format("%n", new Object[0]);
        }
        List attList = g.getAttributes();
        for (Attribute att : attList) {
            Ncdumpx.writeNcMLAtt(att, out, indent);
        }
        if (attList.size() > 0) {
            out.format("%n", new Object[0]);
        }
        for (Variable v : g.getVariables()) {
            if (v instanceof Structure) {
                Ncdumpx.writeNcMLStructure((Structure)v, out, indent, showValues);
                continue;
            }
            Ncdumpx.writeNcMLVariable(v, out, indent, showValues);
        }
        List groupList = g.getGroups();
        for (int i = 0; i < groupList.size(); ++i) {
            if (i > 0) {
                out.format("%n", new Object[0]);
            }
            Group nested = (Group)groupList.get(i);
            Ncdumpx.writeNcMLGroup(ncfile, nested, out, indent, showValues);
        }
        indent.decr();
        if (g != ncfile.getRootGroup()) {
            out.format("%s</group>%n", indent);
        }
    }

    private static void writeNcMLStructure(Structure s, Formatter out, Indent indent, WantValues showValues) throws IOException {
        out.format("%s<structure name='%s", indent, StringUtil2.quoteXmlAttribute((String)s.getShortName()));
        if (s.getRank() > 0) {
            Ncdumpx.writeNcMLDimension((Variable)s, out);
        }
        out.format(">%n", new Object[0]);
        indent.incr();
        List attList = s.getAttributes();
        for (Attribute att : attList) {
            Ncdumpx.writeNcMLAtt(att, out, indent);
        }
        if (attList.size() > 0) {
            out.format("%n", new Object[0]);
        }
        List varList = s.getVariables();
        for (Variable v : varList) {
            Ncdumpx.writeNcMLVariable(v, out, indent, showValues);
        }
        indent.decr();
        out.format("%s</structure>%n", indent);
    }

    private static void writeNcMLVariable(Variable v, Formatter out, Indent indent, WantValues showValues) throws IOException {
        out.format("%s<variable name='%s' type='%s'", indent, StringUtil2.quoteXmlAttribute((String)v.getShortName()), v.getDataType());
        if (v.getRank() > 0) {
            Ncdumpx.writeNcMLDimension(v, out);
        }
        indent.incr();
        boolean closed = false;
        List atts = v.getAttributes();
        if (atts.size() > 0) {
            out.format(" >%n", new Object[0]);
            closed = true;
            for (Attribute att : atts) {
                Ncdumpx.writeNcMLAtt(att, out, indent);
            }
        }
        if (showValues == WantValues.all || showValues == WantValues.coordsOnly && v.isCoordinateVariable()) {
            if (!closed) {
                out.format(" >%n", new Object[0]);
                closed = true;
            }
            Ncdumpx.writeNcMLValues(v, out, indent);
        }
        indent.decr();
        if (!closed) {
            out.format(" />%n", new Object[0]);
        } else {
            out.format("%s</variable>%n", indent);
        }
    }

    private static void writeNcMLDimension(Variable v, Formatter out) {
        out.format(" shape='", new Object[0]);
        List dims = v.getDimensions();
        for (int j = 0; j < dims.size(); ++j) {
            Dimension dim = (Dimension)dims.get(j);
            if (j != 0) {
                out.format(" ", new Object[0]);
            }
            if (dim.isShared()) {
                out.format("%s", StringUtil2.quoteXmlAttribute((String)dim.getShortName()));
                continue;
            }
            out.format("%d", dim.getLength());
        }
        out.format("'", new Object[0]);
    }

    private static void writeNcMLAtt(Attribute att, Formatter out, Indent indent) {
        out.format("%s<attribute name='%s' value='", indent, StringUtil2.quoteXmlAttribute((String)att.getShortName()));
        if (att.isString()) {
            for (int i = 0; i < att.getLength(); ++i) {
                if (i > 0) {
                    out.format("\\, ", new Object[0]);
                }
                out.format("%s", StringUtil2.quoteXmlAttribute((String)att.getStringValue(i)));
            }
        } else {
            for (int i = 0; i < att.getLength(); ++i) {
                if (i > 0) {
                    out.format(" ", new Object[0]);
                }
                out.format("%s ", att.getNumericValue(i));
            }
            out.format("' type='%s", att.getDataType());
        }
        out.format("' />%n", new Object[0]);
    }

    private static void writeNcMLValues(Variable v, Formatter out, Indent indent) throws IOException {
        Array data = v.read();
        int width = Ncdumpx.formatValues(indent + "<values>", out, 0, indent);
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext()) {
            width = Ncdumpx.formatValues(ii.next() + " ", out, width, indent);
        }
        Ncdumpx.formatValues("</values>\n", out, width, indent);
    }

    private static int formatValues(String s, Formatter out, int width, Indent indent) {
        int totalWidth;
        int len = s.length();
        if (len + width > (totalWidth = 80)) {
            out.format("%n%s", indent);
            width = indent.toString().length();
        }
        out.format("%s", s);
        return width += len;
    }

    public static String encodeString(String s) {
        return StringUtil2.replace((String)s, (char[])org, (String[])replace);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(usage);
            return;
        }
        StringBuilder sbuff = new StringBuilder();
        for (String arg : args) {
            sbuff.append(arg);
            sbuff.append(" ");
        }
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, CDM.utf8Charset));
            Ncdumpx.print(sbuff.toString(), writer, null);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static enum WantValues {
        none,
        coordsOnly,
        all;

    }
}

