/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Variable;
import ucar.nc2.dt.image.image.ImageArrayAdapter;
import ucar.nc2.ui.image.ImageViewPanel;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.ProgressMonitorTask;
import ucar.nc2.ui.widget.StopButton;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.CancelTask;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.ComboBox;

public class NCdumpPane
extends TextHistoryPane {
    private static final String ImageViewer_WindowSize = "ImageViewer_WindowSize";
    private PreferencesExt prefs;
    private ComboBox cb;
    private CommonTask task;
    private StopButton stopButton;
    private NetcdfFile ds;
    private IndependentWindow imageWindow = null;
    private ImageViewPanel imageView = null;

    public NCdumpPane(PreferencesExt prefs) {
        super(true);
        this.prefs = prefs;
        this.cb = new ComboBox(prefs);
        JButton getButton = new JButton("NCdump");
        getButton.setToolTipText("show selected data values");
        getButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NCdumpPane.this.ncdump((String)NCdumpPane.this.cb.getSelectedItem());
            }
        });
        JButton imageButton = new JButton("Image");
        imageButton.setToolTipText("view selected data as Image");
        imageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NCdumpPane.this.showImage((String)NCdumpPane.this.cb.getSelectedItem());
            }
        });
        JButton binButton = new JButton("Write");
        binButton.setToolTipText("write binary data to file");
        binButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NCdumpPane.this.writeBinaryData((String)NCdumpPane.this.cb.getSelectedItem());
            }
        });
        this.stopButton = new StopButton("stop NCdump");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NCdumpPane.this.ta.setText(((NCdumpPane)NCdumpPane.this).task.v.toString());
                NCdumpPane.this.ta.append("\n data:\n");
                NCdumpPane.this.ta.append(((NCdumpPane)NCdumpPane.this).task.contents);
                if (e.getActionCommand().equals("success")) {
                    NCdumpPane.this.cb.setSelectedItem(((NCdumpPane)NCdumpPane.this).task.command);
                }
            }
        });
        JPanel buttPanel = new JPanel(new FlowLayout(0, 5, 0));
        buttPanel.add(getButton);
        buttPanel.add(imageButton);
        buttPanel.add(binButton);
        buttPanel.add(this.stopButton);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new JLabel("Variable:"), "West");
        topPanel.add((Component)this.cb, "Center");
        topPanel.add((Component)buttPanel, "East");
        this.add((Component)topPanel, "North");
    }

    public void setContext(NetcdfFile ds, String command) {
        this.ds = ds;
        this.cb.addItem(command);
    }

    private void ncdump(String command) {
        if (this.ds == null) {
            return;
        }
        if (command == null) {
            return;
        }
        this.task = new NCdumpTask(command);
        if (this.task.v != null) {
            this.stopButton.startProgressMonitorTask(this.task);
        }
    }

    private void showImage(String command) {
        if (this.ds == null) {
            return;
        }
        if (command == null) {
            return;
        }
        if (this.imageWindow == null) {
            this.makeImageViewer();
        }
        this.task = new GetContentsTask(command);
        if (this.task.v != null) {
            this.stopButton.startProgressMonitorTask(this.task);
        }
    }

    private void writeBinaryData(String variableSection) {
        ParsedSectionSpec cer;
        try {
            cer = ParsedSectionSpec.parseVariableSection((NetcdfFile)this.ds, (String)variableSection);
            if (cer.child != null) {
                return;
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            return;
        }
        String name = "C:/temp/file.bin";
        try (FileOutputStream stream = new FileOutputStream(name);){
            FileChannel channel = stream.getChannel();
            cer.v.readToByteChannel(cer.section, (WritableByteChannel)channel);
            System.out.printf("Write ok to %s%n", name);
        }
        catch (IOException | InvalidRangeException e) {
            e.printStackTrace();
        }
    }

    private void makeImageViewer() {
        this.imageWindow = new IndependentWindow("Image Viewer", BAMutil.getImage("ImageData"));
        this.imageView = new ImageViewPanel(null);
        this.imageWindow.setComponent(new JScrollPane(this.imageView));
        Rectangle b = (Rectangle)this.prefs.getBean(ImageViewer_WindowSize, new Rectangle(99, 33, 700, 900));
        this.imageWindow.setBounds(b);
    }

    public void save() {
        this.cb.save();
        if (this.imageWindow != null) {
            this.prefs.putBeanObject(ImageViewer_WindowSize, this.imageWindow.getBounds());
        }
    }

    @Override
    public void clear() {
        this.ta.setText(null);
    }

    @Override
    public String getText() {
        return this.ta.getText();
    }

    @Override
    public void gotoTop() {
        this.ta.setCaretPosition(0);
    }

    @Override
    public void setText(String text) {
        this.ta.setText(text);
    }

    private class NCdumpTask
    extends CommonTask {
        NCdumpTask(String command) {
            super(command);
        }

        @Override
        public void run() {
            try {
                this.data = NCdumpPane.this.ds.readSection(this.command);
                this.contents = NCdumpW.toString((Array)this.data, null, (CancelTask)this);
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter(100000);
                e.printStackTrace(new PrintWriter(sw));
                this.contents = sw.toString();
                this.setError(e.getMessage());
                this.done = true;
                return;
            }
            if (this.cancel) {
                this.contents = "\n***Cancelled by User";
            }
            this.success = !this.cancel;
            this.done = true;
        }
    }

    private class GetContentsTask
    extends CommonTask {
        GetContentsTask(String command) {
            super(command);
        }

        @Override
        public void run() {
            StringWriter sw = new StringWriter(100000);
            PrintWriter ps = new PrintWriter(sw);
            try {
                this.data = NCdumpPane.this.ds.readSection(this.command);
                if (this.data != null) {
                    NCdumpPane.this.imageView.setImage(ImageArrayAdapter.makeGrayscaleImage((Array)((NCdumpPane)NCdumpPane.this).task.data));
                    NCdumpPane.this.imageWindow.show();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintWriter(sw));
                this.contents = sw.toString();
                this.setError(e.getMessage());
                this.done = true;
                return;
            }
            if (this.cancel) {
                ps.println("\n***Cancelled by User");
            }
            this.contents = sw.toString();
            this.success = !this.cancel;
            this.done = true;
        }
    }

    private abstract class CommonTask
    extends ProgressMonitorTask
    implements CancelTask {
        String contents;
        String command;
        Variable v = null;
        Array data;

        CommonTask(String command) {
            this.command = command;
            try {
                ParsedSectionSpec cer = ParsedSectionSpec.parseVariableSection((NetcdfFile)NCdumpPane.this.ds, (String)command);
                while (cer != null) {
                    this.v = cer.v;
                    cer = cer.child;
                }
            }
            catch (Exception e) {
                NCdumpPane.this.ta.setText(e.getMessage());
            }
        }
    }
}

