/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.iosp.bufr.writer.BufrSplitter2;
import ucar.nc2.ui.ReportPanel;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class BufrReportPanel
extends ReportPanel {
    public BufrReportPanel(PreferencesExt prefs) {
        super(prefs);
    }

    @Override
    public Object[] getOptions() {
        return Report.values();
    }

    @Override
    protected void doReport(Formatter f, Object option, MCollection dcm, boolean useIndex, boolean eachFile, boolean extra) throws IOException {
        Report which = (Report)((Object)option);
        switch (which) {
            case bufrSplitter: {
                this.doBufrSplitter(f, dcm, useIndex);
                break;
            }
            case checkHash: {
                this.doCheckHash(f, dcm, useIndex);
            }
        }
    }

    private void doCheckHash(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        f.format("Check Files for hash consistency%n", new Object[0]);
        int[] accum = new int[4];
        TrackMessageTypes all = new TrackMessageTypes();
        for (MFile mfile : dcm.getFilesSorted()) {
            String path = mfile.getPath();
            if (path.endsWith(".ncx")) continue;
            f.format("%n %s%n", path);
            try {
                this.doCheckHash(mfile, f, all, accum);
            }
            catch (Throwable t) {
                System.out.printf("FAIL on %s%n", mfile.getPath());
                t.printStackTrace();
            }
        }
        f.format("%n================%nTotals countMess=%d countObs = %d%n", accum[0], accum[1]);
        this.show(all, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckHash(MFile ff, Formatter fm, TrackMessageTypes all, int[] accum) throws IOException {
        TrackMessageTypes oneFile = new TrackMessageTypes();
        int countMess = 0;
        int countObs = 0;
        try (RandomAccessFile raf = null;){
            raf = new RandomAccessFile(ff.getPath(), "r");
            MessageScanner scan = new MessageScanner(raf, 0L, true);
            while (scan.hasNext()) {
                Message m = scan.next();
                if (m == null) continue;
                oneFile.add(m);
                all.add(m);
                ++countMess;
                countObs += m.getNumberDatasets();
            }
        }
        this.show(oneFile, fm);
        accum[0] = accum[0] + countMess;
        accum[1] = accum[1] + countObs;
    }

    private void show(TrackMessageTypes track, Formatter f) throws IOException {
        ArrayList<Message> mess = new ArrayList<Message>(track.map.keySet());
        Collections.sort(mess, new Comparator<Message>(){

            @Override
            public int compare(Message o1, Message o2) {
                return o1.getLookup().getCategoryNo().compareTo(o2.getLookup().getCategoryNo());
            }
        });
        f.format("  nmess / nobs (hash) (ddsHash) category - center %n", new Object[0]);
        for (Message m : mess) {
            Count hashCount = track.map.get(m);
            f.format("   %6d/%7d (%8s) (%8s) %s - %s%n", hashCount.nmess, hashCount.nobs, Integer.toHexString(m.hashCode()), Integer.toHexString(m.dds.getDataDescriptors().hashCode()), m.getLookup().getCategoryFullName(), m.getLookup().getCenterNo());
        }
    }

    private void doBufrSplitter(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        long start = System.currentTimeMillis();
        String dirName = dcm.getRoot() + "/split";
        f.format("BufrSplitter on files in collection %s, write to %s%n", dcm, dirName);
        BufrSplitter2 splitter = new BufrSplitter2(dirName, f);
        for (MFile mfile : dcm.getFilesSorted()) {
            String path = mfile.getPath();
            if (path.endsWith(".ncx")) continue;
            f.format("%n %s%n", path);
            System.out.printf(" BufrSplitter on %s%n", path);
            long start2 = System.currentTimeMillis();
            try {
                splitter.execute(path);
                long took2 = System.currentTimeMillis() - start2;
                System.out.printf("  %s took %s msecs%n", path, took2);
            }
            catch (Throwable t) {
                System.out.printf("FAIL on %s%n", mfile.getPath());
                t.printStackTrace();
            }
        }
        splitter.exit();
        long took = (System.currentTimeMillis() - start) / 1000L;
        System.out.printf("That took %s secs%n", took);
    }

    private static class TrackMessageTypes {
        HashMap<Message, Count> map = new HashMap();

        private TrackMessageTypes() {
        }

        void add(Message m) {
            Count hashCount = this.map.get(m);
            if (hashCount == null) {
                this.map.put(m, new Count(m.getNumberDatasets()));
            } else {
                ++hashCount.nmess;
                hashCount.nobs += m.getNumberDatasets();
            }
        }
    }

    private static class Count {
        int nmess = 1;
        int nobs = 0;

        private Count(int nobs) {
            this.nobs = nobs;
        }
    }

    public static enum Report {
        checkHash,
        bufrSplitter;

    }
}

