/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.geoloc;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import ucar.nc2.ui.geoloc.NavigatedPanel;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;

public class Navigation {
    private NavigatedPanel np;
    private double pwidth = 0.0;
    private double pheight = 0.0;
    private double pix_per_world = 1.0;
    private double pix_x0 = 0.0;
    private double pix_y0 = 0.0;
    private ProjectionRect bb;
    private AffineTransform at;
    private boolean mapAreaIsSet = false;
    private boolean screenSizeIsSet = false;
    private ZoomStack zoom = new ZoomStack();
    private static boolean debug = false;
    private static boolean debugZoom = false;
    private static boolean debugTransform = false;
    private static boolean debugRecalc = false;

    Navigation(NavigatedPanel np) {
        this.np = np;
        this.bb = new ProjectionRect();
        this.at = new AffineTransform();
    }

    public double getScreenWidth() {
        return this.pwidth;
    }

    public double getScreenHeight() {
        return this.pheight;
    }

    public void setScreenSize(double pwidth, double pheight) {
        if (pwidth == 0.0 || pheight == 0.0) {
            return;
        }
        if (this.mapAreaIsSet && this.screenSizeIsSet) {
            this.bb.setRect(this.getMapArea(null));
        }
        this.pwidth = pwidth;
        this.pheight = pheight;
        this.screenSizeIsSet = true;
        if (debugRecalc) {
            System.out.println("navigation/setScreenSize " + pwidth + " " + pheight);
        }
        if (this.mapAreaIsSet) {
            this.recalcFromBoundingBox();
        }
        this.fireMapAreaEvent();
    }

    public AffineTransform getTransform() {
        this.at.setTransform(this.pix_per_world, 0.0, 0.0, -this.pix_per_world, this.pix_x0, this.pix_y0);
        if (debug) {
            System.out.println("Navigation getTransform = " + this.pix_per_world + " " + this.pix_x0 + " " + this.pix_y0);
            System.out.println("  transform = " + this.at);
        }
        return this.at;
    }

    public boolean wantRotate(double displayWidth, double displayHeight) {
        this.getMapArea(this.bb);
        boolean aspectDisplay = displayHeight < displayWidth;
        boolean aspectWorldBB = this.bb.getHeight() < this.bb.getWidth();
        return aspectDisplay ^ aspectWorldBB;
    }

    public AffineTransform calcTransform(boolean rotate, double displayX, double displayY, double displayWidth, double displayHeight) {
        double pypsy;
        double pxpsx;
        this.getMapArea(this.bb);
        if (rotate) {
            pxpsx = displayHeight / this.bb.getWidth();
            pypsy = displayWidth / this.bb.getHeight();
        } else {
            pxpsx = displayWidth / this.bb.getWidth();
            pypsy = displayHeight / this.bb.getHeight();
        }
        double pps = Math.min(pxpsx, pypsy);
        double wx0 = this.bb.getX() + this.bb.getWidth() / 2.0;
        double wy0 = this.bb.getY() + this.bb.getHeight() / 2.0;
        double x0 = displayX + displayWidth / 2.0 - pps * wx0;
        double y0 = displayY + displayHeight / 2.0 + pps * wy0;
        AffineTransform cat = new AffineTransform(pps, 0.0, 0.0, -pps, x0, y0);
        if (rotate) {
            cat.rotate(1.5707963267948966, wx0, wy0);
        }
        if (debug) {
            System.out.println("Navigation calcTransform = " + displayX + " " + displayY + " " + displayWidth + " " + displayHeight);
            System.out.println("  world = " + this.bb);
            System.out.println("  scale/origin = " + pps + " " + x0 + " " + y0);
            System.out.println("  transform = " + cat);
        }
        return cat;
    }

    public ProjectionRect getMapArea(ProjectionRect rect) {
        if (rect == null) {
            rect = new ProjectionRect();
        }
        double width = this.pwidth / this.pix_per_world;
        double height = this.pheight / this.pix_per_world;
        double wx0 = (this.pwidth / 2.0 - this.pix_x0) / this.pix_per_world;
        double wy0 = (this.pix_y0 - this.pheight / 2.0) / this.pix_per_world;
        rect.setRect(wx0 - width / 2.0, wy0 - height / 2.0, width, height);
        return rect;
    }

    public void setMapArea(ProjectionRect ma) {
        if (debugRecalc) {
            System.out.println("navigation/setMapArea " + ma);
        }
        this.bb.setRect(ma);
        this.zoom.push();
        this.mapAreaIsSet = true;
        if (this.screenSizeIsSet) {
            this.recalcFromBoundingBox();
            this.fireMapAreaEvent();
        }
    }

    void setWorldCenterX(double wx_center) {
        this.pix_x0 = this.pwidth / 2.0 - this.pix_per_world * wx_center;
    }

    public Point2D worldToScreen(ProjectionPointImpl w, Point2D p) {
        p.setLocation(this.pix_per_world * w.getX() + this.pix_x0, -this.pix_per_world * w.getY() + this.pix_y0);
        return p;
    }

    public ProjectionPointImpl screenToWorld(Point2D p, ProjectionPointImpl w) {
        w.setLocation((p.getX() - this.pix_x0) / this.pix_per_world, (this.pix_y0 - p.getY()) / this.pix_per_world);
        return w;
    }

    public double getPixPerWorld() {
        return this.pix_per_world;
    }

    public ProjectionRect screenToWorld(Point2D start, Point2D end) {
        ProjectionPointImpl p1 = new ProjectionPointImpl();
        ProjectionPointImpl p2 = new ProjectionPointImpl();
        this.screenToWorld(start, p1);
        this.screenToWorld(end, p2);
        return new ProjectionRect(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public Rectangle worldToScreen(ProjectionRect projRect) {
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        this.worldToScreen((ProjectionPointImpl)projRect.getMaxPoint(), p1);
        this.worldToScreen((ProjectionPointImpl)projRect.getMinPoint(), p2);
        return new Rectangle((int)((Point2D)p1).getX(), (int)((Point2D)p1).getY(), (int)((Point2D)p2).getX(), (int)((Point2D)p2).getY());
    }

    public void pan(double deltax, double deltay) {
        this.zoom.push();
        this.pix_x0 -= deltax;
        this.pix_y0 -= deltay;
        this.fireMapAreaEvent();
    }

    public void zoom(double startx, double starty, double width, double height) {
        if (debugZoom) {
            System.out.println("zoom " + startx + " " + starty + " " + width + " " + height + " ");
        }
        if (width < 5.0 || height < 5.0) {
            return;
        }
        this.zoom.push();
        this.pix_x0 -= startx + width / 2.0 - this.pwidth / 2.0;
        this.pix_y0 -= starty + height / 2.0 - this.pheight / 2.0;
        this.zoom(this.pwidth / width);
    }

    public void zoomIn(double x, double y) {
        this.zoomIn();
    }

    public void zoomOut(double x, double y) {
        this.zoomOut();
    }

    public void zoomIn() {
        this.zoom(2.0);
    }

    public void zoomOut() {
        this.zoom(0.5);
    }

    private void zoom(double scale) {
        this.zoom.push();
        double fac = 1.0 - scale;
        this.pix_x0 = scale * this.pix_x0 + fac * this.pwidth / 2.0;
        this.pix_y0 = scale * this.pix_y0 + fac * this.pheight / 2.0;
        this.pix_per_world *= scale;
        this.fireMapAreaEvent();
    }

    public void moveDown() {
        this.zoom.push();
        this.pix_y0 -= this.pheight / 2.0;
        this.fireMapAreaEvent();
    }

    public void moveUp() {
        this.zoom.push();
        this.pix_y0 += this.pheight / 2.0;
        this.fireMapAreaEvent();
    }

    public void moveRight() {
        this.zoom.push();
        this.pix_x0 -= this.pwidth / 2.0;
        this.fireMapAreaEvent();
    }

    public void moveLeft() {
        this.zoom.push();
        this.pix_x0 += this.pwidth / 2.0;
        this.fireMapAreaEvent();
    }

    public void zoomPrevious() {
        this.zoom.pop();
        this.fireMapAreaEvent();
    }

    private void recalcFromBoundingBox() {
        if (debugRecalc) {
            System.out.println("Navigation recalcFromBoundingBox= " + this.bb);
            System.out.println("  " + this.pwidth + " " + this.pheight);
        }
        double pixx_per_wx = this.bb.getWidth() == 0.0 ? 1.0 : this.pwidth / this.bb.getWidth();
        double pixy_per_wy = this.bb.getHeight() == 0.0 ? 1.0 : this.pheight / this.bb.getHeight();
        this.pix_per_world = Math.min(pixx_per_wx, pixy_per_wy);
        double wx0 = this.bb.getX() + this.bb.getWidth() / 2.0;
        double wy0 = this.bb.getY() + this.bb.getHeight() / 2.0;
        this.pix_x0 = this.pwidth / 2.0 - this.pix_per_world * wx0;
        this.pix_y0 = this.pheight / 2.0 + this.pix_per_world * wy0;
        if (debugRecalc) {
            System.out.println("Navigation recalcFromBoundingBox done= " + this.pix_per_world + " " + this.pix_x0 + " " + this.pix_y0);
            System.out.println("  " + this.pwidth + " " + this.pheight + " " + this.bb);
        }
    }

    private synchronized void fireMapAreaEvent() {
        this.np.fireMapAreaEvent();
    }

    private class ZoomStack
    extends ArrayList {
        private int current;

        ZoomStack() {
            super(20);
            this.current = -1;
        }

        void push() {
            ++this.current;
            this.add(this.current, new Zoom(Navigation.this.pix_per_world, Navigation.this.pix_x0, Navigation.this.pix_y0));
        }

        void pop() {
            if (this.current < 0) {
                return;
            }
            Zoom zoom = (Zoom)this.get(this.current);
            Navigation.this.pix_per_world = zoom.pix_per_world;
            Navigation.this.pix_x0 = zoom.pix_x0;
            Navigation.this.pix_y0 = zoom.pix_y0;
            --this.current;
        }

        private class Zoom {
            double pix_per_world;
            double pix_x0;
            double pix_y0;

            Zoom(double p1, double p2, double p3) {
                this.pix_per_world = p1;
                this.pix_x0 = p2;
                this.pix_y0 = p3;
            }
        }
    }
}

