/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.table;

import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.ui.table.ColumnWidthsResizer;
import ucar.nc2.ui.table.HidableTableColumnModel;
import ucar.nc2.ui.util.Resource;
import ucar.nc2.ui.widget.BAMutil;

public class TableAppearanceAction
extends AbstractAction {
    private static final Logger logger = LoggerFactory.getLogger(TableAppearanceAction.class);
    private final JTable table;

    public TableAppearanceAction(JTable table) {
        if (!(table.getColumnModel() instanceof HidableTableColumnModel)) {
            throw new IllegalArgumentException("table's TableColumnModel must be an instance of HidableTableColumnModel.");
        }
        this.table = table;
        this.putValue("Name", "Table appearance");
        this.putValue("SmallIcon", Resource.getIcon(BAMutil.getResourcePath() + "TableAppearance.png", true));
        this.putValue("ShortDescription", "Configure the appearance of the table.");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JComponent) {
            JComponent invoker = (JComponent)e.getSource();
            this.buildPopupMenu().show(invoker, invoker.getWidth() / 2, invoker.getHeight() / 2);
        } else {
            logger.error(String.format("JPopupMenu requires a JComponent invoker, but was %s", e.getSource()));
        }
    }

    private JPopupMenu buildPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu(this.getValue("Name").toString());
        popupMenu.add(new ResizeColumnWidthsAction());
        popupMenu.addSeparator();
        popupMenu.add(new ShowAllColumnsAction());
        popupMenu.add(new HideAllColumnsAction());
        popupMenu.addSeparator();
        Enumeration<TableColumn> allTableColumns = this.getTableColumnModel().getColumns(false);
        while (allTableColumns.hasMoreElements()) {
            TableColumn tableColumn = allTableColumns.nextElement();
            ColumnVisibilityAction columnVisibilityAction = new ColumnVisibilityAction(tableColumn);
            JCheckBoxMenuItem columnVisibilityMenuItem = new JCheckBoxMenuItem(columnVisibilityAction);
            popupMenu.add(columnVisibilityMenuItem);
        }
        return popupMenu;
    }

    private HidableTableColumnModel getTableColumnModel() {
        return (HidableTableColumnModel)this.table.getColumnModel();
    }

    private class ColumnVisibilityAction
    extends AbstractAction {
        private final TableColumn column;

        private ColumnVisibilityAction(TableColumn column) {
            this.column = column;
            this.putValue("Name", column.getHeaderValue().toString());
            this.putValue("ShortDescription", "Check to show this column; uncheck to hide it.");
            this.putValue("SwingSelectedKey", TableAppearanceAction.this.getTableColumnModel().isColumnVisible(column));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isSelected = (Boolean)this.getValue("SwingSelectedKey");
            TableAppearanceAction.this.getTableColumnModel().setColumnVisible(this.column, isSelected);
        }
    }

    private class HideAllColumnsAction
    extends AbstractAction {
        private HideAllColumnsAction() {
            this.putValue("Name", "Hide all columns");
            this.putValue("ShortDescription", "Hide all columns in the table.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Enumeration<TableColumn> allTableColumns = TableAppearanceAction.this.getTableColumnModel().getColumns(false);
            while (allTableColumns.hasMoreElements()) {
                TableColumn tableColumn = allTableColumns.nextElement();
                TableAppearanceAction.this.getTableColumnModel().setColumnVisible(tableColumn, false);
            }
        }
    }

    private class ShowAllColumnsAction
    extends AbstractAction {
        private ShowAllColumnsAction() {
            this.putValue("Name", "Show all columns");
            this.putValue("ShortDescription", "Show all columns in the table.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Enumeration<TableColumn> allTableColumns = TableAppearanceAction.this.getTableColumnModel().getColumns(false);
            while (allTableColumns.hasMoreElements()) {
                TableColumn tableColumn = allTableColumns.nextElement();
                TableAppearanceAction.this.getTableColumnModel().setColumnVisible(tableColumn, true);
            }
        }
    }

    private class ResizeColumnWidthsAction
    extends AbstractAction {
        private ResizeColumnWidthsAction() {
            this.putValue("Name", "Resize column widths");
            this.putValue("ShortDescription", "Resize widths of the columns so that they're big enough to display all of their contents.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnWidthsResizer.resize(TableAppearanceAction.this.table);
        }
    }
}

