/*
 * Decompiled with CFR 0.152.
 */
package ucar.util.prefs.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import ucar.util.prefs.PersistenceManager;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.Field;
import ucar.util.prefs.ui.FieldResizable;

public class PrefPanel
extends JPanel {
    private String name;
    private Preferences prefs;
    private PersistenceManager storeData;
    private boolean finished = false;
    private HashMap<String, Field> flds = new HashMap(40);
    private List<LayoutComponent> layoutComponents;
    private int cursorRow = 0;
    private int cursorCol = 0;
    private JPanel mainPanel;
    private List<JComponent> auxButtons = new ArrayList<JComponent>();
    private EventListenerList listenerList = new EventListenerList();
    private boolean debugLayout = false;

    public PrefPanel(String name, PreferencesExt prefs) {
        this(name, prefs, prefs);
    }

    public PrefPanel(String name, Preferences prefs, PersistenceManager storeData) {
        this.name = name;
        this.prefs = prefs;
        this.storeData = storeData;
        this.layoutComponents = new ArrayList<LayoutComponent>(20);
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    private void fireEvent(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    public boolean accept() {
        StringBuffer buff = new StringBuffer("Invalid field value ");
        boolean ok = true;
        for (Field o : this.flds.values()) {
            ok &= o.accept(buff);
        }
        if (!ok) {
            try {
                JOptionPane.showMessageDialog(PrefPanel.findActiveFrame(), buff.toString());
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
            return false;
        }
        this.fireEvent(new ActionEvent(this, 0, "Accept"));
        return true;
    }

    @Override
    public void setEnabled(boolean enable) {
        for (Field field : this.flds.values()) {
            field.setEnabled(enable);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Iterator<Field> getFields() {
        return this.flds.values().iterator();
    }

    public Field getField(String name) {
        Field fld = this.flds.get(name);
        if (fld == null) {
            return null;
        }
        return fld instanceof FieldResizable ? ((FieldResizable)fld).getDelegate() : fld;
    }

    public Object getFieldValue(String name) {
        Field fld = this.getField(name);
        if (fld == null) {
            throw new IllegalArgumentException("no field named " + name);
        }
        return fld.getValue();
    }

    public void setFieldValue(String name, Object value) {
        Field fld = this.getField(name);
        if (fld == null) {
            throw new IllegalArgumentException("no field named " + name);
        }
        fld.setValue(value);
    }

    public void addButton(JComponent b) {
        this.auxButtons.add(b);
    }

    public Field addField(Field fld) {
        this.addField(fld, this.cursorCol, this.cursorRow, null);
        ++this.cursorRow;
        return fld;
    }

    public Field addField(Field fld, int col, int row, String constraint) {
        if (null != this.flds.get(fld.getName())) {
            throw new IllegalArgumentException("PrefPanel: already have field named " + fld.getName());
        }
        this.flds.put(fld.getName(), fld);
        this.layoutComponents.add(new LayoutComponent(fld, col, row, constraint));
        fld.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                PrefPanel.this.revalidate();
            }
        });
        return fld;
    }

    public Field.BeanTableField addBeanTableField(String fldName, String label, ArrayList beans, Class beanClass, int col, int row, String constraint) {
        Field.BeanTableField fld = new Field.BeanTableField(fldName, label, beans, beanClass, (PreferencesExt)this.prefs, this.storeData);
        this.addField(fld, col, row, constraint);
        return fld;
    }

    public Field.CheckBox addCheckBoxField(String fldName, String label, boolean defValue) {
        Field.CheckBox fld = new Field.CheckBox(fldName, label, defValue, this.storeData);
        this.addField(fld);
        return fld;
    }

    public Field.CheckBox addCheckBoxField(String fldName, String label, boolean defValue, int col, int row) {
        Field.CheckBox fld = new Field.CheckBox(fldName, label, defValue, this.storeData);
        this.addField(fld, col, row, null);
        return fld;
    }

    public Field.Date addDateField(String fldName, String label, Date defValue) {
        Field.Date fld = new Field.Date(fldName, label, defValue, this.storeData);
        this.addField(new FieldResizable(fld, this));
        return fld;
    }

    public Field.Date addDateField(String fldName, String label, Date defValue, int col, int row, String constraint) {
        Field.Date fld = new Field.Date(fldName, label, defValue, this.storeData);
        this.addField(fld, col, row, constraint);
        return fld;
    }

    public Field.Double addDoubleField(String fldName, String label, double defValue) {
        Field.Double fld = new Field.Double(fldName, label, defValue, -1, this.storeData);
        this.addField(new FieldResizable(fld, this));
        return fld;
    }

    public Field.Double addDoubleField(String fldName, String label, double defValue, int col, int row, String constraint) {
        Field.Double fld = new Field.Double(fldName, label, defValue, -1, this.storeData);
        this.addField(fld, col, row, constraint);
        return fld;
    }

    public Field.Double addDoubleField(String fldName, String label, double defValue, int nfracDig, int col, int row, String constraint) {
        Field.Double fld = new Field.Double(fldName, label, defValue, nfracDig, this.storeData);
        this.addField(fld, col, row, constraint);
        return fld;
    }

    public Field.EnumCombo addEnumComboField(String fldName, String label, Collection defValues, boolean editable, int col, int row, String constraint) {
        Field.EnumCombo fld = new Field.EnumCombo(fldName, label, defValues, this.storeData);
        this.addField(fld, col, row, constraint);
        fld.setEditable(editable);
        return fld;
    }

    public Field.EnumCombo addEnumComboField(String fldName, String label, Collection defValues, boolean editable) {
        Field.EnumCombo fld = new Field.EnumCombo(fldName, label, defValues, this.storeData);
        this.addField(fld);
        fld.setEditable(editable);
        return fld;
    }

    public Field.Int addIntField(String fldName, String label, int defValue) {
        Field.Int fld = new Field.Int(fldName, label, defValue, this.storeData);
        this.addField(new FieldResizable(fld, this));
        return fld;
    }

    public Field.Password addPasswordField(String fldName, String label, String defValue) {
        Field.Password fld = new Field.Password(fldName, label, defValue, this.storeData);
        this.addField(new FieldResizable(fld, this));
        return fld;
    }

    public Field.Text addTextField(String fldName, String label, String defValue) {
        Field.Text fld = new Field.Text(fldName, label, defValue, this.storeData);
        this.addField(new FieldResizable(fld, this));
        return fld;
    }

    public Field.Text addTextField(String fldName, String label, String defValue, int col, int row, String constraint) {
        Field.Text fld = new Field.Text(fldName, label, defValue, this.storeData);
        this.addField(fld, col, row, constraint);
        return fld;
    }

    public Field.TextCombo addTextComboField(String fldName, String label, Collection defValues, int nKeep, boolean editable) {
        Field.TextCombo fld = new Field.TextCombo(fldName, label, defValues, nKeep, this.storeData);
        this.addField(fld);
        fld.setEditable(editable);
        return fld;
    }

    public Field.TextCombo addTextComboField(String fldName, String label, Collection defValues, int nKeep, boolean editable, int col, int row, String constraint) {
        Field.TextCombo fld = new Field.TextCombo(fldName, label, defValues, nKeep, this.storeData);
        this.addField(fld, col, row, constraint);
        fld.setEditable(editable);
        return fld;
    }

    public Field.TextArea addTextAreaField(String fldName, String label, String def, int nrows) {
        Field.TextArea fld = new Field.TextArea(fldName, label, def, nrows, this.storeData);
        this.addField(fld);
        return fld;
    }

    public Field.TextArea addTextAreaField(String fldName, String label, String def, int nrows, int col, int row, String constraint) {
        Field.TextArea fld = new Field.TextArea(fldName, label, def, nrows, this.storeData);
        this.addField(fld, col, row, constraint);
        return fld;
    }

    public void addHeading(String heading) {
        this.addHeading(heading, this.cursorRow);
        ++this.cursorRow;
    }

    public void addHeading(String heading, int row) {
        this.layoutComponents.add(new LayoutComponent(heading, 0, row, null));
    }

    public void addComponent(Component comp, int col, int row, String constraint) {
        this.layoutComponents.add(new LayoutComponent(comp, col, row, constraint));
    }

    public void addSeparator() {
        this.addEmptyRow(this.cursorRow++, 15);
    }

    public void addEmptyRow(int row, int size) {
        this.layoutComponents.add(new LayoutComponent(null, size, row, null));
    }

    public void setCursor(int col, int row) {
        this.cursorCol = col;
        this.cursorRow = row;
    }

    public void finish() {
        this.finish(true);
    }

    public void finish(boolean addButtons) {
        this.finish(addButtons, "South");
    }

    public void finish(boolean addButtons, String where) {
        if (this.finished) {
            throw new IllegalStateException("PrefPanel " + this.name + ": already called finish()");
        }
        StringBuilder sbuff = new StringBuilder();
        Collections.sort(this.layoutComponents, new Comparator<LayoutComponent>(){

            @Override
            public int compare(LayoutComponent o1, LayoutComponent o2) {
                return o1.col - o2.col;
            }

            @Override
            public boolean equals(Object o1) {
                return o1 == this;
            }
        });
        sbuff.setLength(0);
        int currCol = -1;
        for (LayoutComponent lc : this.layoutComponents) {
            if (lc.col > currCol) {
                if (currCol >= 0) {
                    sbuff.append(", 5dlu, ");
                } else {
                    sbuff.append("3dlu, ");
                }
                sbuff.append("right:default, 3dlu, default:grow");
                currCol += 2;
            }
            lc.ccLabel.gridX = 2 * lc.col + 2;
            lc.cc.gridX = 2 * lc.col + 4;
        }
        String colSpec = sbuff.toString();
        if (this.debugLayout) {
            System.out.println(" column layout = " + colSpec);
        }
        int ncols = 2 * currCol;
        Collections.sort(this.layoutComponents, new Comparator<LayoutComponent>(){

            @Override
            public int compare(LayoutComponent o1, LayoutComponent o2) {
                return o1.row - o2.row;
            }

            @Override
            public boolean equals(Object o1) {
                return o1 == this;
            }
        });
        int incr = 0;
        for (LayoutComponent lc : this.layoutComponents) {
            if (lc.comp instanceof String && lc.row > 0) {
                ++incr;
            }
            lc.ccLabel.gridY = lc.cc.gridY = lc.row + incr + 1;
            if (!this.debugLayout) continue;
            System.out.println(lc + " constraint = " + lc.cc);
        }
        sbuff.setLength(0);
        int currRow = -1;
        for (LayoutComponent lc : this.layoutComponents) {
            while (lc.row > currRow) {
                if (lc.comp instanceof String && lc.row > 0) {
                    sbuff.append(", 5dlu, default");
                } else if (lc.comp == null) {
                    sbuff.append(", ").append(lc.col).append("dlu");
                } else {
                    if (currRow >= 0) {
                        sbuff.append(", ");
                    }
                    sbuff.append("default");
                }
                ++currRow;
            }
        }
        String rowSpec = sbuff.toString();
        if (this.debugLayout) {
            System.out.println(" row layout = " + rowSpec);
        }
        FormLayout layout = new FormLayout(colSpec, rowSpec);
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        for (LayoutComponent lc : this.layoutComponents) {
            if (lc.comp instanceof Field) {
                Field fld = (Field)lc.comp;
                builder.addLabel(fld.getLabel() + ":", lc.ccLabel);
                Object comp = fld.getEditComponent();
                if (lc.comp instanceof Field.TextArea) {
                    comp = new JScrollPane((Component)comp);
                }
                builder.add((Component)comp, lc.cc);
                continue;
            }
            if (lc.comp instanceof String) {
                String header = (String)lc.comp;
                builder.addSeparator(header, cc.xyw(1, lc.cc.gridY, ncols));
                continue;
            }
            if (!(lc.comp instanceof Component)) continue;
            builder.add((Component)lc.comp, lc.cc);
        }
        this.mainPanel = builder.getPanel();
        JPanel buttPanel = new JPanel();
        JButton acceptButton = new JButton("Apply");
        buttPanel.add((Component)acceptButton, null);
        for (JComponent auxButton : this.auxButtons) {
            buttPanel.add((Component)auxButton, null);
        }
        acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefPanel.this.accept();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        if (addButtons) {
            if (where.equals("South")) {
                JPanel south = new JPanel();
                south.setLayout(new BoxLayout(south, 1));
                south.add(new JSeparator(0));
                south.add(buttPanel);
                this.add((Component)south, "South");
            } else {
                this.add((Component)buttPanel, where);
            }
        }
        this.finished = true;
    }

    public static Frame findActiveFrame() {
        Frame[] frames;
        for (Frame frame : frames = JFrame.getFrames()) {
            if (!frame.isVisible()) continue;
            return frame;
        }
        return null;
    }

    public static class Dialog
    extends JDialog {
        private PrefPanel pp;
        private PreferencesExt substore = null;

        public Dialog(RootPaneContainer parent, boolean modal, String title, PreferencesExt prefs) {
            this(parent, modal, title, prefs, prefs);
        }

        public Dialog(RootPaneContainer parent, boolean modal, String title, Preferences prefs, PersistenceManager storeData) {
            super(parent != null && parent instanceof JFrame ? (JFrame)parent : PrefPanel.findActiveFrame());
            Rectangle r;
            this.setModal(modal);
            if (title != null) {
                this.setTitle(title);
            }
            if (prefs != null) {
                this.substore = (PreferencesExt)prefs.node("Dialog");
            }
            if (this.substore != null && (r = (Rectangle)this.substore.getBean("Bounds", null)) != null) {
                this.setBounds(r);
            }
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("lookAndFeel")) {
                        SwingUtilities.updateComponentTreeUI(Dialog.this);
                    }
                }
            });
            Container cp = this.getContentPane();
            this.pp = new PrefPanel(title, prefs, storeData);
            cp.add((Component)this.pp, "Center");
            JButton dismiss = new JButton("Cancel");
            dismiss.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Dialog.this.setVisible(false);
                }
            });
            this.pp.addButton(dismiss);
            this.pp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Dialog.this.setVisible(false);
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    if (Dialog.this.substore != null) {
                        Dialog.this.substore.putBeanObject("Bounds", Dialog.this.getBounds());
                    }
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    if (Dialog.this.substore != null) {
                        Dialog.this.substore.putBeanObject("Bounds", Dialog.this.getBounds());
                    }
                }
            });
        }

        public PrefPanel getPrefPanel() {
            return this.pp;
        }

        public Field getField(String name) {
            return this.pp.getField(name);
        }

        public void finish() {
            this.pp.finish();
            this.pack();
            if (this.substore != null) {
                Rectangle b = (Rectangle)this.substore.getBean("Bounds", null);
                if (b != null) {
                    this.setBounds(b);
                }
                this.substore.putBeanObject("Bounds", this.getBounds());
            }
        }
    }

    private static class LayoutComponent {
        Object comp;
        int row;
        int col;
        CellConstraints cc;
        CellConstraints ccLabel;

        LayoutComponent(Object comp, int col, int row, String constraint) {
            this.comp = comp;
            this.row = row;
            this.col = col;
            this.cc = new CellConstraints("1, 1 " + (constraint == null ? "" : constraint));
            if (this.cc.gridWidth > 1) {
                this.cc.gridWidth = this.cc.gridWidth * 2 - 1;
            }
            this.ccLabel = new CellConstraints();
        }

        public String toString() {
            if (this.comp == null) {
                return "empty row";
            }
            if (this.comp instanceof Field) {
                return ((Field)this.comp).getName();
            }
            return this.comp.getClass().getName();
        }
    }
}

