/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import ucar.nc2.ui.widget.BAMutil;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.ComboBox;
import ucar.util.prefs.ui.Debug;

public class HtmlBrowser
extends JPanel {
    private static EditorKit kit = JEditorPane.createEditorKitForContentType("text/html");
    private PreferencesExt prefs;
    private RootPaneContainer parent = null;
    private boolean eventsOK = true;
    private JEditorPane htmlViewer;
    private ComboBox cbox;
    private JLabel statusText;
    private JPanel topButtons;
    private AbstractAction backAction;
    private AbstractAction forwardAction;
    private ArrayList nav = new ArrayList();
    private int currentPage = -1;
    private boolean debug = false;
    private boolean debugDoc = false;
    private boolean showEvent = false;

    public HtmlBrowser() {
        this.cbox = new ComboBox(null);
        this.cbox.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!HtmlBrowser.this.eventsOK) {
                    return;
                }
                System.out.println("cbox= " + HtmlBrowser.this.cbox.getSelectedItem());
                if (e.getActionCommand().equals("comboBoxChanged")) {
                    Object selected = HtmlBrowser.this.cbox.getSelectedItem();
                    if (selected instanceof String) {
                        HtmlBrowser.this.setUrlString((String)selected);
                    }
                    if (selected instanceof Page) {
                        HtmlBrowser.this.setCurrentPage((Page)selected);
                    }
                }
            }
        });
        this.topButtons = new JPanel(new FlowLayout(0, 5, 0));
        this.backAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlBrowser.this.decrCurrentPage();
            }
        };
        BAMutil.setActionProperties(this.backAction, "Left", "Back", false, 66, 0);
        BAMutil.addActionToContainer(this.topButtons, this.backAction);
        this.forwardAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlBrowser.this.incrCurrentPage();
            }
        };
        BAMutil.setActionProperties(this.forwardAction, "Right", "Forward", false, 70, 0);
        BAMutil.addActionToContainer(this.topButtons, this.forwardAction);
        this.enableActions();
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)this.topButtons, "West");
        topPanel.add((Component)this.cbox, "Center");
        this.htmlViewer = new JEditorPane();
        this.htmlViewer.setContentType("text/html; charset=iso-8859-1");
        this.htmlViewer.setEditable(false);
        this.htmlViewer.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    HtmlBrowser.this.statusText.setText(e.getDescription());
                } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    HtmlBrowser.this.statusText.setText("");
                } else if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    JEditorPane pane = (JEditorPane)e.getSource();
                    if (HtmlBrowser.this.showEvent || Debug.isSet("HtmlBrowser/showEvent")) {
                        System.out.println("HyperlinkEvent= " + e.getURL() + " == " + e.getDescription());
                    }
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                        HTMLDocument doc = (HTMLDocument)pane.getDocument();
                        doc.processHTMLFrameHyperlinkEvent(evt);
                    } else {
                        String desc = e.getDescription();
                        if (desc.startsWith("dataset:")) {
                            String urlString = desc.substring(8);
                            HtmlBrowser.this.firePropertyChangeEvent(new PropertyChangeEvent(this, "datasetURL", null, urlString));
                        } else if (desc.startsWith("catref:")) {
                            String urlString = desc.substring(7);
                            HtmlBrowser.this.firePropertyChangeEvent(new PropertyChangeEvent(this, "catrefURL", null, urlString));
                        } else {
                            HtmlBrowser.this.setURL(e.getURL());
                        }
                    }
                }
            }
        });
        JPanel statusPanel = new JPanel(new BorderLayout());
        this.statusText = new JLabel("status text");
        statusPanel.add((Component)this.statusText, "West");
        this.setLayout(new BorderLayout());
        this.add((Component)topPanel, "North");
        this.add((Component)new JScrollPane(this.htmlViewer), "Center");
        this.add((Component)statusPanel, "South");
    }

    public void save() {
        this.cbox.save();
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        this.firePropertyChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
    }

    public void setUrlString(String urlString) {
        this.addNewPage(new Page(urlString));
    }

    public void setURL(URL url) {
        this.addNewPage(new Page(url));
    }

    public void setContent(String title, String content) {
        this.addNewPage(new Page(title, content));
    }

    private void addNewPage(Page page) {
        if (this.currentPage < this.nav.size() - 1) {
            ArrayList nn = new ArrayList();
            for (int i = 0; i <= this.currentPage; ++i) {
                nn.add(this.nav.get(i));
            }
            this.nav = nn;
        }
        this.nav.add(page);
        this.currentPage = this.nav.size() - 1;
        this.showCurrentPage();
        this.enableActions();
        if (this.debug) {
            System.out.println("---addNewPage done=" + this.currentPage + " " + page);
        }
    }

    private void incrCurrentPage() {
        if (this.currentPage < this.nav.size() - 1) {
            ++this.currentPage;
            this.showCurrentPage();
        }
    }

    private void decrCurrentPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.showCurrentPage();
        }
    }

    private void showCurrentPage() {
        Page p = (Page)this.nav.get(this.currentPage);
        p.show();
        if (this.debug) {
            System.out.println("showCurrentPage current=" + this.currentPage + " " + p);
        }
        this.enableActions();
        this.eventsOK = false;
        this.cbox.addItem(p);
        this.eventsOK = true;
    }

    private void setCurrentPage(Page page) {
        int i = this.nav.indexOf(page);
        if (i < 0) {
            return;
        }
        if (this.debug) {
            System.out.println("setCurrentPage to=" + i);
        }
        this.currentPage = i;
        this.showCurrentPage();
    }

    private void enableActions() {
        this.backAction.setEnabled(this.currentPage > 0);
        this.forwardAction.setEnabled(this.currentPage < this.nav.size() - 1);
    }

    public JDialog makeDialog(RootPaneContainer parent, String title, boolean modal) {
        this.parent = parent;
        return new Dialog(parent, title, modal);
    }

    private class Dialog
    extends JDialog {
        private Dialog(RootPaneContainer parent, String title, boolean modal) {
            super(parent instanceof Frame ? (Frame)((Object)parent) : null, title, modal);
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("lookAndFeel")) {
                        SwingUtilities.updateComponentTreeUI(Dialog.this);
                    }
                }
            });
            JButton dismissButton = new JButton("Dismiss");
            HtmlBrowser.this.topButtons.add((Component)dismissButton, null);
            dismissButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Dialog.this.setVisible(false);
                }
            });
            Container cp = this.getContentPane();
            cp.setLayout(new BorderLayout());
            cp.add((Component)HtmlBrowser.this, "Center");
            this.pack();
        }
    }

    private class Page {
        String type;
        String title;
        String content;
        URL url;

        Page(String urlString) {
            this.title = urlString;
            this.type = "urlString";
        }

        Page(URL url) {
            this.url = url;
            this.type = "url";
        }

        Page(String title, String content) {
            this.title = title;
            this.content = content;
            this.type = "content";
        }

        void show() {
            HTMLEditorKit hkit;
            HtmlBrowser.this.htmlViewer.setContentType("text/html; charset=iso-8859-1");
            HtmlBrowser.this.htmlViewer.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            HtmlBrowser.this.htmlViewer.getDocument().putProperty("stream", null);
            if (HtmlBrowser.this.debugDoc) {
                System.out.println("--show page starts with content type = " + HtmlBrowser.this.htmlViewer.getContentType() + " kit=" + HtmlBrowser.this.htmlViewer.getEditorKit());
                hkit = (HTMLEditorKit)HtmlBrowser.this.htmlViewer.getEditorKit();
                System.out.println("   Css=" + hkit.getStyleSheet().hashCode());
                if (HtmlBrowser.this.htmlViewer.getDocument() instanceof HTMLDocument) {
                    this.showDoc((HTMLDocument)HtmlBrowser.this.htmlViewer.getDocument());
                }
            }
            try {
                if (this.type.equals("urlString")) {
                    HtmlBrowser.this.htmlViewer.setPage(this.title);
                } else if (this.type.equals("url")) {
                    HtmlBrowser.this.htmlViewer.setPage(this.url.toString());
                } else if (this.type.equals("content")) {
                    HtmlBrowser.this.htmlViewer.setText(this.content);
                }
                HtmlBrowser.this.htmlViewer.setCaretPosition(0);
                if (HtmlBrowser.this.debugDoc) {
                    System.out.println(" show page ends with content type = " + HtmlBrowser.this.htmlViewer.getContentType() + " kit=" + HtmlBrowser.this.htmlViewer.getEditorKit());
                    hkit = (HTMLEditorKit)HtmlBrowser.this.htmlViewer.getEditorKit();
                    System.out.println("   Css=" + hkit.getStyleSheet().hashCode());
                    if (HtmlBrowser.this.htmlViewer.getDocument() instanceof HTMLDocument) {
                        this.showDoc((HTMLDocument)HtmlBrowser.this.htmlViewer.getDocument());
                    }
                    HtmlBrowser.this.htmlViewer.repaint();
                }
            }
            catch (IOException ioe) {
                HtmlBrowser.this.statusText.setText("Error: " + ioe.getMessage());
                ioe.printStackTrace();
            }
        }

        public String toString() {
            if (this.title != null) {
                return this.title;
            }
            if (this.url != null) {
                return this.url.toString();
            }
            return "huh?";
        }

        void showDoc(HTMLDocument doc) {
            System.out.println(" Doc base=" + doc.getBase());
            Dictionary<Object, Object> dict = doc.getDocumentProperties();
            Enumeration<Object> e = dict.keys();
            System.out.println(" DocumentProperties");
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                System.out.println("  key= " + key + " value=" + dict.get(key));
            }
        }
    }
}

