/*
 * Decompiled with CFR 0.152.
 */
package thredds.logs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import thredds.logs.LogReader;
import ucar.nc2.util.EscapeStrings;

public class ServletLogParser
implements LogReader.LogParser {
    private static final Pattern donePattern = Pattern.compile("^Request Completed - (.*) - (.*) - (.*)");
    private static final Pattern startPattern = Pattern.compile("^Remote host: ([^-]+) - Request: \"(\\w+) (.*) (.*)");
    private static final Pattern commonPattern = Pattern.compile("^(\\d+-\\d+-\\d+T\\d+:\\d+:\\d+\\.\\d+ [+-]\\d+) \\[(.*)]\\[(.*)] (\\w+)[\\s]+- ([^-]+) - (.*)");
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    @Override
    public LogReader.Log nextLog(BufferedReader dataIS) throws IOException {
        ServletLog log = new ServletLog();
        boolean haveLog = false;
        while (true) {
            dataIS.mark(20000);
            String line = dataIS.readLine();
            if (line == null) {
                return haveLog ? log : null;
            }
            try {
                Matcher m = commonPattern.matcher(line);
                if (m.matches()) {
                    Matcher m2;
                    int pos;
                    if (haveLog) {
                        try {
                            dataIS.reset();
                            return log;
                        }
                        catch (Throwable t) {
                            System.out.println("Cant reset " + line);
                        }
                    }
                    haveLog = true;
                    log.date = this.convertDate(m.group(1));
                    log.reqTime = this.parseLong(m.group(2));
                    log.reqSeq = this.parseLong(m.group(3));
                    log.level = m.group(4).intern();
                    log.where = m.group(5);
                    String rest = m.group(6);
                    if (rest.contains("Request Completed")) {
                        pos = rest.indexOf("Request Completed");
                        m2 = donePattern.matcher(rest.substring(pos));
                        if (m2.matches()) {
                            log.returnCode = this.parse(m2.group(1));
                            log.sizeBytes = this.parseLong(m2.group(2));
                            log.msecs = this.parseLong(m2.group(3));
                            log.isDone = true;
                            continue;
                        }
                        System.out.println("Cant parse donePattern= " + rest);
                        System.out.println(" line= " + line);
                        log.addExtra(rest);
                        continue;
                    }
                    if (rest.contains("Remote host")) {
                        pos = rest.indexOf("Remote host");
                        m2 = startPattern.matcher(rest.substring(pos));
                        if (m2.matches()) {
                            log.ip = m2.group(1);
                            log.verb = m2.group(2).intern();
                            log.path = EscapeStrings.urlDecode((String)m2.group(3));
                            if (m2.groupCount() > 4) {
                                log.http = m2.group(4).intern();
                            }
                            log.isStart = true;
                            continue;
                        }
                        System.out.println("Cant parse startPattern= " + rest);
                        System.out.println(" line= " + line);
                        log.addExtra(rest);
                        continue;
                    }
                    log.addExtra(rest);
                    continue;
                }
                log.addExtra(line);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Cant parse " + line);
                log.addExtra(line);
                continue;
            }
            break;
        }
    }

    private long convertDate(String accessDateFormat) {
        try {
            Date d = this.df.parse(accessDateFormat);
            return d.getTime();
        }
        catch (Throwable t) {
            System.out.printf("Bad date format = %s err = %s%n", accessDateFormat, t.getMessage());
            return -1L;
        }
    }

    private int parse(String s) {
        if ((s = s.trim()).isEmpty()) {
            return 0;
        }
        if (s.equals("-")) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    private long parseLong(String s) {
        if ((s = s.trim()).isEmpty()) {
            return 0L;
        }
        if (s.equals("-")) {
            return 0L;
        }
        return Long.parseLong(s);
    }

    public static void main1(String[] args) throws IOException {
        LogReader reader = new LogReader(new ServletLogParser());
        long startElapsed = System.nanoTime();
        LogReader.Stats stats = new LogReader.Stats();
        reader.readAll(new File("D:/mlode/logs/servlet/"), null, new LogReader.Closure(){

            @Override
            public void process(LogReader.Log log) throws IOException {
            }
        }, new MyLogFilter(-1), stats);
        long elapsedTime = System.nanoTime() - startElapsed;
        System.out.printf(" total= %d passed=%d%n", stats.total, stats.passed);
        System.out.printf(" elapsed=%d secs%n", elapsedTime / 1000000000L);
    }

    public static void main2(String[] args) {
        String s1 = "2009-03-10T16:08:55.184 -0600 [  16621850][  162233] INFO  - thredds.server.opendap.NcDODSServlet - Remote host: 128.117.140.71 - Request: \"GET /thredds/dodsC/model/NCEP/NAM/CONUS_80km/NAM_CONUS_80km_20090309_0000.grib1.dods?Geopotential_height%5B7:1:7%5D%5B0:10:10%5D%5B0:1:64%5D%5B0:1:92%5D HTTP/1.1\"";
        Pattern p1 = Pattern.compile("^(\\d+-\\d+-\\d+T\\d+:\\d+:\\d+\\.\\d+ -\\d+) \\[(.*)]\\[(.*)] (\\w+)[\\s]+- ([^-]+) - Remote host: ([^-]+) - Request: \"(\\w+) (.*) (.*)");
        ServletLogParser.show(s1, p1);
        String s2 = "2009-03-10T16:08:54.617 -0600 [  16621283][  162230] INFO  - thredds.server.opendap.NcDODSServlet - Request Completed - 200 - -1 - 47";
        Pattern p2 = Pattern.compile("^(\\d+-\\d+-\\d+T\\d+:\\d+:\\d+\\.\\d+ -\\d+) \\[(.*)]\\[(.*)] (\\w+)[\\s]+- ([^-]+) - Request Completed - (\\d+) - (.*) - (.*)");
        ServletLogParser.show(s2, p2);
        Pattern p3 = Pattern.compile("^(\\d+-\\d+-\\d+T\\d+:\\d+:\\d+\\.\\d+ -\\d+) \\[(.*)]\\[(.*)] (\\w+)[\\s]+- ([^-]+) - (.*)");
        ServletLogParser.show(s1, p3);
        ServletLogParser.show(s2, p3);
    }

    public static void main(String[] args) {
        String test = "2009-04-03T21:48:54.000 -0600 [   4432114][    1184] INFO  - thredds.servlet.ServletUtil - Remote host: 128.117.140.75 - Request: \"GET /thredds/dodsC/fmrc/NCEP/NAM/CONUS_20km/surface/forecast/NCEP-NAM-CONUS_20km-surface_ConstantForecast_2009-04-04T15:00:00Z.dods?time,time_run,time_offset,Lambert_Conformal,pressure_difference_layer_bounds,depth_below_surface_layer_bounds,pressure_difference_layer1_bounds,depth_below_surface_layer1_bounds,depth_below_surface_layer2_bounds,pressure_difference_layer2_bounds,pressure_difference_layer3_bounds,pressure_difference_layer4_bounds,pressure_difference_layer5_bounds,height_above_ground_layer1_bounds,pressure_layer_bounds,height_above_ground_layer_bounds,y,x,height_above_ground1,height_above_ground2,pressure_difference_layer,depth_below_surface_layer,pressure_difference_layer1,depth_below_surface_layer1,depth_below_surface_layer2,height_above_ground,pressure_difference_layer2,height_above_ground3,pressure,depth_below_surface,pressure1,pressure_difference_layer3,pressure_difference_layer4,pressure_difference_layer5,height_above_ground_layer1,pressure2,pressure_layer,height_above_ground_layer HTTP/1.1\"";
        ServletLogParser.show(test, commonPattern);
        String test2 = "Remote host: 128.117.140.75 - Request: \"GET /thredds/dodsC/fmrc/NCEP/NAM/CONUS_20km/surface/forecast/NCEP-NAM-CONUS_20km-surface_ConstantForecast_2009-04-04T15:00:00Z.dods?time,time_run,time_offset,Lambert_Conformal,pressure_difference_layer_bounds,depth_below_surface_layer_bounds,pressure_difference_layer1_bounds,depth_below_surface_layer1_bounds,depth_below_surface_layer2_bounds,pressure_difference_layer2_bounds,pressure_difference_layer3_bounds,pressure_difference_layer4_bounds,pressure_difference_layer5_bounds,height_above_ground_layer1_bounds,pressure_layer_bounds,height_above_ground_layer_bounds,y,x,height_above_ground1,height_above_ground2,pressure_difference_layer,depth_below_surface_layer,pressure_difference_layer1,depth_below_surface_layer1,depth_below_surface_layer2,height_above_ground,pressure_difference_layer2,height_above_ground3,pressure,depth_below_surface,pressure1,pressure_difference_layer3,pressure_difference_layer4,pressure_difference_layer5,height_above_ground_layer1,pressure2,pressure_layer,height_above_ground_layer HTTP/1.1\"";
        ServletLogParser.show(test2, startPattern);
    }

    private static void show(String s, Pattern p) {
        System.out.println("==============================");
        Matcher m = p.matcher(s);
        System.out.printf(" match against %s = %s %n", m, m.matches());
        if (!m.matches()) {
            return;
        }
        for (int i = 1; i <= m.groupCount(); ++i) {
            System.out.println(" " + i + " " + m.group(i));
        }
    }

    static class MyLogFilter
    implements LogReader.LogFilter {
        int count = 0;
        int limit;

        MyLogFilter(int limit) {
            this.limit = limit;
        }

        @Override
        public boolean pass(LogReader.Log log) {
            return this.limit < 0 || this.count++ < this.limit;
        }
    }

    public static class ServletLog
    extends LogReader.Log {
        long reqTime;
        long reqSeq;
        String level;
        String where;
        public StringBuilder extra;
        boolean isDone;
        boolean isStart;
        int nthreads;

        public long getReqTime() {
            return this.reqTime;
        }

        public long getReqSeq() {
            return this.reqSeq;
        }

        public String getLevel() {
            return this.level;
        }

        public boolean isExtra() {
            return this.extra != null;
        }

        public boolean isDone() {
            return this.isDone;
        }

        public boolean isStart() {
            return this.isStart;
        }

        public int getNthreads() {
            return this.nthreads;
        }

        public void setNthreads(int nthreads) {
            this.nthreads = nthreads;
        }

        @Override
        public String toString() {
            Formatter f = new Formatter();
            f.format("%s [%d] [%d] %s %s: ", this.getDate(), this.reqTime, this.reqSeq, this.level, this.where);
            if (this.isStart) {
                f.format(" (%s) %s %n", this.ip, this.getPath());
            } else if (this.isDone) {
                f.format(" %d %d %d %n", this.returnCode, this.sizeBytes, this.msecs);
            }
            if (this.extra != null) {
                f.format(" %s", this.extra);
            }
            return f.toString();
        }

        void addExtra(String s) {
            if (this.extra == null) {
                this.extra = new StringBuilder(300);
            }
            this.extra.append(s);
            this.extra.append("\n");
        }
    }
}

