/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.widget;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class PLAF {
    private JComponent topComponent;
    private boolean debug = false;

    public PLAF(JComponent topComponent) {
        this.topComponent = topComponent;
    }

    public void addToMenu(JMenu menu) {
        UIManager.LookAndFeelInfo[] plafInfo;
        for (UIManager.LookAndFeelInfo aPlafInfo : plafInfo = UIManager.getInstalledLookAndFeels()) {
            this.addToMenu(aPlafInfo.getName(), aPlafInfo.getClassName(), menu);
        }
        LookAndFeel current = UIManager.getLookAndFeel();
        System.out.printf("current L&F=%s%n", current.getName());
    }

    private void addToMenu(String name, String className, JMenu menu) {
        if (this.debug) {
            System.out.println("PLAF LookAndFeelInfo  " + className);
        }
        boolean isSupported = true;
        try {
            Class<?> cl = Class.forName(className);
            LookAndFeel lf = (LookAndFeel)cl.newInstance();
            if (!lf.isSupportedLookAndFeel()) {
                isSupported = false;
            }
        }
        catch (Throwable t) {
            isSupported = false;
        }
        PLAFAction act = new PLAFAction(name, className);
        JMenuItem mi = menu.add(act);
        if (!isSupported) {
            mi.setEnabled(false);
        }
    }

    private class PLAFAction
    extends AbstractAction {
        String plafClassName;

        PLAFAction(String name, String plafClassName) {
            this.plafClassName = plafClassName;
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                UIManager.setLookAndFeel(this.plafClassName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            SwingUtilities.updateComponentTreeUI(PLAF.this.topComponent);
        }
    }
}

