/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileSubclass;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.CDM;
import ucar.nc2.dataset.SequenceDS;
import ucar.nc2.ft.point.bufr.BufrCdmIndex;
import ucar.nc2.ft.point.bufr.BufrCdmIndexProto;
import ucar.nc2.ft.point.bufr.StandardFields;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.bufr.BufrConfig;
import ucar.nc2.iosp.bufr.BufrIosp2;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageCompressedDataReader;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.iosp.bufr.MessageUncompressedDataReader;
import ucar.nc2.iosp.bufr.writer.Bufr2Xml;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.ui.StructureTable;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class BufrMessageViewer
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable messageTable;
    private BeanTable obsTable;
    private BeanTable ddsTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoTA;
    private TextHistoryPane infoTA2;
    private IndependentWindow infoWindow;
    private IndependentWindow infoWindow2;
    private StructureTable dataTable;
    private IndependentWindow dataWindow;
    private FileManager fileChooser;
    private boolean seperateWindow = false;
    private RandomAccessFile raf;
    private MessageScanner scan;
    int center;

    public BufrMessageViewer(final PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        AbstractButton tableButt = BAMutil.makeButtcon("Structure", "Data Table", false);
        tableButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    NetcdfFile ncd = BufrMessageViewer.this.makeBufrDataset();
                    Variable v = ncd.findVariable("obs");
                    if (v != null && v instanceof Structure) {
                        if (BufrMessageViewer.this.dataTable == null) {
                            BufrMessageViewer.this.makeDataTable();
                        }
                        BufrMessageViewer.this.dataTable.setStructure((Structure)v);
                        BufrMessageViewer.this.dataWindow.show();
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(BufrMessageViewer.this, ex.getMessage());
                    ex.printStackTrace();
                }
            }
        });
        buttPanel.add(tableButt);
        AbstractButton showButt = BAMutil.makeButtcon("GetAll", "Read All Data", false);
        showButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                BufrMessageViewer.this.readData(f);
                BufrMessageViewer.this.infoTA2.setText(f.toString());
                BufrMessageViewer.this.infoTA2.gotoTop();
                BufrMessageViewer.this.infoWindow2.show();
            }
        });
        buttPanel.add(showButt);
        AbstractAction seperateWindowAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufrMessageViewer.this.seperateWindow = (Boolean)this.getValue("state");
            }
        };
        BAMutil.setActionProperties(seperateWindowAction, "DrawVert", "seperate DDS window", true, 67, -1);
        seperateWindowAction.putValue("state", this.seperateWindow);
        BAMutil.addActionToContainer(buttPanel, seperateWindowAction);
        AbstractButton distinctDdsButt = BAMutil.makeButtcon("dd", "Dump distinct DDS", false);
        distinctDdsButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufrMessageViewer.this.dumpDDS();
            }
        });
        buttPanel.add(distinctDdsButt);
        AbstractButton distinctMessButt = BAMutil.makeButtcon("Import", "Write distinct messages", false);
        distinctMessButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufrMessageViewer.this.writeAll();
            }
        });
        buttPanel.add(distinctMessButt);
        AbstractButton configButt = BAMutil.makeButtcon("Dump", "Make BufrConfig", false);
        configButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BufrMessageViewer.this.raf == null) {
                    return;
                }
                try {
                    BufrConfig config = BufrConfig.scanEntireFile((RandomAccessFile)BufrMessageViewer.this.raf);
                    Formatter out = new Formatter();
                    config.show(out);
                    BufrMessageViewer.this.infoTA2.setText(out.toString());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    StringWriter sw = new StringWriter(10000);
                    ex.printStackTrace(new PrintWriter(sw));
                    BufrMessageViewer.this.infoTA2.setText(sw.toString());
                }
                BufrMessageViewer.this.infoTA2.gotoTop();
                BufrMessageViewer.this.infoWindow2.show();
            }
        });
        buttPanel.add(configButt);
        AbstractButton writeButton = BAMutil.makeButtcon("V3", "Write index", false);
        writeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                try {
                    if (BufrMessageViewer.this.writeIndex(f)) {
                        f.format("Index written", new Object[0]);
                        BufrMessageViewer.this.infoTA2.setText(f.toString());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    StringWriter sw = new StringWriter(10000);
                    ex.printStackTrace(new PrintWriter(sw));
                    BufrMessageViewer.this.infoTA2.setText(sw.toString());
                }
                BufrMessageViewer.this.infoTA2.gotoTop();
                BufrMessageViewer.this.infoWindow2.show();
            }
        });
        buttPanel.add(writeButton);
        this.messageTable = new BeanTable(MessageBean.class, (PreferencesExt)prefs.node("GridRecordBean"), false);
        this.messageTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BufrMessageViewer.this.ddsTable.setBeans(new ArrayList());
                BufrMessageViewer.this.obsTable.setBeans(new ArrayList());
                MessageBean mb = (MessageBean)BufrMessageViewer.this.messageTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                ArrayList beanList = new ArrayList();
                try {
                    BufrMessageViewer.this.setDataDescriptors(beanList, mb.m.getRootDataDescriptor(), 0);
                    BufrMessageViewer.this.setObs(mb.m);
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(BufrMessageViewer.this, e1.getMessage());
                    e1.printStackTrace();
                }
                BufrMessageViewer.this.ddsTable.setBeans(beanList);
            }
        });
        this.obsTable = new BeanTable(ObsBean.class, (PreferencesExt)prefs.node("ObsBean"), false);
        this.ddsTable = new BeanTable(DdsBean.class, (PreferencesExt)prefs.node("DdsBean"), false);
        PopupMenu varPopup = new PopupMenu(this.messageTable.getJTable(), "Options");
        varPopup.addAction("Show DDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBean vb = (MessageBean)BufrMessageViewer.this.messageTable.getSelectedBean();
                if (vb == null) {
                    return;
                }
                if (!BufrMessageViewer.this.seperateWindow) {
                    BufrMessageViewer.this.infoTA.clear();
                }
                Formatter f = new Formatter();
                try {
                    if (!vb.m.isTablesComplete()) {
                        f.format(" MISSING DATA DESCRIPTORS= ", new Object[0]);
                        vb.m.showMissingFields(f);
                        f.format("%n%n", new Object[0]);
                    }
                    vb.m.dump(f);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(BufrMessageViewer.this, e1.getMessage());
                    e1.printStackTrace();
                }
                if (BufrMessageViewer.this.seperateWindow) {
                    TextHistoryPane ta = new TextHistoryPane();
                    IndependentWindow info = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), ta);
                    info.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
                    ta.appendLine(f.toString());
                    ta.gotoTop();
                    info.show();
                } else {
                    BufrMessageViewer.this.infoTA.appendLine(f.toString());
                    BufrMessageViewer.this.infoTA.gotoTop();
                    BufrMessageViewer.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Data Table", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBean mb = (MessageBean)BufrMessageViewer.this.messageTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                try {
                    NetcdfFile ncd = BufrMessageViewer.this.makeBufrMessageAsDataset(mb.m);
                    Variable v = ncd.findVariable("obs");
                    if (v != null && v instanceof Structure) {
                        if (BufrMessageViewer.this.dataTable == null) {
                            BufrMessageViewer.this.makeDataTable();
                        }
                        BufrMessageViewer.this.dataTable.setStructure((Structure)v);
                        BufrMessageViewer.this.dataWindow.show();
                        mb.setReadOk(true);
                    }
                }
                catch (Exception ex) {
                    mb.setReadOk(false);
                    JOptionPane.showMessageDialog(BufrMessageViewer.this, ex.getMessage());
                    ex.printStackTrace();
                }
            }
        });
        varPopup.addAction("BitCount", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBean mb = (MessageBean)BufrMessageViewer.this.messageTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                mb.checkBits();
            }
        });
        varPopup.addAction("Bit Count Details", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBean mb = (MessageBean)BufrMessageViewer.this.messageTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                Message m = mb.m;
                Formatter out = new Formatter();
                try {
                    MessageUncompressedDataReader reader;
                    BufrMessageViewer.this.infoTA2.clear();
                    if (!m.dds.isCompressed()) {
                        reader = new MessageUncompressedDataReader();
                        reader.readData(null, m, BufrMessageViewer.this.raf, null, false, out);
                    } else {
                        reader = new MessageCompressedDataReader();
                        reader.readData(null, m, BufrMessageViewer.this.raf, null, out);
                    }
                    int nbitsGiven = 8 * (m.dataSection.getDataLength() - 4);
                    DataDescriptor root = m.getRootDataDescriptor();
                    out.format("Message nobs=%d compressed=%s vlen=%s countBits= %d givenBits=%d %n", m.getNumberDatasets(), m.dds.isCompressed(), root.isVarLength(), m.getCountedDataBits(), nbitsGiven);
                    out.format(" countBits= %d givenBits=%d %n", m.getCountedDataBits(), nbitsGiven);
                    out.format(" countBytes= %d dataSize=%d %n", m.getCountedDataBytes(), m.dataSection.getDataLength());
                    out.format("%n", new Object[0]);
                    BufrMessageViewer.this.infoTA2.appendLine(out.toString());
                }
                catch (Exception ex) {
                    StringWriter sw = new StringWriter(5000);
                    ex.printStackTrace(new PrintWriter(sw));
                    BufrMessageViewer.this.infoTA2.appendLine(out.toString());
                    BufrMessageViewer.this.infoTA2.appendLine(sw.toString());
                }
                BufrMessageViewer.this.infoTA2.gotoTop();
                BufrMessageViewer.this.infoWindow2.show();
            }
        });
        varPopup.addAction("Read", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBean mb = (MessageBean)BufrMessageViewer.this.messageTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                mb.read();
            }
        });
        varPopup.addAction("Write Message", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBean mb = (MessageBean)BufrMessageViewer.this.messageTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                try {
                    String defloc;
                    String header = mb.m.getHeader();
                    if (header != null) {
                        header = header.split(" ")[0];
                    }
                    if (header == null) {
                        defloc = BufrMessageViewer.this.raf.getLocation() == null ? "." : BufrMessageViewer.this.raf.getLocation();
                        int pos = defloc.lastIndexOf(".");
                        if (pos > 0) {
                            defloc = defloc.substring(0, pos);
                        }
                    } else {
                        defloc = header;
                    }
                    BufrMessageViewer.this.makeFileChooser();
                    String filename = BufrMessageViewer.this.fileChooser.chooseFilenameToSave(defloc + ".bufr");
                    if (filename == null) {
                        return;
                    }
                    File file = new File(filename);
                    FileOutputStream fos = new FileOutputStream(file);
                    FileChannel wbc = fos.getChannel();
                    String headerS = mb.m.getHeader();
                    if (headerS != null) {
                        wbc.write(ByteBuffer.wrap(headerS.getBytes(CDM.utf8Charset)));
                    }
                    byte[] raw = BufrMessageViewer.this.scan.getMessageBytes(mb.m);
                    wbc.write(ByteBuffer.wrap(raw));
                    wbc.close();
                    JOptionPane.showMessageDialog(BufrMessageViewer.this, filename + " successfully written");
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(BufrMessageViewer.this, "ERROR: " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
        });
        varPopup.addAction("Show XML", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBean mb = (MessageBean)BufrMessageViewer.this.messageTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                Message m = mb.m;
                ByteArrayOutputStream out = new ByteArrayOutputStream(100000);
                try {
                    BufrMessageViewer.this.infoTA.clear();
                    NetcdfFile ncd = BufrMessageViewer.this.makeBufrMessageAsDataset(mb.m);
                    new Bufr2Xml(m, ncd, (OutputStream)out, true);
                    BufrMessageViewer.this.infoTA.setText(out.toString("UTF-8"));
                }
                catch (Exception ex) {
                    StringWriter sw = new StringWriter();
                    ex.printStackTrace(new PrintWriter(sw));
                    try {
                        BufrMessageViewer.this.infoTA.appendLine(out.toString("UTF-8"));
                    }
                    catch (UnsupportedEncodingException uee) {
                        uee.printStackTrace();
                    }
                    BufrMessageViewer.this.infoTA.appendLine(sw.toString());
                }
                BufrMessageViewer.this.infoTA.gotoTop();
                BufrMessageViewer.this.infoWindow.show();
            }
        });
        varPopup.addAction("Compare DDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = BufrMessageViewer.this.messageTable.getSelectedBeans();
                for (Object beano : list) {
                    MessageBean bean = (MessageBean)beano;
                    BufrMessageViewer.this.showDDS(bean.m);
                }
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.infoTA2 = new TextHistoryPane();
        this.infoWindow2 = new IndependentWindow("Extra Information-2", BAMutil.getImage("netcdfUI"), this.infoTA2);
        this.infoWindow2.setBounds((Rectangle)prefs.getBean("InfoWindowBounds2", (Object)new Rectangle(300, 300, 500, 300)));
        this.split2 = new JSplitPane(0, false, this.ddsTable, this.obsTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.split = new JSplitPane(0, false, this.messageTable, this.split2);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    private void makeFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new FileManager(null, null, null, (PreferencesExt)this.prefs.node("FileManager"));
        }
    }

    public boolean writeIndex(Formatter f) throws IOException {
        File bufrFile = new File(this.raf.getLocation());
        String name = bufrFile.getName();
        int pos = name.lastIndexOf(47);
        if (pos < 0) {
            pos = name.lastIndexOf(92);
        }
        if (pos > 0) {
            name = name.substring(pos + 1);
        }
        File def = new File(bufrFile.getParent(), name + ".ncx");
        this.makeFileChooser();
        String filename = this.fileChooser.chooseFilename(def);
        if (filename == null) {
            return false;
        }
        if (!filename.endsWith(".ncx")) {
            filename = filename + ".ncx";
        }
        File idxFile = new File(filename);
        BufrConfig config = BufrConfig.scanEntireFile((RandomAccessFile)this.raf);
        return BufrCdmIndex.writeIndex((String)this.raf.getLocation(), (BufrConfig)config, (File)idxFile);
    }

    private void makeDataTable() {
        this.dataTable = new StructureTable((PreferencesExt)this.prefs.node("structTable"));
        this.dataWindow = new IndependentWindow("Data Table", BAMutil.getImage("netcdfUI"), this.dataTable);
        this.dataWindow.setBounds((Rectangle)this.prefs.getBean("dataWindow", (Object)new Rectangle(50, 300, 1000, 600)));
    }

    private void writeAll() {
        List beans = this.messageTable.getBeans();
        HashMap<Integer, Message> map = new HashMap<Integer, Message>(2 * beans.size());
        for (MessageBean mb : beans) {
            map.put(mb.m.hashCode(), mb.m);
        }
        this.makeFileChooser();
        String defloc = this.raf.getLocation() == null ? "." : this.raf.getLocation();
        String dirName = this.fileChooser.chooseDirectory(defloc);
        if (dirName == null) {
            return;
        }
        try {
            int count = 0;
            for (Message m : map.values()) {
                String header = m.getHeader();
                header = header != null ? header.split(" ")[0] : Integer.toString(m.hashCode() & Integer.MAX_VALUE);
                File file = new File(dirName + "/" + header + ".bufr");
                try (FileOutputStream fos = new FileOutputStream(file);
                     FileChannel wbc = fos.getChannel();){
                    String headerS = m.getHeader();
                    if (headerS != null) {
                        wbc.write(ByteBuffer.wrap(headerS.getBytes(CDM.utf8Charset)));
                    }
                    byte[] raw = this.scan.getMessageBytes(m);
                    wbc.write(ByteBuffer.wrap(raw));
                }
                ++count;
            }
            JOptionPane.showMessageDialog(this, count + " successfully written to " + dirName);
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this, e1.getMessage());
            e1.printStackTrace();
        }
    }

    private void readData(Formatter f) {
        List beans = this.messageTable.getBeans();
        int count = 0;
        try {
            for (MessageBean bean : beans) {
                bean.read();
                ++count;
            }
            f.format("Read %d messages", count);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter(10000);
            e.printStackTrace(new PrintWriter(sw));
            f.format("%s", sw.toString());
        }
    }

    private void dumpDDS() {
        String filename;
        List beans = this.messageTable.getBeans();
        HashMap<Integer, Message> map = new HashMap<Integer, Message>(2 * beans.size());
        for (MessageBean mb : beans) {
            map.put(mb.m.hashCode(), mb.m);
        }
        this.makeFileChooser();
        String defloc = this.raf.getLocation() == null ? "." : this.raf.getLocation();
        int pos = defloc.lastIndexOf(".");
        if (pos > 0) {
            defloc = defloc.substring(0, pos);
        }
        if ((filename = this.fileChooser.chooseFilenameToSave(defloc + ".txt")) == null) {
            return;
        }
        try (FileOutputStream out = new FileOutputStream(filename);){
            OutputStreamWriter fout = new OutputStreamWriter((OutputStream)out, CDM.utf8Charset);
            BufferedWriter bw = new BufferedWriter(fout);
            Formatter f = new Formatter(bw);
            int count = 0;
            for (Message m : map.values()) {
                m.dump(f);
                f.flush();
                ++count;
            }
            JOptionPane.showMessageDialog(this, count + " successfully written to " + filename);
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this, e1.getMessage());
            e1.printStackTrace();
        }
    }

    private void showDDS(Message m1) {
        Formatter f1 = new Formatter();
        m1.dump(f1);
        TextHistoryPane ta = new TextHistoryPane();
        IndependentWindow info = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), ta);
        info.setBounds((Rectangle)this.prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        ta.appendLine(f1.toString());
        ta.gotoTop();
        info.show();
    }

    public void save() {
        this.messageTable.saveState(false);
        this.ddsTable.saveState(false);
        this.obsTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putBeanObject("InfoWindowBounds2", (Object)this.infoWindow2.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        if (this.fileChooser != null) {
            this.fileChooser.save();
        }
    }

    public void setBufrFile(RandomAccessFile raf) throws IOException {
        this.raf = raf;
        ArrayList<MessageBean> beanList = new ArrayList<MessageBean>();
        this.center = -1;
        this.scan = new MessageScanner(raf, 0L, true);
        while (this.scan.hasNext()) {
            Message m = this.scan.next();
            if (m == null) continue;
            if (this.center == -1) {
                this.center = m.ids.getCenterId();
            }
            beanList.add(new MessageBean(m));
        }
        this.messageTable.setBeans(beanList);
        this.obsTable.setBeans(new ArrayList());
        this.ddsTable.setBeans(new ArrayList());
    }

    private NetcdfFile makeBufrMessageAsDataset(Message m) throws IOException {
        BufrIosp2 iosp = new BufrIosp2();
        NetcdfFileSubclass ncfile = new NetcdfFileSubclass((IOServiceProvider)iosp, this.raf.getLocation());
        iosp.open(this.raf, (NetcdfFile)ncfile, m);
        return ncfile;
    }

    private NetcdfFile makeBufrDataset() throws IOException {
        BufrIosp2 iosp = new BufrIosp2();
        NetcdfFileSubclass ncfile = new NetcdfFileSubclass((IOServiceProvider)iosp, this.raf.getLocation());
        iosp.open(this.raf, (NetcdfFile)ncfile, (CancelTask)null);
        return ncfile;
    }

    private int setDataDescriptors(List<DdsBean> beanList, DataDescriptor dds, int seqno) {
        for (DataDescriptor key : dds.getSubKeys()) {
            beanList.add(new DdsBean(key, seqno++));
            if (key.getSubKeys() == null) continue;
            seqno = this.setDataDescriptors(beanList, key, seqno);
        }
        return seqno;
    }

    private void setObs(Message m) {
        ArrayList<ObsBean> beanList;
        block15: {
            beanList = new ArrayList<ObsBean>();
            try {
                NetcdfFile ncd = this.makeBufrMessageAsDataset(m);
                Variable v = ncd.findVariable("obs");
                if (v == null || !(v instanceof Structure)) break block15;
                Structure obs = (Structure)v;
                StandardFields.StandardFieldsFromStructure extract = new StandardFields.StandardFieldsFromStructure(this.center, obs);
                try (StructureDataIterator iter = obs.getStructureIterator();){
                    while (iter.hasNext()) {
                        beanList.add(new ObsBean(extract, iter.next()));
                    }
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage());
                ex.printStackTrace();
            }
        }
        this.obsTable.setBeans(beanList);
    }

    public class ObsBean {
        double lat = Double.NaN;
        double lon = Double.NaN;
        double height = Double.NaN;
        double heightOfStation = Double.NaN;
        int year = -1;
        int month = -1;
        int day = -1;
        int hour = -1;
        int minute = -1;
        int sec = -1;
        int doy = -1;
        CalendarDate date;
        int wmo_block = -1;
        int wmo_id = -1;
        String stn = null;

        public ObsBean() {
        }

        public ObsBean(StandardFields.StandardFieldsFromStructure extract, StructureData sdata) {
            extract.extract(sdata);
            this.stn = extract.getStationId();
            this.date = extract.makeCalendarDate();
            this.lat = extract.getFieldValueD(BufrCdmIndexProto.FldType.lat);
            this.lon = extract.getFieldValueD(BufrCdmIndexProto.FldType.lon);
            this.height = extract.getFieldValueD(BufrCdmIndexProto.FldType.height);
            this.heightOfStation = extract.getFieldValueD(BufrCdmIndexProto.FldType.heightOfStation);
            this.year = extract.getFieldValue(BufrCdmIndexProto.FldType.year);
            this.month = extract.getFieldValue(BufrCdmIndexProto.FldType.month);
            this.day = extract.getFieldValue(BufrCdmIndexProto.FldType.day);
            this.hour = extract.getFieldValue(BufrCdmIndexProto.FldType.hour);
            this.minute = extract.getFieldValue(BufrCdmIndexProto.FldType.minute);
            this.sec = extract.getFieldValue(BufrCdmIndexProto.FldType.sec);
            this.doy = extract.getFieldValue(BufrCdmIndexProto.FldType.doy);
            this.wmo_block = extract.getFieldValue(BufrCdmIndexProto.FldType.wmoBlock);
            this.wmo_id = extract.getFieldValue(BufrCdmIndexProto.FldType.wmoId);
        }

        public double getLat() {
            return this.lat;
        }

        public double getLon() {
            return this.lon;
        }

        public double getHeight() {
            return this.height;
        }

        public double getHeightOfStation() {
            return this.heightOfStation;
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }

        public int getDay() {
            return this.day;
        }

        public int getHour() {
            return this.hour;
        }

        public int getMinute() {
            return this.minute;
        }

        public int getSec() {
            return this.sec;
        }

        public int getDoy() {
            return this.doy;
        }

        public String getWmoId() {
            return this.wmo_block + "/" + this.wmo_id;
        }

        public String getStation() {
            return this.stn;
        }

        public String getDate() {
            return this.date.toString();
        }
    }

    public class DdsBean {
        DataDescriptor dds;
        int seq;

        public DdsBean(DataDescriptor dds, int seq) {
            this.dds = dds;
            this.seq = seq;
        }

        public String getFxy() {
            return this.dds.getFxyName();
        }

        public String getName() {
            return this.dds.getName();
        }

        public String getUnits() {
            return this.dds.getUnits();
        }

        public String getDesc() {
            return this.dds.getDesc();
        }

        public int getBitWidth() {
            return this.dds.getBitWidth();
        }

        public int getScale() {
            return this.dds.getScale();
        }

        public int getReference() {
            return this.dds.getRefVal();
        }

        public String getSource() {
            return this.dds.getSource();
        }

        public int getSeq() {
            return this.seq;
        }

        public String getLocal() {
            if (this.dds.isLocalOverride()) {
                return "override";
            }
            return this.dds.isLocal() ? "true" : "false";
        }
    }

    public class MessageBean {
        Message m;
        int readOk = 0;
        int bitsOk = 0;

        public MessageBean() {
        }

        public MessageBean(Message m) {
            this.m = m;
        }

        public String getCategory() throws IOException {
            return this.m.getLookup().getCategoryFullName();
        }

        public String getCenter() {
            return this.m.getLookup().getCenterName();
        }

        public String getTable() {
            return this.m.getLookup().getTableName();
        }

        public String getHeader() {
            return this.m.getHeader();
        }

        public int getEdition() {
            return this.m.is.getBufrEdition();
        }

        public int getNobs() {
            return this.m.getNumberDatasets();
        }

        public long getSize() {
            return this.m.getMessageSize();
        }

        public String getHash() {
            return Integer.toHexString(this.m.hashCode());
        }

        public String getDdsHash() {
            return Integer.toHexString(this.m.dds.getDataDescriptors().hashCode());
        }

        public String getCompress() {
            return this.m.dds.isCompressed() ? "true" : "false";
        }

        public String getDate() {
            return this.m.getReferenceTime().toString();
        }

        public String getComplete() {
            try {
                return this.m.isTablesComplete() ? "true" : "false";
            }
            catch (IOException e) {
                return "exception";
            }
        }

        public String getBitsOk() {
            if (this.bitsOk == 0) {
                this.checkBits();
            }
            switch (this.bitsOk) {
                default: {
                    return "N/A";
                }
                case 1: {
                    return "true";
                }
                case 2: {
                    return "false";
                }
                case 3: 
            }
            return "fail";
        }

        void checkBits() {
            if (this.getNobs() == 0) {
                return;
            }
            try {
                boolean ok = this.m.isBitCountOk();
                this.setBitsOk(ok);
            }
            catch (Exception e) {
                this.bitsOk = 3;
            }
        }

        public String getLocal() {
            try {
                return this.m.usesLocalTable() ? "true" : "false";
            }
            catch (Exception e) {
                return "exception";
            }
        }

        public String getReadOk() {
            switch (this.readOk) {
                default: {
                    return "N/A";
                }
                case 1: {
                    return "true";
                }
                case 2: 
            }
            return "false";
        }

        void setBitsOk(boolean ok) {
            this.bitsOk = ok ? 1 : 2;
        }

        void setReadOk(boolean ok) {
            this.readOk = ok ? 1 : 2;
        }

        private void read() {
            try {
                NetcdfFile ncd = BufrMessageViewer.this.makeBufrMessageAsDataset(this.m);
                SequenceDS v = (SequenceDS)ncd.findVariable("obs");
                try (StructureDataIterator iter = v.getStructureIterator(-1);){
                    while (iter.hasNext()) {
                        iter.next();
                    }
                }
                this.setReadOk(true);
            }
            catch (IOException e) {
                this.setReadOk(false);
            }
        }
    }
}

