/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Rectangle;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.time.CalendarDate;
import ucar.util.prefs.PreferencesExt;

public class VariablePlot
extends JPanel {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final JFreeChart chart;
    NetcdfFile file;

    public VariablePlot(PreferencesExt prefs) {
        this.setLayout(new BorderLayout());
        this.chart = this.createChart();
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setPreferredSize(new java.awt.Dimension(800, 600));
        chartPanel.setMouseZoomable(true, false);
        if (prefs != null) {
            chartPanel.setBounds((Rectangle)prefs.getBean("PlotWindowBounds", (Object)new Rectangle(300, 300, 600, 600)));
        } else {
            chartPanel.setBounds(new Rectangle(300, 300, 600, 600));
        }
        XYPlot plot = this.chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.GRAY);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.GRAY);
        plot.setAxisOffset(RectangleInsets.ZERO_INSETS);
        LegendTitle legend = this.chart.getLegend();
        if (legend != null) {
            legend.setPosition(RectangleEdge.BOTTOM);
        }
        this.add((Component)chartPanel);
    }

    private JFreeChart createChart() {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)"Variable Plot", (String)"X", (String)"Value", null, (boolean)true, (boolean)true, (boolean)false);
        return chart;
    }

    public void setDataset(NetcdfFile ncFile) {
        this.log.info("setDataset");
        this.file = ncFile;
    }

    public void autoScale() {
        this.chart.getXYPlot().getRangeAxis().setAutoRange(true);
        this.chart.getXYPlot().getDomainAxis().setAutoRange(true);
    }

    public void clear() {
        XYPlot p = this.chart.getXYPlot();
        for (int i = 0; i < p.getDatasetCount(); ++i) {
            XYDataset dataset = p.getDataset(i);
            this.log.info("clear dataset " + i + " dataset " + dataset);
            if (dataset instanceof TimeSeriesCollection) {
                ((TimeSeriesCollection)dataset).removeAllSeries();
            }
            if (dataset instanceof XYSeriesCollection) {
                ((XYSeriesCollection)dataset).removeAllSeries();
            }
            p.setDataset(i, null);
            if (i <= 0) continue;
            p.setRangeAxis(i, null);
        }
    }

    public void setVariable(Variable v) throws IOException {
        StandardXYToolTipGenerator g;
        this.log.info("variable " + v.getShortName());
        TimeSeriesCollection dataset = null;
        Dimension dim = v.getDimension(0);
        String dimName = dim.getShortName();
        Attribute title = this.file.findGlobalAttribute("title");
        if (title != null) {
            this.chart.setTitle(title.getStringValue());
        }
        Variable varXdim = this.file.findVariable(null, dimName);
        boolean hasXdim = false;
        if (varXdim != null) {
            hasXdim = true;
        }
        boolean xIsTime = false;
        XYPlot p = this.chart.getXYPlot();
        if (hasXdim) {
            Attribute xUnit = varXdim.findAttribute("units");
            Attribute xAxis = varXdim.findAttribute("axis");
            if (xUnit != null && xUnit.getStringValue().contains("since")) {
                xIsTime = true;
            }
            if (xAxis != null && xAxis.getStringValue().equals("T")) {
                xIsTime = true;
            }
            if (xUnit != null) {
                p.getDomainAxis().setLabel(xUnit.getStringValue());
            } else {
                p.getDomainAxis().setLabel(dimName);
            }
            if (xAxis != null) {
                this.log.info("X axis type " + xUnit.getDataType() + " value " + xUnit.toString() + " is Time " + xIsTime);
            }
        }
        int ax = 0;
        this.log.info("dataset count " + p.getDatasetCount());
        if (p.getDatasetCount() >= 1 && p.getDataset(p.getDatasetCount() - 1) != null) {
            this.log.info("number in dataset " + p.getDataset(0));
            ax = p.getDatasetCount();
            if (ax > 0) {
                p.setRangeAxis(ax, (ValueAxis)new NumberAxis());
            }
        }
        this.log.info("axis number " + ax);
        XYItemRenderer renderer = p.getRenderer();
        if (xIsTime) {
            g = new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0.00"));
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)g);
            dataset = new TimeSeriesCollection();
        } else {
            g = new StandardXYToolTipGenerator("{0}: ({1}, {2})", (NumberFormat)new DecimalFormat("0.00"), (NumberFormat)new DecimalFormat("0.00"));
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)g);
            dataset = new XYSeriesCollection();
            p.setDomainAxis((ValueAxis)new NumberAxis());
        }
        p.getRangeAxis(ax).setAutoRange(true);
        Attribute vUnit = v.findAttribute("units");
        Attribute vfill = v.findAttribute("_FillValue");
        double dfill = Double.NaN;
        if (vfill != null) {
            dfill = vfill.getNumericValue().doubleValue();
        }
        if (vUnit != null) {
            p.getRangeAxis(ax).setLabel(vUnit.getStringValue());
        }
        NetcdfDataset fds = new NetcdfDataset(this.file);
        CoordinateAxis1DTime tm = null;
        List dates = null;
        Array varXarray = null;
        if (hasXdim) {
            varXarray = varXdim.read();
            if (xIsTime) {
                tm = CoordinateAxis1DTime.factory((NetcdfDataset)fds, (VariableDS)new VariableDS(null, varXdim, true), null);
                dates = tm.getCalendarDates();
            }
        }
        Array a = v.read();
        Index idx = a.getIndex();
        idx.setCurrentCounter(0);
        int d2 = 1;
        int rank = idx.getRank();
        for (int k = 1; k < rank; ++k) {
            d2 *= idx.getShape(k);
        }
        this.log.info("variable : " + v.getShortName() + " : dims " + v.getDimensionsString() + " rank " + rank + " d2 " + d2);
        double max = -1000.0;
        double min = 1000.0;
        for (int j = 0; j < d2; ++j) {
            if (rank > 1) {
                idx.set1(j);
            }
            String name = v.getShortName();
            if (d2 > 1) {
                name = name + "-" + j;
            }
            Object s1 = xIsTime ? new TimeSeries((Comparable)((Object)name)) : new XYSeries((Comparable)((Object)name));
            for (int i = 0; i < idx.getShape(0); ++i) {
                idx.set0(i);
                float f = a.getFloat(idx);
                if ((double)f == dfill) continue;
                if (!Float.isNaN(f)) {
                    max = Math.max(max, (double)f);
                    min = Math.min(min, (double)f);
                }
                if (xIsTime) {
                    Date ts = new Date(((CalendarDate)dates.get(i)).getMillis());
                    s1.addOrUpdate((RegularTimePeriod)new Second(ts), (double)f);
                    continue;
                }
                if (hasXdim) {
                    ((XYSeries)s1).addOrUpdate(varXarray.getDouble(i), (double)f);
                    continue;
                }
                ((XYSeries)s1).addOrUpdate((double)i, (double)f);
            }
            if (dataset instanceof TimeSeriesCollection) {
                dataset.addSeries(s1);
            }
            if (!(dataset instanceof XYSeriesCollection)) continue;
            ((XYSeriesCollection)dataset).addSeries((XYSeries)s1);
        }
        XYLineAndShapeRenderer renderer1 = new XYLineAndShapeRenderer(true, false);
        p.setRenderer(ax, (XYItemRenderer)renderer1);
        this.log.info("dataset " + ax + " max " + max + " min " + min + " : " + dataset);
        p.setDataset(ax, (XYDataset)dataset);
        p.mapDatasetToRangeAxis(ax, ax);
        p.getRangeAxis(ax).setLowerBound(min);
        p.getRangeAxis(ax).setUpperBound(max);
    }
}

