/*
 * Decompiled with CFR 0.152.
 */
package ucar.util.prefs;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import ucar.nc2.util.Indent;

public class Convert2Version2 {
    String filename;

    Convert2Version2(String filename) {
        this.filename = filename;
    }

    void convert() throws IOException {
        Document doc;
        try (FileInputStream is = null;){
            is = new FileInputStream(this.filename);
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build((InputStream)is);
        }
        Element root = doc.getRootElement();
        this.check(root, new Indent(2));
    }

    void add(Element elem, Element parent) {
        if (elem.getName().equals("object")) {
            parent.addContent((Content)elem.clone());
        }
        for (Object child : elem.getChildren()) {
            this.add((Element)child, parent);
        }
    }

    void show(Element e, Indent indent) {
        String key;
        String name = e.getName();
        if (name.equals("beanObject")) {
            key = e.getAttributeValue("key");
            Element obj = e.getChild("object");
            String c = obj.getAttributeValue("class");
            System.out.printf("%s%s key=%s class=%s%n", indent, name, key, c);
        } else if (name.equals("beanCollection")) {
            key = e.getAttributeValue("key");
            String c = e.getAttributeValue("class");
            System.out.printf("%s%s key=%s class=%s%n", indent, name, key, c);
        } else if (name.equals("node")) {
            String nname = e.getAttributeValue("name");
            System.out.printf("%n%s%s %s%n", indent, name, nname);
        } else if (name.equals("entry")) {
            key = e.getAttributeValue("key");
            String value = e.getAttributeValue("value");
            System.out.printf("%s%s key=%s value=%s%n", indent, name, key, value);
        } else {
            System.out.printf("%s%s%n", indent, name);
        }
        if (!name.equals("beanObject") && !name.equals("beanCollection")) {
            indent.incr();
            for (Object co : e.getChildren()) {
                this.show((Element)co, indent);
            }
            indent.decr();
        }
    }

    void check(Element e, Indent indent) {
        String name = e.getName();
        if (name.equals("beanObject")) {
            String key = e.getAttributeValue("key");
            Element obj = e.getChild("object");
            assert (obj != null);
            String c = obj.getAttributeValue("class");
            System.out.printf("%s%s key=%s class=%s%n", indent, name, key, c);
        }
        for (Object co : e.getChildren()) {
            this.check((Element)co, indent);
        }
    }

    public static void main(String[] args) throws IOException {
        String test = "C:\\Users\\caron\\.unidata\\NetcdfUI22.xml";
        Convert2Version2 im = new Convert2Version2(test);
        im.convert();
    }
}

