/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.ft.point.bufr.BufrCdmIndex;
import ucar.nc2.ft.point.bufr.BufrCdmIndexProto;
import ucar.nc2.ft.point.bufr.BufrField;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class BufrCdmIndexPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(BufrCdmIndexPanel.class);
    private PreferencesExt prefs;
    private BeanTable stationTable;
    private BeanTable fldTable;
    private JSplitPane split;
    private JSplitPane split2;
    private JSplitPane split3;
    private TextHistoryPane infoPopup;
    private TextHistoryPane detailTA;
    private IndependentWindow infoWindow;
    private IndependentWindow detailWindow;
    String indexFilename;
    BufrCdmIndex index;
    FieldBean rootBean;
    private FileManager fileChooser;

    public BufrCdmIndexPanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        AbstractButton infoButton = BAMutil.makeButtcon("Information", "Show Info", false);
        infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BufrCdmIndexPanel.this.index == null) {
                    return;
                }
                Formatter f = new Formatter();
                BufrCdmIndexPanel.this.index.showIndex(f);
                BufrCdmIndexPanel.this.detailTA.setText(f.toString());
                BufrCdmIndexPanel.this.detailTA.gotoTop();
                BufrCdmIndexPanel.this.detailWindow.show();
            }
        });
        buttPanel.add(infoButton);
        AbstractButton writeButton = BAMutil.makeButtcon("netcdf", "Write index", false);
        writeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                try {
                    if (BufrCdmIndexPanel.this.writeIndex(f)) {
                        f.format("Index written", new Object[0]);
                        BufrCdmIndexPanel.this.detailTA.setText(f.toString());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    StringWriter sw = new StringWriter(10000);
                    ex.printStackTrace(new PrintWriter(sw));
                    BufrCdmIndexPanel.this.detailTA.setText(sw.toString());
                }
                BufrCdmIndexPanel.this.detailTA.gotoTop();
                BufrCdmIndexPanel.this.detailWindow.show();
            }
        });
        buttPanel.add(writeButton);
        this.stationTable = new BeanTable(StationBean.class, (PreferencesExt)prefs.node("StationBean"), false, "stations", "BufrCdmIndexProto.Station", null);
        this.fldTable = new BeanTable(FieldBean.class, (PreferencesExt)prefs.node("FldBean"), false, "Fields", "BufrCdmIndexProto.Field", new FieldBean());
        JTable table = this.fldTable.getJTable();
        JComboBox<BufrCdmIndexProto.FldType> comboBox = new JComboBox<BufrCdmIndexProto.FldType>(BufrCdmIndexProto.FldType.values());
        table.setDefaultEditor(BufrCdmIndexProto.FldType.class, new DefaultCellEditor(comboBox));
        TableColumn sportColumn = table.getColumnModel().getColumn(2);
        JComboBox<String> cb = new JComboBox<String>();
        cb.addItem("Snowboarding");
        cb.addItem("Rowing");
        cb.addItem("Chasing toddlers");
        cb.addItem("Speed reading");
        cb.addItem("Teaching high school");
        cb.addItem("None");
        sportColumn.setCellEditor(new DefaultCellEditor(cb));
        this.infoPopup = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.detailTA = new TextHistoryPane();
        this.detailWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.detailTA);
        this.detailWindow.setBounds((Rectangle)prefs.getBean("DetailWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.setLayout(new BorderLayout());
        this.split = new JSplitPane(0, false, this.stationTable, this.fldTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 800));
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.stationTable.saveState(false);
        this.fldTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putBeanObject("DetailWindowBounds", (Object)this.detailWindow.getBounds());
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
        if (this.split2 != null) {
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        }
        if (this.split3 != null) {
            this.prefs.putInt("splitPos3", this.split3.getDividerLocation());
        }
    }

    public void setIndexFile(String indexFilename) throws IOException {
        this.indexFilename = indexFilename;
        this.index = BufrCdmIndex.readIndex((String)indexFilename);
        ArrayList<StationBean> stations = new ArrayList<StationBean>();
        if (this.index.stations != null) {
            for (BufrCdmIndexProto.Station s : this.index.stations) {
                stations.add(new StationBean(s));
            }
        }
        this.stationTable.setBeans(stations);
        ArrayList<FieldBean> flds = new ArrayList<FieldBean>();
        if (this.index.root != null) {
            this.rootBean = new FieldBean(null, this.index.root);
            this.addFields(this.index.root, this.rootBean, flds);
        }
        this.fldTable.setBeans(flds);
    }

    private void addFields(BufrCdmIndexProto.Field parent, FieldBean parentBean, List<FieldBean> flds) {
        if (parent.getFldsList() == null) {
            return;
        }
        parentBean.children = new ArrayList<FieldBean>();
        for (BufrCdmIndexProto.Field child : parent.getFldsList()) {
            FieldBean childBean = new FieldBean(parentBean, child);
            flds.add(childBean);
            parentBean.children.add(childBean);
            this.addFields(child, childBean, flds);
        }
    }

    public boolean writeIndex(Formatter f) throws IOException {
        this.makeFileChooser();
        String filename = this.fileChooser.chooseFilename(this.indexFilename);
        if (filename == null) {
            return false;
        }
        if (!filename.endsWith(".ncx")) {
            filename = filename + ".ncx";
        }
        File idxFile = new File(filename);
        return BufrCdmIndex.writeIndex((BufrCdmIndex)this.index, (BufrField)this.rootBean, (File)idxFile);
    }

    private void makeFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new FileManager(null, null, null, (PreferencesExt)this.prefs.node("FileManager"));
        }
    }

    public class FieldBean
    implements BufrField {
        FieldBean parent;
        BufrCdmIndexProto.Field child;
        List<FieldBean> children;
        BufrCdmIndexProto.FldAction act;
        BufrCdmIndexProto.FldType type;

        public String editableProperties() {
            return "actionS type name";
        }

        public String hiddenProperties() {
            return "action children fxy";
        }

        public FieldBean() {
        }

        public FieldBean(FieldBean parent, BufrCdmIndexProto.Field child) {
            this.parent = parent;
            this.child = child;
        }

        public String getParent() {
            if (this.parent == null) {
                return null;
            }
            Formatter f = new Formatter();
            FieldBean a = this.parent;
            while (a != null) {
                a = a.parent;
                if (a == null || a.getName().isEmpty()) continue;
                f.format("../", new Object[0]);
            }
            f.format("%s", this.parent.getName());
            return f.toString();
        }

        public String getName() {
            return this.child.getName();
        }

        public String getDesc() {
            return this.child.getDesc();
        }

        public String getUnits() {
            return this.child.getUnits();
        }

        public short getFxy() {
            return (short)this.child.getFxy();
        }

        public String getFxyName() {
            return Descriptor.makeString((short)((short)this.child.getFxy()));
        }

        public BufrCdmIndexProto.FldAction getAction() {
            if (this.act != null) {
                return this.act;
            }
            return this.child.getAction();
        }

        public BufrCdmIndexProto.FldType getType() {
            if (this.type != null) {
                return this.type;
            }
            return this.child.getType();
        }

        public void setType(BufrCdmIndexProto.FldType type) {
            this.type = type;
        }

        public String getActionS() {
            if (this.act != null) {
                return this.act.toString();
            }
            BufrCdmIndexProto.FldAction fact = this.getAction();
            return fact != null ? fact.toString() : "";
        }

        public void setActionS(String actS) {
            try {
                this.act = BufrCdmIndexProto.FldAction.valueOf((String)actS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean isSeq() {
            return this.child.getMax() > 0;
        }

        public int getMin() {
            return this.child.getMin();
        }

        public int getMax() {
            return this.child.getMax();
        }

        public int getScale() {
            return this.child.getScale();
        }

        public int getReference() {
            return this.child.getReference();
        }

        public int getBitWidth() {
            return this.child.getBitWidth();
        }

        public List<? extends BufrField> getChildren() {
            return this.children;
        }
    }

    public class StationBean {
        BufrCdmIndexProto.Station s;

        public StationBean(BufrCdmIndexProto.Station s) {
            this.s = s;
        }

        public String getWmoId() {
            return this.s.getWmoId();
        }

        public String getName() {
            return this.s.getId();
        }

        public String getDescription() {
            return this.s.getDesc();
        }

        public double getLatitude() {
            return this.s.getLat();
        }

        public double getLongitude() {
            return this.s.getLon();
        }

        public double getAltitude() {
            return this.s.getAlt();
        }

        public int getCount() {
            return this.s.getCount();
        }
    }
}

